/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.control;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.machinemuse.api.IPowerModule;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.general.gui.clickable.ClickableKeybinding;
import net.machinemuse.general.gui.clickable.ClickableModule;
import net.machinemuse.numina.general.MuseLogger;
import net.machinemuse.numina.geometry.MusePoint2D;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.Loader;
import org.lwjgl.input.Keyboard;

public class KeybindManager {
    protected Set<ClickableKeybinding> keybindings = new HashSet<ClickableKeybinding>();
    protected static KeybindManager instance;

    protected KeybindManager() {
    }

    public static KeybindManager getInstance() {
        if (instance == null) {
            instance = new KeybindManager();
        }
        return instance;
    }

    public static Set<ClickableKeybinding> getKeybindings() {
        return KeybindManager.getInstance().keybindings;
    }

    public static KeyBinding addKeybinding(String keybindDescription, int keycode, MusePoint2D position) {
        KeyBinding kb = new KeyBinding(keybindDescription, keycode, "Modular Powersuits");
        boolean free = !KeyBinding.field_74514_b.func_76037_b(keycode);
        KeybindManager.getInstance().keybindings.add(new ClickableKeybinding(kb, position, free, false));
        return kb;
    }

    public static String parseName(KeyBinding keybind) {
        if (keybind.func_151463_i() < 0) {
            return "Mouse" + (keybind.func_151463_i() + 100);
        }
        return Keyboard.getKeyName((int)keybind.func_151463_i());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeOutKeybinds() {
        BufferedWriter writer = null;
        try {
            File file = new File(Loader.instance().getConfigDir() + "/machinemuse/", "powersuits-keybinds.cfg");
            if (!file.exists()) {
                file.createNewFile();
            }
            writer = new BufferedWriter(new FileWriter(file));
            List<IPowerModule> modulesToWrite = MuseItemUtils.getPlayerInstalledModules((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            for (ClickableKeybinding keybinding : KeybindManager.getInstance().keybindings) {
                writer.write(keybinding.getKeyBinding().func_151463_i() + ":" + keybinding.getPosition().x() + ':' + keybinding.getPosition().y() + ':' + keybinding.displayOnHUD() + ':' + keybinding.toggleval() + '\n');
                for (ClickableModule module : keybinding.getBoundModules()) {
                    writer.write(module.getModule().getDataName() + '~' + module.getPosition().x() + '~' + module.getPosition().y() + '\n');
                }
            }
        }
        catch (Exception e) {
            MuseLogger.logError((String)"Problem writing out keyconfig :(");
            e.printStackTrace();
        }
        finally {
            try {
                writer.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public static void readInKeybinds() {
        try {
            File file = new File(Loader.instance().getConfigDir() + "/machinemuse/", "powersuits-keybinds.cfg");
            if (!file.exists()) {
                MuseLogger.logError((String)"No powersuits keybind file found.");
                return;
            }
            BufferedReader reader = new BufferedReader(new FileReader(file));
            ClickableKeybinding workingKeybinding = null;
            while (reader.ready()) {
                String[] exploded;
                String line = reader.readLine();
                if (line.contains(":")) {
                    exploded = line.split(":");
                    int id = Integer.parseInt(exploded[0]);
                    if (!KeyBinding.field_74514_b.func_76037_b(id)) {
                        MusePoint2D position = new MusePoint2D(Double.parseDouble(exploded[1]), Double.parseDouble(exploded[2]));
                        boolean free = !KeyBinding.field_74514_b.func_76037_b(id);
                        boolean displayOnHUD = false;
                        boolean toggleval = false;
                        if (exploded.length > 3) {
                            displayOnHUD = Boolean.parseBoolean(exploded[3]);
                        }
                        if (exploded.length > 4) {
                            toggleval = Boolean.parseBoolean(exploded[4]);
                        }
                        workingKeybinding = new ClickableKeybinding(new KeyBinding(Keyboard.getKeyName((int)id), id, "Modular Powersuits"), position, free, displayOnHUD);
                        workingKeybinding.toggleval_$eq(toggleval);
                        KeybindManager.getInstance().keybindings.add(workingKeybinding);
                        continue;
                    }
                    workingKeybinding = null;
                    continue;
                }
                if (!line.contains("~") || workingKeybinding == null) continue;
                exploded = line.split("~");
                MusePoint2D position = new MusePoint2D(Double.parseDouble(exploded[1]), Double.parseDouble(exploded[2]));
                IPowerModule module = ModuleManager.getModule(exploded[0]);
                if (module == null) continue;
                ClickableModule cmodule = new ClickableModule(module, position);
                workingKeybinding.bindModule(cmodule);
            }
            reader.close();
        }
        catch (Exception e) {
            MuseLogger.logError((String)"Problem reading in keyconfig :(");
            e.printStackTrace();
        }
    }
}

