/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.event;

import net.machinemuse.api.IModularItem;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IBlockBreakingModule;
import net.machinemuse.powersuits.item.ItemPowerFist;
import net.machinemuse.utils.MusePlayerUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class HarvestEventHandler {
    @SubscribeEvent
    public void handleHarvestCheck(PlayerEvent.HarvestCheck event) {
        EntityPlayer player = event.entityPlayer;
        Block block = event.block;
        MovingObjectPosition mop = MusePlayerUtils.raytraceBlocks(player.field_70170_p, player, true, 64.0);
        if (mop != null) {
            BlockPos pos = mop.func_178782_a();
            pos = new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            ItemStack stack = player.field_71071_by.func_70448_g();
            if (stack != null && stack.func_77973_b() instanceof ItemPowerFist && ((ItemPowerFist)stack.func_77973_b()).canHarvestBlock(stack, pos, player)) {
                event.success = true;
            }
        }
    }

    @SubscribeEvent
    public void handleBreakSpeed(PlayerEvent.BreakSpeed event) {
        Block block = event.state.func_177230_c();
        EntityPlayer player = event.entityPlayer;
        IBlockState blockstate = event.state;
        BlockPos pos = event.pos;
        event.newSpeed = event.originalSpeed;
        ItemStack stack = player.func_71045_bC();
        if (stack != null && stack.func_77973_b() instanceof IModularItem) {
            for (IBlockBreakingModule module : ModuleManager.getBlockBreakingModules()) {
                if (!ModuleManager.itemHasActiveModule(stack, module.getDataName()) || !module.canHarvestBlock(stack, pos, player)) continue;
                if (event.newSpeed == 0.0f) {
                    event.newSpeed = 1.0f;
                }
                module.handleBreakSpeed(event);
            }
        }
    }
}

