/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.armor;

import java.util.List;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IPlayerTickModule;
import net.machinemuse.api.moduletrigger.IToggleableModule;
import net.machinemuse.general.gui.MuseIcon;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseHeatUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class NitrogenCoolingSystem
extends PowerModuleBase
implements IPlayerTickModule,
IToggleableModule {
    public static final String MODULE_NITROGEN_COOLING_SYSTEM = "Liquid Nitrogen Cooling System";
    public static final String COOLING_BONUS = "Cooling Bonus";
    public static final String ENERGY = "Energy Consumption";

    public NitrogenCoolingSystem(List<IModularItem> validItems) {
        super(validItems);
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.liquidNitrogen, 1));
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.rubberHose, 2));
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.controlCircuit, 1));
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.computerChip, 2));
        this.addTradeoffProperty("Power", COOLING_BONUS, 7.0, "%");
        this.addTradeoffProperty("Power", ENERGY, 16.0, "J/t");
    }

    @Override
    public void onPlayerTickActive(EntityPlayer player, ItemStack item) {
        double heatBefore = MuseHeatUtils.getPlayerHeat(player);
        MuseHeatUtils.coolPlayer(player, 0.21 * ModuleManager.computeModularProperty(item, COOLING_BONUS));
        double cooling = heatBefore - MuseHeatUtils.getPlayerHeat(player);
        ElectricItemUtils.drainPlayerEnergy(player, cooling * ModuleManager.computeModularProperty(item, ENERGY));
    }

    @Override
    public void onPlayerTickInactive(EntityPlayer player, ItemStack item) {
    }

    @Override
    public String getTextureFile() {
        return "coolingsystem";
    }

    @Override
    public String getCategory() {
        return "Environment";
    }

    @Override
    public String getDataName() {
        return MODULE_NITROGEN_COOLING_SYSTEM;
    }

    @Override
    public String getUnlocalizedName() {
        return "nitrogenCoolingSystem";
    }

    @Override
    public String getDescription() {
        return "Cools down heat-producing modules even faster than the standard cooling system.";
    }

    @Override
    public TextureAtlasSprite getIcon(ItemStack item) {
        return MuseIcon.nitrogenCoolingSystem;
    }
}

