/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.energy;

import java.util.List;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IPlayerTickModule;
import net.machinemuse.general.gui.MuseIcon;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseHeatUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class AdvancedSolarGenerator
extends PowerModuleBase
implements IPlayerTickModule {
    public static String MODULE_ADVANCED_SOLAR_GENERATOR = "Advanced Solar Generator";
    public static final String A_SOLAR_ENERGY_GENERATION_DAY = "Daytime Energy Generation";
    public static final String A_SOLAR_ENERGY_GENERATION_NIGHT = "Nighttime Energy Generation";
    public static final String SOLAR_HEAT_GENERATION_DAY = "Daytime Heat Generation";
    public static final String SOLAR_HEAT_GENERATION_NIGHT = "Nighttime Heat Generation";

    public AdvancedSolarGenerator(List<IModularItem> validItems) {
        super(validItems);
        this.addBaseProperty(SOLAR_HEAT_GENERATION_DAY, 15.0);
        this.addBaseProperty(SOLAR_HEAT_GENERATION_NIGHT, 5.0);
        this.addBaseProperty(A_SOLAR_ENERGY_GENERATION_DAY, 4500.0);
        this.addBaseProperty(A_SOLAR_ENERGY_GENERATION_NIGHT, 150.0);
        this.addBaseProperty("Weight", 300.0);
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.solarPanel, 3));
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.controlCircuit, 2));
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.computerChip, 1));
    }

    @Override
    public String getTextureFile() {
        return "advsolarhelmet";
    }

    @Override
    public String getCategory() {
        return "Energy";
    }

    @Override
    public String getDataName() {
        return MODULE_ADVANCED_SOLAR_GENERATOR;
    }

    @Override
    public String getUnlocalizedName() {
        return "advSolarGenerator";
    }

    @Override
    public String getDescription() {
        return "A solar generator with 3 times the power generation of the standard solar generator";
    }

    @Override
    public void onPlayerTickActive(EntityPlayer player, ItemStack item) {
        ItemStack helmet = player.func_82169_q(3);
        if (helmet != null && helmet.equals(item)) {
            boolean moonVisible;
            World world = player.field_70170_p;
            boolean canRain = true;
            if (world.func_82737_E() % 20L == 0L) {
                canRain = world.func_180494_b(player.func_180425_c()).func_76744_g() > 0;
            }
            boolean isRaining = canRain && (world.func_72896_J() || world.func_72911_I());
            boolean sunVisible = world.func_72935_r() && !isRaining && world.func_175710_j(player.func_180425_c().func_177982_a(0, 1, 0));
            boolean bl = moonVisible = !world.func_72935_r() && !isRaining && world.func_175710_j(player.func_180425_c().func_177982_a(0, 1, 0));
            if (!world.field_72995_K && !world.field_73011_w.func_177495_o() && world.func_82737_E() % 80L == 0L) {
                if (sunVisible) {
                    ElectricItemUtils.givePlayerEnergy(player, ModuleManager.computeModularProperty(item, A_SOLAR_ENERGY_GENERATION_DAY));
                    MuseHeatUtils.heatPlayer(player, ModuleManager.computeModularProperty(item, SOLAR_HEAT_GENERATION_DAY) / 2.0);
                } else if (moonVisible) {
                    ElectricItemUtils.givePlayerEnergy(player, ModuleManager.computeModularProperty(item, A_SOLAR_ENERGY_GENERATION_NIGHT));
                    MuseHeatUtils.heatPlayer(player, ModuleManager.computeModularProperty(item, SOLAR_HEAT_GENERATION_NIGHT) / 2.0);
                }
            }
        }
    }

    @Override
    public void onPlayerTickInactive(EntityPlayer player, ItemStack item) {
    }

    @Override
    public TextureAtlasSprite getIcon(ItemStack item) {
        return MuseIcon.advSolarGenerator;
    }
}

