/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.misc;

import java.util.List;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IPlayerTickModule;
import net.machinemuse.api.moduletrigger.IToggleableModule;
import net.machinemuse.general.gui.MuseIcon;
import net.machinemuse.powersuits.common.Config;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.FoodStats;

public class AutoFeederModule
extends PowerModuleBase
implements IToggleableModule,
IPlayerTickModule {
    public static final String MODULE_AUTO_FEEDER = "Auto-Feeder";
    public static final String EATING_ENERGY_CONSUMPTION = "Eating Energy Consumption";
    public static final String EATING_EFFICIENCY = "Auto-Feeder Efficiency";

    public AutoFeederModule(List<IModularItem> validItems) {
        super(validItems);
        this.addBaseProperty(EATING_ENERGY_CONSUMPTION, 100.0);
        this.addBaseProperty(EATING_EFFICIENCY, 50.0);
        this.addTradeoffProperty("Efficiency", EATING_ENERGY_CONSUMPTION, 100.0);
        this.addTradeoffProperty("Efficiency", EATING_EFFICIENCY, 50.0);
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.servoMotor, 2));
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.controlCircuit, 1));
    }

    @Override
    public String getTextureFile() {
        return "autofeeder";
    }

    @Override
    public String getCategory() {
        return "Environment";
    }

    @Override
    public String getDataName() {
        return MODULE_AUTO_FEEDER;
    }

    @Override
    public String getUnlocalizedName() {
        return "autoFeeder";
    }

    @Override
    public String getDescription() {
        return "Whenever you're hungry, this module will grab the bottom-left-most food item from your inventory and feed it to you, storing the rest for later.";
    }

    @Override
    public void onPlayerTickActive(EntityPlayer player, ItemStack item) {
        if (Config.useOldAutoFeeder()) {
            InventoryPlayer inv = player.field_71071_by;
            double foodLevel = MuseItemUtils.getFoodLevel(item);
            double saturationLevel = MuseItemUtils.getSaturationLevel(item);
            double efficiency = ModuleManager.computeModularProperty(item, EATING_EFFICIENCY);
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack == null || !(stack.func_77973_b() instanceof ItemFood)) continue;
                ItemFood food = (ItemFood)stack.func_77973_b();
                for (int a = 0; a < stack.field_77994_a; ++a) {
                    foodLevel += (double)food.func_150905_g(stack);
                    saturationLevel += (double)food.func_150906_h(stack);
                }
                foodLevel = foodLevel * efficiency / 100.0;
                saturationLevel = saturationLevel * efficiency / 100.0;
                MuseItemUtils.setFoodLevel(item, foodLevel);
                MuseItemUtils.setSaturationLevel(item, saturationLevel);
                player.field_71071_by.func_70299_a(i, null);
            }
            double eatingEnergyConsumption = ModuleManager.computeModularProperty(item, EATING_ENERGY_CONSUMPTION);
            FoodStats foodStats = player.func_71024_bL();
            int foodNeeded = 20 - foodStats.func_75116_a();
            if (foodNeeded > 0 && eatingEnergyConsumption * (double)foodNeeded < ElectricItemUtils.getPlayerEnergy(player) && MuseItemUtils.getFoodLevel(item) > (double)foodNeeded) {
                if (MuseItemUtils.getSaturationLevel(item) >= 1.0) {
                    foodStats.func_75122_a(foodNeeded, 1.0f);
                    MuseItemUtils.setSaturationLevel(item, MuseItemUtils.getSaturationLevel(item) - 1.0);
                } else {
                    foodStats.func_75122_a(foodNeeded, 0.0f);
                }
                MuseItemUtils.setFoodLevel(item, MuseItemUtils.getFoodLevel(item) - (double)foodNeeded);
                ElectricItemUtils.drainPlayerEnergy(player, eatingEnergyConsumption * (double)foodNeeded);
            }
        } else {
            double totalEnergy = ElectricItemUtils.getPlayerEnergy(player);
            InventoryPlayer inv = player.field_71071_by;
            double foodLevel = MuseItemUtils.getFoodLevel(item);
            double saturationLevel = MuseItemUtils.getSaturationLevel(item);
            double efficiency = ModuleManager.computeModularProperty(item, EATING_EFFICIENCY);
            FoodStats foodStats = player.func_71024_bL();
            int foodNeeded = 20 - foodStats.func_75116_a();
            for (int i = 0; i < inv.func_70302_i_() && (double)foodNeeded > foodLevel; ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack == null || !(stack.func_77973_b() instanceof ItemFood)) continue;
                ItemFood food = (ItemFood)stack.func_77973_b();
                while (stack.field_77994_a > 0 && (double)foodNeeded > foodLevel) {
                    foodLevel += (double)food.func_150905_g(stack) * efficiency / 100.0;
                    saturationLevel += (double)food.func_150906_h(stack) * efficiency / 100.0;
                    --stack.field_77994_a;
                }
                if (stack.field_77994_a != 0) continue;
                player.field_71071_by.func_70299_a(i, null);
            }
            double eatingEnergyConsumption = (double)foodNeeded * ModuleManager.computeModularProperty(item, EATING_ENERGY_CONSUMPTION);
            int foodConsumed = (int)Math.min((double)foodNeeded, Math.min(foodLevel, eatingEnergyConsumption * totalEnergy));
            if (foodConsumed > 0) {
                if (saturationLevel >= 1.0) {
                    foodStats.func_75122_a(foodConsumed, 1.0f);
                    saturationLevel -= 1.0;
                } else {
                    foodStats.func_75122_a(foodConsumed, 0.0f);
                }
                foodLevel -= (double)foodConsumed;
                ElectricItemUtils.drainPlayerEnergy(player, eatingEnergyConsumption * (double)foodConsumed);
            }
            MuseItemUtils.setFoodLevel(item, foodLevel);
            MuseItemUtils.setSaturationLevel(item, saturationLevel);
        }
    }

    @Override
    public void onPlayerTickInactive(EntityPlayer player, ItemStack item) {
    }

    @Override
    public TextureAtlasSprite getIcon(ItemStack item) {
        return MuseIcon.autoFeeder;
    }
}

