/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.tool;

import java.util.List;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IBlockBreakingModule;
import net.machinemuse.api.moduletrigger.IToggleableModule;
import net.machinemuse.general.gui.MuseIcon;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.powersuits.powermodule.tool.PickaxeModule;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class DiamondPickUpgradeModule
extends PowerModuleBase
implements IBlockBreakingModule,
IToggleableModule {
    public static final String MODULE_DIAMOND_PICK_UPGRADE = "Diamond Drill Upgrade";

    public DiamondPickUpgradeModule(List<IModularItem> validItems) {
        super(validItems);
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.solenoid, 1));
        this.addInstallCost(new ItemStack(Items.field_151045_i, 3));
    }

    @Override
    public String getCategory() {
        return "Special";
    }

    @Override
    public String getDataName() {
        return MODULE_DIAMOND_PICK_UPGRADE;
    }

    @Override
    public String getUnlocalizedName() {
        return "diamondPickUpgrade";
    }

    @Override
    public String getDescription() {
        return "Add diamonds to allow your pickaxe module to mine Obsidian. *REQUIRES PICKAXE MODULE TO WORK*";
    }

    @Override
    public String getTextureFile() {
        return "diamondupgrade1";
    }

    @Override
    public boolean canHarvestBlock(ItemStack stack, BlockPos pos, EntityPlayer player) {
        Block block = player.field_70170_p.func_180495_p(pos).func_177230_c();
        return !Items.field_151035_b.canHarvestBlock(block, stack) && Items.field_151046_w.canHarvestBlock(block, stack) && ElectricItemUtils.getPlayerEnergy(player) > ModuleManager.computeModularProperty(stack, "Pickaxe Energy Consumption");
    }

    @Override
    public boolean onBlockDestroyed(ItemStack stack, World world, Block block, BlockPos pos, EntityLivingBase player) {
        IBlockState blockstate = world.func_180495_p(pos);
        if (this.canHarvestBlock(stack, pos, (EntityPlayer)player) && !PickaxeModule.harvestCheck(stack, block, blockstate, (EntityPlayer)player)) {
            ElectricItemUtils.drainPlayerEnergy((EntityPlayer)player, ModuleManager.computeModularProperty(stack, "Pickaxe Energy Consumption"));
            return true;
        }
        return false;
    }

    @Override
    public void handleBreakSpeed(PlayerEvent.BreakSpeed event) {
        event.newSpeed = (float)ModuleManager.computeModularProperty(event.entityPlayer.func_71045_bC(), "Pickaxe Harvest Speed");
    }

    @Override
    public TextureAtlasSprite getIcon(ItemStack item) {
        return MuseIcon.diamondPickUpgrade;
    }
}

