/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.tool;

import java.util.List;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.IPowerModule;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IRightClickModule;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class HoeModule
extends PowerModuleBase
implements IPowerModule,
IRightClickModule {
    public static final String MODULE_HOE = "Rototiller";
    public static final String HOE_ENERGY_CONSUMPTION = "Hoe Energy Consumption";
    public static final String HOE_SEARCH_RADIUS = "Hoe Search Radius";

    public HoeModule(List<IModularItem> validItems) {
        super(validItems);
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.solenoid, 1));
        this.addBaseProperty(HOE_ENERGY_CONSUMPTION, 50.0);
        this.addTradeoffProperty("Search Radius", HOE_ENERGY_CONSUMPTION, 950.0);
        this.addTradeoffProperty("Search Radius", HOE_SEARCH_RADIUS, 8.0, "m");
    }

    @Override
    public void onRightClick(EntityPlayer playerClicking, World world, ItemStack item) {
    }

    @Override
    public void onItemUse(ItemStack itemStack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        double energyConsumed = ModuleManager.computeModularProperty(itemStack, HOE_ENERGY_CONSUMPTION);
        if (player.func_175151_a(pos, side, itemStack) && ElectricItemUtils.getPlayerEnergy(player) > energyConsumed) {
            UseHoeEvent event = new UseHoeEvent(player, itemStack, world, pos);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return;
            }
            if (event.getResult() == Event.Result.ALLOW) {
                ElectricItemUtils.drainPlayerEnergy(player, energyConsumed);
                return;
            }
            if (world.field_72995_K) {
                return;
            }
            double radius = (int)ModuleManager.computeModularProperty(itemStack, HOE_SEARCH_RADIUS);
            int i = (int)Math.floor(-radius);
            while ((double)i < radius) {
                int j = (int)Math.floor(-radius);
                while ((double)j < radius) {
                    Block block;
                    if ((double)(i * i + j * j) < radius * radius && ((block = world.func_180495_p(pos.func_177982_a(i, 0, j)).func_177230_c()) == Blocks.field_150349_c || block == Blocks.field_150346_d)) {
                        world.func_175656_a(pos.func_177982_a(i, 0, j), Blocks.field_150458_ak.func_176223_P());
                        ElectricItemUtils.drainPlayerEnergy(player, ModuleManager.computeModularProperty(itemStack, HOE_ENERGY_CONSUMPTION));
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    @Override
    public boolean onItemUseFirst(ItemStack itemstack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void onPlayerStoppedUsing(ItemStack itemStack, World world, EntityPlayer player, int par4) {
    }

    @Override
    public String getCategory() {
        return "Tool";
    }

    @Override
    public String getDataName() {
        return MODULE_HOE;
    }

    @Override
    public String getUnlocalizedName() {
        return "hoe";
    }

    @Override
    public String getDescription() {
        return "An automated tilling addon to make it easy to till large swaths of land at once.";
    }

    @Override
    public String getTextureFile() {
        return null;
    }

    @Override
    public TextureAtlasSprite getIcon(ItemStack item) {
        return Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(new ItemStack(Items.field_151013_M)).func_177554_e();
    }
}

