/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.tool;

import java.util.List;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IRightClickModule;
import net.machinemuse.general.gui.MuseIcon;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.powersuits.powermodule.PropertyModifierIntLinearAdditive;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class LeafBlowerModule
extends PowerModuleBase
implements IRightClickModule {
    private static final String MODULE_LEAF_BLOWER = "Leaf Blower";
    private static final String LEAF_BLOWER_ENERGY_CONSUMPTION = "Energy Consumption";
    private static final String PLANT_RADIUS = "Plant Radius";
    private static final String LEAF_RADIUS = "Leaf Radius";
    private static final String SNOW_RADIUS = "Snow Radius";

    public LeafBlowerModule(List<IModularItem> validItems) {
        super(validItems);
        this.addInstallCost(new ItemStack(Items.field_151042_j, 3));
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.solenoid, 1));
        this.addBaseProperty(LEAF_BLOWER_ENERGY_CONSUMPTION, 100.0, "J");
        this.addBaseProperty(PLANT_RADIUS, 1.0, "m");
        this.addBaseProperty(LEAF_RADIUS, 1.0, "m");
        this.addBaseProperty(SNOW_RADIUS, 1.0, "m");
        this.addIntTradeoffProperty(PLANT_RADIUS, PLANT_RADIUS, 8.0, "m", 1, 0);
        this.addIntTradeoffProperty(LEAF_RADIUS, LEAF_RADIUS, 8.0, "m", 1, 0);
        this.addIntTradeoffProperty(SNOW_RADIUS, SNOW_RADIUS, 5.0, "m", 1, 0);
    }

    public PowerModuleBase addIntTradeoffProperty(String tradeoffName, String propertyName, double multiplier, String unit, int roundTo, int offset) {
        units.put(propertyName, unit);
        return this.addPropertyModifier(propertyName, new PropertyModifierIntLinearAdditive(tradeoffName, multiplier, roundTo, offset));
    }

    @Override
    public String getCategory() {
        return "Tool";
    }

    @Override
    public String getDataName() {
        return MODULE_LEAF_BLOWER;
    }

    @Override
    public String getUnlocalizedName() {
        return "leafBlower";
    }

    @Override
    public String getDescription() {
        return "Create a torrent of air to knock plants out of the ground and leaves off of trees.";
    }

    @Override
    public String getTextureFile() {
        return "leafblower";
    }

    @Override
    public void onRightClick(EntityPlayer player, World world, ItemStack item) {
    }

    @Override
    public void onItemUse(ItemStack itemStack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        Block blockID = world.func_180495_p(pos).func_177230_c();
        int plant = (int)ModuleManager.computeModularProperty(itemStack, PLANT_RADIUS);
        int leaf = (int)ModuleManager.computeModularProperty(itemStack, LEAF_RADIUS);
        int snow = (int)ModuleManager.computeModularProperty(itemStack, SNOW_RADIUS);
        boolean totalEnergyDrain = false;
        this.useBlower(plant, "plants", itemStack, player, world, pos);
        this.useBlower(leaf, "leaves", itemStack, player, world, pos);
        this.useBlower(snow, "snow", itemStack, player, world, pos);
    }

    @Override
    public boolean onItemUseFirst(ItemStack itemstack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    private boolean blockCheckAndHarvest(String blocktype, EntityPlayer player, World world, BlockPos pos) {
        IBlockState blockState = world.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        if (block == null) {
            return false;
        }
        if (blocktype == "plants" && block != null && (block instanceof BlockTallGrass || block instanceof BlockFlower) && block.canHarvestBlock((IBlockAccess)player.field_70170_p, pos, player)) {
            block.func_180657_a(world, player, pos, blockState, null);
            world.func_175698_g(pos);
            return true;
        }
        if (blocktype == "leaves" && block instanceof BlockLeaves && block.canHarvestBlock((IBlockAccess)player.field_70170_p, pos, player)) {
            block.func_180657_a(world, player, pos, blockState, null);
            world.func_175698_g(pos);
            return true;
        }
        if (blocktype == "snow" && block instanceof BlockSnow && block.canHarvestBlock((IBlockAccess)player.field_70170_p, pos, player)) {
            block.func_180657_a(world, player, pos, blockState, null);
            world.func_175698_g(pos);
        }
        return false;
    }

    private void useBlower(int radius, String blocktypename, ItemStack itemStack, EntityPlayer player, World world, BlockPos pos) {
        int totalEnergyDrain = 0;
        for (int i = -radius; i < radius; ++i) {
            for (int j = -radius; j < radius; ++j) {
                for (int k = -radius; k < radius; ++k) {
                    if (!this.blockCheckAndHarvest(blocktypename, player, world, pos.func_177982_a(i, j, k))) continue;
                    totalEnergyDrain = (int)((double)totalEnergyDrain + ModuleManager.computeModularProperty(itemStack, LEAF_BLOWER_ENERGY_CONSUMPTION));
                }
            }
        }
        ElectricItemUtils.drainPlayerEnergy(player, totalEnergyDrain);
    }

    @Override
    public void onPlayerStoppedUsing(ItemStack itemStack, World world, EntityPlayer player, int par4) {
    }

    @Override
    public TextureAtlasSprite getIcon(ItemStack item) {
        return MuseIcon.leafBlower;
    }
}

