/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.tool;

import java.util.List;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IRightClickModule;
import net.machinemuse.general.gui.MuseIcon;
import net.machinemuse.powersuits.entity.EntityLuxCapacitor;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.ElectricItemUtils;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class LuxCapacitor
extends PowerModuleBase
implements IRightClickModule {
    public static final String MODULE_LUX_CAPACITOR = "Lux Capacitor";
    public static final String ENERGY = "Lux Capacitor Energy Consumption";
    public static final String RED = "Lux Capacitor Red Hue";
    public static final String GREEN = "Lux Capacitor Green Hue";
    public static final String BLUE = "Lux Capacitor Blue Hue";

    public LuxCapacitor(List<IModularItem> validItems) {
        super(validItems);
        this.addInstallCost(new ItemStack(Items.field_151114_aO, 1));
        this.addInstallCost(new ItemStack(Items.field_151042_j, 2));
        this.addBaseProperty(ENERGY, 100.0, "J");
        this.addTradeoffProperty("Red", RED, 1.0, "%");
        this.addTradeoffProperty("Green", GREEN, 1.0, "%");
        this.addTradeoffProperty("Blue", BLUE, 1.0, "%");
    }

    @Override
    public String getCategory() {
        return "Tool";
    }

    @Override
    public String getDataName() {
        return MODULE_LUX_CAPACITOR;
    }

    @Override
    public String getUnlocalizedName() {
        return "luxCapacitor";
    }

    @Override
    public String getDescription() {
        return "Launch a virtually infinite number of attractive light sources at the wall.";
    }

    @Override
    public String getTextureFile() {
        return "bluelight";
    }

    @Override
    public void onRightClick(EntityPlayer player, World world, ItemStack itemStack) {
        player.func_71008_a(itemStack, 10);
        if (!world.field_72995_K) {
            double energyConsumption = ModuleManager.computeModularProperty(itemStack, ENERGY);
            if (ElectricItemUtils.getPlayerEnergy(player) > energyConsumption) {
                ElectricItemUtils.drainPlayerEnergy(player, energyConsumption);
                double red = ModuleManager.computeModularProperty(itemStack, RED);
                double green = ModuleManager.computeModularProperty(itemStack, GREEN);
                double blue = ModuleManager.computeModularProperty(itemStack, BLUE);
                EntityLuxCapacitor luxCapacitor = new EntityLuxCapacitor(world, (EntityLivingBase)player, red, green, blue);
                world.func_72838_d((Entity)luxCapacitor);
            }
        }
    }

    @Override
    public void onItemUse(ItemStack itemStack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
    }

    @Override
    public boolean onItemUseFirst(ItemStack itemstack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void onPlayerStoppedUsing(ItemStack itemStack, World world, EntityPlayer player, int par4) {
    }

    @Override
    public TextureAtlasSprite getIcon(ItemStack item) {
        return MuseIcon.luxCapacitor;
    }
}

