/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.tool;

import java.util.List;
import java.util.Random;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IBlockBreakingModule;
import net.machinemuse.api.moduletrigger.IRightClickModule;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.machinemuse.utils.MusePlayerUtils;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class ShearsModule
extends PowerModuleBase
implements IBlockBreakingModule,
IRightClickModule {
    public static final ItemStack shears = new ItemStack((Item)Items.field_151097_aZ);
    public static final String MODULE_SHEARS = "Shears";
    private static final String SHEARING_ENERGY_CONSUMPTION = "Shearing Energy Consumption";
    private static final String SHEARING_HARVEST_SPEED = "Shearing Harvest Speed";

    public ShearsModule(List<IModularItem> validItems) {
        super(validItems);
        this.addInstallCost(new ItemStack(Items.field_151042_j, 2));
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.solenoid, 1));
        this.addBaseProperty(SHEARING_ENERGY_CONSUMPTION, 50.0, "J");
        this.addBaseProperty(SHEARING_HARVEST_SPEED, 8.0, "x");
        this.addTradeoffProperty("Overclock", SHEARING_ENERGY_CONSUMPTION, 950.0);
        this.addTradeoffProperty("Overclock", SHEARING_HARVEST_SPEED, 22.0);
    }

    @Override
    public String getCategory() {
        return "Tool";
    }

    @Override
    public String getDataName() {
        return MODULE_SHEARS;
    }

    @Override
    public String getUnlocalizedName() {
        return "shears";
    }

    @Override
    public String getDescription() {
        return "Cuts through leaves, wool, and creepers alike.";
    }

    @Override
    public void onRightClick(EntityPlayer playerClicking, World world, ItemStack stack) {
        Entity entity;
        IShearable target;
        if (playerClicking.field_70170_p.field_72995_K) {
            return;
        }
        MovingObjectPosition hitMOP = MusePlayerUtils.raytraceEntities(world, playerClicking, false, 8.0);
        if (hitMOP != null && hitMOP.field_72308_g instanceof IShearable && (target = (IShearable)hitMOP.field_72308_g).isShearable(stack, (IBlockAccess)entity.field_70170_p, (entity = hitMOP.field_72308_g).func_180425_c())) {
            List drops = target.onSheared(stack, (IBlockAccess)entity.field_70170_p, entity.func_180425_c(), EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)stack));
            Random rand = new Random();
            for (ItemStack drop : drops) {
                EntityItem ent = entity.func_70099_a(drop, 1.0f);
                ent.field_70181_x += (double)(rand.nextFloat() * 0.05f);
                ent.field_70159_w += (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f);
                ent.field_70179_y += (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f);
            }
            ElectricItemUtils.drainPlayerEnergy(playerClicking, ModuleManager.computeModularProperty(stack, SHEARING_ENERGY_CONSUMPTION));
        }
    }

    @Override
    public void onItemUse(ItemStack itemStack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
    }

    @Override
    public boolean onItemUseFirst(ItemStack itemstack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void onPlayerStoppedUsing(ItemStack itemStack, World world, EntityPlayer player, int par4) {
    }

    @Override
    public boolean canHarvestBlock(ItemStack stack, BlockPos pos, EntityPlayer player) {
        return ForgeHooks.canToolHarvestBlock((IBlockAccess)player.field_70170_p, (BlockPos)pos, (ItemStack)shears) && ElectricItemUtils.getPlayerEnergy(player) > ModuleManager.computeModularProperty(stack, SHEARING_ENERGY_CONSUMPTION);
    }

    @Override
    public boolean onBlockDestroyed(ItemStack itemstack, World world, Block block, BlockPos pos, EntityLivingBase player) {
        IShearable target;
        if (player.field_70170_p.field_72995_K) {
            return false;
        }
        if (block instanceof IShearable && ElectricItemUtils.getPlayerEnergy((EntityPlayer)player) > ModuleManager.computeModularProperty(itemstack, SHEARING_ENERGY_CONSUMPTION) && (target = (IShearable)block).isShearable(itemstack, (IBlockAccess)player.field_70170_p, pos)) {
            List drops = target.onSheared(itemstack, (IBlockAccess)player.field_70170_p, pos, EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)itemstack));
            Random rand = new Random();
            for (ItemStack stack : drops) {
                float f = 0.7f;
                double d = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d1 = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d2 = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                EntityItem entityitem = new EntityItem(player.field_70170_p, (double)pos.func_177958_n() + d, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, stack);
                entityitem.func_174869_p();
                player.field_70170_p.func_72838_d((Entity)entityitem);
            }
            ElectricItemUtils.drainPlayerEnergy((EntityPlayer)player, ModuleManager.computeModularProperty(itemstack, SHEARING_ENERGY_CONSUMPTION));
            ((EntityPlayer)player).func_71064_a(StatList.field_75934_C[Block.func_149682_b((Block)block)], 1);
        }
        return false;
    }

    @Override
    public void handleBreakSpeed(PlayerEvent.BreakSpeed event) {
        float defaultEffectiveness = 8.0f;
        double ourEffectiveness = ModuleManager.computeModularProperty(event.entityPlayer.func_71045_bC(), SHEARING_HARVEST_SPEED);
        event.newSpeed = (float)((double)event.newSpeed * Math.max((double)defaultEffectiveness, ourEffectiveness));
    }

    @Override
    public TextureAtlasSprite getIcon(ItemStack item) {
        return Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(shears).func_177554_e();
    }

    @Override
    public String getTextureFile() {
        return null;
    }
}

