/*
 * Decompiled with CFR 0.152.
 */
package com.alc.moreminecarts.blocks;

import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.RailState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.item.minecart.ContainerMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.RailShape;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class ColorDetectorRailBlock
extends AbstractRailBlock {
    public static final EnumProperty<RailShape> SHAPE = BlockStateProperties.field_208166_S;
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    public Supplier<Item> detected_item;

    public ColorDetectorRailBlock(AbstractBlock.Properties builder, Supplier<Item> det) {
        super(true, builder);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false))).func_206870_a(SHAPE, (Comparable)RailShape.NORTH_SOUTH));
        this.detected_item = det;
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
    }

    public boolean canMakeSlopes(BlockState state, IBlockReader world, BlockPos pos) {
        return false;
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (worldIn.field_72995_K) {
            return;
        }
        this.updatePoweredState(worldIn, pos, state);
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        this.updatePoweredState((World)worldIn, pos, state);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{SHAPE, POWERED});
    }

    private void updatePoweredState(World worldIn, BlockPos pos, BlockState state) {
        if (this.func_196260_a(state, (IWorldReader)worldIn, pos)) {
            boolean was_powered = (Boolean)state.func_177229_b((Property)POWERED);
            boolean activate = false;
            List<AbstractMinecartEntity> list = this.findMinecarts(worldIn, pos, AbstractMinecartEntity.class, entity -> true);
            if (!list.isEmpty()) {
                if (was_powered) {
                    activate = true;
                } else {
                    for (AbstractMinecartEntity minecart : list) {
                        if (minecart.func_184264_v() == AbstractMinecartEntity.Type.RIDEABLE) {
                            PlayerEntity player;
                            Entity entity2;
                            List passengers = minecart.func_184188_bt();
                            if (passengers.isEmpty() || !((entity2 = (Entity)passengers.get(0)) instanceof PlayerEntity) || (player = (PlayerEntity)entity2).func_184586_b(Hand.MAIN_HAND).func_77973_b() != this.detected_item.get() && player.func_184586_b(Hand.OFF_HAND).func_77973_b() != this.detected_item.get()) continue;
                            activate = true;
                            continue;
                        }
                        if (minecart.func_184264_v() != AbstractMinecartEntity.Type.CHEST && minecart.func_184264_v() != AbstractMinecartEntity.Type.HOPPER) continue;
                        ContainerMinecartEntity container = (ContainerMinecartEntity)minecart;
                        HashSet<Item> set = new HashSet<Item>();
                        set.add(this.detected_item.get());
                        if (!container.func_213902_a(set)) continue;
                        activate = true;
                    }
                }
            }
            if (activate && !was_powered) {
                BlockState blockstate = (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(true));
                worldIn.func_180501_a(pos, blockstate, 3);
                this.updateConnectedRails(worldIn, pos, blockstate, true);
                worldIn.func_195593_d(pos, (Block)this);
                worldIn.func_195593_d(pos.func_177977_b(), (Block)this);
                worldIn.func_225319_b(pos, state, blockstate);
            }
            if (!activate && was_powered) {
                BlockState blockstate1 = (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false));
                worldIn.func_180501_a(pos, blockstate1, 3);
                this.updateConnectedRails(worldIn, pos, blockstate1, false);
                worldIn.func_195593_d(pos, (Block)this);
                worldIn.func_195593_d(pos.func_177977_b(), (Block)this);
                worldIn.func_225319_b(pos, state, blockstate1);
            }
            if (activate) {
                worldIn.func_205220_G_().func_205360_a(pos, (Object)this, 20);
            }
            worldIn.func_175666_e(pos, (Block)this);
        }
    }

    protected void updateConnectedRails(World worldIn, BlockPos pos, BlockState state, boolean powered) {
        RailState railstate = new RailState(worldIn, pos, state);
        for (BlockPos blockpos : railstate.func_196907_a()) {
            BlockState blockstate = worldIn.func_180495_p(blockpos);
            blockstate.func_215697_a(worldIn, blockpos, blockstate.func_177230_c(), pos, false);
        }
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!oldState.func_203425_a(state.func_177230_c())) {
            this.updatePoweredState(worldIn, pos, this.func_235327_a_(state, worldIn, pos, isMoving));
        }
    }

    protected <T extends AbstractMinecartEntity> List<T> findMinecarts(World worldIn, BlockPos pos, Class<T> cartType, @Nullable Predicate<Entity> filter) {
        return worldIn.func_175647_a(cartType, this.getDectectionBox(pos), filter);
    }

    private AxisAlignedBB getDectectionBox(BlockPos pos) {
        double d0 = 0.2;
        return new AxisAlignedBB((double)pos.func_177958_n() + 0.2, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.2, (double)(pos.func_177958_n() + 1) - 0.2, (double)(pos.func_177956_o() + 1) - 0.2, (double)(pos.func_177952_p() + 1) - 0.2);
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return (Boolean)blockState.func_177229_b((Property)POWERED) != false ? 15 : 0;
    }

    public int func_176211_b(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        if (!((Boolean)blockState.func_177229_b((Property)POWERED)).booleanValue()) {
            return 0;
        }
        return side == Direction.UP ? 15 : 0;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        switch (rot) {
            case CLOCKWISE_180: {
                switch ((RailShape)state.func_177229_b(SHAPE)) {
                    case ASCENDING_EAST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.ASCENDING_WEST);
                    }
                    case ASCENDING_WEST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.ASCENDING_EAST);
                    }
                    case ASCENDING_NORTH: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.ASCENDING_SOUTH);
                    }
                    case ASCENDING_SOUTH: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.ASCENDING_NORTH);
                    }
                    case SOUTH_EAST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.NORTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.NORTH_EAST);
                    }
                    case NORTH_WEST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.SOUTH_EAST);
                    }
                    case NORTH_EAST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.SOUTH_WEST);
                    }
                }
            }
            case COUNTERCLOCKWISE_90: {
                switch ((RailShape)state.func_177229_b(SHAPE)) {
                    case ASCENDING_EAST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.ASCENDING_NORTH);
                    }
                    case ASCENDING_WEST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.ASCENDING_SOUTH);
                    }
                    case ASCENDING_NORTH: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.ASCENDING_WEST);
                    }
                    case ASCENDING_SOUTH: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.ASCENDING_EAST);
                    }
                    case SOUTH_EAST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.NORTH_EAST);
                    }
                    case SOUTH_WEST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.SOUTH_EAST);
                    }
                    case NORTH_WEST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.SOUTH_WEST);
                    }
                    case NORTH_EAST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.NORTH_WEST);
                    }
                    case NORTH_SOUTH: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.EAST_WEST);
                    }
                    case EAST_WEST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.NORTH_SOUTH);
                    }
                }
            }
            case CLOCKWISE_90: {
                switch ((RailShape)state.func_177229_b(SHAPE)) {
                    case ASCENDING_EAST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.ASCENDING_SOUTH);
                    }
                    case ASCENDING_WEST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.ASCENDING_NORTH);
                    }
                    case ASCENDING_NORTH: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.ASCENDING_EAST);
                    }
                    case ASCENDING_SOUTH: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.ASCENDING_WEST);
                    }
                    case SOUTH_EAST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.SOUTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.NORTH_WEST);
                    }
                    case NORTH_WEST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.NORTH_EAST);
                    }
                    case NORTH_EAST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.SOUTH_EAST);
                    }
                    case NORTH_SOUTH: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.EAST_WEST);
                    }
                    case EAST_WEST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.NORTH_SOUTH);
                    }
                }
            }
        }
        return state;
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        RailShape railshape = (RailShape)state.func_177229_b(SHAPE);
        block0 : switch (mirrorIn) {
            case LEFT_RIGHT: {
                switch (railshape) {
                    case ASCENDING_NORTH: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.ASCENDING_SOUTH);
                    }
                    case ASCENDING_SOUTH: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.ASCENDING_NORTH);
                    }
                    case SOUTH_EAST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.NORTH_EAST);
                    }
                    case SOUTH_WEST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.NORTH_WEST);
                    }
                    case NORTH_WEST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.SOUTH_WEST);
                    }
                    case NORTH_EAST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.SOUTH_EAST);
                    }
                }
                return super.func_185471_a(state, mirrorIn);
            }
            case FRONT_BACK: {
                switch (railshape) {
                    case ASCENDING_EAST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.ASCENDING_WEST);
                    }
                    case ASCENDING_WEST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.ASCENDING_EAST);
                    }
                    default: {
                        break block0;
                    }
                    case SOUTH_EAST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.SOUTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.SOUTH_EAST);
                    }
                    case NORTH_WEST: {
                        return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.NORTH_EAST);
                    }
                    case NORTH_EAST: 
                }
                return (BlockState)state.func_206870_a(SHAPE, (Comparable)RailShape.NORTH_WEST);
            }
        }
        return super.func_185471_a(state, mirrorIn);
    }

    public Property<RailShape> func_176560_l() {
        return SHAPE;
    }
}

