/*
 * Decompiled with CFR 0.152.
 */
package com.alc.moreminecarts.items;

import com.alc.moreminecarts.entities.CouplerEntity;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ObjectHolder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ObjectHolder(value="moreminecarts")
public class CouplerItem
extends Item {
    public static final EntityType<CouplerEntity> coupler = null;
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String TAG_COUPLED_UUID_1 = "coupled_UUID_1";
    private static final String TAG_COUPLED_UUID_2 = "coupled_UUID_2";

    public CouplerItem(Item.Properties properties) {
        super(properties);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        CompoundNBT tag = stack.func_196082_o();
        if (!tag.func_186855_b(TAG_COUPLED_UUID_1) && tag.func_186855_b(TAG_COUPLED_UUID_2) && entityIn instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entityIn;
            player.func_184185_a(SoundEvents.field_232695_bC_, 0.7f, 1.0f);
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            CouplerItem.clearCoupler(stack);
            return;
        }
        if (!(worldIn instanceof ServerWorld)) {
            return;
        }
        ServerWorld world = (ServerWorld)worldIn;
        if (tag.func_186855_b(TAG_COUPLED_UUID_1) && tag.func_186855_b(TAG_COUPLED_UUID_2)) {
            double distance;
            UUID uuid1 = tag.func_186857_a(TAG_COUPLED_UUID_1);
            Entity ent1 = world.func_217461_a(uuid1);
            UUID uuid2 = tag.func_186857_a(TAG_COUPLED_UUID_2);
            Entity ent2 = world.func_217461_a(uuid2);
            if (ent1 != null && ent2 != null && ent1 != ent2 && (distance = (double)ent1.func_70032_d(ent2)) < 3.0) {
                Vector3d center_pos = new Vector3d((ent1.func_226277_ct_() + ent2.func_226277_ct_()) / 2.0, (ent1.func_226278_cu_() + ent2.func_226278_cu_()) / 2.0, (ent1.func_226281_cx_() + ent2.func_226281_cx_()) / 2.0);
                List list = worldIn.func_217394_a(coupler, new AxisAlignedBB(center_pos.field_72450_a + 0.5, center_pos.field_72448_b + 0.5, center_pos.field_72449_c + 0.5, center_pos.field_72450_a - 0.5, center_pos.field_72448_b - 0.5, center_pos.field_72449_c - 0.5), entity -> true);
                boolean is_duplicate = false;
                for (CouplerEntity ent : list) {
                    if ((ent.getFirstVehicle() != ent1 || ent.getSecondVehicle() != ent2) && (ent.getSecondVehicle() != ent1 || ent.getFirstVehicle() != ent2)) continue;
                    is_duplicate = true;
                    break;
                }
                if (!is_duplicate) {
                    CouplerEntity coupler_ent = new CouplerEntity(coupler, worldIn, ent1, ent2);
                    worldIn.func_217376_c((Entity)coupler_ent);
                    tag.func_82580_o(TAG_COUPLED_UUID_1);
                    return;
                }
            }
            CouplerItem.clearCoupler(stack);
        }
    }

    public static void hookIn(PlayerEntity player, World worldIn, ItemStack used, Entity vehicle) {
        CompoundNBT tag = used.func_196082_o();
        if (tag.func_186855_b(TAG_COUPLED_UUID_2)) {
            // empty if block
        }
        if (tag.func_186855_b(TAG_COUPLED_UUID_1)) {
            UUID uuid = vehicle.func_110124_au();
            tag.func_186854_a(TAG_COUPLED_UUID_2, uuid);
        } else {
            UUID uuid = vehicle.func_110124_au();
            tag.func_186854_a(TAG_COUPLED_UUID_1, uuid);
            tag.func_74768_a("CustomModelData", 1);
        }
    }

    public static void clearCoupler(ItemStack used) {
        CompoundNBT tag = used.func_196082_o();
        tag.func_82580_o(TAG_COUPLED_UUID_1);
        tag.func_82580_o(TAG_COUPLED_UUID_2);
        tag.func_74768_a("CustomModelData", 0);
    }
}

