/*
 * Decompiled with CFR 0.152.
 */
package com.alc.moreminecarts.renderers;

import com.alc.moreminecarts.entities.CouplerEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.model.LeashKnotModel;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.LightType;
import net.minecraft.world.World;

public class CouplerRenderer
extends EntityRenderer<CouplerEntity> {
    private static final ResourceLocation LEASH_KNOT_TEXTURES = new ResourceLocation("minecraft:textures/entity/lead_knot.png");
    private final LeashKnotModel<CouplerEntity> leashKnotModel = new LeashKnotModel();

    public CouplerRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn);
    }

    public void render(CouplerEntity entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        Entity vehicle1 = entityIn.getFirstVehicle();
        Entity vehicle2 = entityIn.getSecondVehicle();
        if (vehicle1 != null && vehicle2 != null) {
            this.renderCoupler(entityIn.field_70170_p, partialTicks, matrixStackIn, bufferIn, vehicle1, vehicle2);
        }
        super.func_225623_a_((Entity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    public ResourceLocation getEntityTexture(CouplerEntity entity) {
        return LEASH_KNOT_TEXTURES;
    }

    private <E extends Entity> void renderCoupler(World world, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, Entity vehicle1, Entity vehicle2) {
        matrixStackIn.func_227860_a_();
        Vector3d from_pos = vehicle1.func_213303_ch().func_178786_a(0.0, vehicle1.func_174813_aQ().func_216360_c() / 2.0, 0.0);
        Vector3d to_pos = vehicle2.func_213303_ch().func_178786_a(0.0, vehicle2.func_174813_aQ().func_216360_c() / 2.0, 0.0);
        double d0 = (double)(vehicle1.func_195046_g(partialTicks) * ((float)Math.PI / 180)) + 1.5707963267948966;
        Vector3d v1_lead_pos = vehicle1.func_241205_ce_();
        double d1 = Math.cos(d0) * v1_lead_pos.field_72449_c + Math.sin(d0) * v1_lead_pos.field_72450_a;
        double d2 = Math.sin(d0) * v1_lead_pos.field_72449_c - Math.cos(d0) * v1_lead_pos.field_72450_a;
        double d3 = MathHelper.func_219803_d((double)partialTicks, (double)vehicle1.field_70169_q, (double)vehicle1.func_226277_ct_()) + d1;
        double d4 = MathHelper.func_219803_d((double)partialTicks, (double)vehicle1.field_70167_r, (double)vehicle1.func_226278_cu_()) + v1_lead_pos.field_72448_b;
        double d5 = MathHelper.func_219803_d((double)partialTicks, (double)vehicle1.field_70166_s, (double)vehicle1.func_226281_cx_()) + d2;
        float dx = (float)(to_pos.field_72450_a - from_pos.field_72450_a);
        float dy = (float)(to_pos.field_72448_b - from_pos.field_72448_b);
        float dz = (float)(to_pos.field_72449_c - from_pos.field_72449_c);
        matrixStackIn.func_227861_a_((double)(-dx / 2.0f), (double)(-dy / 2.0f), (double)(-dz / 2.0f));
        IVertexBuilder ivertexbuilder = bufferIn.getBuffer(RenderType.func_228649_h_());
        Matrix4f matrix4f = matrixStackIn.func_227866_c_().func_227870_a_();
        float dist = MathHelper.func_226165_i_((float)(dx * dx + dz * dz)) * 0.025f / 2.0f;
        float norm_z = dz * dist;
        float norm_x = dx * dist;
        BlockPos blockpos1 = new BlockPos(from_pos);
        BlockPos blockpos2 = new BlockPos(to_pos);
        int i = this.getBlockLightFake(vehicle1, blockpos1);
        int j = this.getBlockLightFake(vehicle2, blockpos2);
        int k = world.func_226658_a_(LightType.SKY, blockpos1);
        int l = world.func_226658_a_(LightType.SKY, blockpos2);
        CouplerRenderer.renderSide(ivertexbuilder, matrix4f, dx, dy, dz, i, j, k, l, 0.1f, 0.1f, norm_z, norm_x);
        matrixStackIn.func_227865_b_();
    }

    protected int getBlockLightFake(Entity entityIn, BlockPos partialTicks) {
        return entityIn.func_70027_ad() ? 15 : entityIn.field_70170_p.func_226658_a_(LightType.BLOCK, partialTicks);
    }

    public static void renderSide(IVertexBuilder builderIn, Matrix4f matrixIn, float p_229119_2_, float p_229119_3_, float p_229119_4_, int blockLight, int holderBlockLight, int skyLight, int holderSkyLight, float p_229119_9_, float p_229119_10_, float norm_z, float norm_x) {
        int i = 4;
        for (int j = 0; j < 4; ++j) {
            float f = (float)j / 3.0f;
            int k = (int)MathHelper.func_219799_g((float)f, (float)blockLight, (float)holderBlockLight);
            int l = (int)MathHelper.func_219799_g((float)f, (float)skyLight, (float)holderSkyLight);
            int i1 = LightTexture.func_228451_a_((int)k, (int)l);
            CouplerRenderer.addVertexPair(builderIn, matrixIn, i1, p_229119_2_, p_229119_3_, p_229119_4_, p_229119_9_, p_229119_10_, 4, j, false, norm_z, norm_x);
            CouplerRenderer.addVertexPair(builderIn, matrixIn, i1, p_229119_2_, p_229119_3_, p_229119_4_, p_229119_9_, p_229119_10_, 4, j + 1, true, norm_z, norm_x);
        }
    }

    public static void addVertexPair(IVertexBuilder builderIn, Matrix4f matrixIn, int packedLight, float dx, float dy, float dz, float thickness, float y_width, int total, int index, boolean is_first, float norm_z, float norm_x) {
        float stress = Math.abs(dx * dx + dy * dy + dz * dz);
        stress = Math.max(0.0f, stress - 3.0f);
        float R = 0.1f + stress / 40.0f;
        float G = 0.15f;
        float B = 0.2f;
        float fraction_done = (float)index / (float)total;
        float center_x = dx * fraction_done;
        float center_y = dy * fraction_done;
        float center_z = dz * fraction_done;
        if (!is_first) {
            builderIn.func_227888_a_(matrixIn, center_x + norm_z, center_y + thickness - y_width, center_z - norm_x).func_227885_a_(R, G, B, 1.0f).func_227886_a_(packedLight).func_181675_d();
        }
        builderIn.func_227888_a_(matrixIn, center_x - norm_z, center_y + y_width, center_z + norm_x).func_227885_a_(R, G, B, 1.0f).func_227886_a_(packedLight).func_181675_d();
        if (is_first) {
            builderIn.func_227888_a_(matrixIn, center_x + norm_z, center_y + thickness - y_width, center_z - norm_x).func_227885_a_(R, G, B, 1.0f).func_227886_a_(packedLight).func_181675_d();
        }
    }

    public static void addVertexPairOpposite(IVertexBuilder builderIn, Matrix4f matrixIn, int packedLight, float dx, float dy, float dz, float thickness, float y_width, int total, int index, boolean is_first, float norm_z, float norm_x) {
        float stress = Math.abs(dx * dx + dy * dy + dz * dz);
        stress = Math.max(0.0f, stress - 3.0f);
        float R = 0.1f + stress / 40.0f;
        float G = 0.15f;
        float B = 0.2f;
        float fraction_done = (float)index / (float)total;
        float center_x = dx * fraction_done;
        float center_y = dy * fraction_done;
        float center_z = dz * fraction_done;
        float magn = MathHelper.func_226165_i_((float)(dx * dx + dy * dy));
        float thickness_z = norm_z * thickness * 100.0f;
        float thickness_x = norm_x * thickness * 100.0f;
        if (!is_first) {
            builderIn.func_227888_a_(matrixIn, center_x + thickness_x / 2.0f + norm_z, center_y + thickness / 2.0f - y_width, center_z + thickness_z / 2.0f - norm_x).func_227885_a_(R, G, B, 1.0f).func_227886_a_(packedLight).func_181675_d();
        }
        builderIn.func_227888_a_(matrixIn, center_x - thickness_x / 2.0f - norm_z, center_y + thickness / 2.0f + y_width, center_z - thickness_z / 2.0f + norm_x).func_227885_a_(R, G, B, 1.0f).func_227886_a_(packedLight).func_181675_d();
        if (is_first) {
            builderIn.func_227888_a_(matrixIn, center_x + thickness_x / 2.0f + norm_z, center_y + thickness / 2.0f - y_width, center_z + thickness_z / 2.0f - norm_x).func_227885_a_(R, G, B, 1.0f).func_227886_a_(packedLight).func_181675_d();
        }
    }
}

