/*
 * Decompiled with CFR 0.152.
 */
package mod.ilja615.mosaic_blocks;

import java.util.function.Function;
import java.util.function.Supplier;
import mod.ilja615.mosaic_blocks.Config;
import mod.ilja615.mosaic_blocks.ModBlocks;
import mod.ilja615.mosaic_blocks.MosaicBlock;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(value="mosaic_blocks")
public class ModMain {
    public static final String MOD_ID = "mosaic_blocks";
    public static final Item.Properties ITEM_PROPERTY = new Item.Properties().func_200916_a(ItemGroup.field_78031_c);
    public static final AbstractBlock.Properties BLOCK_PROPERTY = AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_192427_dB);
    public static ModMain INSTANCE;

    public ModMain() {
        INSTANCE = this;
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, Config.config);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        modEventBus.addListener(this::setupCommon);
        Config.loadConfig(Config.config, FMLPaths.CONFIGDIR.get().resolve("mosaic_blocks-server.toml").toString());
        DeferredRegister blocks = ModMain.makeRegister(modEventBus, ForgeRegistries.BLOCKS);
        DeferredRegister items = ModMain.makeRegister(modEventBus, ForgeRegistries.ITEMS);
        ModBlocks.MOSAIC_BLOCK = ModMain.registerBlockAndItem(blocks, items, "mosaic_block", () -> new Block(BLOCK_PROPERTY), block -> new BlockItem(block, ITEM_PROPERTY));
        ModBlocks.ARROW_MOSAIC_BLOCK = ModMain.registerBlockAndItem(blocks, items, "arrow_mosaic_block", () -> new MosaicBlock(BLOCK_PROPERTY), block -> new BlockItem(block, ITEM_PROPERTY));
        ModBlocks.BOWL_MOSAIC_BLOCK = ModMain.registerBlockAndItem(blocks, items, "bowl_mosaic_block", () -> new MosaicBlock(BLOCK_PROPERTY), block -> new BlockItem(block, ITEM_PROPERTY));
        ModBlocks.CORNER_MOSAIC_BLOCK = ModMain.registerBlockAndItem(blocks, items, "corner_mosaic_block", () -> new MosaicBlock(BLOCK_PROPERTY), block -> new BlockItem(block, ITEM_PROPERTY));
        ModBlocks.CRESCENT_MOSAIC_BLOCK = ModMain.registerBlockAndItem(blocks, items, "crescent_mosaic_block", () -> new MosaicBlock(BLOCK_PROPERTY), block -> new BlockItem(block, ITEM_PROPERTY));
        ModBlocks.DOWNWARD_POINT_MOSAIC_BLOCK = ModMain.registerBlockAndItem(blocks, items, "downward_point_mosaic_block", () -> new MosaicBlock(BLOCK_PROPERTY), block -> new BlockItem(block, ITEM_PROPERTY));
        ModBlocks.DOWNWARD_SLOPE_MOSAIC_BLOCK = ModMain.registerBlockAndItem(blocks, items, "downward_slope_mosaic_block", () -> new MosaicBlock(BLOCK_PROPERTY), block -> new BlockItem(block, ITEM_PROPERTY));
        ModBlocks.FOLD_MOSAIC_BLOCK = ModMain.registerBlockAndItem(blocks, items, "fold_mosaic_block", () -> new MosaicBlock(BLOCK_PROPERTY), block -> new BlockItem(block, ITEM_PROPERTY));
        ModBlocks.FULL_MOSAIC_BLOCK = ModMain.registerBlockAndItem(blocks, items, "full_mosaic_block", () -> new MosaicBlock(BLOCK_PROPERTY), block -> new BlockItem(block, ITEM_PROPERTY));
        ModBlocks.HALF_MOSAIC_BLOCK = ModMain.registerBlockAndItem(blocks, items, "half_mosaic_block", () -> new MosaicBlock(BLOCK_PROPERTY), block -> new BlockItem(block, ITEM_PROPERTY));
        ModBlocks.QUARTER_MOSAIC_BLOCK = ModMain.registerBlockAndItem(blocks, items, "quarter_mosaic_block", () -> new MosaicBlock(BLOCK_PROPERTY), block -> new BlockItem(block, ITEM_PROPERTY));
        ModBlocks.ROUND_MOSAIC_BLOCK = ModMain.registerBlockAndItem(blocks, items, "round_mosaic_block", () -> new MosaicBlock(BLOCK_PROPERTY), block -> new BlockItem(block, ITEM_PROPERTY));
        ModBlocks.STAIR_MOSAIC_BLOCK = ModMain.registerBlockAndItem(blocks, items, "stair_mosaic_block", () -> new MosaicBlock(BLOCK_PROPERTY), block -> new BlockItem(block, ITEM_PROPERTY));
        ModBlocks.TRIANGLE_MOSAIC_BLOCK = ModMain.registerBlockAndItem(blocks, items, "triangle_mosaic_block", () -> new MosaicBlock(BLOCK_PROPERTY), block -> new BlockItem(block, ITEM_PROPERTY));
        ModBlocks.UPWARD_POINT_MOSAIC_BLOCK = ModMain.registerBlockAndItem(blocks, items, "upward_point_mosaic_block", () -> new MosaicBlock(BLOCK_PROPERTY), block -> new BlockItem(block, ITEM_PROPERTY));
        ModBlocks.UPWARD_SLOPE_MOSAIC_BLOCK = ModMain.registerBlockAndItem(blocks, items, "upward_slope_mosaic_block", () -> new MosaicBlock(BLOCK_PROPERTY), block -> new BlockItem(block, ITEM_PROPERTY));
        ModBlocks.WEDGE_MOSAIC_BLOCK = ModMain.registerBlockAndItem(blocks, items, "wedge_mosaic_block", () -> new MosaicBlock(BLOCK_PROPERTY), block -> new BlockItem(block, ITEM_PROPERTY));
    }

    private void setupCommon(FMLCommonSetupEvent event) {
    }

    static <T extends IForgeRegistryEntry<T>> DeferredRegister<T> makeRegister(IEventBus modBus, IForgeRegistry<T> registry) {
        DeferredRegister register = DeferredRegister.create(registry, (String)MOD_ID);
        register.register(modBus);
        return register;
    }

    static <BLOCK extends Block, ITEM extends BlockItem> RegistryObject<BLOCK> registerBlockAndItem(DeferredRegister<Block> blocks, DeferredRegister<Item> items, String name, Supplier<BLOCK> blockSupplier, Function<BLOCK, ITEM> itemFactory) {
        RegistryObject blockObject = blocks.register(name, blockSupplier);
        items.register(name, () -> (BlockItem)itemFactory.apply(blockObject.get()));
        return blockObject;
    }
}

