/*
 * Decompiled with CFR 0.152.
 */
package com.ProfitOrange.MoShiz.init;

import com.ProfitOrange.MoShiz.enchantment.AutoSmelt;
import com.ProfitOrange.MoShiz.enchantment.Height;
import com.ProfitOrange.MoShiz.enchantment.IceAspect;
import com.ProfitOrange.MoShiz.enchantment.LifeSteal;
import com.ProfitOrange.MoShiz.enchantment.Swift;
import com.ProfitOrange.MoShiz.enchantment.Width;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="ms")
@Mod.EventBusSubscriber(modid="ms")
public class MoShizEnchantments {
    public static Enchantment ICE_ASPECT;
    public static Enchantment SWIFT;
    public static Enchantment LIFE_STEAL;
    public static Enchantment WIDTH;
    public static Enchantment HEIGHT;
    public static Enchantment AUTO_SMELT;

    @SubscribeEvent
    public static void registerAll(RegistryEvent.Register<Enchantment> event) {
        if (!event.getName().equals((Object)ForgeRegistries.ENCHANTMENTS.getRegistryName())) {
            return;
        }
        ICE_ASPECT = MoShizEnchantments.setup(event.getRegistry(), new IceAspect(), "ice_aspect");
        SWIFT = MoShizEnchantments.setup(event.getRegistry(), new Swift(), "swift");
        LIFE_STEAL = MoShizEnchantments.setup(event.getRegistry(), new LifeSteal(), "life_steal");
        WIDTH = MoShizEnchantments.setup(event.getRegistry(), new Width(), "width");
        HEIGHT = MoShizEnchantments.setup(event.getRegistry(), new Height(), "height");
        AUTO_SMELT = MoShizEnchantments.setup(event.getRegistry(), new AutoSmelt(Enchantment.Rarity.VERY_RARE, EnchantmentType.DIGGER, EquipmentSlotType.MAINHAND), "auto_smelt");
    }

    @Nonnull
    private static <T extends IForgeRegistryEntry<T>> T setup(IForgeRegistry<T> registry, @Nonnull T entry, @Nonnull String name) {
        return MoShizEnchantments.setup(registry, entry, new ResourceLocation("ms", name));
    }

    @Nonnull
    private static <T extends IForgeRegistryEntry<T>> T setup(IForgeRegistry<T> registry, @Nonnull T entry, @Nonnull ResourceLocation registryName) {
        Preconditions.checkNotNull(entry, (Object)"Entry cannot be null!");
        Preconditions.checkNotNull((Object)registryName, (Object)"Registry name to assign to entry cannot be null!");
        entry.setRegistryName(registryName);
        registry.register(entry);
        return entry;
    }
}

