/*
 * Decompiled with CFR 0.152.
 */
package fudge.notenoughcrashes.mixins;

import fudge.notenoughcrashes.patches.PatchedCrashReport;
import fudge.notenoughcrashes.stacktrace.ModIdentifier;
import fudge.notenoughcrashes.stacktrace.StacktraceDeobfuscator;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.fabricmc.loader.api.metadata.Person;
import net.minecraft.class_128;
import net.minecraft.class_129;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_128.class}, priority=500)
public abstract class MixinCrashReport
implements PatchedCrashReport {
    private static final boolean ANNOYING_EASTER_EGG_DISABLED = true;
    @Shadow
    @Final
    private class_129 field_1092;
    @Shadow
    @Final
    private List<class_129> field_1089;
    @Shadow
    @Final
    private Throwable field_1093;
    @Shadow
    @Final
    private String field_1087;
    private Set<ModMetadata> suspectedMods = null;

    @Shadow
    private static String method_573() {
        return null;
    }

    private static String stacktraceToString(Throwable cause) {
        StringWriter writer = new StringWriter();
        cause.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    @Override
    public Set<ModMetadata> getSuspectedMods() {
        return this.suspectedMods;
    }

    @Inject(method={"fillSystemDetails"}, at={@At(value="HEAD")})
    private void beforeFillSystemDetails(CallbackInfo ci) {
        StacktraceDeobfuscator.deobfuscateThrowable(this.field_1093);
    }

    @Inject(method={"fillSystemDetails"}, at={@At(value="TAIL")})
    private void afterFillSystemDetails(CallbackInfo ci) {
        this.field_1092.method_577("Suspected Mods", () -> {
            try {
                this.suspectedMods = ModIdentifier.identifyFromStacktrace(this.field_1093);
                String modListString = "Unknown";
                ArrayList<String> modNames = new ArrayList<String>();
                for (ModMetadata mod : this.suspectedMods) {
                    modNames.add(mod.getName() + " (" + mod.getId() + ")");
                }
                if (!modNames.isEmpty()) {
                    modListString = StringUtils.join(modNames, (String)", ");
                }
                return modListString;
            }
            catch (Throwable e) {
                return ExceptionUtils.getStackTrace((Throwable)e).replace("\t", "    ");
            }
        });
    }

    @Overwrite
    public String method_568() {
        StringBuilder builder = new StringBuilder();
        builder.append("---- Minecraft Crash Report ----\n").append("// ").append(MixinCrashReport.method_573()).append("\n\n").append("Time: ").append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z").format(new Date())).append("\n").append("Description: ").append(this.field_1087).append("\n\n").append(MixinCrashReport.stacktraceToString(this.field_1093).replace("\t", "    ")).append("\n\nA detailed walkthrough of the error, its code path and all known details is as follows:\n");
        for (int i = 0; i < 87; ++i) {
            builder.append("-");
        }
        builder.append("\n\n");
        this.method_555(builder);
        return builder.toString().replace("\t", "    ");
    }

    @Overwrite
    public void method_555(StringBuilder builder) {
        for (class_129 section : this.field_1089) {
            section.method_574(builder);
            builder.append("\n");
        }
        this.field_1092.method_574(builder);
    }

    private String generateEasterEggComment() {
        try {
            ModMetadata mod;
            String comment = MixinCrashReport.method_573();
            if (comment.contains("Dinnerbone") && !(mod = this.suspectedMods.iterator().next()).getAuthors().isEmpty()) {
                String author = ((Person)mod.getAuthors().iterator().next()).getName();
                comment = comment.replace("Dinnerbone", author);
            }
            return comment;
        }
        catch (Throwable throwable) {
            return MixinCrashReport.method_573();
        }
    }
}

