/*
 * Decompiled with CFR 0.152.
 */
package fudge.notenoughcrashes;

import fudge.notenoughcrashes.DeobfuscatingRewritePolicy;
import fudge.notenoughcrashes.ModConfig;
import fudge.notenoughcrashes.stacktrace.StacktraceDeobfuscator;
import fudge.notenoughcrashes.utils.SSLUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NotEnoughCrashes
implements ModInitializer {
    public static final Path DIRECTORY = Paths.get(FabricLoader.getInstance().getGameDirectory().getAbsolutePath(), "not-enough-crashes");
    public static final String NAME = "Not Enough Crashes";
    public static final String MOD_ID = "notenoughcrashes";
    public static final Logger LOGGER = LogManager.getLogger((String)"Not Enough Crashes");
    private static final boolean DEBUG_DEOBF = false;
    private static final boolean DEBUG_ENTRYPOINT = false;
    public static final boolean FILTER_ENTRYPOINT_CATCHER = true;
    public static final boolean ENABLE_DEOBF;
    public static final boolean ENABLE_ENTRYPOINT_CATCHING;

    public static void ensureDirectoryExists() throws IOException {
        Files.createDirectories(DIRECTORY, new FileAttribute[0]);
    }

    public void onInitialize() {
        ModConfig.instance();
        this.trustIdenTrust();
        this.initStacktraceDeobfuscator();
    }

    private void trustIdenTrust() {
        try (InputStream keyStoreInputStream = NotEnoughCrashes.class.getResourceAsStream("/dst_root_ca_x3.jks");){
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(keyStoreInputStream, "password".toCharArray());
            SSLUtils.trustCertificates(keyStore);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new RuntimeException(e);
        }
    }

    private void initStacktraceDeobfuscator() {
        if (!ENABLE_DEOBF) {
            return;
        }
        LOGGER.info("Initializing StacktraceDeobfuscator");
        try {
            StacktraceDeobfuscator.init();
        }
        catch (Exception e) {
            LOGGER.error("Failed to load mappings!", (Throwable)e);
        }
        LOGGER.info("Done initializing StacktraceDeobfuscator");
        DeobfuscatingRewritePolicy.install();
    }

    static {
        boolean bl = !FabricLoader.getInstance().isDevelopmentEnvironment() && ModConfig.instance().deobfuscateStackTrace ? true : (ENABLE_DEOBF = false);
        ENABLE_ENTRYPOINT_CATCHING = !FabricLoader.getInstance().isDevelopmentEnvironment();
    }
}

