/*
 * Decompiled with CFR 0.152.
 */
package fudge.notenoughcrashes.gui;

import fudge.notenoughcrashes.gui.util.TextWidget;
import fudge.notenoughcrashes.gui.util.Widget;
import fudge.notenoughcrashes.patches.PatchedCrashReport;
import fudge.notenoughcrashes.utils.CrashLogUpload;
import java.io.File;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.metadata.ContactInformation;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_1074;
import net.minecraft.class_128;
import net.minecraft.class_156;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_339;
import net.minecraft.class_407;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Environment(value=EnvType.CLIENT)
public abstract class ProblemScreen
extends class_437 {
    private List<Widget> widgets = new ArrayList<Widget>();
    private static final Logger LOGGER = LogManager.getLogger();
    protected final class_128 report;
    private String hasteLink = null;
    protected int xLeft = Integer.MAX_VALUE;
    protected int xRight = Integer.MIN_VALUE;
    protected int yTop = Integer.MAX_VALUE;
    protected int yBottom = Integer.MIN_VALUE;
    protected int x;
    protected int y;
    private static final List<String> possibleIssuesFieldsByPriority = Arrays.asList("issues", "sources", "homepage");
    private static final Set<String> IGNORED_MODS = new HashSet<String>(Arrays.asList("minecraft", "fabricloader", "loadcatcher", "jumploader"));

    protected void addWidget(Widget widget) {
        this.widgets.add(widget);
    }

    public abstract ProblemScreen construct(class_128 var1);

    protected ProblemScreen(class_128 report) {
        super((class_2561)new class_2585(""));
        this.report = report;
    }

    private String getIssuesPage(ContactInformation contactInformation) {
        for (String possibleField : possibleIssuesFieldsByPriority) {
            Optional value = contactInformation.get(possibleField);
            if (!value.isPresent()) continue;
            return (String)value.get();
        }
        return null;
    }

    private class_2561 getSuspectedModsText() {
        Set<ModMetadata> suspectedMods = ((PatchedCrashReport)this.report).getSuspectedMods();
        if (suspectedMods == null) {
            return new class_2588("notenoughcrashes.crashscreen.identificationErrored", new Object[0]);
        }
        if (suspectedMods.isEmpty()) {
            return new class_2588("notenoughcrashes.crashscreen.unknownCause", new Object[0]);
        }
        suspectedMods.removeIf(mod -> IGNORED_MODS.contains(mod.getId()));
        if (suspectedMods.isEmpty()) {
            return new class_2588("notenoughcrashes.crashscreen.noModsErrored", new Object[0]);
        }
        class_2561 text = suspectedMods.stream().sorted(Comparator.comparing(ModMetadata::getName)).map(mod -> {
            String issuesPage = this.getIssuesPage(mod.getContact());
            class_2585 modText = new class_2585(mod.getName());
            if (issuesPage != null) {
                modText.method_10862(new class_2583().method_10958(new class_2558(class_2558.class_2559.field_11749, issuesPage)));
            }
            return modText;
        }).reduce((existing, next) -> existing.method_10864(", ").method_10852(next)).get();
        return text;
    }

    private void addSuspectedModsWidget() {
        this.addWidget(new TextWidget(this.getSuspectedModsText(), 0xE0E000, this.font, this.width / 2, this.y + 29));
    }

    public void init() {
        this.widgets = new ArrayList<Widget>();
        this.addButton((class_339)new class_4185(this.width / 2 - 155 + 160, this.height / 4 + 120 + 12, 150, 20, class_1074.method_4662((String)"notenoughcrashes.gui.getLink", (Object[])new Object[0]), buttonWidget -> {
            try {
                if (this.hasteLink == null) {
                    this.hasteLink = CrashLogUpload.upload(this.report.method_568());
                }
                Field uriField = class_437.class.getDeclaredField("clickedLink");
                uriField.setAccessible(true);
                uriField.set((Object)this, new URI(this.hasteLink));
                this.minecraft.method_1507((class_437)new class_407(b -> {
                    if (b) {
                        class_156.method_668().method_670(this.hasteLink);
                    }
                    this.minecraft.method_1507((class_437)this.construct(this.report));
                }, this.hasteLink, true));
            }
            catch (Throwable e) {
                LOGGER.error("Exception when crash menu button clicked:", e);
                buttonWidget.setMessage(class_1074.method_4662((String)"notenoughcrashes.gui.failed", (Object[])new Object[0]));
                buttonWidget.active = false;
            }
        }));
        this.x = this.width / 2 - 155;
        this.y = this.height / 4;
        this.addSuspectedModsWidget();
    }

    public boolean mouseClicked(double x, double y, int int_1) {
        File file;
        for (Widget widget : this.widgets) {
            widget.onClick(x, y);
        }
        if (x >= (double)this.xLeft && x <= (double)this.xRight && y >= (double)this.yTop && y <= (double)this.yBottom && (file = this.report.method_572()) != null) {
            class_156.method_668().method_672(file);
        }
        return super.mouseClicked(x, y, int_1);
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }

    protected void drawFileNameString(int y) {
        String fileNameString = this.report.method_572() != null ? "\u00a7n" + this.report.method_572().getName() : class_1074.method_4662((String)"notenoughcrashes.crashscreen.reportSaveFailed", (Object[])new Object[0]);
        int stLen = this.font.method_1727(fileNameString);
        this.xLeft = this.width / 2 - stLen / 2;
        this.xRight = this.width / 2 + stLen / 2;
        this.drawString(this.font, fileNameString, this.xLeft, y += 11, 65280);
        this.yTop = y;
        this.yBottom = y + 10;
    }

    public void render(int mouseX, int mouseY, float delta) {
        for (Widget widget : this.widgets) {
            widget.draw();
        }
        super.render(mouseX, mouseY, delta);
    }
}

