/*
 * Decompiled with CFR 0.152.
 */
package fudge.notenoughcrashes.stacktrace;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.fabricmc.loader.ModContainer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.metadata.ModMetadata;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ModIdentifier {
    private static final Logger LOGGER = LogManager.getLogger();

    public static Set<ModMetadata> identifyFromStacktrace(Throwable e) {
        HashSet<ModMetadata> mods = new HashSet<ModMetadata>();
        ModIdentifier.visitChildrenThrowables(e, throwable -> mods.addAll(ModIdentifier.identifyFromThrowable(throwable)));
        return mods;
    }

    private static void visitChildrenThrowables(Throwable e, Consumer<Throwable> visitor) {
        visitor.accept(e);
        for (Throwable child : e.getSuppressed()) {
            ModIdentifier.visitChildrenThrowables(child, visitor);
        }
    }

    private static Set<ModMetadata> identifyFromThrowable(Throwable e) {
        Map<URI, Set<ModMetadata>> modMap = ModIdentifier.makeModMap();
        LinkedHashSet<String> classes = new LinkedHashSet<String>();
        while (e != null) {
            for (StackTraceElement element : e.getStackTrace()) {
                classes.add(element.getClassName());
            }
            e = e.getCause();
        }
        LinkedHashSet<ModMetadata> mods = new LinkedHashSet<ModMetadata>();
        for (String className : classes) {
            Set<ModMetadata> classMods = ModIdentifier.identifyFromClass(className, modMap);
            if (classMods == null) continue;
            mods.addAll(classMods);
        }
        return mods;
    }

    private static Set<ModMetadata> identifyFromClass(String className, Map<URI, Set<ModMetadata>> modMap) {
        if (className.startsWith("org.spongepowered.asm.mixin.")) {
            return Collections.emptySet();
        }
        try {
            Class<?> clazz = Class.forName(className);
            CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
            if (codeSource == null) {
                return Collections.emptySet();
            }
            URL url = codeSource.getLocation();
            if (url == null) {
                LOGGER.warn("Failed to identify mod for " + className);
                return Collections.emptySet();
            }
            URI jar = ModIdentifier.jarFromUrl(url);
            Set<ModMetadata> metadata = modMap.get(jar);
            if (metadata == null) {
                String oldPath = jar.getPath();
                String fixedPath = oldPath.substring(0, oldPath.length() - "classes/kotlin/main/".length()) + "resources/main/";
                metadata = modMap.get(new File(fixedPath).toURI());
            }
            return metadata;
        }
        catch (IOException | ClassNotFoundException | NoClassDefFoundError | URISyntaxException e) {
            return Collections.emptySet();
        }
    }

    private static Map<URI, Set<ModMetadata>> makeModMap() {
        HashMap<URI, Set<ModMetadata>> modMap = new HashMap<URI, Set<ModMetadata>>();
        for (net.fabricmc.loader.api.ModContainer mod : FabricLoader.getInstance().getAllMods()) {
            if (!(mod instanceof ModContainer)) continue;
            try {
                URI modJar = ModIdentifier.jarFromUrl(((ModContainer)mod).getOriginUrl());
                modMap.computeIfAbsent(modJar, f -> new HashSet()).add(mod.getMetadata());
            }
            catch (IOException | URISyntaxException exception) {}
        }
        return modMap;
    }

    private static URI jarFromUrl(URL url) throws URISyntaxException, IOException {
        if (url.getProtocol().equals("jar")) {
            url = new URL(url.getFile().substring(0, url.getFile().indexOf(33)));
        }
        return url.toURI().normalize();
    }
}

