/*
 * Decompiled with CFR 0.152.
 */
package fudge.notenoughcrashes.stacktrace;

import com.google.common.net.UrlEscapers;
import fudge.notenoughcrashes.NotEnoughCrashes;
import fudge.notenoughcrashes.stacktrace.YarnVersion;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.fabricmc.mapping.reader.v2.MappingGetter;
import net.fabricmc.mapping.reader.v2.TinyMetadata;
import net.fabricmc.mapping.reader.v2.TinyV2Factory;
import net.fabricmc.mapping.reader.v2.TinyVisitor;
import net.minecraft.class_3797;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public final class StacktraceDeobfuscator {
    private static final String MAPPINGS_JAR_LOCATION = "mappings/mappings.tiny";
    private static final String NAMESPACE_FROM = "intermediary";
    private static final String NAMESPACE_TO = "named";
    private static final Path CACHED_MAPPINGS = NotEnoughCrashes.DIRECTORY.resolve("mappings-" + new class_3797().getName() + ".tiny");
    private static Map<String, String> mappings = null;
    private static final List<String> filteredClasses = Arrays.asList("io.github.giantnuker.fabric.loadcatcher.EntrypointCatcher$LoaderClientReplacement", "io.github.giantnuker.fabric.loadcatcher.EntrypointCatcher");

    private static void downloadAndCacheMappings() {
        String yarnVersion;
        try {
            yarnVersion = YarnVersion.getLatestBuildForCurrentVersion();
        }
        catch (IOException e) {
            NotEnoughCrashes.LOGGER.error("Could not get latest yarn build for version", (Throwable)e);
            return;
        }
        NotEnoughCrashes.LOGGER.info("Downloading deobfuscation mappings: " + yarnVersion + " for the first launch");
        String encodedYarnVersion = UrlEscapers.urlFragmentEscaper().escape(yarnVersion);
        String artifactUrl = "https://maven.fabricmc.net/net/fabricmc/yarn/" + encodedYarnVersion + "/yarn-" + encodedYarnVersion + "-v2.jar";
        try {
            Files.createDirectories(NotEnoughCrashes.DIRECTORY, new FileAttribute[0]);
        }
        catch (IOException e) {
            NotEnoughCrashes.LOGGER.error("Could not create Not Enough Crashes directory!", (Throwable)e);
            return;
        }
        File jarFile = NotEnoughCrashes.DIRECTORY.resolve("yarn-mappings.jar").toFile();
        jarFile.deleteOnExit();
        try {
            FileUtils.copyURLToFile((URL)new URL(artifactUrl), (File)jarFile);
        }
        catch (IOException e) {
            NotEnoughCrashes.LOGGER.error("Failed to downloads mappings!", (Throwable)e);
            return;
        }
        try (FileSystem jar = FileSystems.newFileSystem(jarFile.toPath(), null);){
            NotEnoughCrashes.ensureDirectoryExists();
            Files.copy(jar.getPath(MAPPINGS_JAR_LOCATION, new String[0]), CACHED_MAPPINGS, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            NotEnoughCrashes.LOGGER.error("Failed to extract mappings!", (Throwable)e);
        }
    }

    public static void init() {
        if (!Files.exists(CACHED_MAPPINGS, new LinkOption[0])) {
            StacktraceDeobfuscator.downloadAndCacheMappings();
        }
    }

    private static void loadMappings() {
        if (!Files.exists(CACHED_MAPPINGS, new LinkOption[0])) {
            NotEnoughCrashes.LOGGER.warn("Could not download mappings, stack trace won't be deobfuscated");
            return;
        }
        final HashMap<String, String> mappings = new HashMap<String, String>();
        try (BufferedReader mappingReader = Files.newBufferedReader(CACHED_MAPPINGS);){
            TinyV2Factory.visit((BufferedReader)mappingReader, (TinyVisitor)new TinyVisitor(){
                private final Map<String, Integer> namespaceStringToColumn = new HashMap<String, Integer>();

                private void addMappings(MappingGetter name) {
                    mappings.put(name.get(this.namespaceStringToColumn.get(StacktraceDeobfuscator.NAMESPACE_FROM).intValue()).replace('/', '.'), name.get(this.namespaceStringToColumn.get(StacktraceDeobfuscator.NAMESPACE_TO).intValue()).replace('/', '.'));
                }

                public void start(TinyMetadata metadata) {
                    this.namespaceStringToColumn.put(StacktraceDeobfuscator.NAMESPACE_FROM, metadata.index(StacktraceDeobfuscator.NAMESPACE_FROM));
                    this.namespaceStringToColumn.put(StacktraceDeobfuscator.NAMESPACE_TO, metadata.index(StacktraceDeobfuscator.NAMESPACE_TO));
                }

                public void pushClass(MappingGetter name) {
                    this.addMappings(name);
                }

                public void pushMethod(MappingGetter name, String descriptor) {
                    this.addMappings(name);
                }

                public void pushField(MappingGetter name, String descriptor) {
                    this.addMappings(name);
                }
            });
        }
        catch (IOException e) {
            NotEnoughCrashes.LOGGER.error("Could not load mappings", (Throwable)e);
        }
        StacktraceDeobfuscator.mappings = mappings;
    }

    public static void deobfuscateThrowable(Throwable t) {
        ArrayDeque<Throwable> queue = new ArrayDeque<Throwable>();
        queue.add(t);
        boolean firstLoop = true;
        while (!queue.isEmpty()) {
            t = (Throwable)queue.remove();
            t.setStackTrace(StacktraceDeobfuscator.deobfuscateStacktrace(t.getStackTrace(), firstLoop));
            if (t.getCause() != null) {
                queue.add(t.getCause());
            }
            Collections.addAll(queue, t.getSuppressed());
            firstLoop = false;
        }
    }

    public static StackTraceElement[] deobfuscateStacktrace(StackTraceElement[] stackTrace, boolean insertWatermark) {
        if (stackTrace.length == 0) {
            return stackTrace;
        }
        List<StackTraceElement> stackTraceList = Arrays.stream(stackTrace).filter(element -> !filteredClasses.contains(element.getClassName())).collect(Collectors.toList());
        if (NotEnoughCrashes.ENABLE_DEOBF && !StringUtils.startsWith((CharSequence)stackTrace[0].getClassName(), (CharSequence)"Not Enough Crashes")) {
            if (mappings == null) {
                StacktraceDeobfuscator.loadMappings();
            }
            if (mappings == null) {
                return stackTrace;
            }
            if (insertWatermark) {
                try {
                    stackTraceList.add(0, new StackTraceElement("Not Enough Crashes deobfuscated stack trace", "", YarnVersion.getLatestBuildForCurrentVersion(), -1));
                }
                catch (IOException e) {
                    NotEnoughCrashes.LOGGER.error("Could not get used yarn version", (Throwable)e);
                    return stackTrace;
                }
            }
            int index = 0;
            for (StackTraceElement el : stackTraceList) {
                String remappedClass = mappings.get(el.getClassName());
                String remappedMethod = mappings.get(el.getMethodName());
                stackTraceList.set(index, new StackTraceElement(remappedClass != null ? remappedClass : el.getClassName(), remappedMethod != null ? remappedMethod : el.getMethodName(), remappedClass != null ? StacktraceDeobfuscator.getFileName(remappedClass) : el.getFileName(), el.getLineNumber()));
                ++index;
            }
        }
        return stackTraceList.toArray(new StackTraceElement[0]);
    }

    private static String getFileName(String className) {
        if (className.isEmpty()) {
            return className;
        }
        int lastDot = className.lastIndexOf(46);
        if (lastDot != -1) {
            className = className.substring(lastDot + 1);
        }
        return className.split("\\$", 2)[0];
    }

    public static void main(String[] args) {
        StacktraceDeobfuscator.init();
        for (Map.Entry<String, String> entry : mappings.entrySet()) {
            System.out.println(entry.getKey() + " <=> " + entry.getValue());
        }
    }
}

