/*
 * Decompiled with CFR 0.152.
 */
package fudge.notenoughcrashes.utils;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import fudge.notenoughcrashes.ModConfig;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public final class CrashLogUpload {
    private static final String GIST_ACCESS_TOKEN = CrashLogUpload.GIST_ACCESS_TOKEN_PART_1() + CrashLogUpload.GIST_ACCESS_TOKEN_PART_2();

    private static String GIST_ACCESS_TOKEN_PART_1() {
        return "dc07dacff0c2cf84f706";
    }

    private static String GIST_ACCESS_TOKEN_PART_2() {
        return "8ac0fd6a757d53b81233";
    }

    public static String upload(String text) throws IOException {
        ModConfig.CrashLogUploadType type = ModConfig.instance().uploadCrashLogTo;
        if (type == ModConfig.CrashLogUploadType.GIST) {
            return CrashLogUpload.uploadToGist(text);
        }
        return CrashLogUpload.uploadToHaste(text);
    }

    private static String uploadToGist(final String text) throws IOException {
        HttpPost post = new HttpPost("https://api.github.com/gists");
        final String fileName = "crash.txt";
        post.addHeader("Authorization", "token " + GIST_ACCESS_TOKEN);
        GistPost body = new GistPost(true, (Map<String, GistFile>)new HashMap<String, GistFile>(){
            {
                this.put(fileName, new GistFile(text));
            }
        });
        post.setEntity((HttpEntity)new StringEntity(new Gson().toJson((Object)body)));
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);
            String responseString = EntityUtils.toString((HttpEntity)response.getEntity());
            JsonObject responseJson = (JsonObject)new Gson().fromJson(responseString, JsonObject.class);
            String string = responseJson.getAsJsonObject("files").getAsJsonObject(fileName).getAsJsonPrimitive("raw_url").getAsString();
            return string;
        }
    }

    private static String uploadToHaste(String str) throws IOException {
        String baseUrl = "https://paste.dimdev.org";
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        URL uploadURL = new URL(baseUrl + "/documents");
        HttpURLConnection connection = (HttpURLConnection)uploadURL.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "text/plain; charset=UTF-8");
        connection.setFixedLengthStreamingMode(bytes.length);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.connect();
        try {
            String string;
            block16: {
                try (OutputStream os = connection.getOutputStream();){
                    os.write(bytes);
                }
                InputStream is = connection.getInputStream();
                try {
                    JsonObject json = (JsonObject)new Gson().fromJson((Reader)new InputStreamReader(is), JsonObject.class);
                    string = baseUrl + "/" + json.get("key").getAsString() + ".mccrash";
                    if (is == null) break block16;
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                is.close();
            }
            return string;
        }
        finally {
            connection.disconnect();
        }
    }

    private static class GistFile {
        public String content;

        public GistFile(String content) {
            this.content = content;
        }
    }

    private static class GistPost {
        @SerializedName(value="public")
        public boolean isPublic;
        public Map<String, GistFile> files;

        public GistPost(boolean isPublic, Map<String, GistFile> files) {
            this.isPublic = isPublic;
            this.files = files;
        }
    }
}

