/*
 * Decompiled with CFR 0.152.
 */
package fudge.notenoughcrashes.gui;

import fudge.notenoughcrashes.gui.util.TextWidget;
import fudge.notenoughcrashes.gui.util.Widget;
import fudge.notenoughcrashes.patches.PatchedCrashReport;
import fudge.notenoughcrashes.platform.CommonModMetadata;
import fudge.notenoughcrashes.utils.CrashLogUpload;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_128;
import net.minecraft.class_156;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_407;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Environment(value=EnvType.CLIENT)
public abstract class ProblemScreen
extends class_437 {
    private List<Widget> widgets = new ArrayList<Widget>();
    private static final Logger LOGGER = LogManager.getLogger();
    protected final class_128 report;
    private String hasteLink = null;
    protected int xLeft = Integer.MAX_VALUE;
    protected int xRight = Integer.MIN_VALUE;
    protected int yTop = Integer.MAX_VALUE;
    protected int yBottom = Integer.MIN_VALUE;
    protected int x;
    protected int y;
    private static final Set<String> IGNORED_MODS = new HashSet<String>(Arrays.asList("minecraft", "fabricloader", "loadcatcher", "jumploader"));

    protected void addWidget(Widget widget) {
        this.widgets.add(widget);
    }

    public abstract ProblemScreen construct(class_128 var1);

    protected ProblemScreen(class_128 report) {
        super((class_2561)new class_2585(""));
        this.report = report;
    }

    private class_2561 getSuspectedModsText() {
        Set<CommonModMetadata> suspectedMods = ((PatchedCrashReport)this.report).getSuspectedMods();
        if (suspectedMods == null) {
            return new class_2588("notenoughcrashes.crashscreen.identificationErrored");
        }
        suspectedMods.removeIf(mod -> IGNORED_MODS.contains(mod.getId()));
        if (suspectedMods.isEmpty()) {
            return new class_2588("notenoughcrashes.crashscreen.noModsErrored");
        }
        class_2561 text = (class_2561)suspectedMods.stream().sorted(Comparator.comparing(CommonModMetadata::getName)).map(mod -> {
            String issuesPage = mod.getIssuesPage();
            class_2585 modText = new class_2585(mod.getName());
            if (issuesPage != null) {
                modText.method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11749, issuesPage)));
            }
            return modText;
        }).reduce((existing, next) -> existing.method_10852((class_2561)new class_2585(", ")).method_10852((class_2561)next)).get();
        return text;
    }

    private void addSuspectedModsWidget() {
        this.addWidget(new TextWidget(this.getSuspectedModsText(), 0xE0E000, this.field_22793, this.field_22789 / 2, this.y + 29));
    }

    public void method_25426() {
        this.widgets = new ArrayList<Widget>();
        this.method_25411((class_339)new class_4185(this.field_22789 / 2 - 155 + 160, this.field_22790 / 4 + 120 + 12, 150, 20, (class_2561)new class_2588("notenoughcrashes.gui.getLink"), buttonWidget -> {
            try {
                if (this.hasteLink == null) {
                    this.hasteLink = CrashLogUpload.upload(this.report.method_568());
                }
                class_310.method_1551().method_1507((class_437)new class_407(b -> {
                    if (b) {
                        class_156.method_668().method_670(this.hasteLink);
                    }
                    class_310.method_1551().method_1507((class_437)this.construct(this.report));
                }, this.hasteLink, true));
            }
            catch (Throwable e) {
                LOGGER.error("Exception when crash menu button clicked:", e);
                buttonWidget.method_25355((class_2561)new class_2588("notenoughcrashes.gui.failed"));
                buttonWidget.field_22763 = false;
            }
        }));
        this.x = this.field_22789 / 2 - 155;
        this.y = this.field_22790 / 4;
        this.addSuspectedModsWidget();
    }

    public boolean method_25402(double x, double y, int int_1) {
        File file;
        for (Widget widget : this.widgets) {
            widget.onClick(x, y);
        }
        if (x >= (double)this.xLeft && x <= (double)this.xRight && y >= (double)this.yTop && y <= (double)this.yBottom && (file = this.report.method_572()) != null) {
            class_156.method_668().method_672(file);
        }
        return super.method_25402(x, y, int_1);
    }

    public boolean method_25422() {
        return false;
    }

    protected void drawFileNameString(class_4587 matrixStack, int y) {
        String fileNameString = this.report.method_572() != null ? "\u00a7n" + this.report.method_572().getName() : class_1074.method_4662((String)"notenoughcrashes.crashscreen.reportSaveFailed", (Object[])new Object[0]);
        int stLen = this.field_22793.method_1727(fileNameString);
        this.xLeft = this.field_22789 / 2 - stLen / 2;
        this.xRight = this.field_22789 / 2 + stLen / 2;
        ProblemScreen.method_25303((class_4587)matrixStack, (class_327)this.field_22793, (String)fileNameString, (int)this.xLeft, (int)(y += 11), (int)65280);
        this.yTop = y;
        this.yBottom = y + 10;
    }

    public void method_25394(class_4587 matrixStack, int mouseY, int i, float f) {
        for (Widget widget : this.widgets) {
            widget.draw(matrixStack);
        }
        super.method_25394(matrixStack, mouseY, i, f);
    }
}

