/*
 * Decompiled with CFR 0.152.
 */
package fudge.notenoughcrashes.mixinhandlers;

import fudge.notenoughcrashes.StateManager;
import fudge.notenoughcrashes.api.NotEnoughCrashesApi;
import fudge.notenoughcrashes.gui.CrashScreen;
import fudge.notenoughcrashes.mixinhandlers.EntryPointCatcher;
import fudge.notenoughcrashes.stacktrace.CrashUtils;
import fudge.notenoughcrashes.utils.GlUtil;
import java.util.Queue;
import net.minecraft.class_128;
import net.minecraft.class_148;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_424;
import net.minecraft.class_437;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InGameCatcher {
    private static final Logger LOGGER = LogManager.getLogger((String)"Not Enough Crashes In Game Crashes");
    private static int clientCrashCount = 0;
    private static int serverCrashCount = 0;

    public static void handleClientCrash(class_128 report, Queue<Runnable> renderTaskQueue) {
        ++clientCrashCount;
        InGameCatcher.getClient().method_1587(report);
        InGameCatcher.addInfoToCrash(report);
        InGameCatcher.resetModState();
        InGameCatcher.resetGameState(renderTaskQueue);
        boolean reported = report.method_564() instanceof class_148;
        LOGGER.fatal(reported ? "Reported" : "Unreported exception thrown!", report.method_564());
        InGameCatcher.displayCrashScreen(report);
    }

    private static void resetModState() {
        NotEnoughCrashesApi.permanentDisposers.forEach(Runnable::run);
        NotEnoughCrashesApi.oneTimeDisposers.forEach(Runnable::run);
        NotEnoughCrashesApi.oneTimeDisposers.clear();
    }

    public static void handleServerCrash(class_128 report) {
        ++serverCrashCount;
        InGameCatcher.addInfoToCrash(report);
        InGameCatcher.displayCrashScreen(report);
    }

    private static class_310 getClient() {
        return class_310.method_1551();
    }

    private static void addInfoToCrash(class_128 report) {
        report.method_567().method_577("Client Crashes Since Restart", () -> String.valueOf(clientCrashCount));
        report.method_567().method_577("Integrated Server Crashes Since Restart", () -> String.valueOf(serverCrashCount));
    }

    private static void displayCrashScreen(class_128 report) {
        try {
            if (EntryPointCatcher.crashedDuringStartup()) {
                throw new IllegalStateException("Could not initialize startup crash screen");
            }
            CrashUtils.outputReport(report);
            InGameCatcher.getClient().field_1690.field_1866 = false;
            InGameCatcher.getClient().field_1705.method_1743().method_1808(true);
            InGameCatcher.getClient().method_1507((class_437)new CrashScreen(report));
        }
        catch (Throwable t) {
            LOGGER.error("An uncaught exception occured while displaying the crash screen, making normal report instead", t);
            class_310.method_1565((class_128)report);
            System.exit(report.method_572() != null ? -1 : -2);
        }
    }

    public static void resetGameState(Queue<Runnable> renderTaskQueue) {
        try {
            Integer originalReservedMemorySize = null;
            try {
                if (class_310.field_1718 != null) {
                    originalReservedMemorySize = class_310.field_1718.length;
                    class_310.field_1718 = new byte[0];
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            StateManager.resetStates();
            if (InGameCatcher.getClient().method_1562() != null) {
                InGameCatcher.getClient().method_1562().method_2872().method_10747((class_2561)new class_2585(String.format("[%s] Client crashed", "Not Enough Crashes")));
            }
            InGameCatcher.getClient().method_18096((class_437)new class_424((class_2561)new class_2588("menu.savingLevel")));
            renderTaskQueue.clear();
            GlUtil.resetState();
            if (originalReservedMemorySize != null) {
                try {
                    class_310.field_1718 = new byte[originalReservedMemorySize.intValue()];
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            System.gc();
        }
        catch (Throwable t) {
            LOGGER.error("Failed to reset state after a crash", t);
            try {
                StateManager.resetStates();
                GlUtil.resetState();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

