/*
 * Decompiled with CFR 0.152.
 */
package fudge.notenoughcrashes.platform.fabric;

import fudge.notenoughcrashes.platform.CommonModMetadata;
import fudge.notenoughcrashes.platform.NecPlatform;
import fudge.notenoughcrashes.stacktrace.ModIdentifier;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.loader.ModContainer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.metadata.ContactInformation;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.fabricmc.loader.api.metadata.Person;

public class NecPlatformImpl
implements NecPlatform {
    private static final List<String> possibleIssuesFieldsByPriority = Arrays.asList("issues", "sources", "homepage");

    @Override
    public Map<URI, Set<CommonModMetadata>> getModsAtLocationsInDisk() {
        HashMap<URI, Set<CommonModMetadata>> modMap = new HashMap<URI, Set<CommonModMetadata>>();
        for (net.fabricmc.loader.api.ModContainer mod : FabricLoader.getInstance().getAllMods()) {
            if (!(mod instanceof ModContainer)) continue;
            try {
                URI modJar = ModIdentifier.jarFromUrl(((ModContainer)mod).getOriginUrl());
                modMap.computeIfAbsent(modJar, f -> new HashSet()).add(NecPlatformImpl.toCommon(mod.getMetadata()));
            }
            catch (IOException | URISyntaxException exception) {}
        }
        return modMap;
    }

    @Override
    public Path getGameDirectory() {
        return FabricLoader.getInstance().getGameDir();
    }

    @Override
    public Path getConfigDirectory() {
        return FabricLoader.getInstance().getConfigDir();
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    @Override
    public List<CommonModMetadata> getModMetadatas(String modId) {
        Optional mod = FabricLoader.getInstance().getModContainer(modId);
        return mod.map(modContainer -> Collections.singletonList(NecPlatformImpl.toCommon(modContainer.getMetadata()))).orElse(new ArrayList());
    }

    private static String getIssuesPage(ContactInformation contactInformation) {
        for (String possibleField : possibleIssuesFieldsByPriority) {
            Optional value = contactInformation.get(possibleField);
            if (!value.isPresent()) continue;
            return (String)value.get();
        }
        return null;
    }

    private static CommonModMetadata toCommon(ModMetadata mod) {
        return new CommonModMetadata(mod.getId(), mod.getName(), NecPlatformImpl.getIssuesPage(mod.getContact()), mod.getAuthors().stream().map(Person::getName).collect(Collectors.toList()));
    }
}

