/*
 * Decompiled with CFR 0.152.
 */
package fudge.notenoughcrashes.utils;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public final class CrashLogUpload {
    private static final String GIST_ACCESS_TOKEN = CrashLogUpload.GIST_ACCESS_TOKEN_PART_1() + CrashLogUpload.GIST_ACCESS_TOKEN_PART_2();

    private static String GIST_ACCESS_TOKEN_PART_1() {
        return "dc07dacff0c2cf84f706";
    }

    private static String GIST_ACCESS_TOKEN_PART_2() {
        return "8ac0fd6a757d53b81233";
    }

    public static String upload(String text) throws IOException {
        return CrashLogUpload.uploadToGist(text);
    }

    private static String uploadToGist(final String text) throws IOException {
        HttpPost post = new HttpPost("https://api.github.com/gists");
        final String fileName = "crash.txt";
        post.addHeader("Authorization", "token " + GIST_ACCESS_TOKEN);
        GistPost body = new GistPost(true, (Map<String, GistFile>)new HashMap<String, GistFile>(){
            {
                this.put(fileName, new GistFile(text));
            }
        });
        post.setEntity((HttpEntity)new StringEntity(new Gson().toJson((Object)body)));
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);
            String responseString = EntityUtils.toString((HttpEntity)response.getEntity());
            JsonObject responseJson = (JsonObject)new Gson().fromJson(responseString, JsonObject.class);
            String string = responseJson.getAsJsonObject("files").getAsJsonObject(fileName).getAsJsonPrimitive("raw_url").getAsString();
            return string;
        }
    }

    private static class GistPost {
        @SerializedName(value="public")
        public boolean isPublic;
        public Map<String, GistFile> files;

        public GistPost(boolean isPublic, Map<String, GistFile> files) {
            this.isPublic = isPublic;
            this.files = files;
        }
    }

    private static class GistFile {
        public String content;

        public GistFile(String content) {
            this.content = content;
        }
    }
}

