/*
 * Decompiled with CFR 0.152.
 */
package fudge.notenoughcrashes.fabric.platform;

import fudge.notenoughcrashes.NotEnoughCrashes;
import fudge.notenoughcrashes.platform.CommonModMetadata;
import fudge.notenoughcrashes.platform.ModsByLocation;
import fudge.notenoughcrashes.platform.NecPlatform;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ContactInformation;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.fabricmc.loader.api.metadata.Person;
import org.jetbrains.annotations.Nullable;

public class FabricPlatform
implements NecPlatform {
    private static final List<String> possibleIssuesFieldsByPriority = Arrays.asList("issues", "sources", "homepage");

    @Override
    public ModsByLocation getModsAtLocationsInDisk() {
        HashMap<Path, Set<CommonModMetadata>> modMap = new HashMap<Path, Set<CommonModMetadata>>();
        for (ModContainer mod : FabricLoader.getInstance().getAllMods()) {
            Path path = mod.getRootPath();
            modMap.computeIfAbsent(path, f -> new HashSet()).add(FabricPlatform.toCommon(mod));
        }
        return new ModsByLocation(modMap);
    }

    @Override
    public Path getGameDirectory() {
        return FabricLoader.getInstance().getGameDir();
    }

    @Override
    public Path getConfigDirectory() {
        return FabricLoader.getInstance().getConfigDir();
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    @Override
    @Nullable
    public Path getResource(Path relativePath) {
        Path path = NotEnoughCrashes.getMetadata().rootPath().resolve(relativePath.toString());
        if (!Files.exists(path, new LinkOption[0])) {
            return null;
        }
        return path;
    }

    @Override
    public List<CommonModMetadata> getModMetadatas(String modId) {
        Optional mod = FabricLoader.getInstance().getModContainer(modId);
        return mod.map(modContainer -> Collections.singletonList(FabricPlatform.toCommon(modContainer))).orElse(new ArrayList());
    }

    private static String getIssuesPage(ContactInformation contactInformation) {
        for (String possibleField : possibleIssuesFieldsByPriority) {
            Optional value = contactInformation.get(possibleField);
            if (!value.isPresent()) continue;
            return (String)value.get();
        }
        return null;
    }

    private static CommonModMetadata toCommon(ModContainer modContainer) {
        ModMetadata mod = modContainer.getMetadata();
        return new CommonModMetadata(mod.getId(), mod.getName(), FabricPlatform.getIssuesPage(mod.getContact()), mod.getAuthors().stream().map(Person::getName).collect(Collectors.toList()), modContainer.getRootPath());
    }
}

