/*
 * Decompiled with CFR 0.152.
 */
package fudge.notenoughcrashes.mixinhandlers;

import fudge.notenoughcrashes.NecConfig;
import fudge.notenoughcrashes.StateManager;
import fudge.notenoughcrashes.api.NotEnoughCrashesApi;
import fudge.notenoughcrashes.gui.CrashScreen;
import fudge.notenoughcrashes.mixinhandlers.EntryPointCatcher;
import fudge.notenoughcrashes.stacktrace.CrashUtils;
import fudge.notenoughcrashes.utils.GlUtil;
import java.util.Queue;
import net.minecraft.class_128;
import net.minecraft.class_148;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_424;
import net.minecraft.class_437;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InGameCatcher {
    private static final Logger LOGGER = LogManager.getLogger((String)"Not Enough Crashes In Game Crashes");
    private static int clientCrashCount = 0;
    private static int serverCrashCount = 0;

    public static void handleClientCrash(class_128 report) {
        InGameCatcher.addInfoToCrash(report);
        InGameCatcher.resetStates();
        boolean reported = report.method_564() instanceof class_148;
        LOGGER.fatal(reported ? "Reported" : "Unreported exception thrown!", report.method_564());
        InGameCatcher.displayCrashScreen(report, ++clientCrashCount);
        InGameCatcher.getClient().method_1514();
    }

    private static void resetStates() {
        GlUtil.resetState();
        StateManager.resetStates();
        InGameCatcher.resetModState();
        InGameCatcher.resetCriticalGameState();
    }

    public static void cleanupBeforeMinecraft(Queue<Runnable> renderTaskQueue) {
        if (InGameCatcher.getClient().method_1562() != null) {
            InGameCatcher.getClient().method_1562().method_2872().method_10747((class_2561)new class_2585(String.format("[%s] Client crashed", "Not Enough Crashes")));
        }
        InGameCatcher.getClient().method_18096((class_437)new class_424((class_2561)new class_2588("menu.savingLevel")));
        renderTaskQueue.clear();
    }

    private static void resetCriticalGameState() {
        class_310 client = InGameCatcher.getClient();
        client.field_1724 = null;
        client.field_1687 = null;
    }

    private static void resetModState() {
        NotEnoughCrashesApi.permanentDisposers.forEach(Runnable::run);
        NotEnoughCrashesApi.oneTimeDisposers.forEach(Runnable::run);
        NotEnoughCrashesApi.oneTimeDisposers.clear();
    }

    public static void handleServerCrash(class_128 report) {
        InGameCatcher.addInfoToCrash(report);
        InGameCatcher.displayCrashScreen(report, ++serverCrashCount);
    }

    private static class_310 getClient() {
        return class_310.method_1551();
    }

    public static void addInfoToCrash(class_128 report) {
        report.method_567().method_37123("Client Crashes Since Restart", () -> String.valueOf(clientCrashCount));
        report.method_567().method_37123("Integrated Server Crashes Since Restart", () -> String.valueOf(serverCrashCount));
    }

    private static void displayCrashScreen(class_128 report, int crashCount) {
        try {
            if (EntryPointCatcher.crashedDuringStartup()) {
                throw new IllegalStateException("Could not initialize startup crash screen");
            }
            if (crashCount > NecConfig.instance().crashLimit) {
                throw new IllegalStateException("The game has crashed an excessive amount of times");
            }
            CrashUtils.outputReport(report);
            InGameCatcher.getClient().field_1690.field_1866 = false;
            InGameCatcher.getClient().field_1705.method_1743().method_1808(true);
            InGameCatcher.getClient().method_1507((class_437)new CrashScreen(report));
        }
        catch (Throwable t) {
            LOGGER.error("An uncaught exception occured while displaying the crash screen, making normal report instead", t);
            class_310.method_1565((class_128)report);
            System.exit(report.method_572() != null ? -1 : -2);
        }
    }
}

