/*
 * Decompiled with CFR 0.152.
 */
package fudge.notenoughcrashes.platform;

import fudge.notenoughcrashes.platform.CommonModMetadata;
import java.net.URI;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ModsByLocation {
    private final Map<String, Set<CommonModMetadata>> locationToMod;

    public ModsByLocation(Map<Path, Set<CommonModMetadata>> locationToMod) {
        HashMap<String, Set<CommonModMetadata>> mods = new HashMap<String, Set<CommonModMetadata>>();
        locationToMod.forEach((path, mod) -> mods.put(ModsByLocation.normalizePathString(path.toUri().toString()), (Set<CommonModMetadata>)mod));
        this.locationToMod = mods;
    }

    public Set<CommonModMetadata> get(URI path) {
        return this.locationToMod.get(ModsByLocation.normalizePathString(path.toString()));
    }

    public Set<CommonModMetadata> get(Path path) {
        return this.get(path.toUri());
    }

    private static String normalizePathString(String path) {
        String noUnion = ModsByLocation.removePrefix(path, "union:/");
        String noScheme = ModsByLocation.removeAndBefore(noUnion, "//");
        String noPercent = ModsByLocation.removeAndAfter(noScheme, "%");
        return ModsByLocation.removeSuffix(ModsByLocation.removeSuffix(noPercent, "/"), "!");
    }

    private static String removeSuffix(String str, String suffix) {
        return str.endsWith(suffix) ? str.substring(0, str.length() - suffix.length()) : str;
    }

    private static String removePrefix(String str, String suffix) {
        return str.startsWith(suffix) ? str.substring(suffix.length()) : str;
    }

    private static String removeAndBefore(String str, String toRemove) {
        int toRemovePos = str.lastIndexOf(toRemove);
        if (toRemovePos == -1) {
            return str;
        }
        return str.substring(toRemovePos + toRemove.length());
    }

    private static String removeAndAfter(String str, String toRemove) {
        int toRemovePos = str.lastIndexOf(toRemove);
        if (toRemovePos == -1) {
            return str;
        }
        return str.substring(0, toRemovePos);
    }
}

