/*
 * Decompiled with CFR 0.152.
 */
package fudge.notenoughcrashes.utils;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fudge.notenoughcrashes.NotEnoughCrashes;
import fudge.notenoughcrashes.platform.NecPlatform;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NecLocalization {
    private static final String DEFAULT_LANGUAGE_CODE = "en_us";
    private static final Map<String, LanguageTranslations> storedLanguages = new HashMap<String, LanguageTranslations>();
    private static final Gson gson = new Gson();

    @NotNull
    public static String localize(String translationKey) {
        String currentLanguageCode = NecLocalization.getCurrentLanguageCode();
        String translationForChosenLanguage = NecLocalization.localize(translationKey, currentLanguageCode);
        if (translationForChosenLanguage != null) {
            return translationForChosenLanguage;
        }
        String englishTranslation = NecLocalization.localize(translationKey, DEFAULT_LANGUAGE_CODE);
        return englishTranslation == null ? translationKey : englishTranslation;
    }

    @Nullable
    private static String localize(String translationKey, String languageCode) {
        LanguageTranslations translations = storedLanguages.computeIfAbsent(languageCode, ignored -> NecLocalization.loadLanguage(languageCode));
        return translations.get(translationKey);
    }

    public static class_2561 translatedText(String translationKey) {
        return new class_2585(NecLocalization.localize(translationKey));
    }

    private static String getCurrentLanguageCode() {
        return class_310.method_1551().method_1526().method_4669().getCode();
    }

    private static LanguageTranslations loadLanguage(String code) {
        HashMap<String, String> translations;
        try {
            Path localizationsPath = NecLocalization.getLocalizationPath(code);
            if (localizationsPath == null) {
                translations = new HashMap();
                NotEnoughCrashes.logDebug("No localization for language code: " + code);
            } else {
                String content = Files.readString(localizationsPath);
                translations = NecLocalization.parseTranslations(content);
            }
        }
        catch (IOException e) {
            NotEnoughCrashes.getLogger().error("Could not load translations: ", (Throwable)e);
            translations = new HashMap();
        }
        return new LanguageTranslations(translations);
    }

    @Nullable
    private static Path getLocalizationPath(String code) {
        Path relativePath = Paths.get("assets", "notenoughcrashes", "lang", code + ".json");
        return NecPlatform.instance().getResource(relativePath);
    }

    private static Map<String, String> parseTranslations(String raw) {
        JsonObject jsonObject = (JsonObject)gson.fromJson(raw, JsonObject.class);
        HashMap<String, String> translations = new HashMap<String, String>();
        for (Map.Entry child : jsonObject.entrySet()) {
            translations.put((String)child.getKey(), ((JsonElement)child.getValue()).getAsString());
        }
        return translations;
    }

    private static class LanguageTranslations {
        private final Map<String, String> translations;

        private LanguageTranslations(Map<String, String> translations) {
            this.translations = translations;
        }

        @Nullable
        String get(String translationKey) {
            return this.translations.get(translationKey);
        }
    }
}

