/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.obfuscate.client.event;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Cancelable;

public abstract class PlayerModelEvent
extends PlayerEvent {
    private final PlayerModel modelPlayer;
    private final float deltaTicks;
    private final float limbSwing;
    private final float limbSwingAmount;
    private final float ageInTicks;
    private final float netHeadYaw;
    private final float headPitch;

    private PlayerModelEvent(Player player, PlayerModel modelPlayer, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float deltaTicks) {
        super(player);
        this.modelPlayer = modelPlayer;
        this.limbSwing = limbSwing;
        this.limbSwingAmount = limbSwingAmount;
        this.ageInTicks = ageInTicks;
        this.netHeadYaw = netHeadYaw;
        this.headPitch = headPitch;
        this.deltaTicks = deltaTicks;
    }

    public PlayerModel getModelPlayer() {
        return this.modelPlayer;
    }

    public float getLimbSwing() {
        return this.limbSwing;
    }

    public float getLimbSwingAmount() {
        return this.limbSwingAmount;
    }

    public float getAgeInTicks() {
        return this.ageInTicks;
    }

    public float getNetHeadYaw() {
        return this.netHeadYaw;
    }

    public float getHeadPitch() {
        return this.headPitch;
    }

    public float getDeltaTicks() {
        return this.deltaTicks;
    }

    @Cancelable
    public static class Render
    extends PlayerModelEvent {
        private final PoseStack poseStack;
        private final VertexConsumer consumer;
        private final int light;
        private final int overlay;

        private Render(Player player, PlayerModel modelPlayer, PoseStack poseStack, VertexConsumer consumer, int light, int overlay, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float deltaTicks) {
            super(player, modelPlayer, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, deltaTicks);
            this.poseStack = poseStack;
            this.consumer = consumer;
            this.light = light;
            this.overlay = overlay;
        }

        public PoseStack getPoseStack() {
            return this.poseStack;
        }

        public VertexConsumer getVertexConsumer() {
            return this.consumer;
        }

        public int getLight() {
            return this.light;
        }

        public int getOverlay() {
            return this.overlay;
        }

        public static class Post
        extends Render {
            public Post(Player player, PlayerModel modelPlayer, PoseStack poseStack, VertexConsumer consumer, int light, int overlay, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float deltaTicks) {
                super(player, modelPlayer, poseStack, consumer, light, overlay, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, deltaTicks);
            }

            public boolean isCancelable() {
                return false;
            }
        }

        public static class Pre
        extends Render {
            public Pre(Player player, PlayerModel modelPlayer, PoseStack poseStack, VertexConsumer consumer, int light, int overlay, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float deltaTicks) {
                super(player, modelPlayer, poseStack, consumer, light, overlay, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, deltaTicks);
            }
        }
    }

    @Cancelable
    public static class SetupAngles
    extends PlayerModelEvent {
        private SetupAngles(Player player, PlayerModel modelPlayer, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float deltaTicks) {
            super(player, modelPlayer, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, deltaTicks);
        }

        public static class Post
        extends SetupAngles {
            public Post(Player player, PlayerModel modelPlayer, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float deltaTicks) {
                super(player, modelPlayer, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, deltaTicks);
            }

            public boolean isCancelable() {
                return false;
            }
        }

        public static class Pre
        extends SetupAngles {
            public Pre(Player player, PlayerModel modelPlayer, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float deltaTicks) {
                super(player, modelPlayer, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, deltaTicks);
            }
        }
    }
}

