/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.obfuscate.client.event;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

@Cancelable
public class RenderItemEvent
extends Event {
    private final ItemStack heldItem;
    private final ItemTransforms.TransformType transformType;
    private final PoseStack poseStack;
    private final MultiBufferSource source;
    private final float deltaTicks;
    private final int light;
    private final int overlay;

    public RenderItemEvent(ItemStack heldItem, ItemTransforms.TransformType transformType, PoseStack poseStack, MultiBufferSource source, int light, int overlay, float deltaTicks) {
        this.heldItem = heldItem;
        this.transformType = transformType;
        this.poseStack = poseStack;
        this.source = source;
        this.deltaTicks = deltaTicks;
        this.light = light;
        this.overlay = overlay;
    }

    public ItemStack getItem() {
        return this.heldItem;
    }

    public ItemTransforms.TransformType getTransformType() {
        return this.transformType;
    }

    public PoseStack getPoseStack() {
        return this.poseStack;
    }

    public MultiBufferSource getMultiBufferSource() {
        return this.source;
    }

    public int getLight() {
        return this.light;
    }

    public int getOverlay() {
        return this.overlay;
    }

    public float getPartialTicks() {
        return this.deltaTicks;
    }

    @Cancelable
    public static class Head
    extends RenderItemEvent {
        private final LivingEntity entity;

        public Head(LivingEntity entity, ItemStack heldItem, PoseStack poseStack, MultiBufferSource source, int light, int overlay, float deltaTicks) {
            super(heldItem, ItemTransforms.TransformType.FIXED, poseStack, source, light, overlay, deltaTicks);
            this.entity = entity;
        }

        public LivingEntity getEntity() {
            return this.entity;
        }

        public static class Post
        extends Head {
            public Post(LivingEntity entity, ItemStack heldItem, PoseStack poseStack, MultiBufferSource source, int light, int overlay, float deltaTicks) {
                super(entity, heldItem, poseStack, source, light, overlay, deltaTicks);
            }

            public boolean isCancelable() {
                return false;
            }
        }

        public static class Pre
        extends Head {
            public Pre(LivingEntity entity, ItemStack heldItem, PoseStack poseStack, MultiBufferSource source, int light, int overlay, float deltaTicks) {
                super(entity, heldItem, poseStack, source, light, overlay, deltaTicks);
            }
        }
    }

    @Cancelable
    public static class ItemFrame
    extends RenderItemEvent {
        private final net.minecraft.world.entity.decoration.ItemFrame entity;

        public ItemFrame(net.minecraft.world.entity.decoration.ItemFrame entity, ItemStack heldItem, PoseStack poseStack, MultiBufferSource source, int light, int overlay, float deltaTicks) {
            super(heldItem, ItemTransforms.TransformType.FIXED, poseStack, source, light, overlay, deltaTicks);
            this.entity = entity;
        }

        public net.minecraft.world.entity.decoration.ItemFrame getEntity() {
            return this.entity;
        }

        public static class Post
        extends ItemFrame {
            public Post(net.minecraft.world.entity.decoration.ItemFrame entity, ItemStack heldItem, PoseStack poseStack, MultiBufferSource source, int light, int overlay, float deltaTicks) {
                super(entity, heldItem, poseStack, source, light, overlay, deltaTicks);
            }

            public boolean isCancelable() {
                return false;
            }
        }

        public static class Pre
        extends ItemFrame {
            public Pre(net.minecraft.world.entity.decoration.ItemFrame entity, ItemStack heldItem, PoseStack poseStack, MultiBufferSource source, int light, int overlay, float deltaTicks) {
                super(entity, heldItem, poseStack, source, light, overlay, deltaTicks);
            }
        }
    }

    @Cancelable
    public static class Gui
    extends RenderItemEvent {
        public Gui(ItemStack heldItem, PoseStack poseStack, MultiBufferSource source, int light, int overlay) {
            super(heldItem, ItemTransforms.TransformType.GUI, poseStack, source, light, overlay, Minecraft.m_91087_().m_91297_());
        }

        public static class Post
        extends Gui {
            public Post(ItemStack heldItem, PoseStack poseStack, MultiBufferSource source, int light, int overlay) {
                super(heldItem, poseStack, source, light, overlay);
            }

            public boolean isCancelable() {
                return false;
            }
        }

        public static class Pre
        extends Gui {
            public Pre(ItemStack heldItem, PoseStack poseStack, MultiBufferSource source, int light, int overlay) {
                super(heldItem, poseStack, source, light, overlay);
            }
        }
    }

    @Cancelable
    public static class Entity
    extends RenderItemEvent {
        private final ItemEntity entity;

        public Entity(ItemEntity entity, ItemStack heldItem, PoseStack poseStack, MultiBufferSource source, int light, int overlay, float deltaTicks) {
            super(heldItem, ItemTransforms.TransformType.GROUND, poseStack, source, light, overlay, deltaTicks);
            this.entity = entity;
        }

        public ItemEntity getEntity() {
            return this.entity;
        }

        public static class Post
        extends Entity {
            public Post(ItemEntity entity, ItemStack heldItem, PoseStack poseStack, MultiBufferSource source, int light, int overlay, float deltaTicks) {
                super(entity, heldItem, poseStack, source, light, overlay, deltaTicks);
            }

            public boolean isCancelable() {
                return false;
            }
        }

        public static class Pre
        extends Entity {
            public Pre(ItemEntity entity, ItemStack heldItem, PoseStack poseStack, MultiBufferSource source, int light, int overlay, float deltaTicks) {
                super(entity, heldItem, poseStack, source, light, overlay, deltaTicks);
            }
        }
    }

    @Cancelable
    public static class Held
    extends RenderItemEvent {
        private final LivingEntity entity;
        private final HumanoidArm arm;

        public Held(LivingEntity entity, ItemStack heldItem, ItemTransforms.TransformType transformType, PoseStack poseStack, MultiBufferSource source, HumanoidArm arm, int light, int overlay, float deltaTicks) {
            super(heldItem, transformType, poseStack, source, light, overlay, deltaTicks);
            this.entity = entity;
            this.arm = arm;
        }

        public LivingEntity getEntity() {
            return this.entity;
        }

        public HumanoidArm getArm() {
            return this.arm;
        }

        public static class Post
        extends Held {
            public Post(LivingEntity entity, ItemStack heldItem, ItemTransforms.TransformType transformType, PoseStack poseStack, MultiBufferSource source, HumanoidArm HumanoidArm2, int light, int overlay, float deltaTicks) {
                super(entity, heldItem, transformType, poseStack, source, HumanoidArm2, light, overlay, deltaTicks);
            }

            public boolean isCancelable() {
                return false;
            }
        }

        public static class Pre
        extends Held {
            public Pre(LivingEntity entity, ItemStack heldItem, ItemTransforms.TransformType transformType, PoseStack poseStack, MultiBufferSource source, HumanoidArm HumanoidArm2, int light, int overlay, float deltaTicks) {
                super(entity, heldItem, transformType, poseStack, source, HumanoidArm2, light, overlay, deltaTicks);
            }
        }
    }
}

