/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.obfuscate.common.data;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.obfuscate.common.data.SyncedDataKey;
import com.mrcrayfish.obfuscate.network.HandshakeMessages;
import com.mrcrayfish.obfuscate.network.PacketHandler;
import com.mrcrayfish.obfuscate.network.message.MessageSyncPlayerData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fmllegacy.network.PacketDistributor;
import org.apache.commons.lang3.Validate;

public class SyncedPlayerData {
    @CapabilityInject(value=DataHolder.class)
    public static final Capability<DataHolder> CAPABILITY = null;
    private static SyncedPlayerData instance;
    private final Map<ResourceLocation, SyncedDataKey<?>> registeredDataKeys = new HashMap();
    private final Map<Integer, SyncedDataKey<?>> idToDataKey = new HashMap();
    private int nextKeyId = 0;
    private boolean dirty = false;

    private SyncedPlayerData() {
    }

    public static SyncedPlayerData instance() {
        if (instance == null) {
            instance = new SyncedPlayerData();
        }
        return instance;
    }

    public static void onRegisterCapability(RegisterCapabilitiesEvent event) {
        event.register(DataHolder.class);
    }

    public void registerKey(SyncedDataKey<?> key) {
        if (this.registeredDataKeys.containsKey(key.getKey())) {
            throw new IllegalArgumentException(String.format("The data key '%s' is already registered!", key.getKey()));
        }
        int nextId = this.nextKeyId++;
        key.setId(nextId);
        this.registeredDataKeys.put(key.getKey(), key);
        this.idToDataKey.put(nextId, key);
    }

    public <T> void set(Player player, SyncedDataKey<T> key, T value) {
        if (!this.registeredDataKeys.values().contains(key)) {
            throw new IllegalArgumentException(String.format("The data key '%s' is not registered!", key.getKey()));
        }
        DataHolder holder = this.getDataHolder(player);
        if (holder != null && holder.set(player, key, value) && !player.f_19853_.m_5776_()) {
            this.dirty = true;
        }
    }

    public <T> T get(Player player, SyncedDataKey<T> key) {
        if (!this.registeredDataKeys.values().contains(key)) {
            throw new IllegalArgumentException(String.format("The data key '%s' is not registered!", key.getKey()));
        }
        DataHolder holder = this.getDataHolder(player);
        return holder != null ? holder.get(key) : key.getDefaultValueSupplier().get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public <T> void updateClientEntry(Player player, DataEntry<T> entry) {
        SyncedPlayerData.instance().set(player, entry.getKey(), entry.getValue());
    }

    @Nullable
    private SyncedDataKey<?> getKey(int id) {
        return this.idToDataKey.get(id);
    }

    public List<SyncedDataKey<?>> getKeys() {
        return ImmutableList.copyOf(this.registeredDataKeys.values());
    }

    @Nullable
    private DataHolder getDataHolder(Player player) {
        return (DataHolder)player.getCapability(CAPABILITY, null).orElse(null);
    }

    @SubscribeEvent
    public void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            event.addCapability(new ResourceLocation("obfuscate", "synced_player_data"), (ICapabilityProvider)new Provider());
        }
    }

    @SubscribeEvent
    public void onStartTracking(PlayerEvent.StartTracking event) {
        Player player;
        DataHolder holder;
        if (event.getTarget() instanceof Player && !event.getPlayer().f_19853_.m_5776_() && (holder = this.getDataHolder(player = (Player)event.getTarget())) != null) {
            List<DataEntry<?>> entries = holder.gatherAll();
            entries.removeIf(entry -> !entry.getKey().shouldSyncToAllPlayers());
            if (!entries.isEmpty()) {
                PacketHandler.getPlayChannel().send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getPlayer()), (Object)new MessageSyncPlayerData(player.m_142049_(), entries));
            }
        }
    }

    @SubscribeEvent
    public void onPlayerJoinWorld(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        Entity entity2 = entity;
        if (entity2 instanceof Player) {
            List<DataEntry<?>> entries;
            DataHolder holder;
            Player player = (Player)entity2;
            if (!event.getWorld().m_5776_() && (holder = this.getDataHolder(player)) != null && !(entries = holder.gatherAll()).isEmpty()) {
                PacketHandler.getPlayChannel().send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new MessageSyncPlayerData(player.m_142049_(), entries));
            }
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        Player original = event.getOriginal();
        if (!original.f_19853_.m_5776_()) {
            DataHolder newHolder;
            Player player = event.getPlayer();
            DataHolder oldHolder = this.getDataHolder(original);
            if (oldHolder != null && (newHolder = this.getDataHolder(player)) != null) {
                HashMap dataMap = new HashMap(oldHolder.dataMap);
                if (event.isWasDeath()) {
                    dataMap.entrySet().removeIf(entry -> !((SyncedDataKey)entry.getKey()).isPersistent());
                }
                newHolder.dataMap = dataMap;
            }
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && this.dirty) {
            DataHolder holder;
            Player player = event.player;
            if (!player.f_19853_.m_5776_() && (holder = this.getDataHolder(player)) != null && holder.isDirty()) {
                List<DataEntry<?>> entries = holder.gatherDirty();
                if (!entries.isEmpty()) {
                    PacketHandler.getPlayChannel().send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new MessageSyncPlayerData(player.m_142049_(), entries));
                    List<DataEntry<?>> syncToAllEntries = entries.stream().filter(entry -> entry.getKey().shouldSyncToAllPlayers()).collect(Collectors.toList());
                    if (!syncToAllEntries.isEmpty()) {
                        PacketHandler.getPlayChannel().send(PacketDistributor.TRACKING_ENTITY.with(() -> player), (Object)new MessageSyncPlayerData(player.m_142049_(), syncToAllEntries));
                    }
                }
                holder.clean();
            }
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && this.dirty) {
            this.dirty = false;
        }
    }

    public boolean updateMappings(HandshakeMessages.S2CSyncedPlayerData message) {
        this.idToDataKey.clear();
        Map<ResourceLocation, Integer> keyMappings = message.getKeyMap();
        for (ResourceLocation key : keyMappings.keySet()) {
            SyncedDataKey<?> syncedDataKey = this.registeredDataKeys.get(key);
            if (syncedDataKey == null) {
                return false;
            }
            int id = keyMappings.get(key);
            syncedDataKey.setId(id);
            this.idToDataKey.put(id, syncedDataKey);
        }
        return true;
    }

    public static class DataHolder {
        private Map<SyncedDataKey<?>, DataEntry<?>> dataMap = new HashMap();
        private boolean dirty = false;

        private <T> boolean set(Player player, SyncedDataKey<T> key, T value) {
            DataEntry entry = this.dataMap.computeIfAbsent(key, DataEntry::new);
            if (!entry.getValue().equals(value)) {
                boolean dirty = !player.f_19853_.m_5776_() && entry.getKey().shouldSyncToClient();
                entry.setValue(value, dirty);
                this.dirty = dirty;
                return true;
            }
            return false;
        }

        @Nullable
        private <T> T get(SyncedDataKey<T> key) {
            return this.dataMap.computeIfAbsent(key, DataEntry::new).getValue();
        }

        private boolean isDirty() {
            return this.dirty;
        }

        private void clean() {
            this.dirty = false;
            this.dataMap.forEach((key, entry) -> entry.clean());
        }

        private List<DataEntry<?>> gatherDirty() {
            return this.dataMap.values().stream().filter(DataEntry::isDirty).filter(entry -> entry.getKey().shouldSyncToClient()).collect(Collectors.toList());
        }

        private List<DataEntry<?>> gatherAll() {
            return this.dataMap.values().stream().filter(entry -> entry.getKey().shouldSyncToClient()).collect(Collectors.toList());
        }
    }

    public static class DataEntry<T> {
        private SyncedDataKey<T> key;
        private T value;
        private boolean dirty;

        private DataEntry(SyncedDataKey<T> key) {
            this.key = key;
            this.value = key.getDefaultValueSupplier().get();
        }

        private SyncedDataKey<T> getKey() {
            return this.key;
        }

        private T getValue() {
            return this.value;
        }

        private void setValue(T value, boolean dirty) {
            this.value = value;
            this.dirty = dirty;
        }

        private boolean isDirty() {
            return this.dirty;
        }

        private void clean() {
            this.dirty = false;
        }

        public void write(FriendlyByteBuf buffer) {
            buffer.m_130130_(this.key.getId());
            this.key.getSerializer().write(buffer, this.value);
        }

        public static DataEntry<?> read(FriendlyByteBuf buffer) {
            SyncedDataKey<?> key = SyncedPlayerData.instance().getKey(buffer.m_130242_());
            Validate.notNull(key, (String)"Synced key does not exist for id", (Object[])new Object[0]);
            DataEntry entry = new DataEntry(key);
            entry.readValue(buffer);
            return entry;
        }

        private void readValue(FriendlyByteBuf buffer) {
            this.value = this.getKey().getSerializer().read(buffer);
        }

        private Tag writeValue() {
            return this.key.getSerializer().write(this.value);
        }

        private void readValue(Tag nbt) {
            this.value = this.key.getSerializer().read(nbt);
        }
    }

    public static class Provider
    implements ICapabilitySerializable<ListTag> {
        final DataHolder holder = new DataHolder();
        final LazyOptional<DataHolder> optional = LazyOptional.of(() -> this.holder);

        public ListTag serializeNBT() {
            ListTag list = new ListTag();
            this.holder.dataMap.forEach((key, entry) -> {
                if (key.shouldSave()) {
                    CompoundTag keyTag = new CompoundTag();
                    keyTag.m_128359_("Key", key.getKey().toString());
                    keyTag.m_128365_("Value", entry.writeValue());
                    list.add((Object)keyTag);
                }
            });
            return list;
        }

        public void deserializeNBT(ListTag listTag) {
            this.holder.dataMap.clear();
            listTag.forEach(entryTag -> {
                CompoundTag keyTag = (CompoundTag)entryTag;
                ResourceLocation key = ResourceLocation.m_135820_((String)keyTag.m_128461_("Key"));
                Tag value = keyTag.m_128423_("Value");
                SyncedDataKey<?> syncedDataKey = SyncedPlayerData.instance().registeredDataKeys.get(key);
                if (syncedDataKey != null && syncedDataKey.shouldSave()) {
                    DataEntry entry = new DataEntry(syncedDataKey);
                    entry.readValue(value);
                    this.holder.dataMap.put(syncedDataKey, entry);
                }
            });
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return CAPABILITY.orEmpty(cap, this.optional);
        }
    }
}

