/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.obfuscate.network;

import com.mrcrayfish.obfuscate.Obfuscate;
import com.mrcrayfish.obfuscate.common.data.SyncedPlayerData;
import com.mrcrayfish.obfuscate.network.HandshakeMessages;
import com.mrcrayfish.obfuscate.network.PacketHandler;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

class HandshakeHandler {
    private static final Marker OBFUSCATE_HANDSHAKE = MarkerManager.getMarker((String)"OBFUSCATE_HANDSHAKE");

    HandshakeHandler() {
    }

    static void handleAcknowledge(HandshakeMessages.C2SAcknowledge message, Supplier<NetworkEvent.Context> c) {
        Obfuscate.LOGGER.debug(OBFUSCATE_HANDSHAKE, "Received acknowledgement from client");
        c.get().setPacketHandled(true);
    }

    static void handleSyncedPlayerData(HandshakeMessages.S2CSyncedPlayerData message, Supplier<NetworkEvent.Context> c) {
        Obfuscate.LOGGER.debug(OBFUSCATE_HANDSHAKE, "Received synced key mappings from server");
        c.get().setPacketHandled(true);
        if (!SyncedPlayerData.instance().updateMappings(message)) {
            c.get().getNetworkManager().m_129507_((Component)new TextComponent("Connection closed - [Obfuscate] received unknown synced data key"));
            return;
        }
        PacketHandler.getHandshakeChannel().reply((Object)new HandshakeMessages.C2SAcknowledge(), c.get());
    }
}

