/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.obfuscate.network;

import com.mrcrayfish.obfuscate.common.data.SyncedDataKey;
import com.mrcrayfish.obfuscate.common.data.SyncedPlayerData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntSupplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class HandshakeMessages {

    public static class S2CSyncedPlayerData
    extends LoginIndexedMessage {
        private Map<ResourceLocation, Integer> keyMap;

        public S2CSyncedPlayerData() {
            this.keyMap = new HashMap<ResourceLocation, Integer>();
            List<SyncedDataKey<?>> keys = SyncedPlayerData.instance().getKeys();
            keys.forEach(syncedDataKey -> this.keyMap.put(syncedDataKey.getKey(), syncedDataKey.getId()));
        }

        private S2CSyncedPlayerData(Map<ResourceLocation, Integer> keyMap) {
            this.keyMap = keyMap;
        }

        void encode(FriendlyByteBuf output) {
            List<SyncedDataKey<?>> keys = SyncedPlayerData.instance().getKeys();
            keys.forEach(syncedDataKey -> {
                output.m_130085_(syncedDataKey.getKey());
                output.m_130130_(syncedDataKey.getId());
            });
        }

        static S2CSyncedPlayerData decode(FriendlyByteBuf input) {
            HashMap<ResourceLocation, Integer> keyMap = new HashMap<ResourceLocation, Integer>();
            List<SyncedDataKey<?>> keys = SyncedPlayerData.instance().getKeys();
            keys.forEach(syncedDataKey -> keyMap.put(input.m_130281_(), input.m_130242_()));
            return new S2CSyncedPlayerData(keyMap);
        }

        public Map<ResourceLocation, Integer> getKeyMap() {
            return this.keyMap;
        }
    }

    static class C2SAcknowledge
    extends LoginIndexedMessage {
        C2SAcknowledge() {
        }

        void encode(FriendlyByteBuf buf) {
        }

        static C2SAcknowledge decode(FriendlyByteBuf buf) {
            return new C2SAcknowledge();
        }
    }

    static class LoginIndexedMessage
    implements IntSupplier {
        private int loginIndex;

        LoginIndexedMessage() {
        }

        void setLoginIndex(int loginIndex) {
            this.loginIndex = loginIndex;
        }

        int getLoginIndex() {
            return this.loginIndex;
        }

        @Override
        public int getAsInt() {
            return this.getLoginIndex();
        }
    }
}

