/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.obfuscate.network.message;

import com.mrcrayfish.obfuscate.client.ClientHandler;
import com.mrcrayfish.obfuscate.common.data.SyncedPlayerData;
import com.mrcrayfish.obfuscate.network.message.IMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.fmllegacy.network.NetworkDirection;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class MessageSyncPlayerData
implements IMessage<MessageSyncPlayerData> {
    private int entityId;
    private List<SyncedPlayerData.DataEntry<?>> entries;

    public MessageSyncPlayerData() {
    }

    public MessageSyncPlayerData(int entityId, List<SyncedPlayerData.DataEntry<?>> entries) {
        this.entityId = entityId;
        this.entries = entries;
    }

    @Override
    public void encode(MessageSyncPlayerData message, FriendlyByteBuf buffer) {
        buffer.m_130130_(message.entityId);
        buffer.m_130130_(message.entries.size());
        message.entries.forEach(entry -> entry.write(buffer));
    }

    @Override
    public MessageSyncPlayerData decode(FriendlyByteBuf buffer) {
        int entityId = buffer.m_130242_();
        int size = buffer.m_130242_();
        ArrayList entries = new ArrayList();
        for (int i = 0; i < size; ++i) {
            entries.add(SyncedPlayerData.DataEntry.read(buffer));
        }
        return new MessageSyncPlayerData(entityId, entries);
    }

    @Override
    public void handle(MessageSyncPlayerData message, Supplier<NetworkEvent.Context> supplier) {
        if (supplier.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            supplier.get().enqueueWork(() -> ClientHandler.instance().updatePlayerData(message.entityId, message.entries));
            supplier.get().setPacketHandled(true);
        }
    }
}

