/*
 * Decompiled with CFR 0.152.
 */
package com.kreezcraft.onceuponastroll;

import com.kreezcraft.onceuponastroll.StrollConfig;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="onceuponastroll")
public class OnceUponaStroll {
    private static final Logger LOGGER = LogManager.getLogger();

    public OnceUponaStroll() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::setup);
        StrollConfig.init();
    }

    private void setup(FMLCommonSetupEvent event) {
        StrollConfig.load();
    }

    @Mod.EventBusSubscriber(modid="onceuponastroll")
    public static class MakePath {
        private static void generatePath(Entity player) {
            World world = player.func_130014_f_();
            if (!world.field_72995_K && (Math.abs(player.func_213322_ci().func_82615_a()) > 0.0 || Math.abs(player.func_213322_ci().func_82617_b()) > 0.0 || Math.abs(player.func_213322_ci().func_82616_c()) > 0.0)) {
                BlockPos entityLocation = new BlockPos(player.func_226277_ct_(), player.func_226278_cu_() + player.func_70033_W(), player.func_226281_cx_());
                BlockState state = world.func_180495_p(entityLocation);
                Block block = state.func_177230_c();
                double random = Math.random() * StrollConfig.mob_upperLimit + StrollConfig.mob_lowerLimit;
                if (block == Blocks.field_196658_i && random < StrollConfig.mob_grass2dirt) {
                    world.func_175656_a(entityLocation, Blocks.field_150346_d.func_176223_P());
                    return;
                }
                if (StrollConfig.fullPaths) {
                    if (block == Blocks.field_150346_d && random < StrollConfig.mob_dirt2path) {
                        world.func_175656_a(entityLocation, Blocks.field_185774_da.func_176223_P());
                        return;
                    }
                    if (block == Blocks.field_185774_da && random < StrollConfig.mob_path2gravel) {
                        world.func_175656_a(entityLocation, Blocks.field_150351_n.func_176223_P());
                        return;
                    }
                    if (block == Blocks.field_150351_n && random < StrollConfig.mob_gravel2stone) {
                        world.func_175656_a(entityLocation, Blocks.field_150348_b.func_176223_P());
                        return;
                    }
                    if (block == Blocks.field_150348_b && random < StrollConfig.mob_stone2stonebricks) {
                        world.func_175656_a(entityLocation, Blocks.field_196696_di.func_176223_P());
                    }
                }
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void makeMobPath(LivingEvent event) {
            if (event.getEntityLiving() != null && StrollConfig.pathMobs) {
                LivingEntity player = event.getEntityLiving();
                MakePath.generatePath((Entity)player);
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void makePlayerPath(PlayerEvent event) {
            if (event.getPlayer() != null && StrollConfig.pathPlayers) {
                PlayerEntity player = event.getPlayer();
                MakePath.generatePath((Entity)player);
            }
        }
    }
}

