/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.bullet.collision;

import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.physics.bullet.collision.CollisionJNI;
import com.badlogic.gdx.physics.bullet.collision.btConvexShape;
import com.badlogic.gdx.physics.bullet.collision.btTriangleCallback;
import com.badlogic.gdx.physics.bullet.linearmath.btTransform;
import com.badlogic.gdx.physics.bullet.linearmath.btVector3;

public class btTriangleConvexcastCallback
extends btTriangleCallback {
    private long swigCPtr;

    protected btTriangleConvexcastCallback(String className, long cPtr, boolean cMemoryOwn) {
        super(className, CollisionJNI.btTriangleConvexcastCallback_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    public btTriangleConvexcastCallback(long cPtr, boolean cMemoryOwn) {
        this("btTriangleConvexcastCallback", cPtr, cMemoryOwn);
        this.construct();
    }

    @Override
    protected void reset(long cPtr, boolean cMemoryOwn) {
        if (!this.destroyed) {
            this.destroy();
        }
        this.swigCPtr = cPtr;
        super.reset(CollisionJNI.btTriangleConvexcastCallback_SWIGUpcast(this.swigCPtr), cMemoryOwn);
    }

    public static long getCPtr(btTriangleConvexcastCallback obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    protected void finalize() throws Throwable {
        if (!this.destroyed) {
            this.destroy();
        }
        super.finalize();
    }

    @Override
    protected synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                CollisionJNI.delete_btTriangleConvexcastCallback(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    @Override
    protected void swigDirectorDisconnect() {
        this.swigCMemOwn = false;
        this.delete();
    }

    @Override
    public void swigReleaseOwnership() {
        this.swigCMemOwn = false;
        CollisionJNI.btTriangleConvexcastCallback_change_ownership(this, this.swigCPtr, false);
    }

    @Override
    public void swigTakeOwnership() {
        this.swigCMemOwn = true;
        CollisionJNI.btTriangleConvexcastCallback_change_ownership(this, this.swigCPtr, true);
    }

    public void setConvexShape(btConvexShape value) {
        CollisionJNI.btTriangleConvexcastCallback_convexShape_set(this.swigCPtr, this, btConvexShape.getCPtr(value), value);
    }

    public btConvexShape getConvexShape() {
        long cPtr = CollisionJNI.btTriangleConvexcastCallback_convexShape_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new btConvexShape(cPtr, false);
    }

    public void setConvexShapeFrom(btTransform value) {
        CollisionJNI.btTriangleConvexcastCallback_convexShapeFrom_set(this.swigCPtr, this, btTransform.getCPtr(value), value);
    }

    public btTransform getConvexShapeFrom() {
        long cPtr = CollisionJNI.btTriangleConvexcastCallback_convexShapeFrom_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new btTransform(cPtr, false);
    }

    public void setConvexShapeTo(btTransform value) {
        CollisionJNI.btTriangleConvexcastCallback_convexShapeTo_set(this.swigCPtr, this, btTransform.getCPtr(value), value);
    }

    public btTransform getConvexShapeTo() {
        long cPtr = CollisionJNI.btTriangleConvexcastCallback_convexShapeTo_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new btTransform(cPtr, false);
    }

    public void setTriangleToWorld(btTransform value) {
        CollisionJNI.btTriangleConvexcastCallback_triangleToWorld_set(this.swigCPtr, this, btTransform.getCPtr(value), value);
    }

    public btTransform getTriangleToWorld() {
        long cPtr = CollisionJNI.btTriangleConvexcastCallback_triangleToWorld_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new btTransform(cPtr, false);
    }

    public void setHitFraction(float value) {
        CollisionJNI.btTriangleConvexcastCallback_hitFraction_set(this.swigCPtr, this, value);
    }

    public float getHitFraction() {
        return CollisionJNI.btTriangleConvexcastCallback_hitFraction_get(this.swigCPtr, this);
    }

    public void setTriangleCollisionMargin(float value) {
        CollisionJNI.btTriangleConvexcastCallback_triangleCollisionMargin_set(this.swigCPtr, this, value);
    }

    public float getTriangleCollisionMargin() {
        return CollisionJNI.btTriangleConvexcastCallback_triangleCollisionMargin_get(this.swigCPtr, this);
    }

    public void setAllowedPenetration(float value) {
        CollisionJNI.btTriangleConvexcastCallback_allowedPenetration_set(this.swigCPtr, this, value);
    }

    public float getAllowedPenetration() {
        return CollisionJNI.btTriangleConvexcastCallback_allowedPenetration_get(this.swigCPtr, this);
    }

    public btTriangleConvexcastCallback(btConvexShape convexShape, Matrix4 convexShapeFrom, Matrix4 convexShapeTo, Matrix4 triangleToWorld, float triangleCollisionMargin) {
        this(CollisionJNI.new_btTriangleConvexcastCallback(btConvexShape.getCPtr(convexShape), convexShape, convexShapeFrom, convexShapeTo, triangleToWorld, triangleCollisionMargin), true);
        CollisionJNI.btTriangleConvexcastCallback_director_connect(this, this.swigCPtr, this.swigCMemOwn, true);
    }

    @Override
    public void processTriangle(btVector3 triangle, int partId, int triangleIndex) {
        if (this.getClass() == btTriangleConvexcastCallback.class) {
            CollisionJNI.btTriangleConvexcastCallback_processTriangle(this.swigCPtr, this, btVector3.getCPtr(triangle), triangle, partId, triangleIndex);
        } else {
            CollisionJNI.btTriangleConvexcastCallback_processTriangleSwigExplicitbtTriangleConvexcastCallback(this.swigCPtr, this, btVector3.getCPtr(triangle), triangle, partId, triangleIndex);
        }
    }

    public float reportHit(Vector3 hitNormalLocal, Vector3 hitPointLocal, float hitFraction, int partId, int triangleIndex) {
        return CollisionJNI.btTriangleConvexcastCallback_reportHit(this.swigCPtr, this, hitNormalLocal, hitPointLocal, hitFraction, partId, triangleIndex);
    }
}

