/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.bullet.linearmath;

import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.physics.bullet.BulletBase;
import com.badlogic.gdx.physics.bullet.linearmath.LinearMathJNI;
import com.badlogic.gdx.physics.bullet.linearmath.SWIGTYPE_p_float;

public class btTransformUtil
extends BulletBase {
    private long swigCPtr;

    protected btTransformUtil(String className, long cPtr, boolean cMemoryOwn) {
        super(className, cPtr, cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    public btTransformUtil(long cPtr, boolean cMemoryOwn) {
        this("btTransformUtil", cPtr, cMemoryOwn);
        this.construct();
    }

    @Override
    protected void reset(long cPtr, boolean cMemoryOwn) {
        if (!this.destroyed) {
            this.destroy();
        }
        this.swigCPtr = cPtr;
        super.reset(this.swigCPtr, cMemoryOwn);
    }

    public static long getCPtr(btTransformUtil obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    protected void finalize() throws Throwable {
        if (!this.destroyed) {
            this.destroy();
        }
        super.finalize();
    }

    @Override
    protected synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                LinearMathJNI.delete_btTransformUtil(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public static void integrateTransform(Matrix4 curTrans, Vector3 linvel, Vector3 angvel, float timeStep, Matrix4 predictedTransform) {
        LinearMathJNI.btTransformUtil_integrateTransform(curTrans, linvel, angvel, timeStep, predictedTransform);
    }

    public static void calculateVelocityQuaternion(Vector3 pos0, Vector3 pos1, Quaternion orn0, Quaternion orn1, float timeStep, Vector3 linVel, Vector3 angVel) {
        LinearMathJNI.btTransformUtil_calculateVelocityQuaternion(pos0, pos1, orn0, orn1, timeStep, linVel, angVel);
    }

    public static void calculateDiffAxisAngleQuaternion(Quaternion orn0, Quaternion orn1a, Vector3 axis, SWIGTYPE_p_float angle) {
        LinearMathJNI.btTransformUtil_calculateDiffAxisAngleQuaternion(orn0, orn1a, axis, SWIGTYPE_p_float.getCPtr(angle));
    }

    public static void calculateVelocity(Matrix4 transform0, Matrix4 transform1, float timeStep, Vector3 linVel, Vector3 angVel) {
        LinearMathJNI.btTransformUtil_calculateVelocity(transform0, transform1, timeStep, linVel, angVel);
    }

    public static void calculateDiffAxisAngle(Matrix4 transform0, Matrix4 transform1, Vector3 axis, SWIGTYPE_p_float angle) {
        LinearMathJNI.btTransformUtil_calculateDiffAxisAngle(transform0, transform1, axis, SWIGTYPE_p_float.getCPtr(angle));
    }

    public btTransformUtil() {
        this(LinearMathJNI.new_btTransformUtil(), true);
    }
}

