/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;

@Mod.EventBusSubscriber(modid="physicsmod", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ForgeConfigSpec.Builder CLIENT_BUILDER = new ForgeConfigSpec.Builder();
    public static final Client CLIENT = new Client(CLIENT_BUILDER);
    public static final Server CLIENT_SERVER = new Server(CLIENT_BUILDER);
    public static final ForgeConfigSpec CLIENT_SPEC = CLIENT_BUILDER.build();
    private static final ForgeConfigSpec.Builder SERVER_BUILDER = new ForgeConfigSpec.Builder();
    public static final Server SERVER = new Server(SERVER_BUILDER);
    public static final ForgeConfigSpec SERVER_SPEC = SERVER_BUILDER.build();

    @SubscribeEvent
    public static void onModConfigEvent(ModConfig.ModConfigEvent configEvent) {
        if (configEvent.getConfig().getSpec() == CLIENT_SPEC) {
            CLIENT.bake();
            CLIENT_SERVER.bake();
        }
        if (configEvent.getConfig().getSpec() == SERVER_SPEC) {
            SERVER.bake();
        }
    }

    public static class Server {
        public final ForgeConfigSpec.ConfigValue<Boolean> collapseProp;
        public final ForgeConfigSpec.ConfigValue<Boolean> dropBlocksProp;
        public final ForgeConfigSpec.ConfigValue<Integer> maxCollapseObjectsProp;
        public final ForgeConfigSpec.ConfigValue<Integer> collapseSpeedProp;
        public volatile boolean collapse;
        public volatile boolean dropBlocks;
        public volatile int maxCollapseObjects;
        public volatile int collapseSpeed;

        public Server(ForgeConfigSpec.Builder builder) {
            builder.push("Server");
            this.collapseProp = builder.comment("Enable/Disable collapsing blocks.").translation("blocks.colapse").define("collapse", true);
            this.dropBlocksProp = builder.comment("Enable/Disable dropping blocks.").translation("blocks.drop").define("dropBlocks", true);
            this.maxCollapseObjectsProp = builder.comment("Maximum number of collapsing block events that get caused by one update.").translation("blocks.maxCollapseObjects").defineInRange("maxCollapseObjects", 100, 1, 5000);
            this.collapseSpeedProp = builder.comment("Collapsing speed in ticks. 0 means instant collapse.").translation("blocks.collapseSpeed").defineInRange("collapseSpeed", 10, 0, 500);
            builder.pop();
        }

        public void bake() {
            this.collapse = (Boolean)this.collapseProp.get();
            this.maxCollapseObjects = (Integer)this.maxCollapseObjectsProp.get();
            this.collapseSpeed = (Integer)this.collapseSpeedProp.get();
            this.dropBlocks = (Boolean)this.dropBlocksProp.get();
        }

        public void save() {
            this.collapseProp.set((Object)this.collapse);
            this.collapseProp.save();
            this.dropBlocksProp.set((Object)this.dropBlocks);
            this.dropBlocksProp.save();
            this.maxCollapseObjectsProp.set((Object)this.maxCollapseObjects);
            this.maxCollapseObjectsProp.save();
            this.collapseSpeedProp.set((Object)this.collapseSpeed);
            this.collapseSpeedProp.save();
        }
    }

    public static class Client {
        public final ForgeConfigSpec.ConfigValue<Boolean> mobPhysicsProp;
        public final ForgeConfigSpec.ConfigValue<Boolean> bloodProp;
        public final ForgeConfigSpec.ConfigValue<Boolean> mobBlockyProp;
        public final ForgeConfigSpec.ConfigValue<Boolean> blockPhysicsProp;
        public final ForgeConfigSpec.ConfigValue<Integer> physicsRangeProp;
        public final ForgeConfigSpec.ConfigValue<Integer> maxPhysicsObjectsProp;
        public final ForgeConfigSpec.ConfigValue<Double> blockPhysicsScaleProp;
        public final ForgeConfigSpec.ConfigValue<Double> particleLifetimeProp;
        public volatile boolean mobPhysics;
        public volatile boolean bloodPhysics;
        public volatile boolean mobBlockyPhysics;
        public volatile boolean blockPhysics;
        public volatile int physicsRange;
        public volatile int maxPhysicsObjects;
        public volatile double blockPhysicsScale;
        public volatile double particleLifetime;

        public Client(ForgeConfigSpec.Builder builder) {
            builder.push("Client");
            this.mobPhysicsProp = builder.comment("Enable/Disable mob physics.").translation("mob.enabled").define("mobPhysics", true);
            this.mobBlockyProp = builder.comment("Enable/Disable whether killed mobs should fracture or drop in their individual blocky parts.").translation("mob.blocky").define("mobBlockyPhysics", false);
            this.bloodProp = builder.comment("Enable/Disable mob physics blood.").translation("mob.blood").define("mobBlood", true);
            this.blockPhysicsProp = builder.comment("Enable/Disable block physics.").translation("blocks.enabled").define("blockPhysics", true);
            this.physicsRangeProp = builder.comment("Range activation of physics measured in blocks. High numbers are not adviced because a lot of gravel will drop in freshly generated ocean biomes which cause a lot of physics and lag.").translation("blocks.range").defineInRange("physicsRange", 60, 10, 250);
            this.maxPhysicsObjectsProp = builder.comment("Maximum number of active physics objects in the world. Higher numbers also result in better quality fractures being used when a lot of objects are active. This number literally decides if you want to kill your PC or not.").translation("blocks.max").defineInRange("maxPhysicsObjects", 500, 10, 10000);
            this.blockPhysicsScaleProp = builder.comment("Scales the size of the blocks (when they are blocking your view too much).").translation("blocks.scale").defineInRange("blockPhysicsScale", 1.0, 0.05, 4.0);
            this.particleLifetimeProp = builder.comment("Lifetime of physics particles in seconds. It automatically adds a random amount between 0 and 3 seconds to each spawned particle.").translation("blocks.lifetime").defineInRange("particleLifetime", 4.0, 0.1, 10000.0);
            builder.pop();
        }

        public void bake() {
            this.mobPhysics = (Boolean)this.mobPhysicsProp.get();
            this.bloodPhysics = (Boolean)this.bloodProp.get();
            this.mobBlockyPhysics = (Boolean)this.mobBlockyProp.get();
            this.blockPhysics = (Boolean)this.blockPhysicsProp.get();
            this.maxPhysicsObjects = (Integer)this.maxPhysicsObjectsProp.get();
            this.physicsRange = (Integer)this.physicsRangeProp.get();
            this.blockPhysicsScale = (Double)this.blockPhysicsScaleProp.get();
            this.particleLifetime = (Double)this.particleLifetimeProp.get();
        }

        public void save() {
            this.mobPhysicsProp.set((Object)this.mobPhysics);
            this.mobPhysicsProp.save();
            this.bloodProp.set((Object)this.bloodPhysics);
            this.bloodProp.save();
            this.mobBlockyProp.set((Object)this.mobBlockyPhysics);
            this.mobBlockyProp.save();
            this.blockPhysicsProp.set((Object)this.blockPhysics);
            this.blockPhysicsProp.save();
            this.maxPhysicsObjectsProp.set((Object)this.maxPhysicsObjects);
            this.maxPhysicsObjectsProp.save();
            this.physicsRangeProp.set((Object)this.physicsRange);
            this.physicsRangeProp.save();
            this.blockPhysicsScaleProp.set((Object)this.blockPhysicsScale);
            this.blockPhysicsScaleProp.save();
            this.particleLifetimeProp.set((Object)this.particleLifetime);
            this.particleLifetimeProp.save();
        }
    }
}

