/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins;

import com.mojang.blaze3d.systems.RenderSystem;
import net.diebuddies.physics.BlockParticle;
import net.diebuddies.physics.PhysicsMod;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.biome.BiomeColors;
import net.minecraft.world.chunk.Chunk;
import org.joml.Matrix4d;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Chunk.class})
public class MixinChunk {
    @Inject(at={@At(value="HEAD")}, method={"setBlockState"})
    private void setBlockState(BlockPos pos, BlockState state, boolean isMoving, CallbackInfoReturnable<BlockState> ci) {
        if (RenderSystem.isOnRenderThread() && Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71439_g.field_213837_d != null) {
            VoxelShape voxelShape;
            BlockState before = Minecraft.func_71410_x().field_71439_g.field_213837_d.func_180495_p(pos);
            PhysicsMod.getInstance().blockUpdates.add(pos.func_185334_h());
            if (!PhysicsMod.getInstance().clientConfig.blockPhysics) {
                return;
            }
            if (before != null && state != null && !before.func_196958_f() && state.func_196958_f() && before.func_177230_c() != Blocks.field_150335_W && before.func_177230_c() != Blocks.field_150332_K && !(voxelShape = before.func_196952_d((IBlockReader)Minecraft.func_71410_x().field_71439_g.field_213837_d, pos)).func_197766_b()) {
                PhysicsMod.getInstance().queue.add(this.getBlockData(pos, before));
            }
        }
    }

    private BlockParticle getBlockData(BlockPos pos, BlockState state) {
        BlockParticle particle = new BlockParticle();
        Minecraft minecraft = Minecraft.func_71410_x();
        BlockRendererDispatcher ren = minecraft.func_175602_ab();
        IBakedModel model = ren.func_184389_a(state);
        particle.setTransformation(new Matrix4d().translate((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5));
        particle.setOldTransformation(new Matrix4d().translate((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5));
        particle.texture = model.func_177554_e();
        particle.color = state.func_177230_c() == Blocks.field_196572_aa || state.func_177230_c() == Blocks.field_196647_Y || state.func_177230_c() == Blocks.field_196574_ab || state.func_177230_c() == Blocks.field_196648_Z || state.func_177230_c() == Blocks.field_196642_W || state.func_177230_c() == Blocks.field_196645_X ? BiomeColors.func_228361_b_((IBlockDisplayReader)Minecraft.func_71410_x().field_71439_g.field_213837_d, (BlockPos)pos) : -1;
        return particle;
    }
}

