/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins;

import com.mojang.blaze3d.systems.RenderSystem;
import java.lang.reflect.InvocationTargetException;
import net.diebuddies.physics.Explosion;
import net.diebuddies.physics.PhysicsMod;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.play.server.SDestroyEntitiesPacket;
import net.minecraft.network.play.server.SExplosionPacket;
import net.minecraft.world.IWorld;
import org.joml.Vector3d;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientPlayNetHandler.class})
public class MixinClientPlayNetHandler {
    @Inject(at={@At(value="HEAD")}, method={"handleExplosion"})
    public void handleExplosion(SExplosionPacket explosionPacket, CallbackInfo ci) {
        if (RenderSystem.isOnRenderThread()) {
            Explosion explosion = new Explosion();
            explosion.strength = explosionPacket.func_149146_i();
            explosion.position = new Vector3d(explosionPacket.func_149148_f(), explosionPacket.func_149143_g(), explosionPacket.func_149145_h());
            PhysicsMod.getInstance().explosions.add(explosion);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"handleDestroyEntities"})
    public void handleDestroyEntities(SDestroyEntitiesPacket packetIn, CallbackInfo ci) {
        if (RenderSystem.isOnRenderThread()) {
            for (int i = 0; i < packetIn.func_149098_c().length; ++i) {
                int j = packetIn.func_149098_c()[i];
                Entity entity = Minecraft.func_71410_x().field_71439_g.field_213837_d.func_73045_a(j);
                if (entity == null || !(entity instanceof LivingEntity) || !(entity.func_213303_ch().func_72438_d(Minecraft.func_71410_x().field_71439_g.func_213303_ch()) < 40.0)) continue;
                try {
                    PhysicsMod.blockifyEntity((IWorld)((LivingEntity)entity).func_130014_f_(), entity);
                    continue;
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

