/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Random;
import net.diebuddies.engine.util.math.MatrixUtil;
import net.diebuddies.physics.BlockParticle;
import net.diebuddies.physics.IRigidBody;
import net.diebuddies.physics.Mesh;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.PhysicsWorld;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IWorld;
import org.joml.Matrix4d;
import org.joml.Vector2d;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WorldRenderer.class})
public class MixinWorldRenderer {
    private static final int[] indices = new int[]{0, 1, 2, 0, 2, 3, 6, 5, 4, 7, 6, 4, 10, 9, 8, 11, 10, 8, 12, 13, 14, 12, 14, 15, 18, 17, 16, 19, 18, 16, 20, 21, 22, 20, 22, 23};
    private static final int[] indices_quad = new int[]{0, 1, 2, 3, 6, 5, 4, 7, 10, 9, 8, 11, 12, 13, 14, 15, 18, 17, 16, 19, 20, 21, 22, 23};
    private static final float[] positions = new float[]{-0.5f, -0.5f, 0.5f, 0.5f, -0.5f, 0.5f, 0.5f, 0.5f, 0.5f, -0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, -0.5f, 0.5f, -0.5f, -0.5f, 0.5f, -0.5f, 0.5f, -0.5f, -0.5f, -0.5f, 0.5f, -0.5f, -0.5f, 0.5f, 0.5f, -0.5f, -0.5f, 0.5f, -0.5f, -0.5f, -0.5f, -0.5f, -0.5f, -0.5f, 0.5f, -0.5f, 0.5f, 0.5f, -0.5f, 0.5f, -0.5f, 0.5f, 0.5f, 0.5f, -0.5f, 0.5f, 0.5f, -0.5f, 0.5f, -0.5f, 0.5f, 0.5f, -0.5f, -0.5f, -0.5f, -0.5f, 0.5f, -0.5f, -0.5f, 0.5f, -0.5f, 0.5f, -0.5f, -0.5f, 0.5f};
    private static final float[] uv = new float[]{0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f};
    private static final byte[] colors = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private static final float[] normals = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f};

    @Inject(at={@At(value="TAIL")}, method={"renderBlockLayer"})
    private void renderBlockLayer(RenderType blockLayerIn, MatrixStack matrixStackIn, double xIn, double yIn, double zIn, CallbackInfo ci) {
        PhysicsMod mod = PhysicsMod.getInstance();
        if (blockLayerIn == RenderType.func_228639_c_()) {
            ClientWorld world;
            blockLayerIn.func_228549_b_();
            RenderSystem.enableDepthTest();
            RenderSystem.enableAlphaTest();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.defaultAlphaFunc();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            Vector3d view = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
            MatrixStack stack = matrixStackIn;
            RenderSystem.pushMatrix();
            RenderSystem.enableLighting();
            RenderSystem.enableColorMaterial();
            RenderSystem.enableFog();
            RenderSystem.enableCull();
            Minecraft.func_71410_x().field_71460_t.func_228384_l_().func_205109_c();
            RenderHelper.func_227781_a_((Matrix4f)matrixStackIn.func_227866_c_().func_227870_a_());
            GlStateManager.func_227639_a_((int)516, (float)0.95f);
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            float[] m = new float[16];
            if (player != null && (world = player.field_213837_d) != null) {
                PhysicsWorld physics = mod.physicWorlds.get(world);
                if (physics == null) {
                    physics = new PhysicsWorld((IWorld)world);
                    mod.physicWorlds.put((IWorld)world, physics);
                }
                RenderSystem.pushMatrix();
                RenderSystem.multMatrix((Matrix4f)stack.func_227866_c_().func_227870_a_());
                if (physics != null) {
                    BlockParticle particle;
                    int qsize;
                    double chance = 1.0;
                    if (mod.queue.size() > 10 || (double)physics.getBodies().size() > (double)mod.clientConfig.maxPhysicsObjects * 0.4) {
                        chance = 0.3;
                        if ((double)physics.getBodies().size() > (double)mod.clientConfig.maxPhysicsObjects * 0.7) {
                            chance = 0.05;
                        }
                    }
                    if (physics.getBodies().size() > mod.clientConfig.maxPhysicsObjects) {
                        chance = 0.0;
                    }
                    if ((qsize = mod.queue.size()) == 1) {
                        chance = 1.0;
                    }
                    while (!mod.queue.isEmpty()) {
                        particle = mod.queue.poll();
                        org.joml.Vector3d vector3d = new org.joml.Vector3d();
                        if (!(particle.getTransformation().getTranslation(vector3d).distance(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_()) < (double)mod.clientConfig.physicsRange) || !(Math.random() < chance)) continue;
                        if (chance < 0.5 || (double)physics.getBodies().size() > (double)mod.clientConfig.maxPhysicsObjects * 0.4) {
                            particle.scale = PhysicsMod.getInstance().clientConfig.blockPhysicsScale;
                            physics.addBlockParticle(PhysicsMod.brokenBlocksLittle.get(new Random().nextInt(PhysicsMod.brokenBlocksLittle.size())), particle);
                            continue;
                        }
                        particle.scale = PhysicsMod.getInstance().clientConfig.blockPhysicsScale;
                        physics.addBlockParticle(PhysicsMod.brokenBlocksLots.get(new Random().nextInt(PhysicsMod.brokenBlocksLots.size())), particle);
                    }
                    while (!mod.entityBlocks.isEmpty()) {
                        particle = mod.entityBlocks.poll();
                        org.joml.Vector3d vector3d = new org.joml.Vector3d();
                        if (!(particle.getTransformation().getTranslation(vector3d).distance(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_()) < (double)mod.clientConfig.physicsRange)) continue;
                        physics.addBlockParticle(particle);
                    }
                    while (!mod.blockUpdates.isEmpty()) {
                        BlockPos pos = mod.blockUpdates.poll();
                        if (!player.func_233580_cy_().func_218141_a((Vector3i)pos, (double)mod.clientConfig.physicsRange + 5.0)) continue;
                        physics.blockUpdate(pos);
                    }
                    while (!mod.explosions.isEmpty()) {
                        physics.applyExplosion(mod.explosions.poll());
                    }
                    for (IRigidBody body : physics.getBodies()) {
                        BlockParticle particle2 = (BlockParticle)body.getEntity();
                        Matrix4d transformation = MatrixUtil.slerp(particle2.getOldTransformation(), particle2.getTransformation(), physics.getRenderPercent(), new Matrix4d());
                        transformation.scale(net.diebuddies.engine.util.math.Math.clamp(particle2.time * 2.0, 0.0, 1.0));
                        org.joml.Vector3d pos = transformation.getTranslation(new org.joml.Vector3d());
                        BlockPos blockPos = new BlockPos(pos.x + physics.getOffset().x, pos.y + physics.getOffset().y, pos.z + physics.getOffset().z);
                        transformation._m30(transformation.m30() - view.field_72450_a + physics.getOffset().x);
                        transformation._m31(transformation.m31() - view.field_72448_b + physics.getOffset().y);
                        transformation._m32(transformation.m32() - view.field_72449_c + physics.getOffset().z);
                        transformation.scale(particle2.scalePhysics.x, particle2.scalePhysics.y, particle2.scalePhysics.z);
                        transformation.get(m);
                        Matrix4f modelMatrix = new Matrix4f(m);
                        RenderSystem.pushMatrix();
                        modelMatrix.func_226602_e_();
                        RenderSystem.multMatrix((Matrix4f)modelMatrix);
                        if (particle2.texture != null) {
                            particle2.texture.func_229241_m_().func_229148_d_();
                        } else if (particle2.textureState != null) {
                            particle2.textureState.func_228547_a_();
                        }
                        bufferbuilder.func_181668_a(4, DefaultVertexFormats.field_227849_i_);
                        Mesh mesh = particle2.mesh;
                        int brightness = 0;
                        BlockState bState = world.func_180495_p(blockPos);
                        brightness = bState.func_177230_c() == Blocks.field_150350_a || bState.func_177230_c() == Blocks.field_150355_j || bState.func_177230_c() == Blocks.field_150353_l ? (world.func_175667_e(blockPos) ? WorldRenderer.func_228421_a_((IBlockDisplayReader)world, (BlockPos)blockPos) : 0) : (world.func_175667_e(blockPos.func_177984_a()) ? WorldRenderer.func_228421_a_((IBlockDisplayReader)world, (BlockPos)blockPos.func_177984_a()) : 0);
                        int j = brightness >> 16 & 0xFFFF;
                        int k = brightness & 0xFFFF;
                        int b = particle2.color & 0xFF;
                        int g = particle2.color >> 8 & 0xFF;
                        int r = particle2.color >> 16 & 0xFF;
                        for (org.joml.Vector3i index : mesh.indices) {
                            org.joml.Vector3d position = mesh.positions.get(index.x - 1);
                            Vector2d uv = mesh.uvs.get(index.y - 1);
                            org.joml.Vector3d normal = mesh.normals.get(index.z - 1);
                            if (mesh.colors.size() > 0) {
                                org.joml.Vector3f color = mesh.colors.get(index.x - 1);
                                r = (int)(color.x * 255.0f);
                                g = (int)(color.y * 255.0f);
                                b = (int)(color.z * 255.0f);
                            }
                            float minU = 0.0f;
                            float maxU = 1.0f;
                            float minV = 0.0f;
                            float maxV = 1.0f;
                            if (particle2.texture != null) {
                                minU = particle2.texture.func_94209_e();
                                maxU = particle2.texture.func_94212_f();
                                minV = particle2.texture.func_94206_g();
                                maxV = particle2.texture.func_94210_h();
                            }
                            bufferbuilder.func_225582_a_(position.x * particle2.scale, position.y * particle2.scale, position.z * particle2.scale).func_225586_a_(r, g, b, 255).func_225583_a_(net.diebuddies.engine.util.math.Math.remap((float)uv.x, 0.0f, 1.0f, minU, maxU), net.diebuddies.engine.util.math.Math.remap((float)uv.y, 0.0f, 1.0f, minV, maxV)).func_225585_a_(0, 0).func_225587_b_(k, j).func_225584_a_((float)normal.x, (float)normal.y, (float)normal.z).func_181675_d();
                        }
                        tessellator.func_78381_a();
                        RenderSystem.popMatrix();
                    }
                }
                RenderSystem.popMatrix();
            }
            RenderSystem.popMatrix();
        }
        RenderSystem.defaultAlphaFunc();
        RenderSystem.disableLighting();
        blockLayerIn.func_228547_a_();
    }

    private void applyTranslationRotation(MatrixStack stack, LivingEntity entityIn, LivingRenderer renderer) {
        Direction direction;
        boolean shouldSit;
        float partialTicks = Minecraft.func_71410_x().func_184121_ak();
        double px = MathHelper.func_219803_d((double)partialTicks, (double)entityIn.field_70169_q, (double)entityIn.func_226277_ct_());
        double py = MathHelper.func_219803_d((double)partialTicks, (double)entityIn.field_70167_r, (double)entityIn.func_226278_cu_());
        double pz = MathHelper.func_219803_d((double)partialTicks, (double)entityIn.field_70166_s, (double)entityIn.func_226281_cx_());
        stack.func_227861_a_(px, py + 2.0, pz);
        renderer.func_217764_d().field_217112_c = entityIn.func_70678_g(partialTicks);
        renderer.func_217764_d().field_217113_d = shouldSit = entityIn.func_184218_aH() && entityIn.func_184187_bx() != null && entityIn.func_184187_bx().shouldRiderSit();
        renderer.func_217764_d().field_217114_e = entityIn.func_70631_g_();
        float f = MathHelper.func_219805_h((float)partialTicks, (float)entityIn.field_70760_ar, (float)entityIn.field_70761_aq);
        float f1 = MathHelper.func_219805_h((float)partialTicks, (float)entityIn.field_70758_at, (float)entityIn.field_70759_as);
        float f2 = f1 - f;
        if (shouldSit && entityIn.func_184187_bx() instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entityIn.func_184187_bx();
            f = MathHelper.func_219805_h((float)partialTicks, (float)livingentity.field_70760_ar, (float)livingentity.field_70761_aq);
            f2 = f1 - f;
            float f3 = MathHelper.func_76142_g((float)f2);
            if (f3 < -85.0f) {
                f3 = -85.0f;
            }
            if (f3 >= 85.0f) {
                f3 = 85.0f;
            }
            f = f1 - f3;
            if (f3 * f3 > 2500.0f) {
                f += f3 * 0.2f;
            }
            f2 = f1 - f;
        }
        float f6 = MathHelper.func_219799_g((float)partialTicks, (float)entityIn.field_70127_C, (float)entityIn.field_70125_A);
        if (entityIn.func_213283_Z() == Pose.SLEEPING && (direction = entityIn.func_213376_dz()) != null) {
            float f4 = entityIn.func_213307_e(Pose.STANDING) - 0.1f;
            stack.func_227861_a_((double)((float)(-direction.func_82601_c()) * f4), 0.0, (double)((float)(-direction.func_82599_e()) * f4));
        }
        float f7 = (float)entityIn.field_70173_aa + partialTicks;
        stack.func_227862_a_(-1.0f, -1.0f, 1.0f);
        stack.func_227861_a_(0.0, (double)-1.501f, 0.0);
        float f8 = 0.0f;
        float f5 = 0.0f;
        if (!shouldSit && entityIn.func_70089_S()) {
            f8 = MathHelper.func_219799_g((float)partialTicks, (float)entityIn.field_184618_aE, (float)entityIn.field_70721_aZ);
            f5 = entityIn.field_184619_aG - entityIn.field_70721_aZ * (1.0f - partialTicks);
            if (entityIn.func_70631_g_()) {
                f5 *= 3.0f;
            }
            if (f8 > 1.0f) {
                f8 = 1.0f;
            }
        }
        renderer.func_217764_d().func_212843_a_((Entity)entityIn, f5, f8, partialTicks);
        renderer.func_217764_d().func_225597_a_((Entity)entityIn, f5, f8, f7, f2, f6);
    }

    private void renderModel(MatrixStack stack, IWorld world, Vector3d pos, Tessellator tessellator, BufferBuilder bufferbuilder, ModelRenderer modelRenderer) {
        stack.func_227860_a_();
        stack.func_227861_a_((double)(modelRenderer.field_78800_c / 16.0f), (double)(modelRenderer.field_78797_d / 16.0f), (double)(modelRenderer.field_78798_e / 16.0f));
        if (modelRenderer.field_78808_h != 0.0f) {
            stack.func_227863_a_(Vector3f.field_229183_f_.func_229193_c_(modelRenderer.field_78808_h));
        }
        if (modelRenderer.field_78796_g != 0.0f) {
            stack.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(modelRenderer.field_78796_g));
        }
        if (modelRenderer.field_78795_f != 0.0f) {
            stack.func_227863_a_(Vector3f.field_229179_b_.func_229193_c_(modelRenderer.field_78795_f));
        }
        for (ModelRenderer model : modelRenderer.field_78805_m) {
            this.renderModel(stack, world, pos, tessellator, bufferbuilder, model);
        }
        for (ModelRenderer.ModelBox box : modelRenderer.field_78804_l) {
            BlockPos blockPos = new BlockPos(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
            RenderSystem.pushMatrix();
            RenderSystem.multMatrix((Matrix4f)stack.func_227866_c_().func_227870_a_());
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_227849_i_);
            int brightness = world.func_175667_e(blockPos) ? WorldRenderer.func_228421_a_((IBlockDisplayReader)world, (BlockPos)blockPos) : 0;
            int j = brightness >> 16 & 0xFFFF;
            int k = brightness & 0xFFFF;
            for (ModelRenderer.TexturedQuad quad : box.field_78254_i) {
                for (ModelRenderer.PositionTextureVertex vertex : quad.field_78239_a) {
                    float lvt_23_1_ = vertex.field_78243_a.func_195899_a() / 16.0f;
                    float lvt_24_1_ = vertex.field_78243_a.func_195900_b() / 16.0f;
                    float lvt_25_1_ = vertex.field_78243_a.func_195902_c() / 16.0f;
                    bufferbuilder.func_225582_a_((double)(vertex.field_78243_a.func_195899_a() / 16.0f), (double)(vertex.field_78243_a.func_195900_b() / 16.0f), (double)(vertex.field_78243_a.func_195902_c() / 16.0f)).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(vertex.field_78241_b, vertex.field_78242_c).func_225585_a_(0, 0).func_225587_b_(k, j).func_225584_a_(quad.field_228312_b_.func_195899_a(), quad.field_228312_b_.func_195900_b(), quad.field_228312_b_.func_195902_c()).func_181675_d();
                }
            }
            tessellator.func_78381_a();
            RenderSystem.popMatrix();
        }
        stack.func_227865_b_();
    }

    private void renderBox(MatrixStack stack, IWorld world, Vector3d pos, Tessellator tessellator, BufferBuilder bufferbuilder, ModelRenderer modelRenderer, LivingEntity entity, LivingRenderer renderer) {
        stack.func_227860_a_();
        stack.func_227861_a_((double)(modelRenderer.field_78800_c / 16.0f), (double)(modelRenderer.field_78797_d / 16.0f), (double)(modelRenderer.field_78798_e / 16.0f));
        if (modelRenderer.field_78808_h != 0.0f) {
            stack.func_227863_a_(Vector3f.field_229183_f_.func_229193_c_(modelRenderer.field_78808_h));
        }
        if (modelRenderer.field_78796_g != 0.0f) {
            stack.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(modelRenderer.field_78796_g));
        }
        if (modelRenderer.field_78795_f != 0.0f) {
            stack.func_227863_a_(Vector3f.field_229179_b_.func_229193_c_(modelRenderer.field_78795_f));
        }
        for (ModelRenderer model : modelRenderer.field_78805_m) {
            this.renderBox(stack, world, pos, tessellator, bufferbuilder, model, entity, renderer);
        }
        for (ModelRenderer.ModelBox box : modelRenderer.field_78804_l) {
            BlockPos blockPos = new BlockPos(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
            RenderSystem.pushMatrix();
            RenderSystem.multMatrix((Matrix4f)stack.func_227866_c_().func_227870_a_());
            int brightness = world.func_175667_e(blockPos) ? WorldRenderer.func_228421_a_((IBlockDisplayReader)world, (BlockPos)blockPos) : 0;
            int j = brightness >> 16 & 0xFFFF;
            int k = brightness & 0xFFFF;
            int[] remap = new int[]{5, 0, 4, 1, 3, 2};
            Vector3d[] faceNormals = new Vector3d[]{new Vector3d(0.0, 0.0, 1.0), new Vector3d(1.0, 0.0, 0.0), new Vector3d(0.0, 0.0, -1.0), new Vector3d(-1.0, 0.0, 0.0), new Vector3d(0.0, 1.0, 0.0), new Vector3d(0.0, -1.0, 0.0)};
            List<Mesh> meshes = PhysicsMod.brokenBlocksLittle.get(0);
            bufferbuilder.func_181668_a(4, DefaultVertexFormats.field_227849_i_);
            for (Mesh mesh : meshes) {
                for (org.joml.Vector3i index : mesh.indices) {
                    float minU = 1.0f;
                    float maxU = 0.0f;
                    float minV = 1.0f;
                    float maxV = 0.0f;
                    int sideIndex = -1;
                    org.joml.Vector3d position = mesh.positions.get(index.x - 1);
                    Vector2d uv = mesh.uvs.get(index.y - 1);
                    org.joml.Vector3d normal = mesh.normals.get(index.z - 1);
                    for (int i = 0; i < faceNormals.length; ++i) {
                        if (!(Math.abs(Math.acos(normal.dot(faceNormals[i].field_72450_a, faceNormals[i].field_72448_b, faceNormals[i].field_72449_c))) < 0.01)) continue;
                        sideIndex = i;
                        break;
                    }
                    org.joml.Vector3f color = new org.joml.Vector3f(1.0f);
                    if (sideIndex == -1) {
                        color.set(0.6f, 0.0f, 0.0f);
                        sideIndex = 0;
                    }
                    for (ModelRenderer.PositionTextureVertex vertex : box.field_78254_i[remap[sideIndex]].field_78239_a) {
                        if (vertex.field_78241_b < minU) {
                            minU = vertex.field_78241_b;
                        }
                        if (vertex.field_78242_c < minV) {
                            minV = vertex.field_78242_c;
                        }
                        if (vertex.field_78241_b > maxU) {
                            maxU = vertex.field_78241_b;
                        }
                        if (!(vertex.field_78242_c > maxV)) continue;
                        maxV = vertex.field_78242_c;
                    }
                    bufferbuilder.func_225582_a_(net.diebuddies.engine.util.math.Math.remap(position.x + mesh.offset.x, -0.5, 0.5, (double)box.field_78252_a, (double)box.field_78248_d) / 16.0, net.diebuddies.engine.util.math.Math.remap(position.y + mesh.offset.y, -0.5, 0.5, (double)box.field_78250_b, (double)box.field_78249_e) / 16.0, net.diebuddies.engine.util.math.Math.remap(position.z + mesh.offset.z, -0.5, 0.5, (double)box.field_78251_c, (double)box.field_78246_f) / 16.0).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(net.diebuddies.engine.util.math.Math.remap((float)uv.x, 1.0f, 0.0f, minU, maxU), net.diebuddies.engine.util.math.Math.remap((float)uv.y, 0.0f, 1.0f, minV, maxV)).func_225585_a_(0, 0).func_225587_b_(k, j).func_225584_a_((float)normal.x, (float)normal.y, (float)normal.z).func_181675_d();
                }
            }
            tessellator.func_78381_a();
            RenderSystem.popMatrix();
        }
        stack.func_227865_b_();
    }
}

