/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics;

import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.physics.bullet.collision.btConvexHullShape;
import com.badlogic.gdx.physics.bullet.dynamics.btRigidBody;
import com.badlogic.gdx.physics.bullet.linearmath.btDefaultMotionState;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import net.diebuddies.physics.BlockParticle;
import net.diebuddies.physics.IRigidBody;
import org.joml.Matrix4d;
import org.joml.Quaterniond;
import org.joml.Vector3d;
import org.lwjgl.system.MemoryUtil;

public class ConvexRigidBody
extends IRigidBody {
    private btDefaultMotionState motionState;
    private btRigidBody.btRigidBodyConstructionInfo rbInfo;
    public float width;
    public float height;
    public float depth;
    private FloatBuffer buffer;

    private ConvexRigidBody() {
    }

    public static ConvexRigidBody create(BlockParticle entity, float width, float height, float depth, Matrix4d offset, boolean dynamic) {
        ConvexRigidBody boxRigidBody = new ConvexRigidBody();
        Vector3d scale = entity.getTransformation().getScale(new Vector3d());
        Vector3d translation = entity.getTransformation().getTranslation(new Vector3d());
        boxRigidBody.entity = entity;
        boxRigidBody.offset.set(offset).mulLocal(new Matrix4d().scale(scale.x, scale.y, scale.z));
        boxRigidBody.offset.normalize3x3();
        entity.scalePhysics.set(scale);
        boxRigidBody.shape = new btConvexHullShape();
        for (Vector3d position : entity.mesh.positions) {
            ((btConvexHullShape)boxRigidBody.shape).addPoint(new Vector3((float)position.x * (float)Math.abs(scale.x) * (float)entity.scale, (float)position.y * (float)Math.abs(scale.y) * (float)entity.scale, (float)position.z * (float)Math.abs(scale.z) * (float)entity.scale));
        }
        ((btConvexHullShape)boxRigidBody.shape).setMargin(0.02f);
        Matrix4 transformation = new Matrix4();
        Quaterniond tmpQuat = new Quaterniond();
        entity.getTransformation().getUnnormalizedRotation(tmpQuat).normalize();
        Matrix4 tmp = new Matrix4(boxRigidBody.offset.get(new float[16]));
        transformation.translate((float)translation.x, (float)translation.y, (float)translation.z).rotate(new Quaternion((float)tmpQuat.x, (float)tmpQuat.y, (float)tmpQuat.z, (float)tmpQuat.w)).mul(tmp);
        boxRigidBody.motionState = new btDefaultMotionState(transformation);
        float mass = dynamic ? 1.0f : 0.0f;
        Vector3 fallInertia = new Vector3(0.0f, 0.0f, 0.0f);
        boxRigidBody.shape.calculateLocalInertia(mass, fallInertia);
        boxRigidBody.rbInfo = new btRigidBody.btRigidBodyConstructionInfo(mass, boxRigidBody.motionState, boxRigidBody.shape, fallInertia);
        boxRigidBody.rbInfo.setFriction(1.0f);
        boxRigidBody.rigidBody = new btRigidBody(boxRigidBody.rbInfo);
        boxRigidBody.rigidBody.userData = boxRigidBody;
        if (!dynamic) {
            boxRigidBody.rigidBody.setCollisionFlags(1);
            boxRigidBody.rigidBody.setActivationState(5);
        }
        boxRigidBody.width = width;
        boxRigidBody.height = height;
        boxRigidBody.depth = depth;
        return boxRigidBody;
    }

    public static ConvexRigidBody create(BlockParticle entity, float width, float height, float depth, boolean dynamic) {
        return ConvexRigidBody.create(entity, width, height, depth, new Matrix4d(), dynamic);
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.motionState != null) {
            this.motionState.dispose();
        }
        if (this.rbInfo != null) {
            this.rbInfo.dispose();
        }
        if (this.buffer != null) {
            MemoryUtil.memFree((Buffer)this.buffer);
        }
    }
}

