/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics;

import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.physics.bullet.collision.btBroadphaseInterface;
import com.badlogic.gdx.physics.bullet.collision.btCollisionDispatcher;
import com.badlogic.gdx.physics.bullet.collision.btDbvtBroadphase;
import com.badlogic.gdx.physics.bullet.collision.btDefaultCollisionConfiguration;
import com.badlogic.gdx.physics.bullet.dynamics.btDiscreteDynamicsWorld;
import com.badlogic.gdx.physics.bullet.dynamics.btSequentialImpulseConstraintSolver;

public class DynamicsWorld {
    public static final Vector3 GRAVITY = new Vector3(0.0f, -9.81f, 0.0f);
    public static final Vector3 WATER_GRAVITY = new Vector3(0.0f, 2.0f, 0.0f);
    private btDiscreteDynamicsWorld dynamicsWorld;
    private btBroadphaseInterface broadphase;
    private btDefaultCollisionConfiguration collisionConfiguration;
    private btCollisionDispatcher dispatcher;
    private btSequentialImpulseConstraintSolver solver;
    private float fixedTimeStep;
    private boolean destroyed = false;
    private double time = 0.0;

    public DynamicsWorld(float fixedTimeStep) {
        this.fixedTimeStep = fixedTimeStep;
        this.broadphase = new btDbvtBroadphase();
        this.collisionConfiguration = new btDefaultCollisionConfiguration();
        this.dispatcher = new btCollisionDispatcher(this.collisionConfiguration);
        this.solver = new btSequentialImpulseConstraintSolver();
        this.dynamicsWorld = new btDiscreteDynamicsWorld(this.dispatcher, this.broadphase, this.solver, this.collisionConfiguration);
        this.dynamicsWorld.setGravity(new Vector3(GRAVITY));
        this.dynamicsWorld.setForceUpdateAllAabbs(false);
    }

    public boolean update(double diff) {
        boolean updated = false;
        if (!this.destroyed) {
            this.time += diff;
            while (this.time >= (double)this.fixedTimeStep) {
                this.time -= (double)this.fixedTimeStep;
                this.dynamicsWorld.stepSimulation(this.fixedTimeStep, 1, this.fixedTimeStep);
                updated = true;
            }
        }
        return updated;
    }

    public btDiscreteDynamicsWorld getPhysics() {
        return this.dynamicsWorld;
    }

    public void destroy() {
        if (!this.destroyed) {
            this.dynamicsWorld.dispose();
            this.broadphase.dispose();
            this.collisionConfiguration.dispose();
            this.solver.dispose();
            this.dispatcher.dispose();
        }
        this.destroyed = true;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public double getTime() {
        return this.time;
    }

    public float getFixedTimeStep() {
        return this.fixedTimeStep;
    }
}

