/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics;

import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.physics.bullet.collision.btCollisionShape;
import com.badlogic.gdx.physics.bullet.dynamics.btRigidBody;
import net.diebuddies.physics.PhysicsEntity;
import org.joml.Matrix4d;

public abstract class IRigidBody {
    protected PhysicsEntity entity;
    protected Object userData;
    protected btRigidBody rigidBody;
    protected btCollisionShape shape;
    protected Matrix4d offset;
    protected boolean destroyed = false;
    protected float[] tmpArray = new float[16];
    protected Matrix4 tmpPhysics = new Matrix4();
    protected Matrix4d tmpMatrix = new Matrix4d();

    public IRigidBody() {
        this.offset = new Matrix4d();
    }

    public void destroy() {
        if (this.rigidBody != null) {
            this.rigidBody.dispose();
        }
        if (this.shape != null) {
            this.shape.dispose();
        }
        this.destroyed = true;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public PhysicsEntity getEntity() {
        return this.entity;
    }

    public Matrix4d getOffset() {
        return this.offset;
    }

    public Object getUserData() {
        return this.userData;
    }

    public btCollisionShape getShape() {
        return this.shape;
    }

    public btRigidBody getRigidBody() {
        return this.rigidBody;
    }

    public void updatePositions(double diff) {
        this.entity.getOldTransformation().set(this.entity.getTransformation());
        btRigidBody rigidBody = this.getRigidBody();
        rigidBody.getWorldTransform(this.tmpPhysics);
        System.arraycopy(this.tmpPhysics.getValues(), 0, this.tmpArray, 0, 16);
        this.tmpMatrix.set(this.tmpArray);
        this.entity.getTransformation().set(this.tmpMatrix);
    }
}

