/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics;

import com.badlogic.gdx.physics.bullet.Bullet;
import com.badlogic.gdx.utils.GdxNativesLoader;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.diebuddies.config.Config;
import net.diebuddies.physics.BlockParticle;
import net.diebuddies.physics.Explosion;
import net.diebuddies.physics.Mesh;
import net.diebuddies.physics.PhysicsWorld;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.model.AgeableModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.SegmentedModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.joml.Matrix4d;
import org.joml.Vector2d;
import org.joml.Vector3i;
import org.joml.Vector4f;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class PhysicsMod {
    public static PhysicsMod instance;
    public Map<IWorld, PhysicsWorld> physicWorlds = new HashMap<IWorld, PhysicsWorld>();
    private boolean init = false;
    public ConcurrentLinkedQueue<BlockParticle> queue = new ConcurrentLinkedQueue();
    public ConcurrentLinkedQueue<BlockParticle> entityBlocks = new ConcurrentLinkedQueue();
    public ConcurrentLinkedQueue<BlockPos> blockUpdates = new ConcurrentLinkedQueue();
    public ConcurrentLinkedQueue<Explosion> explosions = new ConcurrentLinkedQueue();
    public Set<Integer> alreadyBlockified = new HashSet<Integer>();
    private Map<PlayerEntity, Float> players = new HashMap<PlayerEntity, Float>();
    private long time;
    public Config.Client clientConfig;
    public static final List<List<Mesh>> brokenBlocksLittle;
    public static final List<List<Mesh>> brokenBlocksLots;
    public static final List<Mesh> brokenBlock;
    private static final Method applyRotations;
    private static final Method preRenderCallback;
    private static final Method getHeadParts;
    private static final Method getBodyParts;

    private static List<Mesh> readBlock(String asset) {
        ArrayList<Mesh> meshes = new ArrayList<Mesh>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(PhysicsMod.class.getClassLoader().getResourceAsStream(asset)));){
            String line = "";
            Mesh mesh = null;
            int ov = 0;
            int ot = 0;
            int on = 0;
            while ((line = reader.readLine()) != null) {
                String[] data;
                if (line.startsWith("o")) {
                    if (mesh != null) {
                        mesh.calculateOffset();
                        meshes.add(mesh);
                        ov += mesh.positions.size();
                        ot += mesh.uvs.size();
                        on += mesh.normals.size();
                    }
                    mesh = new Mesh();
                    continue;
                }
                if (line.startsWith("vt")) {
                    data = line.split(" ");
                    mesh.uvs.add(new Vector2d(Double.parseDouble(data[1]), Double.parseDouble(data[2])));
                    continue;
                }
                if (line.startsWith("vn")) {
                    data = line.split(" ");
                    mesh.normals.add(new org.joml.Vector3d(Double.parseDouble(data[1]), Double.parseDouble(data[2]), Double.parseDouble(data[3])));
                    continue;
                }
                if (line.startsWith("v")) {
                    data = line.split(" ");
                    mesh.positions.add(new org.joml.Vector3d(Double.parseDouble(data[1]), Double.parseDouble(data[2]), Double.parseDouble(data[3])));
                    continue;
                }
                if (!line.startsWith("f")) continue;
                data = line.split(" ");
                for (int i = 1; i < data.length; ++i) {
                    String[] idata = data[i].split("/");
                    mesh.indices.add(new Vector3i(Integer.parseInt(idata[0]) - ov, Integer.parseInt(idata[1]) - ot, Integer.parseInt(idata[2]) - on));
                }
            }
            if (mesh != null) {
                mesh.calculateOffset();
                meshes.add(mesh);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return meshes;
    }

    public static PhysicsMod getInstance() {
        return instance;
    }

    public PhysicsMod() {
        instance = this;
        this.clientConfig = Config.CLIENT;
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        long currentTime;
        if (!this.init) {
            GdxNativesLoader.load();
            Bullet.init();
            this.init = true;
        }
        if ((double)((currentTime = System.nanoTime()) - this.time) / 1000000.0 > 2000.0) {
            this.time = currentTime;
        }
        if (event.side == LogicalSide.CLIENT) {
            PhysicsWorld physics;
            ClientWorld world;
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            double diff = (double)(currentTime - this.time) / 1.0E9;
            if (player != null && (world = player.field_213837_d) != null && (physics = this.physicWorlds.get(world)) != null) {
                physics.update(diff);
            }
        }
        this.time = currentTime;
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        if (RenderSystem.isOnRenderThread() && event.getEntity().func_213303_ch().func_72438_d(Minecraft.func_71410_x().field_71439_g.func_213303_ch()) < (double)this.clientConfig.physicsRange) {
            try {
                PhysicsMod.blockifyEntity((IWorld)event.getEntityLiving().func_130014_f_(), event.getEntity());
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void onPlayerDeath(TickEvent.RenderTickEvent event) {
        if (Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71439_g.field_213837_d != null) {
            Vector3d pos = Minecraft.func_71410_x().field_71439_g.func_213303_ch();
            for (PlayerEntity player : Minecraft.func_71410_x().field_71439_g.field_213837_d.func_217357_a(PlayerEntity.class, new AxisAlignedBB(pos.field_72450_a - (double)this.clientConfig.physicsRange, pos.field_72448_b - (double)this.clientConfig.physicsRange, pos.field_72449_c - (double)this.clientConfig.physicsRange, pos.field_72450_a + (double)this.clientConfig.physicsRange, pos.field_72448_b + (double)this.clientConfig.physicsRange, pos.field_72449_c + (double)this.clientConfig.physicsRange))) {
                Float health = this.players.get(player);
                if (health != null && health.floatValue() > 0.0f && player.func_110143_aJ() <= 0.0f && PhysicsMod.getInstance().clientConfig.mobPhysics) {
                    try {
                        PhysicsMod.blockifyEntity((IWorld)player.func_130014_f_(), (Entity)player);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
                this.players.put(player, Float.valueOf(player.func_110143_aJ()));
            }
        }
    }

    public static void blockifyEntity(IWorld world, Entity entity) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (!PhysicsMod.getInstance().clientConfig.mobPhysics) {
            return;
        }
        if (PhysicsMod.getInstance().alreadyBlockified.contains(entity.func_145782_y()) && !(entity instanceof PlayerEntity)) {
            return;
        }
        if (entity instanceof LivingEntity && ((LivingEntity)entity).func_82150_aj()) {
            return;
        }
        PhysicsMod.getInstance().alreadyBlockified.add(entity.func_145782_y());
        EntityRenderer entityRenderer = Minecraft.func_71410_x().func_175598_ae().func_78713_a(entity);
        MatrixStack stack = new MatrixStack();
        if (entityRenderer instanceof LivingRenderer) {
            LivingRenderer renderer = (LivingRenderer)entityRenderer;
            EntityModel model = renderer.func_217764_d();
            Vector3d entPos = entity.func_213303_ch();
            stack.func_227860_a_();
            PhysicsMod.applyTranslationRotation(stack, (LivingEntity)entity, renderer);
            if (model instanceof SegmentedModel) {
                if (entity instanceof LivingEntity) {
                    ((LivingEntity)entity).func_70106_y();
                }
                SegmentedModel segmentedModel = (SegmentedModel)model;
                for (Object part : segmentedModel.func_225601_a_()) {
                    if (!(part instanceof ModelRenderer)) continue;
                    ModelRenderer modelRenderer = (ModelRenderer)part;
                    PhysicsMod.addBox(stack, new MatrixStack(), world, entPos, modelRenderer, (LivingEntity)entity, renderer);
                }
            } else if (model instanceof AgeableModel) {
                ModelRenderer modelRenderer;
                if (entity instanceof LivingEntity) {
                    ((LivingEntity)entity).func_70106_y();
                }
                AgeableModel ageableModel = (AgeableModel)model;
                MatrixStack local = new MatrixStack();
                if (ageableModel.field_217114_e) {
                    local.func_227860_a_();
                    if (ageableModel.field_228221_a_) {
                        float headScale = 1.5f / ageableModel.field_228224_g_;
                        local.func_227862_a_(headScale, headScale, headScale);
                    }
                    local.func_227861_a_(0.0, (double)(ageableModel.field_228222_b_ / 16.0f), (double)(ageableModel.field_228223_f_ / 16.0f));
                }
                for (Object part : (Iterable)getHeadParts.invoke((Object)ageableModel, new Object[0])) {
                    if (!(part instanceof ModelRenderer)) continue;
                    modelRenderer = (ModelRenderer)part;
                    PhysicsMod.addBox(stack, local, world, entPos, modelRenderer, (LivingEntity)entity, renderer);
                }
                if (ageableModel.field_217114_e) {
                    local.func_227865_b_();
                    local.func_227860_a_();
                    float bodyScale = 1.0f / ageableModel.field_228225_h_;
                    local.func_227862_a_(bodyScale, bodyScale, bodyScale);
                    local.func_227861_a_(0.0, (double)(ageableModel.field_228226_i_ / 16.0f), 0.0);
                }
                for (Object part : (Iterable)getBodyParts.invoke((Object)ageableModel, new Object[0])) {
                    if (!(part instanceof ModelRenderer)) continue;
                    modelRenderer = (ModelRenderer)part;
                    PhysicsMod.addBox(stack, local, world, entPos, modelRenderer, (LivingEntity)entity, renderer);
                }
                if (ageableModel.field_217114_e) {
                    local.func_227865_b_();
                }
            }
            stack.func_227865_b_();
        }
    }

    private static void addBox(MatrixStack stack, MatrixStack local, IWorld world, Vector3d pos, ModelRenderer modelRenderer, LivingEntity entity, LivingRenderer renderer) {
        local.func_227860_a_();
        stack.func_227860_a_();
        local.func_227861_a_((double)(modelRenderer.field_78800_c / 16.0f), (double)(modelRenderer.field_78797_d / 16.0f), (double)(modelRenderer.field_78798_e / 16.0f));
        if (modelRenderer.field_78808_h != 0.0f) {
            local.func_227863_a_(Vector3f.field_229183_f_.func_229193_c_(modelRenderer.field_78808_h));
        }
        if (modelRenderer.field_78796_g != 0.0f) {
            local.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(modelRenderer.field_78796_g));
        }
        if (modelRenderer.field_78795_f != 0.0f) {
            local.func_227863_a_(Vector3f.field_229179_b_.func_229193_c_(modelRenderer.field_78795_f));
        }
        for (ModelRenderer model : modelRenderer.field_78805_m) {
            PhysicsMod.addBox(stack, local, world, pos, model, entity, renderer);
        }
        Matrix4f m = stack.func_227866_c_().func_227870_a_();
        Matrix4f localM = local.func_227866_c_().func_227870_a_();
        Matrix3f localNM = local.func_227866_c_().func_227872_b_();
        FloatBuffer fb = FloatBuffer.wrap(new float[16]);
        m.func_195879_b(fb);
        Matrix4d transformation = new Matrix4d();
        transformation.set(fb.array());
        Vector4f[] minMax = new Vector4f[6];
        RenderState.TextureState textureState = new RenderState.TextureState(renderer.func_110775_a((Entity)entity), false, false);
        Vector3f tmpNormal = new Vector3f();
        net.minecraft.util.math.vector.Vector4f tmpPos = new net.minecraft.util.math.vector.Vector4f();
        for (int i = 0; i < minMax.length; ++i) {
            minMax[i] = new Vector4f();
        }
        for (ModelRenderer.ModelBox box : modelRenderer.field_78804_l) {
            int[] remap = new int[]{5, 0, 4, 1, 3, 2};
            float volume = Math.abs(box.field_78248_d - box.field_78252_a) / 16.0f * (Math.abs(box.field_78249_e - box.field_78250_b) / 16.0f) * (Math.abs(box.field_78246_f - box.field_78251_c) / 16.0f);
            if ((double)volume <= 1.0E-4) continue;
            List<Mesh> meshes = brokenBlocksLittle.get((int)(Math.random() * (double)brokenBlocksLittle.size()));
            if ((double)volume <= 0.04 || PhysicsMod.getInstance().clientConfig.mobBlockyPhysics) {
                meshes = brokenBlock;
            }
            for (int i = 0; i < box.field_78254_i.length; ++i) {
                float minU = 1.0f;
                float maxU = 0.0f;
                float minV = 1.0f;
                float maxV = 0.0f;
                for (ModelRenderer.PositionTextureVertex vertex : box.field_78254_i[i].field_78239_a) {
                    if (vertex.field_78241_b < minU) {
                        minU = vertex.field_78241_b;
                    }
                    if (vertex.field_78242_c < minV) {
                        minV = vertex.field_78242_c;
                    }
                    if (vertex.field_78241_b > maxU) {
                        maxU = vertex.field_78241_b;
                    }
                    if (!(vertex.field_78242_c > maxV)) continue;
                    maxV = vertex.field_78242_c;
                }
                minMax[i].set(minU, maxU, minV, maxV);
            }
            for (Mesh mesh : meshes) {
                Mesh clone;
                BlockParticle particle = new BlockParticle();
                particle.textureState = textureState;
                particle.mesh = clone = new Mesh();
                particle.setTransformation(new Matrix4d(transformation));
                particle.setOldTransformation(new Matrix4d(particle.getTransformation()));
                int count = 1;
                org.joml.Vector3d offset = new org.joml.Vector3d();
                for (Vector3i index : mesh.indices) {
                    int sideIndex = mesh.sides.get(index.z - 1);
                    org.joml.Vector3d position = mesh.positions.get(index.x - 1);
                    Vector2d uv = mesh.uvs.get(index.y - 1);
                    org.joml.Vector3d normal = mesh.normals.get(index.z - 1);
                    org.joml.Vector3f color = new org.joml.Vector3f(1.0f);
                    if (sideIndex == -1) {
                        if (PhysicsMod.getInstance().clientConfig.bloodPhysics && !PhysicsMod.getInstance().clientConfig.mobBlockyPhysics) {
                            color.set(0.6f, 0.0f, 0.0f);
                        }
                        sideIndex = 0;
                    }
                    tmpNormal.func_195905_a((float)normal.x, (float)normal.y, (float)normal.z);
                    tmpNormal.func_229188_a_(localNM);
                    Vector4f minMaxUVs = minMax[remap[sideIndex]];
                    tmpPos.func_195911_a((float)net.diebuddies.engine.util.math.Math.remap(position.x + mesh.offset.x, -0.5, 0.5, (double)box.field_78252_a, (double)box.field_78248_d) / 16.0f, (float)net.diebuddies.engine.util.math.Math.remap(position.y + mesh.offset.y, -0.5, 0.5, (double)box.field_78250_b, (double)box.field_78249_e) / 16.0f, (float)net.diebuddies.engine.util.math.Math.remap(position.z + mesh.offset.z, -0.5, 0.5, (double)box.field_78251_c, (double)box.field_78246_f) / 16.0f, 1.0f);
                    tmpPos.func_229372_a_(localM);
                    clone.indices.add(new Vector3i(count, count, count));
                    offset.add(tmpPos.func_195910_a(), tmpPos.func_195913_b(), tmpPos.func_195914_c());
                    ++count;
                    org.joml.Vector3d posR = new org.joml.Vector3d(tmpPos.func_195910_a(), tmpPos.func_195913_b(), tmpPos.func_195914_c());
                    clone.positions.add(posR);
                    clone.uvs.add(new Vector2d(net.diebuddies.engine.util.math.Math.remap((float)uv.x, 1.0f, 0.0f, minMaxUVs.x, minMaxUVs.y), net.diebuddies.engine.util.math.Math.remap((float)uv.y, 0.0f, 1.0f, minMaxUVs.z, minMaxUVs.w)));
                    clone.normals.add(new org.joml.Vector3d(tmpNormal.func_195899_a(), tmpNormal.func_195900_b(), tmpNormal.func_195902_c()));
                    clone.colors.add(color);
                }
                offset.div(clone.positions.size());
                for (org.joml.Vector3d position : clone.positions) {
                    position.sub(offset);
                }
                clone.offset = offset;
                PhysicsMod.getInstance().entityBlocks.add(particle);
            }
        }
        local.func_227865_b_();
        stack.func_227865_b_();
    }

    private static void applyTranslationRotation(MatrixStack stack, LivingEntity entityIn, LivingRenderer renderer) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Direction direction;
        boolean shouldSit;
        float partialTicks = Minecraft.func_71410_x().func_184121_ak();
        double px = MathHelper.func_219803_d((double)partialTicks, (double)entityIn.field_70169_q, (double)entityIn.func_226277_ct_());
        double py = MathHelper.func_219803_d((double)partialTicks, (double)entityIn.field_70167_r, (double)entityIn.func_226278_cu_());
        double pz = MathHelper.func_219803_d((double)partialTicks, (double)entityIn.field_70166_s, (double)entityIn.func_226281_cx_());
        stack.func_227861_a_(px, py, pz);
        renderer.func_217764_d().field_217112_c = entityIn.func_70678_g(partialTicks);
        renderer.func_217764_d().field_217113_d = shouldSit = entityIn.func_184218_aH() && entityIn.func_184187_bx() != null && entityIn.func_184187_bx().shouldRiderSit();
        renderer.func_217764_d().field_217114_e = entityIn.func_70631_g_();
        float f = MathHelper.func_219805_h((float)partialTicks, (float)entityIn.field_70760_ar, (float)entityIn.field_70761_aq);
        float f1 = MathHelper.func_219805_h((float)partialTicks, (float)entityIn.field_70758_at, (float)entityIn.field_70759_as);
        float f2 = f1 - f;
        if (shouldSit && entityIn.func_184187_bx() instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entityIn.func_184187_bx();
            f = MathHelper.func_219805_h((float)partialTicks, (float)livingentity.field_70760_ar, (float)livingentity.field_70761_aq);
            f2 = f1 - f;
            float f3 = MathHelper.func_76142_g((float)f2);
            if (f3 < -85.0f) {
                f3 = -85.0f;
            }
            if (f3 >= 85.0f) {
                f3 = 85.0f;
            }
            f = f1 - f3;
            if (f3 * f3 > 2500.0f) {
                f += f3 * 0.2f;
            }
            f2 = f1 - f;
        }
        float f6 = MathHelper.func_219799_g((float)partialTicks, (float)entityIn.field_70127_C, (float)entityIn.field_70125_A);
        if (entityIn.func_213283_Z() == Pose.SLEEPING && (direction = entityIn.func_213376_dz()) != null) {
            float f4 = entityIn.func_213307_e(Pose.STANDING) - 0.1f;
            stack.func_227861_a_((double)((float)(-direction.func_82601_c()) * f4), 0.0, (double)((float)(-direction.func_82599_e()) * f4));
        }
        float f7 = (float)entityIn.field_70173_aa + partialTicks;
        applyRotations.invoke((Object)renderer, entityIn, stack, Float.valueOf(f7), Float.valueOf(f), Float.valueOf(partialTicks));
        stack.func_227862_a_(-1.0f, -1.0f, 1.0f);
        preRenderCallback.invoke((Object)renderer, entityIn, stack, Float.valueOf(partialTicks));
        stack.func_227861_a_(0.0, (double)-1.501f, 0.0);
        float f8 = 0.0f;
        float f5 = 0.0f;
        if (!shouldSit && entityIn.func_70089_S()) {
            f8 = MathHelper.func_219799_g((float)partialTicks, (float)entityIn.field_184618_aE, (float)entityIn.field_70721_aZ);
            f5 = entityIn.field_184619_aG - entityIn.field_70721_aZ * (1.0f - partialTicks);
            if (entityIn.func_70631_g_()) {
                f5 *= 3.0f;
            }
            if (f8 > 1.0f) {
                f8 = 1.0f;
            }
        }
        renderer.func_217764_d().func_212843_a_((Entity)entityIn, f5, f8, partialTicks);
        renderer.func_217764_d().func_225597_a_((Entity)entityIn, f5, f8, f7, f2, f6);
    }

    static {
        brokenBlocksLittle = new ArrayList<List<Mesh>>();
        brokenBlocksLots = new ArrayList<List<Mesh>>();
        brokenBlocksLittle.add(PhysicsMod.readBlock("assets/physics_shattered_little_1.obj"));
        brokenBlocksLittle.add(PhysicsMod.readBlock("assets/physics_shattered_little_2.obj"));
        brokenBlocksLittle.add(PhysicsMod.readBlock("assets/physics_shattered_little_3.obj"));
        brokenBlocksLots.add(PhysicsMod.readBlock("assets/physics_shattered_lots_2.obj"));
        brokenBlocksLots.add(PhysicsMod.readBlock("assets/physics_shattered_lots_3.obj"));
        brokenBlocksLots.add(PhysicsMod.readBlock("assets/physics_shattered_lots_4.obj"));
        brokenBlocksLots.add(PhysicsMod.readBlock("assets/physics_shattered_lots_5.obj"));
        brokenBlocksLots.add(PhysicsMod.readBlock("assets/physics_shattered_lots_6.obj"));
        brokenBlocksLots.add(PhysicsMod.readBlock("assets/physics_shattered_lots_7.obj"));
        brokenBlocksLots.add(PhysicsMod.readBlock("assets/physics_shattered_lots_8.obj"));
        brokenBlocksLots.add(PhysicsMod.readBlock("assets/physics_shattered_lots_9.obj"));
        brokenBlocksLots.add(PhysicsMod.readBlock("assets/physics_shattered_lots_10.obj"));
        brokenBlocksLots.add(PhysicsMod.readBlock("assets/physics_shattered_lots_11.obj"));
        brokenBlocksLots.add(PhysicsMod.readBlock("assets/physics_shattered_lots_12.obj"));
        brokenBlocksLots.add(PhysicsMod.readBlock("assets/physics_shattered_lots_13.obj"));
        brokenBlock = PhysicsMod.readBlock("assets/physics_simple.obj");
        applyRotations = ObfuscationReflectionHelper.findMethod(LivingRenderer.class, (String)"func_225621_a_", (Class[])new Class[]{LivingEntity.class, MatrixStack.class, Float.TYPE, Float.TYPE, Float.TYPE});
        preRenderCallback = ObfuscationReflectionHelper.findMethod(LivingRenderer.class, (String)"func_225620_a_", (Class[])new Class[]{LivingEntity.class, MatrixStack.class, Float.TYPE});
        getHeadParts = ObfuscationReflectionHelper.findMethod(AgeableModel.class, (String)"func_225602_a_", (Class[])new Class[0]);
        getBodyParts = ObfuscationReflectionHelper.findMethod(AgeableModel.class, (String)"func_225600_b_", (Class[])new Class[0]);
    }
}

