/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.diebuddies.config.Config;
import net.minecraft.client.AbstractOption;
import net.minecraft.client.GameSettings;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.SettingsScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.OptionsRowList;
import net.minecraft.client.settings.BooleanOption;
import net.minecraft.client.settings.SliderPercentageOption;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class PhysicsSettingsScreen
extends SettingsScreen {
    private static final BooleanOption PHYSICS_MOB = new BooleanOption("Mob Physics", gameOptions -> Config.CLIENT.mobPhysics, (gameOptions, value) -> {
        Config.CLIENT.mobPhysics = value;
        Config.CLIENT.save();
    });
    private static final BooleanOption MOB_BLOCKY_PHYSICS = new BooleanOption("Mob Fracturing", gameOptions -> !Config.CLIENT.mobBlockyPhysics, (gameOptions, value) -> {
        Config.CLIENT.mobBlockyPhysics = value == false;
        Config.CLIENT.save();
    });
    private static final BooleanOption MOB_BLOOD = new BooleanOption("Mob Blood", gameOptions -> Config.CLIENT.bloodPhysics, (gameOptions, value) -> {
        Config.CLIENT.bloodPhysics = value;
        Config.CLIENT.save();
    });
    private static final BooleanOption PHYSICS_BLOCK = new BooleanOption("Block Physics", gameOptions -> Config.CLIENT.blockPhysics, (gameOptions, value) -> {
        Config.CLIENT.blockPhysics = value;
        Config.CLIENT.save();
    });
    private static final SliderPercentageOption PHYSICS_RADIUS = new SliderPercentageOption("Physics Range", 10.0, 250.0, 1.0f, gameOptions -> Config.CLIENT.physicsRange, (gameOptions, value) -> {
        Config.CLIENT.physicsRange = value.intValue();
        Config.CLIENT.save();
    }, (gameOptions, option) -> {
        double d = option.func_216729_a(gameOptions);
        return new StringTextComponent("Physics Range: " + (int)d);
    });
    private static final SliderPercentageOption PHYSICS_PARTICLE_LIFETIME = new SliderPercentageOption("Physics Lifetime", 0.1, 100.0, 0.1f, gameOptions -> Config.CLIENT.particleLifetime, (gameOptions, value) -> {
        Config.CLIENT.particleLifetime = value;
        Config.CLIENT.save();
    }, (gameOptions, option) -> new StringTextComponent("Physics Lifetime: " + String.format("%.2f", option.func_216729_a(gameOptions))));
    private static final SliderPercentageOption PHYSICS_MAX_OBJECTS = new SliderPercentageOption("Physics Max Objects", 10.0, 3000.0, 1.0f, gameOptions -> Config.CLIENT.maxPhysicsObjects, (gameOptions, value) -> {
        Config.CLIENT.maxPhysicsObjects = value.intValue();
        Config.CLIENT.save();
    }, (gameOptions, option) -> new StringTextComponent("Physics Max Objects: " + (int)option.func_216729_a(gameOptions)));
    private static final SliderPercentageOption PHYSICS_BLOCK_SCALE = new SliderPercentageOption("Physics Objects Scale", 0.05, 4.0, 0.01f, gameOptions -> Config.CLIENT.blockPhysicsScale, (gameOptions, value) -> {
        Config.CLIENT.blockPhysicsScale = value;
        Config.CLIENT.save();
    }, (gameOptions, option) -> new StringTextComponent("Physics Objects Scale: " + String.format("%.2f", option.func_216729_a(gameOptions))));
    private static final BooleanOption SERVER_COLLAPSE = new BooleanOption("Collapse Blocks", gameOptions -> Config.CLIENT_SERVER.collapse, (gameOptions, value) -> {
        Config.CLIENT_SERVER.collapse = value;
        Config.CLIENT_SERVER.save();
    });
    private static final BooleanOption SERVER_DROP_BLOCKS = new BooleanOption("Drop Blocks", gameOptions -> Config.CLIENT_SERVER.dropBlocks, (gameOptions, value) -> {
        Config.CLIENT_SERVER.dropBlocks = value;
        Config.CLIENT_SERVER.save();
    });
    private static final SliderPercentageOption SERVER_COLLAPSE_SPEED = new SliderPercentageOption("Collapse Speed", 0.0, 500.0, 1.0f, gameOptions -> Config.CLIENT_SERVER.collapseSpeed, (gameOptions, value) -> {
        Config.CLIENT_SERVER.collapseSpeed = value.intValue();
        Config.CLIENT_SERVER.save();
    }, (gameOptions, option) -> new StringTextComponent("Collapse Speed (Ticks): " + (int)option.func_216729_a(gameOptions)));
    private static final SliderPercentageOption SERVER_COLLAPSE_LIMIT = new SliderPercentageOption("Collapse Limit", 1.0, 5000.0, 1.0f, gameOptions -> Config.CLIENT_SERVER.maxCollapseObjects, (gameOptions, value) -> {
        Config.CLIENT_SERVER.maxCollapseObjects = value.intValue();
        Config.CLIENT_SERVER.save();
    }, (gameOptions, option) -> new StringTextComponent("Collapse Limit (Blocks): " + (int)option.func_216729_a(gameOptions)));
    private OptionsRowList list;

    public PhysicsSettingsScreen(Screen parent, GameSettings options) {
        super(parent, options, (ITextComponent)new StringTextComponent("Physics Settings"));
    }

    protected void func_231160_c_() {
        this.list = new OptionsRowList(this.field_230706_i_, this.field_230708_k_, this.field_230709_l_, 32, this.field_230709_l_ - 32, 25);
        this.list.func_214334_a((AbstractOption)PHYSICS_MOB, (AbstractOption)MOB_BLOCKY_PHYSICS);
        this.list.func_214334_a((AbstractOption)MOB_BLOOD, (AbstractOption)PHYSICS_BLOCK);
        this.list.func_214334_a((AbstractOption)PHYSICS_RADIUS, (AbstractOption)PHYSICS_MAX_OBJECTS);
        this.list.func_214334_a((AbstractOption)PHYSICS_PARTICLE_LIFETIME, (AbstractOption)PHYSICS_BLOCK_SCALE);
        this.list.func_214334_a((AbstractOption)SERVER_COLLAPSE, (AbstractOption)SERVER_DROP_BLOCKS);
        this.list.func_214334_a((AbstractOption)SERVER_COLLAPSE_SPEED, (AbstractOption)SERVER_COLLAPSE_LIMIT);
        this.field_230705_e_.add(this.list);
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 100, this.field_230709_l_ - 27, 200, 20, DialogTexts.field_240632_c_, button -> this.field_230706_i_.func_147108_a(this.field_228182_a_)));
    }

    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        this.func_230446_a_(matrices);
        this.list.func_230430_a_(matrices, mouseX, mouseY, delta);
        PhysicsSettingsScreen.func_238472_a_((MatrixStack)matrices, (FontRenderer)this.field_230712_o_, (ITextComponent)this.field_230704_d_, (int)(this.field_230708_k_ / 2), (int)5, (int)0xFFFFFF);
        super.func_230430_a_(matrices, mouseX, mouseY, delta);
        List list = PhysicsSettingsScreen.func_243293_a((OptionsRowList)this.list, (int)mouseX, (int)mouseY);
        if (list != null) {
            this.func_238654_b_(matrices, list, mouseX, mouseY);
        }
    }
}

