/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.diebuddies.config.Config;
import net.diebuddies.physics.FallingBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Vector3i;

@Mod.EventBusSubscriber(value={Dist.DEDICATED_SERVER})
public class ServerPhysicsMod {
    private List<FallingBlocks> fallingBlocks;
    private Config.Server serverConfig;

    public ServerPhysicsMod(boolean isClient) {
        this.serverConfig = isClient ? Config.CLIENT_SERVER : Config.SERVER;
        this.fallingBlocks = new ArrayList<FallingBlocks>();
    }

    private boolean canFall(IWorld world, BlockPos pos, BlockState b) {
        if (b.func_177230_c() != Blocks.field_150343_Z && b.func_177230_c() != Blocks.field_150357_h && b.func_177230_c() != Blocks.field_150427_aO && b.func_177230_c() != Blocks.field_150384_bq && b.func_177230_c() != Blocks.field_150378_br && !b.func_196958_f() && b.func_177230_c() != Blocks.field_150355_j && b.func_177230_c() != Blocks.field_150353_l) {
            BlockState toCheck = world.func_180495_p(pos.func_177977_b());
            Block block = toCheck.func_177230_c();
            if (toCheck.func_196958_f() || block == Blocks.field_150355_j || block == Blocks.field_150353_l || block == Blocks.field_196553_aF) {
                return true;
            }
        }
        return false;
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent e) {
        if (!this.serverConfig.collapse) {
            return;
        }
        if (!e.isCanceled()) {
            BlockPos pos = e.getPos();
            this.checkAdjacentBlocks(new HashSet<Vector3i>(), new HashSet<Vector3i>(), (World)e.getWorld(), e.getPlayer(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        Iterator<FallingBlocks> it = this.fallingBlocks.iterator();
        while (it.hasNext()) {
            FallingBlocks falling = it.next();
            if (this.serverConfig.collapseSpeed == 0 || falling.ticks % this.serverConfig.collapseSpeed == 0) {
                Vector3i tmp = new Vector3i();
                boolean end = false;
                do {
                    HashSet<Vector3i> toCheck = new HashSet<Vector3i>();
                    for (Vector3i check : falling.toCheck) {
                        for (int y = -1; y <= 1; ++y) {
                            for (int x = -1; x <= 1; ++x) {
                                for (int z = -1; z <= 1; ++z) {
                                    if (x == 0 && y == 0 && z == 0) continue;
                                    tmp.set(check.x + x, check.y + y, check.z + z);
                                    if (falling.alreadyChecked.contains(tmp)) continue;
                                    BlockPos blockPos = new BlockPos(check.x + x, check.y + y, check.z + z);
                                    BlockState b = falling.world.func_180495_p(blockPos);
                                    falling.alreadyChecked.add(new Vector3i(tmp));
                                    if (!this.canFall((IWorld)falling.world, blockPos, b)) continue;
                                    if (this.serverConfig.dropBlocks) {
                                        BlockState state = falling.world.func_180495_p(blockPos);
                                        TileEntity te = falling.world.func_175625_s(blockPos);
                                        state.func_177230_c().func_180657_a(falling.world, falling.player, blockPos, state, te, falling.player.func_184607_cu());
                                    }
                                    falling.world.func_175656_a(blockPos, Blocks.field_150350_a.func_176223_P());
                                    falling.fallen.add(new Vector3i(tmp));
                                    toCheck.add(new Vector3i(tmp));
                                }
                            }
                        }
                        if (falling.fallen.size() <= this.serverConfig.maxCollapseObjects) continue;
                        end = true;
                        it.remove();
                        break;
                    }
                    falling.toCheck = toCheck;
                    if (falling.toCheck.size() != 0) continue;
                    end = true;
                    it.remove();
                } while (this.serverConfig.collapseSpeed == 0 && !end);
            }
            ++falling.ticks;
        }
    }

    private void checkAdjacentBlocks(Set<Vector3i> alreadyChecked, Set<Vector3i> fallen, World world, PlayerEntity player, int bx, int by, int bz) {
        FallingBlocks falling = new FallingBlocks(world, player);
        falling.toCheck.add(new Vector3i(bx, by, bz));
        this.fallingBlocks.add(falling);
    }
}

