/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 3.0.11
 *
 * This file is not intended to be easily readable and contains a number of
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG
 * interface file instead.
 * ----------------------------------------------------------------------------- */


#ifndef SWIGJAVA
#define SWIGJAVA
#endif

#define SWIG_DIRECTORS


#ifdef __cplusplus
/* SwigValueWrapper is described in swig.swg */
template<typename T> class SwigValueWrapper {
  struct SwigMovePointer {
    T *ptr;
    SwigMovePointer(T *p) : ptr(p) { }
    ~SwigMovePointer() { delete ptr; }
    SwigMovePointer& operator=(SwigMovePointer& rhs) { T* oldptr = ptr; ptr = 0; delete oldptr; ptr = rhs.ptr; rhs.ptr = 0; return *this; }
  } pointer;
  SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
  SwigValueWrapper(const SwigValueWrapper<T>& rhs);
public:
  SwigValueWrapper() : pointer(0) { }
  SwigValueWrapper& operator=(const T& t) { SwigMovePointer tmp(new T(t)); pointer = tmp; return *this; }
  operator T&() const { return *pointer.ptr; }
  T *operator&() { return pointer.ptr; }
};

template <typename T> T SwigValueInit() {
  return T();
}
#endif

/* -----------------------------------------------------------------------------
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 * ----------------------------------------------------------------------------- */

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
# if defined(__SUNPRO_CC) && (__SUNPRO_CC <= 0x560)
#  define SWIGTEMPLATEDISAMBIGUATOR template
# elif defined(__HP_aCC)
/* Needed even with `aCC -AA' when `aCC -V' reports HP ANSI C++ B3910B A.03.55 */
/* If we find a maximum version that requires this, the test would be __HP_aCC <= 35500 for A.03.55 */
#  define SWIGTEMPLATEDISAMBIGUATOR template
# else
#  define SWIGTEMPLATEDISAMBIGUATOR
# endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__)
#   if !(defined(__cplusplus)) || (__GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4))
#     define SWIGUNUSED __attribute__ ((__unused__))
#   else
#     define SWIGUNUSED
#   endif
# elif defined(__ICC)
#   define SWIGUNUSED __attribute__ ((__unused__))
# else
#   define SWIGUNUSED
# endif
#endif

#ifndef SWIG_MSC_UNSUPPRESS_4505
# if defined(_MSC_VER)
#   pragma warning(disable : 4505) /* unreferenced local function has been removed */
# endif
#endif

#ifndef SWIGUNUSEDPARM
# ifdef __cplusplus
#   define SWIGUNUSEDPARM(p)
# else
#   define SWIGUNUSEDPARM(p) p SWIGUNUSED
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods */
#if defined(__GNUC__)
#  if (__GNUC__ >= 4) || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4)
#    ifndef GCC_HASCLASSVISIBILITY
#      define GCC_HASCLASSVISIBILITY
#    endif
#  endif
#endif

#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   if defined(__GNUC__) && defined(GCC_HASCLASSVISIBILITY)
#     define SWIGEXPORT __attribute__ ((visibility("default")))
#   else
#     define SWIGEXPORT
#   endif
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif
#endif

/* Deal with Microsoft's attempt at deprecating C standard runtime functions */
#if !defined(SWIG_NO_CRT_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_CRT_SECURE_NO_DEPRECATE)
# define _CRT_SECURE_NO_DEPRECATE
#endif

/* Deal with Microsoft's attempt at deprecating methods in the standard C++ library */
#if !defined(SWIG_NO_SCL_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_SCL_SECURE_NO_DEPRECATE)
# define _SCL_SECURE_NO_DEPRECATE
#endif

/* Deal with Apple's deprecated 'AssertMacros.h' from Carbon-framework */
#if defined(__APPLE__) && !defined(__ASSERT_MACROS_DEFINE_VERSIONS_WITHOUT_UNDERSCORES)
# define __ASSERT_MACROS_DEFINE_VERSIONS_WITHOUT_UNDERSCORES 0
#endif

/* Intel's compiler complains if a variable which was never initialised is
 * cast to void, which is a common idiom which we use to indicate that we
 * are aware a variable isn't used.  So we just silence that warning.
 * See: https://github.com/swig/swig/issues/192 for more discussion.
 */
#ifdef __INTEL_COMPILER
# pragma warning disable 592
#endif


/* Fix for jlong on some versions of gcc on Windows */
#if defined(__GNUC__) && !defined(__INTEL_COMPILER)
  typedef long long __int64;
#endif

/* Fix for jlong on 64-bit x86 Solaris */
#if defined(__x86_64)
# ifdef _LP64
#   undef _LP64
# endif
#endif

#include <jni.h>
#include <stdlib.h>
#include <string.h>


/* Support for throwing Java exceptions */
typedef enum {
  SWIG_JavaOutOfMemoryError = 1, 
  SWIG_JavaIOException, 
  SWIG_JavaRuntimeException, 
  SWIG_JavaIndexOutOfBoundsException,
  SWIG_JavaArithmeticException,
  SWIG_JavaIllegalArgumentException,
  SWIG_JavaNullPointerException,
  SWIG_JavaDirectorPureVirtual,
  SWIG_JavaUnknownError
} SWIG_JavaExceptionCodes;

typedef struct {
  SWIG_JavaExceptionCodes code;
  const char *java_exception;
} SWIG_JavaExceptions_t;


static void SWIGUNUSED SWIG_JavaThrowException(JNIEnv *jenv, SWIG_JavaExceptionCodes code, const char *msg) {
  jclass excep;
  static const SWIG_JavaExceptions_t java_exceptions[] = {
    { SWIG_JavaOutOfMemoryError, "java/lang/OutOfMemoryError" },
    { SWIG_JavaIOException, "java/io/IOException" },
    { SWIG_JavaRuntimeException, "java/lang/RuntimeException" },
    { SWIG_JavaIndexOutOfBoundsException, "java/lang/IndexOutOfBoundsException" },
    { SWIG_JavaArithmeticException, "java/lang/ArithmeticException" },
    { SWIG_JavaIllegalArgumentException, "java/lang/IllegalArgumentException" },
    { SWIG_JavaNullPointerException, "java/lang/NullPointerException" },
    { SWIG_JavaDirectorPureVirtual, "java/lang/RuntimeException" },
    { SWIG_JavaUnknownError,  "java/lang/UnknownError" },
    { (SWIG_JavaExceptionCodes)0,  "java/lang/UnknownError" }
  };
  const SWIG_JavaExceptions_t *except_ptr = java_exceptions;

  while (except_ptr->code != code && except_ptr->code)
    except_ptr++;

  jenv->ExceptionClear();
  excep = jenv->FindClass(except_ptr->java_exception);
  if (excep)
    jenv->ThrowNew(excep, msg);
}


/* Contract support */

#define SWIG_contract_assert(nullreturn, expr, msg) if (!(expr)) {SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, msg); return nullreturn; } else

/* -----------------------------------------------------------------------------
 * director_common.swg
 *
 * This file contains support for director classes which is common between
 * languages.
 * ----------------------------------------------------------------------------- */

/*
  Use -DSWIG_DIRECTOR_STATIC if you prefer to avoid the use of the
  'Swig' namespace. This could be useful for multi-modules projects.
*/
#ifdef SWIG_DIRECTOR_STATIC
/* Force anonymous (static) namespace */
#define Swig
#endif
/* -----------------------------------------------------------------------------
 * director.swg
 *
 * This file contains support for director classes so that Java proxy
 * methods can be called from C++.
 * ----------------------------------------------------------------------------- */

#if defined(DEBUG_DIRECTOR_OWNED) || defined(DEBUG_DIRECTOR_EXCEPTION)
#include <iostream>
#endif

#include <exception>

namespace Swig {

  /* Java object wrapper */
  class JObjectWrapper {
  public:
    JObjectWrapper() : jthis_(NULL), weak_global_(true) {
    }

    ~JObjectWrapper() {
      jthis_ = NULL;
      weak_global_ = true;
    }

    bool set(JNIEnv *jenv, jobject jobj, bool mem_own, bool weak_global) {
      if (!jthis_) {
        weak_global_ = !mem_own; // hold as weak global if explicitly requested or not owned
        if (jobj)
          jthis_ = weak_global_ ? jenv->NewWeakGlobalRef(jobj) : jenv->NewGlobalRef(jobj);
#if defined(DEBUG_DIRECTOR_OWNED)
        std::cout << "JObjectWrapper::set(" << jobj << ", " << (weak_global ? "weak_global" : "global_ref") << ") -> " << jthis_ << std::endl;
#endif
        return true;
      } else {
#if defined(DEBUG_DIRECTOR_OWNED)
        std::cout << "JObjectWrapper::set(" << jobj << ", " << (weak_global ? "weak_global" : "global_ref") << ") -> already set" << std::endl;
#endif
        return false;
      }
    }

    jobject get(JNIEnv *jenv) const {
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "JObjectWrapper::get(";
      if (jthis_)
        std::cout << jthis_;
      else
        std::cout << "null";
      std::cout << ") -> return new local ref" << std::endl;
#endif
      return (jthis_ ? jenv->NewLocalRef(jthis_) : jthis_);
    }

    void release(JNIEnv *jenv) {
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "JObjectWrapper::release(" << jthis_ << "): " << (weak_global_ ? "weak global ref" : "global ref") << std::endl;
#endif
      if (jthis_) {
        if (weak_global_) {
          if (jenv->IsSameObject(jthis_, NULL) == JNI_FALSE)
            jenv->DeleteWeakGlobalRef((jweak)jthis_);
        } else
          jenv->DeleteGlobalRef(jthis_);
      }

      jthis_ = NULL;
      weak_global_ = true;
    }

    /* Only call peek if you know what you are doing wrt to weak/global references */
    jobject peek() {
      return jthis_;
    }

    /* Java proxy releases ownership of C++ object, C++ object is now
       responsible for destruction (creates NewGlobalRef to pin Java proxy) */
    void java_change_ownership(JNIEnv *jenv, jobject jself, bool take_or_release) {
      if (take_or_release) {  /* Java takes ownership of C++ object's lifetime. */
        if (!weak_global_) {
          jenv->DeleteGlobalRef(jthis_);
          jthis_ = jenv->NewWeakGlobalRef(jself);
          weak_global_ = true;
        }
      } else {
	/* Java releases ownership of C++ object's lifetime */
        if (weak_global_) {
          jenv->DeleteWeakGlobalRef((jweak)jthis_);
          jthis_ = jenv->NewGlobalRef(jself);
          weak_global_ = false;
        }
      }
    }

  private:
    /* pointer to Java object */
    jobject jthis_;
    /* Local or global reference flag */
    bool weak_global_;
  };

  /* Local JNI reference deleter */
  class LocalRefGuard {
    JNIEnv *jenv_;
    jobject jobj_;

    // non-copyable
    LocalRefGuard(const LocalRefGuard &);
    LocalRefGuard &operator=(const LocalRefGuard &);
  public:
    LocalRefGuard(JNIEnv *jenv, jobject jobj): jenv_(jenv), jobj_(jobj) {}
    ~LocalRefGuard() {
      if (jobj_)
        jenv_->DeleteLocalRef(jobj_);
    }
  };

  /* director base class */
  class Director {
    /* pointer to Java virtual machine */
    JavaVM *swig_jvm_;

  protected:
#if defined (_MSC_VER) && (_MSC_VER<1300)
    class JNIEnvWrapper;
    friend class JNIEnvWrapper;
#endif
    /* Utility class for managing the JNI environment */
    class JNIEnvWrapper {
      const Director *director_;
      JNIEnv *jenv_;
      int env_status;
    public:
      JNIEnvWrapper(const Director *director) : director_(director), jenv_(0), env_status(0) {
#if defined(__ANDROID__)
        JNIEnv **jenv = &jenv_;
#else
        void **jenv = (void **)&jenv_;
#endif
        env_status = director_->swig_jvm_->GetEnv((void **)&jenv_, JNI_VERSION_1_2);
#if defined(SWIG_JAVA_ATTACH_CURRENT_THREAD_AS_DAEMON)
        // Attach a daemon thread to the JVM. Useful when the JVM should not wait for
        // the thread to exit upon shutdown. Only for jdk-1.4 and later.
        director_->swig_jvm_->AttachCurrentThreadAsDaemon(jenv, NULL);
#else
        director_->swig_jvm_->AttachCurrentThread(jenv, NULL);
#endif
      }
      ~JNIEnvWrapper() {
#if !defined(SWIG_JAVA_NO_DETACH_CURRENT_THREAD)
        // Some JVMs, eg jdk-1.4.2 and lower on Solaris have a bug and crash with the DetachCurrentThread call.
        // However, without this call, the JVM hangs on exit when the thread was not created by the JVM and creates a memory leak.
        if (env_status == JNI_EDETACHED)
          director_->swig_jvm_->DetachCurrentThread();
#endif
      }
      JNIEnv *getJNIEnv() const {
        return jenv_;
      }
    };

    /* Java object wrapper */
    JObjectWrapper swig_self_;

    /* Disconnect director from Java object */
    void swig_disconnect_director_self(const char *disconn_method) {
      JNIEnvWrapper jnienv(this) ;
      JNIEnv *jenv = jnienv.getJNIEnv() ;
      jobject jobj = swig_self_.get(jenv);
      LocalRefGuard ref_deleter(jenv, jobj);
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "Swig::Director::disconnect_director_self(" << jobj << ")" << std::endl;
#endif
      if (jobj && jenv->IsSameObject(jobj, NULL) == JNI_FALSE) {
        jmethodID disconn_meth = jenv->GetMethodID(jenv->GetObjectClass(jobj), disconn_method, "()V");
        if (disconn_meth) {
#if defined(DEBUG_DIRECTOR_OWNED)
          std::cout << "Swig::Director::disconnect_director_self upcall to " << disconn_method << std::endl;
#endif
          jenv->CallVoidMethod(jobj, disconn_meth);
        }
      }
    }

  public:
    Director(JNIEnv *jenv) : swig_jvm_((JavaVM *) NULL), swig_self_() {
      /* Acquire the Java VM pointer */
      jenv->GetJavaVM(&swig_jvm_);
    }

    virtual ~Director() {
      JNIEnvWrapper jnienv(this) ;
      JNIEnv *jenv = jnienv.getJNIEnv() ;
      swig_self_.release(jenv);
    }

    bool swig_set_self(JNIEnv *jenv, jobject jself, bool mem_own, bool weak_global) {
      return swig_self_.set(jenv, jself, mem_own, weak_global);
    }

    jobject swig_get_self(JNIEnv *jenv) const {
      return swig_self_.get(jenv);
    }

    // Change C++ object's ownership, relative to Java
    void swig_java_change_ownership(JNIEnv *jenv, jobject jself, bool take_or_release) {
      swig_self_.java_change_ownership(jenv, jself, take_or_release);
    }
  };

  // Zero initialized bool array
  template<size_t N> class BoolArray {
    bool array_[N];
  public:
    BoolArray() {
      memset(array_, 0, sizeof(array_));
    }
    bool& operator[](size_t n) {
      return array_[n];
    }
    bool operator[](size_t n) const {
      return array_[n];
    }
  };

  // Utility classes and functions for exception handling.

  // Simple holder for a Java string during exception handling, providing access to a c-style string
  class JavaString {
  public:
    JavaString(JNIEnv *jenv, jstring jstr) : jenv_(jenv), jstr_(jstr), cstr_(0) {
      if (jenv_ && jstr_)
	cstr_ = (const char *) jenv_->GetStringUTFChars(jstr_, NULL);
    }

    ~JavaString() {
      if (jenv_ && jstr_ && cstr_)
	jenv_->ReleaseStringUTFChars(jstr_, cstr_);
    }

    const char *c_str(const char *null_string = "null JavaString") const {
      return cstr_ ? cstr_ : null_string;
    }

  private:
    // non-copyable
    JavaString(const JavaString &);
    JavaString &operator=(const JavaString &);

    JNIEnv *jenv_;
    jstring jstr_;
    const char *cstr_;
  };

  // Helper class to extract the exception message from a Java throwable
  class JavaExceptionMessage {
  public:
    JavaExceptionMessage(JNIEnv *jenv, jthrowable throwable) : message_(jenv, exceptionMessageFromThrowable(jenv, throwable)) {
    }

    const char *message() const {
      return message_.c_str("Could not get exception message in JavaExceptionMessage");
    }

  private:
    // non-copyable
    JavaExceptionMessage(const JavaExceptionMessage &);
    JavaExceptionMessage &operator=(const JavaExceptionMessage &);

    // Get exception message by calling Java method Throwable.getMessage()
    static jstring exceptionMessageFromThrowable(JNIEnv *jenv, jthrowable throwable) {
      jstring jmsg = NULL;
      if (jenv && throwable) {
	jenv->ExceptionClear(); // Cannot invoke methods with any pending exceptions
	jclass throwclz = jenv->GetObjectClass(throwable);
	if (throwclz) {
	  // All Throwable classes have a getMessage() method, so call it to extract the exception message
	  jmethodID getMessageMethodID = jenv->GetMethodID(throwclz, "getMessage", "()Ljava/lang/String;");
	  if (getMessageMethodID)
	    jmsg = (jstring)jenv->CallObjectMethod(throwable, getMessageMethodID);
	}
	if (jmsg == NULL && jenv->ExceptionCheck())
	  jenv->ExceptionClear();
      }
      return jmsg;
    }

    JavaString message_;
  };

  // C++ Exception class for handling Java exceptions thrown during a director method Java upcall
  class DirectorException : public std::exception {
  public:

    // Construct exception from a Java throwable
    DirectorException(JNIEnv *jenv, jthrowable throwable) : classname_(0), msg_(0) {

      // Call Java method Object.getClass().getName() to obtain the throwable's class name (delimited by '/')
      if (throwable) {
	jclass throwclz = jenv->GetObjectClass(throwable);
	if (throwclz) {
	  jclass clzclz = jenv->GetObjectClass(throwclz);
	  if (clzclz) {
	    jmethodID getNameMethodID = jenv->GetMethodID(clzclz, "getName", "()Ljava/lang/String;");
	    if (getNameMethodID) {
	      jstring jstr_classname = (jstring)(jenv->CallObjectMethod(throwclz, getNameMethodID));
              // Copy strings, since there is no guarantee that jenv will be active when handled
              if (jstr_classname) {
                JavaString jsclassname(jenv, jstr_classname);
                const char *classname = jsclassname.c_str(0);
                if (classname)
                  classname_ = copypath(classname);
              }
	    }
	  }
	}
      }

      JavaExceptionMessage exceptionmsg(jenv, throwable);
      msg_ = copystr(exceptionmsg.message());
    }

    // More general constructor for handling as a java.lang.RuntimeException
    DirectorException(const char *msg) : classname_(0), msg_(copystr(msg ? msg : "Unspecified DirectorException message")) {
    }

    ~DirectorException() throw() {
      delete[] classname_;
      delete[] msg_;
    }

    const char *what() const throw() {
      return msg_;
    }

    // Reconstruct and raise/throw the Java Exception that caused the DirectorException
    // Note that any error in the JNI exception handling results in a Java RuntimeException
    void raiseJavaException(JNIEnv *jenv) const {
      if (jenv) {
	jenv->ExceptionClear();

	jmethodID ctorMethodID = 0;
	jclass throwableclass = 0;
        if (classname_) {
          throwableclass = jenv->FindClass(classname_);
          if (throwableclass)
            ctorMethodID = jenv->GetMethodID(throwableclass, "<init>", "(Ljava/lang/String;)V");
	}

	if (ctorMethodID) {
	  jenv->ThrowNew(throwableclass, what());
	} else {
	  SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, what());
	}
      }
    }

  private:
    static char *copypath(const char *srcmsg) {
      char *target = copystr(srcmsg);
      for (char *c=target; *c; ++c) {
        if ('.' == *c)
          *c = '/';
      }
      return target;
    }

    static char *copystr(const char *srcmsg) {
      char *target = 0;
      if (srcmsg) {
	size_t msglen = strlen(srcmsg) + 1;
	target = new char[msglen];
	strncpy(target, srcmsg, msglen);
      }
      return target;
    }

    const char *classname_;
    const char *msg_;
  };

  // Helper method to determine if a Java throwable matches a particular Java class type
  SWIGINTERN inline bool ExceptionMatches(JNIEnv *jenv, jthrowable throwable, const char *classname) {
    bool matches = false;

    if (throwable && jenv && classname) {
      // Exceptions need to be cleared for correct behavior.
      // The caller of ExceptionMatches should restore pending exceptions if desired -
      // the caller already has the throwable.
      jenv->ExceptionClear();

      jclass clz = jenv->FindClass(classname);
      if (clz) {
	jclass classclz = jenv->GetObjectClass(clz);
	jmethodID isInstanceMethodID = jenv->GetMethodID(classclz, "isInstance", "(Ljava/lang/Object;)Z");
	if (isInstanceMethodID) {
	  matches = jenv->CallBooleanMethod(clz, isInstanceMethodID, throwable) != 0;
	}
      }

#if defined(DEBUG_DIRECTOR_EXCEPTION)
      if (jenv->ExceptionCheck()) {
        // Typically occurs when an invalid classname argument is passed resulting in a ClassNotFoundException
        JavaExceptionMessage exc(jenv, jenv->ExceptionOccurred());
        std::cout << "Error: ExceptionMatches: class '" << classname << "' : " << exc.message() << std::endl;
      }
#endif
    }
    return matches;
  }
}

namespace Swig {
  namespace {
    jclass jclass_LinearMathJNI = NULL;
    jmethodID director_method_ids[30];
  }
}

#if defined(SWIG_NOINCLUDE) || defined(SWIG_NOARRAYS)


static int SWIG_JavaArrayInBool (JNIEnv *jenv, jboolean **jarr, bool **carr, jbooleanArray input);
static void SWIG_JavaArrayArgoutBool (JNIEnv *jenv, jboolean *jarr, bool *carr, jbooleanArray input);
static jbooleanArray SWIG_JavaArrayOutBool (JNIEnv *jenv, bool *result, jsize sz);


static int SWIG_JavaArrayInSchar (JNIEnv *jenv, jbyte **jarr, signed char **carr, jbyteArray input);
static void SWIG_JavaArrayArgoutSchar (JNIEnv *jenv, jbyte *jarr, signed char *carr, jbyteArray input);
static jbyteArray SWIG_JavaArrayOutSchar (JNIEnv *jenv, signed char *result, jsize sz);


static int SWIG_JavaArrayInUchar (JNIEnv *jenv, jshort **jarr, unsigned char **carr, jshortArray input);
static void SWIG_JavaArrayArgoutUchar (JNIEnv *jenv, jshort *jarr, unsigned char *carr, jshortArray input);
static jshortArray SWIG_JavaArrayOutUchar (JNIEnv *jenv, unsigned char *result, jsize sz);


static int SWIG_JavaArrayInShort (JNIEnv *jenv, jshort **jarr, short **carr, jshortArray input);
static void SWIG_JavaArrayArgoutShort (JNIEnv *jenv, jshort *jarr, short *carr, jshortArray input);
static jshortArray SWIG_JavaArrayOutShort (JNIEnv *jenv, short *result, jsize sz);


static int SWIG_JavaArrayInUshort (JNIEnv *jenv, jint **jarr, unsigned short **carr, jintArray input);
static void SWIG_JavaArrayArgoutUshort (JNIEnv *jenv, jint *jarr, unsigned short *carr, jintArray input);
static jintArray SWIG_JavaArrayOutUshort (JNIEnv *jenv, unsigned short *result, jsize sz);


static int SWIG_JavaArrayInInt (JNIEnv *jenv, jint **jarr, int **carr, jintArray input);
static void SWIG_JavaArrayArgoutInt (JNIEnv *jenv, jint *jarr, int *carr, jintArray input);
static jintArray SWIG_JavaArrayOutInt (JNIEnv *jenv, int *result, jsize sz);


static int SWIG_JavaArrayInUint (JNIEnv *jenv, jlong **jarr, unsigned int **carr, jlongArray input);
static void SWIG_JavaArrayArgoutUint (JNIEnv *jenv, jlong *jarr, unsigned int *carr, jlongArray input);
static jlongArray SWIG_JavaArrayOutUint (JNIEnv *jenv, unsigned int *result, jsize sz);


static int SWIG_JavaArrayInLong (JNIEnv *jenv, jint **jarr, long **carr, jintArray input);
static void SWIG_JavaArrayArgoutLong (JNIEnv *jenv, jint *jarr, long *carr, jintArray input);
static jintArray SWIG_JavaArrayOutLong (JNIEnv *jenv, long *result, jsize sz);


static int SWIG_JavaArrayInUlong (JNIEnv *jenv, jlong **jarr, unsigned long **carr, jlongArray input);
static void SWIG_JavaArrayArgoutUlong (JNIEnv *jenv, jlong *jarr, unsigned long *carr, jlongArray input);
static jlongArray SWIG_JavaArrayOutUlong (JNIEnv *jenv, unsigned long *result, jsize sz);


static int SWIG_JavaArrayInLonglong (JNIEnv *jenv, jlong **jarr, jlong **carr, jlongArray input);
static void SWIG_JavaArrayArgoutLonglong (JNIEnv *jenv, jlong *jarr, jlong *carr, jlongArray input);
static jlongArray SWIG_JavaArrayOutLonglong (JNIEnv *jenv, jlong *result, jsize sz);


static int SWIG_JavaArrayInFloat (JNIEnv *jenv, jfloat **jarr, float **carr, jfloatArray input);
static void SWIG_JavaArrayArgoutFloat (JNIEnv *jenv, jfloat *jarr, float *carr, jfloatArray input);
static jfloatArray SWIG_JavaArrayOutFloat (JNIEnv *jenv, float *result, jsize sz);


static int SWIG_JavaArrayInDouble (JNIEnv *jenv, jdouble **jarr, double **carr, jdoubleArray input);
static void SWIG_JavaArrayArgoutDouble (JNIEnv *jenv, jdouble *jarr, double *carr, jdoubleArray input);
static jdoubleArray SWIG_JavaArrayOutDouble (JNIEnv *jenv, double *result, jsize sz);


#else


/* bool[] support */
static int SWIG_JavaArrayInBool (JNIEnv *jenv, jboolean **jarr, bool **carr, jbooleanArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetBooleanArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new bool[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = ((*jarr)[i] != 0);
  return 1;
}

static void SWIG_JavaArrayArgoutBool (JNIEnv *jenv, jboolean *jarr, bool *carr, jbooleanArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jboolean)carr[i];
  jenv->ReleaseBooleanArrayElements(input, jarr, 0);
}

static jbooleanArray SWIG_JavaArrayOutBool (JNIEnv *jenv, bool *result, jsize sz) {
  jboolean *arr;
  int i;
  jbooleanArray jresult = jenv->NewBooleanArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetBooleanArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jboolean)result[i];
  jenv->ReleaseBooleanArrayElements(jresult, arr, 0);
  return jresult;
}


/* signed char[] support */
static int SWIG_JavaArrayInSchar (JNIEnv *jenv, jbyte **jarr, signed char **carr, jbyteArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetByteArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new signed char[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (signed char)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutSchar (JNIEnv *jenv, jbyte *jarr, signed char *carr, jbyteArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jbyte)carr[i];
  jenv->ReleaseByteArrayElements(input, jarr, 0);
}

static jbyteArray SWIG_JavaArrayOutSchar (JNIEnv *jenv, signed char *result, jsize sz) {
  jbyte *arr;
  int i;
  jbyteArray jresult = jenv->NewByteArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetByteArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jbyte)result[i];
  jenv->ReleaseByteArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned char[] support */
static int SWIG_JavaArrayInUchar (JNIEnv *jenv, jshort **jarr, unsigned char **carr, jshortArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetShortArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned char[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned char)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutUchar (JNIEnv *jenv, jshort *jarr, unsigned char *carr, jshortArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jshort)carr[i];
  jenv->ReleaseShortArrayElements(input, jarr, 0);
}

static jshortArray SWIG_JavaArrayOutUchar (JNIEnv *jenv, unsigned char *result, jsize sz) {
  jshort *arr;
  int i;
  jshortArray jresult = jenv->NewShortArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetShortArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jshort)result[i];
  jenv->ReleaseShortArrayElements(jresult, arr, 0);
  return jresult;
}


/* short[] support */
static int SWIG_JavaArrayInShort (JNIEnv *jenv, jshort **jarr, short **carr, jshortArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetShortArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new short[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (short)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutShort (JNIEnv *jenv, jshort *jarr, short *carr, jshortArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jshort)carr[i];
  jenv->ReleaseShortArrayElements(input, jarr, 0);
}

static jshortArray SWIG_JavaArrayOutShort (JNIEnv *jenv, short *result, jsize sz) {
  jshort *arr;
  int i;
  jshortArray jresult = jenv->NewShortArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetShortArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jshort)result[i];
  jenv->ReleaseShortArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned short[] support */
static int SWIG_JavaArrayInUshort (JNIEnv *jenv, jint **jarr, unsigned short **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned short[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned short)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutUshort (JNIEnv *jenv, jint *jarr, unsigned short *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

static jintArray SWIG_JavaArrayOutUshort (JNIEnv *jenv, unsigned short *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* int[] support */
static int SWIG_JavaArrayInInt (JNIEnv *jenv, jint **jarr, int **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new int[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (int)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutInt (JNIEnv *jenv, jint *jarr, int *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

static jintArray SWIG_JavaArrayOutInt (JNIEnv *jenv, int *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned int[] support */
static int SWIG_JavaArrayInUint (JNIEnv *jenv, jlong **jarr, unsigned int **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned int[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned int)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutUint (JNIEnv *jenv, jlong *jarr, unsigned int *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

static jlongArray SWIG_JavaArrayOutUint (JNIEnv *jenv, unsigned int *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* long[] support */
static int SWIG_JavaArrayInLong (JNIEnv *jenv, jint **jarr, long **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new long[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (long)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutLong (JNIEnv *jenv, jint *jarr, long *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

static jintArray SWIG_JavaArrayOutLong (JNIEnv *jenv, long *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned long[] support */
static int SWIG_JavaArrayInUlong (JNIEnv *jenv, jlong **jarr, unsigned long **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned long[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned long)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutUlong (JNIEnv *jenv, jlong *jarr, unsigned long *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

static jlongArray SWIG_JavaArrayOutUlong (JNIEnv *jenv, unsigned long *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* jlong[] support */
static int SWIG_JavaArrayInLonglong (JNIEnv *jenv, jlong **jarr, jlong **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new jlong[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (jlong)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutLonglong (JNIEnv *jenv, jlong *jarr, jlong *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

static jlongArray SWIG_JavaArrayOutLonglong (JNIEnv *jenv, jlong *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* float[] support */
static int SWIG_JavaArrayInFloat (JNIEnv *jenv, jfloat **jarr, float **carr, jfloatArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetFloatArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new float[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (float)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutFloat (JNIEnv *jenv, jfloat *jarr, float *carr, jfloatArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jfloat)carr[i];
  jenv->ReleaseFloatArrayElements(input, jarr, 0);
}

static jfloatArray SWIG_JavaArrayOutFloat (JNIEnv *jenv, float *result, jsize sz) {
  jfloat *arr;
  int i;
  jfloatArray jresult = jenv->NewFloatArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetFloatArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jfloat)result[i];
  jenv->ReleaseFloatArrayElements(jresult, arr, 0);
  return jresult;
}


/* double[] support */
static int SWIG_JavaArrayInDouble (JNIEnv *jenv, jdouble **jarr, double **carr, jdoubleArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetDoubleArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new double[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (double)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutDouble (JNIEnv *jenv, jdouble *jarr, double *carr, jdoubleArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jdouble)carr[i];
  jenv->ReleaseDoubleArrayElements(input, jarr, 0);
}

static jdoubleArray SWIG_JavaArrayOutDouble (JNIEnv *jenv, double *result, jsize sz) {
  jdouble *arr;
  int i;
  jdoubleArray jresult = jenv->NewDoubleArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetDoubleArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jdouble)result[i];
  jenv->ReleaseDoubleArrayElements(jresult, arr, 0);
  return jresult;
}


#endif


#ifndef BT_INFINITY
static  int btInfinityMask = 0x7F800000;
#define BT_INFINITY (*(float*)&btInfinityMask)
#endif


#include <gdx/common/jniHelpers.h>


#include <stdint.h>


#include <gdx/linearmath/mathtypes.h>
#include <LinearMath/btVector3.h>
#include <LinearMath/btQuaternion.h>
#include <LinearMath/btMatrix3x3.h>
#include <LinearMath/btTransform.h>


#include <LinearMath/btTransform.h>



	/* Gets a global ref to the temp class.  Do not release this. */
	SWIGINTERN inline jclass gdx_getTempClassQuaternion(JNIEnv * jenv) {
	  static jclass cls = NULL;
	  if (cls == NULL) {
		cls = (jclass) jenv->NewGlobalRef(jenv->FindClass("com/badlogic/gdx/physics/bullet/linearmath/LinearMath"));
	  }
	  return cls;
	}
	
	SWIGINTERN inline jobject gdx_takePoolObjectQuaternion(JNIEnv * jenv, const char * poolName) {
	  jclass tempClass = gdx_getTempClassQuaternion(jenv);
	  
	  static jfieldID poolField = NULL;
	  if (poolField == NULL) {
		poolField = jenv->GetStaticFieldID(tempClass, poolName, "Lcom/badlogic/gdx/utils/Pool;");
	  }
	  
	  jobject poolObject = jenv->GetStaticObjectField(tempClass, poolField);
	  jclass poolClass = jenv->GetObjectClass(poolObject);
	  
	  static jmethodID obtainMethod = NULL;
	  if (obtainMethod == NULL) {
		obtainMethod = (jmethodID) jenv->GetMethodID(poolClass, "obtain", "()Ljava/lang/Object;");
	  }
	  
	  jobject ret = jenv->CallObjectMethod(poolObject, obtainMethod);
	
	  jenv->DeleteLocalRef(poolObject);
	  jenv->DeleteLocalRef(poolClass);
	
	  return ret;
	}
	
	SWIGINTERN inline void gdx_releasePoolObjectQuaternion(JNIEnv * jenv, const char * poolName, jobject obj) {
	  jclass tempClass = gdx_getTempClassQuaternion(jenv);
	  
	  static jfieldID poolField = NULL;
	  if (poolField == NULL) {
		poolField = jenv->GetStaticFieldID(tempClass, poolName, "Lcom/badlogic/gdx/utils/Pool;");
	  }
	  
	  jobject poolObject = jenv->GetStaticObjectField(tempClass, poolField);
	  jclass poolClass = jenv->GetObjectClass(poolObject);
	  
	  static jmethodID freeMethod = NULL;
	  if (freeMethod == NULL) {
		freeMethod = (jmethodID) jenv->GetMethodID(poolClass, "free", "(Ljava/lang/Object;)V");
	  }
	  
	  jenv->CallVoidMethod(poolObject, freeMethod, obj);
	  
	  jenv->DeleteLocalRef(poolObject);
	  jenv->DeleteLocalRef(poolClass);
	  jenv->DeleteLocalRef(obj);
	}
	
	/*
	 * A simple RAII wrapper to release jobjects we obtain from pools in 
	 * directorin typemaps.  SWIG doesn't have hooks to release them after
	 * they're used. 
	 */
	class gdxPoolAutoReleaseQuaternion {
	private:
	  JNIEnv * jenv;
	  const char * poolName;
	  jobject obj;
	public:
	  gdxPoolAutoReleaseQuaternion(JNIEnv * jenv, const char * poolName, jobject obj) : 
		jenv(jenv), poolName(poolName), obj(obj) { };
	  virtual ~gdxPoolAutoReleaseQuaternion() {
		gdx_releasePoolObjectQuaternion(this->jenv, this->poolName, this->obj);
	  };
	};


	
// Workaround for some strange swig behaviour


	/* Gets a global ref to the temp class's Return Quaternion.  Do not release this. */ 
	SWIGINTERN inline jobject gdx_getReturnQuaternion(JNIEnv * jenv) {
	  static jobject ret = NULL;
	  if (ret == NULL) {
	    jclass tempClass = gdx_getTempClassQuaternion(jenv);
	    jfieldID field = jenv->GetStaticFieldID(tempClass, "staticQuaternion", "Lcom/badlogic/gdx/math/Quaternion;");
	    ret = jenv->NewGlobalRef(jenv->GetStaticObjectField(tempClass, field));
	  }
	  return ret;
	}
	
	/* Sets the data in the Bullet type from the Gdx type. */
	SWIGINTERN inline void gdx_setbtQuaternionFromQuaternion(JNIEnv * jenv, btQuaternion & target, jobject source) {
		Quaternion_to_btQuaternion(jenv, target, source);
	}

	SWIGINTERN inline void gdx_setbtQuaternionFromQuaternion(JNIEnv * jenv, btQuaternion * target, jobject source) {
		gdx_setbtQuaternionFromQuaternion(jenv, *target, source);
	}

	/* Sets the data in the Gdx type from the Bullet type. */
	SWIGINTERN inline void gdx_setQuaternionFrombtQuaternion(JNIEnv * jenv, jobject target, const btQuaternion & source) {
		btQuaternion_to_Quaternion(jenv, target, source);
	}

	SWIGINTERN inline void gdx_setQuaternionFrombtQuaternion(JNIEnv * jenv, jobject target, const btQuaternion * source) {
		gdx_setQuaternionFrombtQuaternion(jenv, target, *source);
	}

	/*
	 * RAII wrapper to commit changes made to a local btQuaternion back to Quaternion
	 */
	class gdxAutoCommitQuaternion {
	private:
	  JNIEnv * jenv;
	  jobject jQuaternion;
	  btQuaternion & cbtQuaternion;
	public:
	  gdxAutoCommitQuaternion(JNIEnv * jenv, jobject jQuaternion, btQuaternion & cbtQuaternion) : 
	    jenv(jenv), jQuaternion(jQuaternion), cbtQuaternion(cbtQuaternion) { };
	  gdxAutoCommitQuaternion(JNIEnv * jenv, jobject jQuaternion, btQuaternion * cbtQuaternion) : 
	    jenv(jenv), jQuaternion(jQuaternion), cbtQuaternion(*cbtQuaternion) { };
	  virtual ~gdxAutoCommitQuaternion() {
	    gdx_setQuaternionFrombtQuaternion(this->jenv, this->jQuaternion, this->cbtQuaternion);
	  };
	};

	class gdxAutoCommitbtQuaternionAndReleaseQuaternion {
	private:
	  JNIEnv * jenv;
	  jobject jQuaternion;
	  btQuaternion & cbtQuaternion;
	  const char * poolName;
	public:
	  gdxAutoCommitbtQuaternionAndReleaseQuaternion(JNIEnv * jenv, jobject jQuaternion, btQuaternion & cbtQuaternion, const char *poolName) : 
	    jenv(jenv), jQuaternion(jQuaternion), cbtQuaternion(cbtQuaternion), poolName(poolName) { };
	  gdxAutoCommitbtQuaternionAndReleaseQuaternion(JNIEnv * jenv, jobject jQuaternion, btQuaternion * cbtQuaternion, const char *poolName) : 
	    jenv(jenv), jQuaternion(jQuaternion), cbtQuaternion(*cbtQuaternion), poolName(poolName) { };
	  virtual ~gdxAutoCommitbtQuaternionAndReleaseQuaternion() {
	    gdx_setbtQuaternionFromQuaternion(this->jenv, this->cbtQuaternion, this->jQuaternion);
	    gdx_releasePoolObjectQuaternion(this->jenv, this->poolName, this->jQuaternion);
	  };
	};



	/* Gets a global ref to the temp class.  Do not release this. */
	SWIGINTERN inline jclass gdx_getTempClassVector3(JNIEnv * jenv) {
	  static jclass cls = NULL;
	  if (cls == NULL) {
		cls = (jclass) jenv->NewGlobalRef(jenv->FindClass("com/badlogic/gdx/physics/bullet/linearmath/LinearMath"));
	  }
	  return cls;
	}
	
	SWIGINTERN inline jobject gdx_takePoolObjectVector3(JNIEnv * jenv, const char * poolName) {
	  jclass tempClass = gdx_getTempClassVector3(jenv);
	  
	  static jfieldID poolField = NULL;
	  if (poolField == NULL) {
		poolField = jenv->GetStaticFieldID(tempClass, poolName, "Lcom/badlogic/gdx/utils/Pool;");
	  }
	  
	  jobject poolObject = jenv->GetStaticObjectField(tempClass, poolField);
	  jclass poolClass = jenv->GetObjectClass(poolObject);
	  
	  static jmethodID obtainMethod = NULL;
	  if (obtainMethod == NULL) {
		obtainMethod = (jmethodID) jenv->GetMethodID(poolClass, "obtain", "()Ljava/lang/Object;");
	  }
	  
	  jobject ret = jenv->CallObjectMethod(poolObject, obtainMethod);
	
	  jenv->DeleteLocalRef(poolObject);
	  jenv->DeleteLocalRef(poolClass);
	
	  return ret;
	}
	
	SWIGINTERN inline void gdx_releasePoolObjectVector3(JNIEnv * jenv, const char * poolName, jobject obj) {
	  jclass tempClass = gdx_getTempClassVector3(jenv);
	  
	  static jfieldID poolField = NULL;
	  if (poolField == NULL) {
		poolField = jenv->GetStaticFieldID(tempClass, poolName, "Lcom/badlogic/gdx/utils/Pool;");
	  }
	  
	  jobject poolObject = jenv->GetStaticObjectField(tempClass, poolField);
	  jclass poolClass = jenv->GetObjectClass(poolObject);
	  
	  static jmethodID freeMethod = NULL;
	  if (freeMethod == NULL) {
		freeMethod = (jmethodID) jenv->GetMethodID(poolClass, "free", "(Ljava/lang/Object;)V");
	  }
	  
	  jenv->CallVoidMethod(poolObject, freeMethod, obj);
	  
	  jenv->DeleteLocalRef(poolObject);
	  jenv->DeleteLocalRef(poolClass);
	  jenv->DeleteLocalRef(obj);
	}
	
	/*
	 * A simple RAII wrapper to release jobjects we obtain from pools in 
	 * directorin typemaps.  SWIG doesn't have hooks to release them after
	 * they're used. 
	 */
	class gdxPoolAutoReleaseVector3 {
	private:
	  JNIEnv * jenv;
	  const char * poolName;
	  jobject obj;
	public:
	  gdxPoolAutoReleaseVector3(JNIEnv * jenv, const char * poolName, jobject obj) : 
		jenv(jenv), poolName(poolName), obj(obj) { };
	  virtual ~gdxPoolAutoReleaseVector3() {
		gdx_releasePoolObjectVector3(this->jenv, this->poolName, this->obj);
	  };
	};


	
// Workaround for some strange swig behaviour


	/* Gets a global ref to the temp class's Return Vector3.  Do not release this. */ 
	SWIGINTERN inline jobject gdx_getReturnVector3(JNIEnv * jenv) {
	  static jobject ret = NULL;
	  if (ret == NULL) {
	    jclass tempClass = gdx_getTempClassVector3(jenv);
	    jfieldID field = jenv->GetStaticFieldID(tempClass, "staticVector3", "Lcom/badlogic/gdx/math/Vector3;");
	    ret = jenv->NewGlobalRef(jenv->GetStaticObjectField(tempClass, field));
	  }
	  return ret;
	}
	
	/* Sets the data in the Bullet type from the Gdx type. */
	SWIGINTERN inline void gdx_setbtVector3FromVector3(JNIEnv * jenv, btVector3 & target, jobject source) {
		Vector3_to_btVector3(jenv, target, source);
	}

	SWIGINTERN inline void gdx_setbtVector3FromVector3(JNIEnv * jenv, btVector3 * target, jobject source) {
		gdx_setbtVector3FromVector3(jenv, *target, source);
	}

	/* Sets the data in the Gdx type from the Bullet type. */
	SWIGINTERN inline void gdx_setVector3FrombtVector3(JNIEnv * jenv, jobject target, const btVector3 & source) {
		btVector3_to_Vector3(jenv, target, source);
	}

	SWIGINTERN inline void gdx_setVector3FrombtVector3(JNIEnv * jenv, jobject target, const btVector3 * source) {
		gdx_setVector3FrombtVector3(jenv, target, *source);
	}

	/*
	 * RAII wrapper to commit changes made to a local btVector3 back to Vector3
	 */
	class gdxAutoCommitVector3 {
	private:
	  JNIEnv * jenv;
	  jobject jVector3;
	  btVector3 & cbtVector3;
	public:
	  gdxAutoCommitVector3(JNIEnv * jenv, jobject jVector3, btVector3 & cbtVector3) : 
	    jenv(jenv), jVector3(jVector3), cbtVector3(cbtVector3) { };
	  gdxAutoCommitVector3(JNIEnv * jenv, jobject jVector3, btVector3 * cbtVector3) : 
	    jenv(jenv), jVector3(jVector3), cbtVector3(*cbtVector3) { };
	  virtual ~gdxAutoCommitVector3() {
	    gdx_setVector3FrombtVector3(this->jenv, this->jVector3, this->cbtVector3);
	  };
	};

	class gdxAutoCommitbtVector3AndReleaseVector3 {
	private:
	  JNIEnv * jenv;
	  jobject jVector3;
	  btVector3 & cbtVector3;
	  const char * poolName;
	public:
	  gdxAutoCommitbtVector3AndReleaseVector3(JNIEnv * jenv, jobject jVector3, btVector3 & cbtVector3, const char *poolName) : 
	    jenv(jenv), jVector3(jVector3), cbtVector3(cbtVector3), poolName(poolName) { };
	  gdxAutoCommitbtVector3AndReleaseVector3(JNIEnv * jenv, jobject jVector3, btVector3 * cbtVector3, const char *poolName) : 
	    jenv(jenv), jVector3(jVector3), cbtVector3(*cbtVector3), poolName(poolName) { };
	  virtual ~gdxAutoCommitbtVector3AndReleaseVector3() {
	    gdx_setbtVector3FromVector3(this->jenv, this->cbtVector3, this->jVector3);
	    gdx_releasePoolObjectVector3(this->jenv, this->poolName, this->jVector3);
	  };
	};



	/* Gets a global ref to the temp class.  Do not release this. */
	SWIGINTERN inline jclass gdx_getTempClassMatrix3(JNIEnv * jenv) {
	  static jclass cls = NULL;
	  if (cls == NULL) {
		cls = (jclass) jenv->NewGlobalRef(jenv->FindClass("com/badlogic/gdx/physics/bullet/linearmath/LinearMath"));
	  }
	  return cls;
	}
	
	SWIGINTERN inline jobject gdx_takePoolObjectMatrix3(JNIEnv * jenv, const char * poolName) {
	  jclass tempClass = gdx_getTempClassMatrix3(jenv);
	  
	  static jfieldID poolField = NULL;
	  if (poolField == NULL) {
		poolField = jenv->GetStaticFieldID(tempClass, poolName, "Lcom/badlogic/gdx/utils/Pool;");
	  }
	  
	  jobject poolObject = jenv->GetStaticObjectField(tempClass, poolField);
	  jclass poolClass = jenv->GetObjectClass(poolObject);
	  
	  static jmethodID obtainMethod = NULL;
	  if (obtainMethod == NULL) {
		obtainMethod = (jmethodID) jenv->GetMethodID(poolClass, "obtain", "()Ljava/lang/Object;");
	  }
	  
	  jobject ret = jenv->CallObjectMethod(poolObject, obtainMethod);
	
	  jenv->DeleteLocalRef(poolObject);
	  jenv->DeleteLocalRef(poolClass);
	
	  return ret;
	}
	
	SWIGINTERN inline void gdx_releasePoolObjectMatrix3(JNIEnv * jenv, const char * poolName, jobject obj) {
	  jclass tempClass = gdx_getTempClassMatrix3(jenv);
	  
	  static jfieldID poolField = NULL;
	  if (poolField == NULL) {
		poolField = jenv->GetStaticFieldID(tempClass, poolName, "Lcom/badlogic/gdx/utils/Pool;");
	  }
	  
	  jobject poolObject = jenv->GetStaticObjectField(tempClass, poolField);
	  jclass poolClass = jenv->GetObjectClass(poolObject);
	  
	  static jmethodID freeMethod = NULL;
	  if (freeMethod == NULL) {
		freeMethod = (jmethodID) jenv->GetMethodID(poolClass, "free", "(Ljava/lang/Object;)V");
	  }
	  
	  jenv->CallVoidMethod(poolObject, freeMethod, obj);
	  
	  jenv->DeleteLocalRef(poolObject);
	  jenv->DeleteLocalRef(poolClass);
	  jenv->DeleteLocalRef(obj);
	}
	
	/*
	 * A simple RAII wrapper to release jobjects we obtain from pools in 
	 * directorin typemaps.  SWIG doesn't have hooks to release them after
	 * they're used. 
	 */
	class gdxPoolAutoReleaseMatrix3 {
	private:
	  JNIEnv * jenv;
	  const char * poolName;
	  jobject obj;
	public:
	  gdxPoolAutoReleaseMatrix3(JNIEnv * jenv, const char * poolName, jobject obj) : 
		jenv(jenv), poolName(poolName), obj(obj) { };
	  virtual ~gdxPoolAutoReleaseMatrix3() {
		gdx_releasePoolObjectMatrix3(this->jenv, this->poolName, this->obj);
	  };
	};


	
// Workaround for some strange swig behaviour


	/* Gets a global ref to the temp class's Return Matrix3.  Do not release this. */ 
	SWIGINTERN inline jobject gdx_getReturnMatrix3(JNIEnv * jenv) {
	  static jobject ret = NULL;
	  if (ret == NULL) {
	    jclass tempClass = gdx_getTempClassMatrix3(jenv);
	    jfieldID field = jenv->GetStaticFieldID(tempClass, "staticMatrix3", "Lcom/badlogic/gdx/math/Matrix3;");
	    ret = jenv->NewGlobalRef(jenv->GetStaticObjectField(tempClass, field));
	  }
	  return ret;
	}
	
	/* Sets the data in the Bullet type from the Gdx type. */
	SWIGINTERN inline void gdx_setbtMatrix3x3FromMatrix3(JNIEnv * jenv, btMatrix3x3 & target, jobject source) {
		Matrix3_to_btMatrix3(jenv, target, source);
	}

	SWIGINTERN inline void gdx_setbtMatrix3x3FromMatrix3(JNIEnv * jenv, btMatrix3x3 * target, jobject source) {
		gdx_setbtMatrix3x3FromMatrix3(jenv, *target, source);
	}

	/* Sets the data in the Gdx type from the Bullet type. */
	SWIGINTERN inline void gdx_setMatrix3FrombtMatrix3x3(JNIEnv * jenv, jobject target, const btMatrix3x3 & source) {
		btMatrix3_to_Matrix3(jenv, target, source);
	}

	SWIGINTERN inline void gdx_setMatrix3FrombtMatrix3x3(JNIEnv * jenv, jobject target, const btMatrix3x3 * source) {
		gdx_setMatrix3FrombtMatrix3x3(jenv, target, *source);
	}

	/*
	 * RAII wrapper to commit changes made to a local btMatrix3x3 back to Matrix3
	 */
	class gdxAutoCommitMatrix3 {
	private:
	  JNIEnv * jenv;
	  jobject jMatrix3;
	  btMatrix3x3 & cbtMatrix3x3;
	public:
	  gdxAutoCommitMatrix3(JNIEnv * jenv, jobject jMatrix3, btMatrix3x3 & cbtMatrix3x3) : 
	    jenv(jenv), jMatrix3(jMatrix3), cbtMatrix3x3(cbtMatrix3x3) { };
	  gdxAutoCommitMatrix3(JNIEnv * jenv, jobject jMatrix3, btMatrix3x3 * cbtMatrix3x3) : 
	    jenv(jenv), jMatrix3(jMatrix3), cbtMatrix3x3(*cbtMatrix3x3) { };
	  virtual ~gdxAutoCommitMatrix3() {
	    gdx_setMatrix3FrombtMatrix3x3(this->jenv, this->jMatrix3, this->cbtMatrix3x3);
	  };
	};

	class gdxAutoCommitbtMatrix3x3AndReleaseMatrix3 {
	private:
	  JNIEnv * jenv;
	  jobject jMatrix3;
	  btMatrix3x3 & cbtMatrix3x3;
	  const char * poolName;
	public:
	  gdxAutoCommitbtMatrix3x3AndReleaseMatrix3(JNIEnv * jenv, jobject jMatrix3, btMatrix3x3 & cbtMatrix3x3, const char *poolName) : 
	    jenv(jenv), jMatrix3(jMatrix3), cbtMatrix3x3(cbtMatrix3x3), poolName(poolName) { };
	  gdxAutoCommitbtMatrix3x3AndReleaseMatrix3(JNIEnv * jenv, jobject jMatrix3, btMatrix3x3 * cbtMatrix3x3, const char *poolName) : 
	    jenv(jenv), jMatrix3(jMatrix3), cbtMatrix3x3(*cbtMatrix3x3), poolName(poolName) { };
	  virtual ~gdxAutoCommitbtMatrix3x3AndReleaseMatrix3() {
	    gdx_setbtMatrix3x3FromMatrix3(this->jenv, this->cbtMatrix3x3, this->jMatrix3);
	    gdx_releasePoolObjectMatrix3(this->jenv, this->poolName, this->jMatrix3);
	  };
	};



	/* Gets a global ref to the temp class.  Do not release this. */
	SWIGINTERN inline jclass gdx_getTempClassMatrix4(JNIEnv * jenv) {
	  static jclass cls = NULL;
	  if (cls == NULL) {
		cls = (jclass) jenv->NewGlobalRef(jenv->FindClass("com/badlogic/gdx/physics/bullet/linearmath/LinearMath"));
	  }
	  return cls;
	}
	
	SWIGINTERN inline jobject gdx_takePoolObjectMatrix4(JNIEnv * jenv, const char * poolName) {
	  jclass tempClass = gdx_getTempClassMatrix4(jenv);
	  
	  static jfieldID poolField = NULL;
	  if (poolField == NULL) {
		poolField = jenv->GetStaticFieldID(tempClass, poolName, "Lcom/badlogic/gdx/utils/Pool;");
	  }
	  
	  jobject poolObject = jenv->GetStaticObjectField(tempClass, poolField);
	  jclass poolClass = jenv->GetObjectClass(poolObject);
	  
	  static jmethodID obtainMethod = NULL;
	  if (obtainMethod == NULL) {
		obtainMethod = (jmethodID) jenv->GetMethodID(poolClass, "obtain", "()Ljava/lang/Object;");
	  }
	  
	  jobject ret = jenv->CallObjectMethod(poolObject, obtainMethod);
	
	  jenv->DeleteLocalRef(poolObject);
	  jenv->DeleteLocalRef(poolClass);
	
	  return ret;
	}
	
	SWIGINTERN inline void gdx_releasePoolObjectMatrix4(JNIEnv * jenv, const char * poolName, jobject obj) {
	  jclass tempClass = gdx_getTempClassMatrix4(jenv);
	  
	  static jfieldID poolField = NULL;
	  if (poolField == NULL) {
		poolField = jenv->GetStaticFieldID(tempClass, poolName, "Lcom/badlogic/gdx/utils/Pool;");
	  }
	  
	  jobject poolObject = jenv->GetStaticObjectField(tempClass, poolField);
	  jclass poolClass = jenv->GetObjectClass(poolObject);
	  
	  static jmethodID freeMethod = NULL;
	  if (freeMethod == NULL) {
		freeMethod = (jmethodID) jenv->GetMethodID(poolClass, "free", "(Ljava/lang/Object;)V");
	  }
	  
	  jenv->CallVoidMethod(poolObject, freeMethod, obj);
	  
	  jenv->DeleteLocalRef(poolObject);
	  jenv->DeleteLocalRef(poolClass);
	  jenv->DeleteLocalRef(obj);
	}
	
	/*
	 * A simple RAII wrapper to release jobjects we obtain from pools in 
	 * directorin typemaps.  SWIG doesn't have hooks to release them after
	 * they're used. 
	 */
	class gdxPoolAutoReleaseMatrix4 {
	private:
	  JNIEnv * jenv;
	  const char * poolName;
	  jobject obj;
	public:
	  gdxPoolAutoReleaseMatrix4(JNIEnv * jenv, const char * poolName, jobject obj) : 
		jenv(jenv), poolName(poolName), obj(obj) { };
	  virtual ~gdxPoolAutoReleaseMatrix4() {
		gdx_releasePoolObjectMatrix4(this->jenv, this->poolName, this->obj);
	  };
	};


	
// Workaround for some strange swig behaviour


	/* Gets a global ref to the temp class's Return Matrix4.  Do not release this. */ 
	SWIGINTERN inline jobject gdx_getReturnMatrix4(JNIEnv * jenv) {
	  static jobject ret = NULL;
	  if (ret == NULL) {
	    jclass tempClass = gdx_getTempClassMatrix4(jenv);
	    jfieldID field = jenv->GetStaticFieldID(tempClass, "staticMatrix4", "Lcom/badlogic/gdx/math/Matrix4;");
	    ret = jenv->NewGlobalRef(jenv->GetStaticObjectField(tempClass, field));
	  }
	  return ret;
	}
	
	/* Sets the data in the Bullet type from the Gdx type. */
	SWIGINTERN inline void gdx_setbtTransformFromMatrix4(JNIEnv * jenv, btTransform & target, jobject source) {
		Matrix4_to_btTransform(jenv, target, source);
	}

	SWIGINTERN inline void gdx_setbtTransformFromMatrix4(JNIEnv * jenv, btTransform * target, jobject source) {
		gdx_setbtTransformFromMatrix4(jenv, *target, source);
	}

	/* Sets the data in the Gdx type from the Bullet type. */
	SWIGINTERN inline void gdx_setMatrix4FrombtTransform(JNIEnv * jenv, jobject target, const btTransform & source) {
		btTransform_to_Matrix4(jenv, target, source);
	}

	SWIGINTERN inline void gdx_setMatrix4FrombtTransform(JNIEnv * jenv, jobject target, const btTransform * source) {
		gdx_setMatrix4FrombtTransform(jenv, target, *source);
	}

	/*
	 * RAII wrapper to commit changes made to a local btTransform back to Matrix4
	 */
	class gdxAutoCommitMatrix4 {
	private:
	  JNIEnv * jenv;
	  jobject jMatrix4;
	  btTransform & cbtTransform;
	public:
	  gdxAutoCommitMatrix4(JNIEnv * jenv, jobject jMatrix4, btTransform & cbtTransform) : 
	    jenv(jenv), jMatrix4(jMatrix4), cbtTransform(cbtTransform) { };
	  gdxAutoCommitMatrix4(JNIEnv * jenv, jobject jMatrix4, btTransform * cbtTransform) : 
	    jenv(jenv), jMatrix4(jMatrix4), cbtTransform(*cbtTransform) { };
	  virtual ~gdxAutoCommitMatrix4() {
	    gdx_setMatrix4FrombtTransform(this->jenv, this->jMatrix4, this->cbtTransform);
	  };
	};

	class gdxAutoCommitbtTransformAndReleaseMatrix4 {
	private:
	  JNIEnv * jenv;
	  jobject jMatrix4;
	  btTransform & cbtTransform;
	  const char * poolName;
	public:
	  gdxAutoCommitbtTransformAndReleaseMatrix4(JNIEnv * jenv, jobject jMatrix4, btTransform & cbtTransform, const char *poolName) : 
	    jenv(jenv), jMatrix4(jMatrix4), cbtTransform(cbtTransform), poolName(poolName) { };
	  gdxAutoCommitbtTransformAndReleaseMatrix4(JNIEnv * jenv, jobject jMatrix4, btTransform * cbtTransform, const char *poolName) : 
	    jenv(jenv), jMatrix4(jMatrix4), cbtTransform(*cbtTransform), poolName(poolName) { };
	  virtual ~gdxAutoCommitbtTransformAndReleaseMatrix4() {
	    gdx_setbtTransformFromMatrix4(this->jenv, this->cbtTransform, this->jMatrix4);
	    gdx_releasePoolObjectMatrix4(this->jenv, this->poolName, this->jMatrix4);
	  };
	};


#include <LinearMath/btVector3.h>


#include <LinearMath/btQuadWord.h>


#include <LinearMath/btQuaternion.h>


#include <LinearMath/btMatrix3x3.h>


#include <LinearMath/btAabbUtil2.h>


#include <LinearMath/btIDebugDraw.h>


#include <LinearMath/btGeometryUtil.h>

bool btGeometryUtil::isInside(btAlignedObjectArray<btVector3> const&, btVector3 const&, float)
{
	return false;
}


#include <LinearMath/btRandom.h>


#include <LinearMath/btTransformUtil.h>


#include <LinearMath/btConvexHull.h>


#include <LinearMath/btGrahamScan2dConvexHull.h>


#include <LinearMath/btPoolAllocator.h>


#include <LinearMath/btQuickprof.h>


#include <LinearMath/btConvexHullComputer.h>


#include <LinearMath/btAlignedObjectArray.h>


#include <LinearMath/btList.h>


#include <LinearMath/btAlignedAllocator.h>


#include <LinearMath/btHashMap.h>


#include <LinearMath/btStackAlloc.h>


#include <LinearMath/btMinMax.h>


#include <LinearMath/btMatrixX.h>


#include <LinearMath/btPolarDecomposition.h>


#include <LinearMath/btSerializer.h>


#include <LinearMath/btSpatialAlgebra.h>


#include <LinearMath/btStackAlloc.h>


#include <LinearMath/btThreads.h>


#include <LinearMath/btMotionState.h>


#include <LinearMath/btDefaultMotionState.h>

SWIGINTERN void btDefaultMotionState_getGraphicsWorldTrans(btDefaultMotionState *self,btTransform &out){
		out = self->m_graphicsWorldTrans;
	}
SWIGINTERN void btDefaultMotionState_getCenterOfMassOffset(btDefaultMotionState *self,btTransform &out){
		out = self->m_centerOfMassOffset;
	}
SWIGINTERN void btDefaultMotionState_getStartWorldTrans(btDefaultMotionState *self,btTransform &out){
		out = self->m_startWorldTrans;
	}


/* ---------------------------------------------------
 * C++ director class methods
 * --------------------------------------------------- */

#include "linearmath_wrap.h"

SwigDirector_btIDebugDraw::SwigDirector_btIDebugDraw(JNIEnv *jenv) : btIDebugDraw(), Swig::Director(jenv) {
}

SwigDirector_btIDebugDraw::~SwigDirector_btIDebugDraw() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


btIDebugDraw::DefaultColors SwigDirector_btIDebugDraw::getDefaultColors() const {
  btIDebugDraw::DefaultColors c_result ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  btIDebugDraw::DefaultColors *argp ;
  
  if (!swig_override[0]) {
    return btIDebugDraw::getDefaultColors();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_LinearMathJNI, Swig::director_method_ids[0], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    argp = *(btIDebugDraw::DefaultColors **)&jresult; 
    if (!argp) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Unexpected null return for type btIDebugDraw::DefaultColors");
      return c_result;
    }
    c_result = *argp; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btIDebugDraw::getDefaultColors ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_btIDebugDraw::setDefaultColors(btIDebugDraw::DefaultColors const &arg0) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jarg0 = 0 ;
  
  if (!swig_override[1]) {
    btIDebugDraw::setDefaultColors(arg0);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(btIDebugDraw::DefaultColors **)&jarg0 = (btIDebugDraw::DefaultColors *) &arg0; 
    jenv->CallStaticVoidMethod(Swig::jclass_LinearMathJNI, Swig::director_method_ids[1], swigjobj, jarg0);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btIDebugDraw::setDefaultColors ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_btIDebugDraw::drawLine(btVector3 const &from, btVector3 const &to, btVector3 const &color) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jobject jfrom = 0 ;
  jobject jto = 0 ;
  jobject jcolor = 0 ;
  
  if (!swig_override[2]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method btIDebugDraw::drawLine.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jfrom = gdx_takePoolObjectVector3(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jfrom, from);
    gdxPoolAutoReleaseVector3 autoRelease_jfrom(jenv, "poolVector3", jfrom);
    jto = gdx_takePoolObjectVector3(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jto, to);
    gdxPoolAutoReleaseVector3 autoRelease_jto(jenv, "poolVector3", jto);
    jcolor = gdx_takePoolObjectVector3(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jcolor, color);
    gdxPoolAutoReleaseVector3 autoRelease_jcolor(jenv, "poolVector3", jcolor);
    jenv->CallStaticVoidMethod(Swig::jclass_LinearMathJNI, Swig::director_method_ids[2], swigjobj, jfrom, jto, jcolor);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btIDebugDraw::drawLine ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_btIDebugDraw::drawLine(btVector3 const &from, btVector3 const &to, btVector3 const &fromColor, btVector3 const &toColor) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jobject jfrom = 0 ;
  jobject jto = 0 ;
  jobject jfromColor = 0 ;
  jobject jtoColor = 0 ;
  
  if (!swig_override[3]) {
    btIDebugDraw::drawLine(from,to,fromColor,toColor);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jfrom = gdx_takePoolObjectVector3(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jfrom, from);
    gdxPoolAutoReleaseVector3 autoRelease_jfrom(jenv, "poolVector3", jfrom);
    jto = gdx_takePoolObjectVector3(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jto, to);
    gdxPoolAutoReleaseVector3 autoRelease_jto(jenv, "poolVector3", jto);
    jfromColor = gdx_takePoolObjectVector3(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jfromColor, fromColor);
    gdxPoolAutoReleaseVector3 autoRelease_jfromColor(jenv, "poolVector3", jfromColor);
    jtoColor = gdx_takePoolObjectVector3(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jtoColor, toColor);
    gdxPoolAutoReleaseVector3 autoRelease_jtoColor(jenv, "poolVector3", jtoColor);
    jenv->CallStaticVoidMethod(Swig::jclass_LinearMathJNI, Swig::director_method_ids[3], swigjobj, jfrom, jto, jfromColor, jtoColor);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btIDebugDraw::drawLine ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_btIDebugDraw::drawSphere(btScalar radius, btTransform const &transform, btVector3 const &color) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jfloat jradius  ;
  jobject jtransform = 0 ;
  jobject jcolor = 0 ;
  
  if (!swig_override[4]) {
    btIDebugDraw::drawSphere(radius,transform,color);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jradius = (jfloat) radius;
    jtransform = gdx_takePoolObjectMatrix4(jenv, "poolMatrix4");
    gdx_setMatrix4FrombtTransform(jenv, jtransform, transform);
    gdxPoolAutoReleaseMatrix4 autoRelease_jtransform(jenv, "poolMatrix4", jtransform);
    jcolor = gdx_takePoolObjectVector3(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jcolor, color);
    gdxPoolAutoReleaseVector3 autoRelease_jcolor(jenv, "poolVector3", jcolor);
    jenv->CallStaticVoidMethod(Swig::jclass_LinearMathJNI, Swig::director_method_ids[4], swigjobj, jradius, jtransform, jcolor);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btIDebugDraw::drawSphere ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_btIDebugDraw::drawSphere(btVector3 const &p, btScalar radius, btVector3 const &color) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jobject jp = 0 ;
  jfloat jradius  ;
  jobject jcolor = 0 ;
  
  if (!swig_override[5]) {
    btIDebugDraw::drawSphere(p,radius,color);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jp = gdx_takePoolObjectVector3(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jp, p);
    gdxPoolAutoReleaseVector3 autoRelease_jp(jenv, "poolVector3", jp);
    jradius = (jfloat) radius;
    jcolor = gdx_takePoolObjectVector3(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jcolor, color);
    gdxPoolAutoReleaseVector3 autoRelease_jcolor(jenv, "poolVector3", jcolor);
    jenv->CallStaticVoidMethod(Swig::jclass_LinearMathJNI, Swig::director_method_ids[5], swigjobj, jp, jradius, jcolor);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btIDebugDraw::drawSphere ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_btIDebugDraw::drawTriangle(btVector3 const &v0, btVector3 const &v1, btVector3 const &v2, btVector3 const &arg3, btVector3 const &arg4, btVector3 const &arg5, btVector3 const &color, btScalar alpha) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jobject jv0 = 0 ;
  jobject jv1 = 0 ;
  jobject jv2 = 0 ;
  jobject jarg3 = 0 ;
  jobject jarg4 = 0 ;
  jobject jarg5 = 0 ;
  jobject jcolor = 0 ;
  jfloat jalpha  ;
  
  if (!swig_override[6]) {
    btIDebugDraw::drawTriangle(v0,v1,v2,arg3,arg4,arg5,color,alpha);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jv0 = gdx_takePoolObjectVector3(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jv0, v0);
    gdxPoolAutoReleaseVector3 autoRelease_jv0(jenv, "poolVector3", jv0);
    jv1 = gdx_takePoolObjectVector3(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jv1, v1);
    gdxPoolAutoReleaseVector3 autoRelease_jv1(jenv, "poolVector3", jv1);
    jv2 = gdx_takePoolObjectVector3(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jv2, v2);
    gdxPoolAutoReleaseVector3 autoRelease_jv2(jenv, "poolVector3", jv2);
    jarg3 = gdx_takePoolObjectVector3(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jarg3, arg3);
    gdxPoolAutoReleaseVector3 autoRelease_jarg3(jenv, "poolVector3", jarg3);
    jarg4 = gdx_takePoolObjectVector3(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jarg4, arg4);
    gdxPoolAutoReleaseVector3 autoRelease_jarg4(jenv, "poolVector3", jarg4);
    jarg5 = gdx_takePoolObjectVector3(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jarg5, arg5);
    gdxPoolAutoReleaseVector3 autoRelease_jarg5(jenv, "poolVector3", jarg5);
    jcolor = gdx_takePoolObjectVector3(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jcolor, color);
    gdxPoolAutoReleaseVector3 autoRelease_jcolor(jenv, "poolVector3", jcolor);
    jalpha = (jfloat) alpha;
    jenv->CallStaticVoidMethod(Swig::jclass_LinearMathJNI, Swig::director_method_ids[6], swigjobj, jv0, jv1, jv2, jarg3, jarg4, jarg5, jcolor, jalpha);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btIDebugDraw::drawTriangle ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_btIDebugDraw::drawTriangle(btVector3 const &v0, btVector3 const &v1, btVector3 const &v2, btVector3 const &color, btScalar arg4) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jobject jv0 = 0 ;
  jobject jv1 = 0 ;
  jobject jv2 = 0 ;
  jobject jcolor = 0 ;
  jfloat jarg4  ;
  
  if (!swig_override[7]) {
    btIDebugDraw::drawTriangle(v0,v1,v2,color,arg4);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jv0 = gdx_takePoolObjectVector3(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jv0, v0);
    gdxPoolAutoReleaseVector3 autoRelease_jv0(jenv, "poolVector3", jv0);
    jv1 = gdx_takePoolObjectVector3(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jv1, v1);
    gdxPoolAutoReleaseVector3 autoRelease_jv1(jenv, "poolVector3", jv1);
    jv2 = gdx_takePoolObjectVector3(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jv2, v2);
    gdxPoolAutoReleaseVector3 autoRelease_jv2(jenv, "poolVector3", jv2);
    jcolor = gdx_takePoolObjectVector3(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jcolor, color);
    gdxPoolAutoReleaseVector3 autoRelease_jcolor(jenv, "poolVector3", jcolor);
    jarg4 = (jfloat) arg4;
    jenv->CallStaticVoidMethod(Swig::jclass_LinearMathJNI, Swig::director_method_ids[7], swigjobj, jv0, jv1, jv2, jcolor, jarg4);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btIDebugDraw::drawTriangle ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_btIDebugDraw::drawContactPoint(btVector3 const &PointOnB, btVector3 const &normalOnB, btScalar distance, int lifeTime, btVector3 const &color) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jobject jPointOnB = 0 ;
  jobject jnormalOnB = 0 ;
  jfloat jdistance  ;
  jint jlifeTime  ;
  jobject jcolor = 0 ;
  
  if (!swig_override[8]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method btIDebugDraw::drawContactPoint.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jPointOnB = gdx_takePoolObjectVector3(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jPointOnB, PointOnB);
    gdxPoolAutoReleaseVector3 autoRelease_jPointOnB(jenv, "poolVector3", jPointOnB);
    jnormalOnB = gdx_takePoolObjectVector3(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jnormalOnB, normalOnB);
    gdxPoolAutoReleaseVector3 autoRelease_jnormalOnB(jenv, "poolVector3", jnormalOnB);
    jdistance = (jfloat) distance;
    jlifeTime = (jint) lifeTime;
    jcolor = gdx_takePoolObjectVector3(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jcolor, color);
    gdxPoolAutoReleaseVector3 autoRelease_jcolor(jenv, "poolVector3", jcolor);
    jenv->CallStaticVoidMethod(Swig::jclass_LinearMathJNI, Swig::director_method_ids[8], swigjobj, jPointOnB, jnormalOnB, jdistance, jlifeTime, jcolor);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btIDebugDraw::drawContactPoint ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_btIDebugDraw::reportErrorWarning(char const *warningString) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jstring jwarningString = 0 ;
  
  if (!swig_override[9]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method btIDebugDraw::reportErrorWarning.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jwarningString = 0;
    if (warningString) {
      jwarningString = jenv->NewStringUTF((const char *)warningString);
      if (!jwarningString) return ;
    }
    Swig::LocalRefGuard warningString_refguard(jenv, jwarningString);
    jenv->CallStaticVoidMethod(Swig::jclass_LinearMathJNI, Swig::director_method_ids[9], swigjobj, jwarningString);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btIDebugDraw::reportErrorWarning ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_btIDebugDraw::draw3dText(btVector3 const &location, char const *textString) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jobject jlocation = 0 ;
  jstring jtextString = 0 ;
  
  if (!swig_override[10]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method btIDebugDraw::draw3dText.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jlocation = gdx_takePoolObjectVector3(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jlocation, location);
    gdxPoolAutoReleaseVector3 autoRelease_jlocation(jenv, "poolVector3", jlocation);
    jtextString = 0;
    if (textString) {
      jtextString = jenv->NewStringUTF((const char *)textString);
      if (!jtextString) return ;
    }
    Swig::LocalRefGuard textString_refguard(jenv, jtextString);
    jenv->CallStaticVoidMethod(Swig::jclass_LinearMathJNI, Swig::director_method_ids[10], swigjobj, jlocation, jtextString);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btIDebugDraw::draw3dText ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_btIDebugDraw::setDebugMode(int debugMode) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jint jdebugMode  ;
  
  if (!swig_override[11]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method btIDebugDraw::setDebugMode.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jdebugMode = (jint) debugMode;
    jenv->CallStaticVoidMethod(Swig::jclass_LinearMathJNI, Swig::director_method_ids[11], swigjobj, jdebugMode);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btIDebugDraw::setDebugMode ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

int SwigDirector_btIDebugDraw::getDebugMode() const {
  int c_result = SwigValueInit< int >() ;
  jint jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[12]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method btIDebugDraw::getDebugMode.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jint) jenv->CallStaticIntMethod(Swig::jclass_LinearMathJNI, Swig::director_method_ids[12], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = (int)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btIDebugDraw::getDebugMode ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_btIDebugDraw::drawAabb(btVector3 const &from, btVector3 const &to, btVector3 const &color) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jobject jfrom = 0 ;
  jobject jto = 0 ;
  jobject jcolor = 0 ;
  
  if (!swig_override[13]) {
    btIDebugDraw::drawAabb(from,to,color);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jfrom = gdx_takePoolObjectVector3(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jfrom, from);
    gdxPoolAutoReleaseVector3 autoRelease_jfrom(jenv, "poolVector3", jfrom);
    jto = gdx_takePoolObjectVector3(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jto, to);
    gdxPoolAutoReleaseVector3 autoRelease_jto(jenv, "poolVector3", jto);
    jcolor = gdx_takePoolObjectVector3(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jcolor, color);
    gdxPoolAutoReleaseVector3 autoRelease_jcolor(jenv, "poolVector3", jcolor);
    jenv->CallStaticVoidMethod(Swig::jclass_LinearMathJNI, Swig::director_method_ids[13], swigjobj, jfrom, jto, jcolor);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btIDebugDraw::drawAabb ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_btIDebugDraw::drawTransform(btTransform const &transform, btScalar orthoLen) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jobject jtransform = 0 ;
  jfloat jorthoLen  ;
  
  if (!swig_override[14]) {
    btIDebugDraw::drawTransform(transform,orthoLen);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jtransform = gdx_takePoolObjectMatrix4(jenv, "poolMatrix4");
    gdx_setMatrix4FrombtTransform(jenv, jtransform, transform);
    gdxPoolAutoReleaseMatrix4 autoRelease_jtransform(jenv, "poolMatrix4", jtransform);
    jorthoLen = (jfloat) orthoLen;
    jenv->CallStaticVoidMethod(Swig::jclass_LinearMathJNI, Swig::director_method_ids[14], swigjobj, jtransform, jorthoLen);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btIDebugDraw::drawTransform ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_btIDebugDraw::drawArc(btVector3 const &center, btVector3 const &normal, btVector3 const &axis, btScalar radiusA, btScalar radiusB, btScalar minAngle, btScalar maxAngle, btVector3 const &color, bool drawSect, btScalar stepDegrees) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jobject jcenter = 0 ;
  jobject jnormal = 0 ;
  jobject jaxis = 0 ;
  jfloat jradiusA  ;
  jfloat jradiusB  ;
  jfloat jminAngle  ;
  jfloat jmaxAngle  ;
  jobject jcolor = 0 ;
  jboolean jdrawSect  ;
  jfloat jstepDegrees  ;
  
  if (!swig_override[15]) {
    btIDebugDraw::drawArc(center,normal,axis,radiusA,radiusB,minAngle,maxAngle,color,drawSect,stepDegrees);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jcenter = gdx_takePoolObjectVector3(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jcenter, center);
    gdxPoolAutoReleaseVector3 autoRelease_jcenter(jenv, "poolVector3", jcenter);
    jnormal = gdx_takePoolObjectVector3(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jnormal, normal);
    gdxPoolAutoReleaseVector3 autoRelease_jnormal(jenv, "poolVector3", jnormal);
    jaxis = gdx_takePoolObjectVector3(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jaxis, axis);
    gdxPoolAutoReleaseVector3 autoRelease_jaxis(jenv, "poolVector3", jaxis);
    jradiusA = (jfloat) radiusA;
    jradiusB = (jfloat) radiusB;
    jminAngle = (jfloat) minAngle;
    jmaxAngle = (jfloat) maxAngle;
    jcolor = gdx_takePoolObjectVector3(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jcolor, color);
    gdxPoolAutoReleaseVector3 autoRelease_jcolor(jenv, "poolVector3", jcolor);
    jdrawSect = (jboolean) drawSect;
    jstepDegrees = (jfloat) stepDegrees;
    jenv->CallStaticVoidMethod(Swig::jclass_LinearMathJNI, Swig::director_method_ids[15], swigjobj, jcenter, jnormal, jaxis, jradiusA, jradiusB, jminAngle, jmaxAngle, jcolor, jdrawSect, jstepDegrees);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btIDebugDraw::drawArc ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_btIDebugDraw::drawSpherePatch(btVector3 const &center, btVector3 const &up, btVector3 const &axis, btScalar radius, btScalar minTh, btScalar maxTh, btScalar minPs, btScalar maxPs, btVector3 const &color, btScalar stepDegrees, bool drawCenter) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jobject jcenter = 0 ;
  jobject jup = 0 ;
  jobject jaxis = 0 ;
  jfloat jradius  ;
  jfloat jminTh  ;
  jfloat jmaxTh  ;
  jfloat jminPs  ;
  jfloat jmaxPs  ;
  jobject jcolor = 0 ;
  jfloat jstepDegrees  ;
  jboolean jdrawCenter  ;
  
  if (!swig_override[17]) {
    btIDebugDraw::drawSpherePatch(center,up,axis,radius,minTh,maxTh,minPs,maxPs,color,stepDegrees,drawCenter);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jcenter = gdx_takePoolObjectVector3(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jcenter, center);
    gdxPoolAutoReleaseVector3 autoRelease_jcenter(jenv, "poolVector3", jcenter);
    jup = gdx_takePoolObjectVector3(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jup, up);
    gdxPoolAutoReleaseVector3 autoRelease_jup(jenv, "poolVector3", jup);
    jaxis = gdx_takePoolObjectVector3(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jaxis, axis);
    gdxPoolAutoReleaseVector3 autoRelease_jaxis(jenv, "poolVector3", jaxis);
    jradius = (jfloat) radius;
    jminTh = (jfloat) minTh;
    jmaxTh = (jfloat) maxTh;
    jminPs = (jfloat) minPs;
    jmaxPs = (jfloat) maxPs;
    jcolor = gdx_takePoolObjectVector3(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jcolor, color);
    gdxPoolAutoReleaseVector3 autoRelease_jcolor(jenv, "poolVector3", jcolor);
    jstepDegrees = (jfloat) stepDegrees;
    jdrawCenter = (jboolean) drawCenter;
    jenv->CallStaticVoidMethod(Swig::jclass_LinearMathJNI, Swig::director_method_ids[17], swigjobj, jcenter, jup, jaxis, jradius, jminTh, jmaxTh, jminPs, jmaxPs, jcolor, jstepDegrees, jdrawCenter);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btIDebugDraw::drawSpherePatch ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_btIDebugDraw::drawBox(btVector3 const &bbMin, btVector3 const &bbMax, btVector3 const &color) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jobject jbbMin = 0 ;
  jobject jbbMax = 0 ;
  jobject jcolor = 0 ;
  
  if (!swig_override[20]) {
    btIDebugDraw::drawBox(bbMin,bbMax,color);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jbbMin = gdx_takePoolObjectVector3(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jbbMin, bbMin);
    gdxPoolAutoReleaseVector3 autoRelease_jbbMin(jenv, "poolVector3", jbbMin);
    jbbMax = gdx_takePoolObjectVector3(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jbbMax, bbMax);
    gdxPoolAutoReleaseVector3 autoRelease_jbbMax(jenv, "poolVector3", jbbMax);
    jcolor = gdx_takePoolObjectVector3(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jcolor, color);
    gdxPoolAutoReleaseVector3 autoRelease_jcolor(jenv, "poolVector3", jcolor);
    jenv->CallStaticVoidMethod(Swig::jclass_LinearMathJNI, Swig::director_method_ids[20], swigjobj, jbbMin, jbbMax, jcolor);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btIDebugDraw::drawBox ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_btIDebugDraw::drawBox(btVector3 const &bbMin, btVector3 const &bbMax, btTransform const &trans, btVector3 const &color) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jobject jbbMin = 0 ;
  jobject jbbMax = 0 ;
  jobject jtrans = 0 ;
  jobject jcolor = 0 ;
  
  if (!swig_override[21]) {
    btIDebugDraw::drawBox(bbMin,bbMax,trans,color);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jbbMin = gdx_takePoolObjectVector3(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jbbMin, bbMin);
    gdxPoolAutoReleaseVector3 autoRelease_jbbMin(jenv, "poolVector3", jbbMin);
    jbbMax = gdx_takePoolObjectVector3(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jbbMax, bbMax);
    gdxPoolAutoReleaseVector3 autoRelease_jbbMax(jenv, "poolVector3", jbbMax);
    jtrans = gdx_takePoolObjectMatrix4(jenv, "poolMatrix4");
    gdx_setMatrix4FrombtTransform(jenv, jtrans, trans);
    gdxPoolAutoReleaseMatrix4 autoRelease_jtrans(jenv, "poolMatrix4", jtrans);
    jcolor = gdx_takePoolObjectVector3(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jcolor, color);
    gdxPoolAutoReleaseVector3 autoRelease_jcolor(jenv, "poolVector3", jcolor);
    jenv->CallStaticVoidMethod(Swig::jclass_LinearMathJNI, Swig::director_method_ids[21], swigjobj, jbbMin, jbbMax, jtrans, jcolor);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btIDebugDraw::drawBox ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_btIDebugDraw::drawCapsule(btScalar radius, btScalar halfHeight, int upAxis, btTransform const &transform, btVector3 const &color) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jfloat jradius  ;
  jfloat jhalfHeight  ;
  jint jupAxis  ;
  jobject jtransform = 0 ;
  jobject jcolor = 0 ;
  
  if (!swig_override[22]) {
    btIDebugDraw::drawCapsule(radius,halfHeight,upAxis,transform,color);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jradius = (jfloat) radius;
    jhalfHeight = (jfloat) halfHeight;
    jupAxis = (jint) upAxis;
    jtransform = gdx_takePoolObjectMatrix4(jenv, "poolMatrix4");
    gdx_setMatrix4FrombtTransform(jenv, jtransform, transform);
    gdxPoolAutoReleaseMatrix4 autoRelease_jtransform(jenv, "poolMatrix4", jtransform);
    jcolor = gdx_takePoolObjectVector3(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jcolor, color);
    gdxPoolAutoReleaseVector3 autoRelease_jcolor(jenv, "poolVector3", jcolor);
    jenv->CallStaticVoidMethod(Swig::jclass_LinearMathJNI, Swig::director_method_ids[22], swigjobj, jradius, jhalfHeight, jupAxis, jtransform, jcolor);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btIDebugDraw::drawCapsule ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_btIDebugDraw::drawCylinder(btScalar radius, btScalar halfHeight, int upAxis, btTransform const &transform, btVector3 const &color) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jfloat jradius  ;
  jfloat jhalfHeight  ;
  jint jupAxis  ;
  jobject jtransform = 0 ;
  jobject jcolor = 0 ;
  
  if (!swig_override[23]) {
    btIDebugDraw::drawCylinder(radius,halfHeight,upAxis,transform,color);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jradius = (jfloat) radius;
    jhalfHeight = (jfloat) halfHeight;
    jupAxis = (jint) upAxis;
    jtransform = gdx_takePoolObjectMatrix4(jenv, "poolMatrix4");
    gdx_setMatrix4FrombtTransform(jenv, jtransform, transform);
    gdxPoolAutoReleaseMatrix4 autoRelease_jtransform(jenv, "poolMatrix4", jtransform);
    jcolor = gdx_takePoolObjectVector3(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jcolor, color);
    gdxPoolAutoReleaseVector3 autoRelease_jcolor(jenv, "poolVector3", jcolor);
    jenv->CallStaticVoidMethod(Swig::jclass_LinearMathJNI, Swig::director_method_ids[23], swigjobj, jradius, jhalfHeight, jupAxis, jtransform, jcolor);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btIDebugDraw::drawCylinder ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_btIDebugDraw::drawCone(btScalar radius, btScalar height, int upAxis, btTransform const &transform, btVector3 const &color) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jfloat jradius  ;
  jfloat jheight  ;
  jint jupAxis  ;
  jobject jtransform = 0 ;
  jobject jcolor = 0 ;
  
  if (!swig_override[24]) {
    btIDebugDraw::drawCone(radius,height,upAxis,transform,color);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jradius = (jfloat) radius;
    jheight = (jfloat) height;
    jupAxis = (jint) upAxis;
    jtransform = gdx_takePoolObjectMatrix4(jenv, "poolMatrix4");
    gdx_setMatrix4FrombtTransform(jenv, jtransform, transform);
    gdxPoolAutoReleaseMatrix4 autoRelease_jtransform(jenv, "poolMatrix4", jtransform);
    jcolor = gdx_takePoolObjectVector3(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jcolor, color);
    gdxPoolAutoReleaseVector3 autoRelease_jcolor(jenv, "poolVector3", jcolor);
    jenv->CallStaticVoidMethod(Swig::jclass_LinearMathJNI, Swig::director_method_ids[24], swigjobj, jradius, jheight, jupAxis, jtransform, jcolor);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btIDebugDraw::drawCone ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_btIDebugDraw::drawPlane(btVector3 const &planeNormal, btScalar planeConst, btTransform const &transform, btVector3 const &color) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jobject jplaneNormal = 0 ;
  jfloat jplaneConst  ;
  jobject jtransform = 0 ;
  jobject jcolor = 0 ;
  
  if (!swig_override[25]) {
    btIDebugDraw::drawPlane(planeNormal,planeConst,transform,color);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jplaneNormal = gdx_takePoolObjectVector3(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jplaneNormal, planeNormal);
    gdxPoolAutoReleaseVector3 autoRelease_jplaneNormal(jenv, "poolVector3", jplaneNormal);
    jplaneConst = (jfloat) planeConst;
    jtransform = gdx_takePoolObjectMatrix4(jenv, "poolMatrix4");
    gdx_setMatrix4FrombtTransform(jenv, jtransform, transform);
    gdxPoolAutoReleaseMatrix4 autoRelease_jtransform(jenv, "poolMatrix4", jtransform);
    jcolor = gdx_takePoolObjectVector3(jenv, "poolVector3");
    gdx_setVector3FrombtVector3(jenv, jcolor, color);
    gdxPoolAutoReleaseVector3 autoRelease_jcolor(jenv, "poolVector3", jcolor);
    jenv->CallStaticVoidMethod(Swig::jclass_LinearMathJNI, Swig::director_method_ids[25], swigjobj, jplaneNormal, jplaneConst, jtransform, jcolor);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btIDebugDraw::drawPlane ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_btIDebugDraw::clearLines() {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[26]) {
    btIDebugDraw::clearLines();
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jenv->CallStaticVoidMethod(Swig::jclass_LinearMathJNI, Swig::director_method_ids[26], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btIDebugDraw::clearLines ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_btIDebugDraw::flushLines() {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[27]) {
    btIDebugDraw::flushLines();
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jenv->CallStaticVoidMethod(Swig::jclass_LinearMathJNI, Swig::director_method_ids[27], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btIDebugDraw::flushLines ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_btIDebugDraw::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "getDefaultColors", "()Lcom/badlogic/gdx/physics/bullet/linearmath/btIDebugDraw$DefaultColors;", NULL 
    },
    {
      "setDefaultColors", "(Lcom/badlogic/gdx/physics/bullet/linearmath/btIDebugDraw$DefaultColors;)V", NULL 
    },
    {
      "drawLine", "(Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;)V", NULL 
    },
    {
      "drawLine", "(Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;)V", NULL 
    },
    {
      "drawSphere", "(FLcom/badlogic/gdx/math/Matrix4;Lcom/badlogic/gdx/math/Vector3;)V", NULL 
    },
    {
      "drawSphere", "(Lcom/badlogic/gdx/math/Vector3;FLcom/badlogic/gdx/math/Vector3;)V", NULL 
    },
    {
      "drawTriangle", "(Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;F)V", NULL 
    },
    {
      "drawTriangle", "(Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;F)V", NULL 
    },
    {
      "drawContactPoint", "(Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;FILcom/badlogic/gdx/math/Vector3;)V", NULL 
    },
    {
      "reportErrorWarning", "(Ljava/lang/String;)V", NULL 
    },
    {
      "draw3dText", "(Lcom/badlogic/gdx/math/Vector3;Ljava/lang/String;)V", NULL 
    },
    {
      "setDebugMode", "(I)V", NULL 
    },
    {
      "getDebugMode", "()I", NULL 
    },
    {
      "drawAabb", "(Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;)V", NULL 
    },
    {
      "drawTransform", "(Lcom/badlogic/gdx/math/Matrix4;F)V", NULL 
    },
    {
      "drawArc", "(Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;FFFFLcom/badlogic/gdx/math/Vector3;ZF)V", NULL 
    },
    {
      "drawArc", "(Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;FFFFLcom/badlogic/gdx/math/Vector3;Z)V", NULL 
    },
    {
      "drawSpherePatch", "(Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;FFFFFLcom/badlogic/gdx/math/Vector3;FZ)V", NULL 
    },
    {
      "drawSpherePatch", "(Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;FFFFFLcom/badlogic/gdx/math/Vector3;F)V", NULL 
    },
    {
      "drawSpherePatch", "(Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;FFFFFLcom/badlogic/gdx/math/Vector3;)V", NULL 
    },
    {
      "drawBox", "(Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;)V", NULL 
    },
    {
      "drawBox", "(Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Matrix4;Lcom/badlogic/gdx/math/Vector3;)V", NULL 
    },
    {
      "drawCapsule", "(FFILcom/badlogic/gdx/math/Matrix4;Lcom/badlogic/gdx/math/Vector3;)V", NULL 
    },
    {
      "drawCylinder", "(FFILcom/badlogic/gdx/math/Matrix4;Lcom/badlogic/gdx/math/Vector3;)V", NULL 
    },
    {
      "drawCone", "(FFILcom/badlogic/gdx/math/Matrix4;Lcom/badlogic/gdx/math/Vector3;)V", NULL 
    },
    {
      "drawPlane", "(Lcom/badlogic/gdx/math/Vector3;FLcom/badlogic/gdx/math/Matrix4;Lcom/badlogic/gdx/math/Vector3;)V", NULL 
    },
    {
      "clearLines", "()V", NULL 
    },
    {
      "flushLines", "()V", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/badlogic/gdx/physics/bullet/linearmath/btIDebugDraw");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 28; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_btMotionState::SwigDirector_btMotionState(JNIEnv *jenv) : btMotionState(), Swig::Director(jenv) {
}

SwigDirector_btMotionState::~SwigDirector_btMotionState() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_btMotionState::getWorldTransform(btTransform &worldTrans) const {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jobject jworldTrans = 0 ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method btMotionState::getWorldTransform.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jworldTrans = gdx_takePoolObjectMatrix4(jenv, "poolMatrix4");
    gdx_setMatrix4FrombtTransform(jenv, jworldTrans, worldTrans);
    gdxAutoCommitbtTransformAndReleaseMatrix4 auto_commit_worldTrans(jenv, jworldTrans, &worldTrans, "poolMatrix4");
    jenv->CallStaticVoidMethod(Swig::jclass_LinearMathJNI, Swig::director_method_ids[28], swigjobj, jworldTrans);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btMotionState::getWorldTransform ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_btMotionState::setWorldTransform(btTransform const &worldTrans) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jobject jworldTrans = 0 ;
  
  if (!swig_override[1]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method btMotionState::setWorldTransform.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jworldTrans = gdx_takePoolObjectMatrix4(jenv, "poolMatrix4");
    gdx_setMatrix4FrombtTransform(jenv, jworldTrans, worldTrans);
    gdxPoolAutoReleaseMatrix4 autoRelease_jworldTrans(jenv, "poolMatrix4", jworldTrans);
    jenv->CallStaticVoidMethod(Swig::jclass_LinearMathJNI, Swig::director_method_ids[29], swigjobj, jworldTrans);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in btMotionState::setWorldTransform ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_btMotionState::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "getWorldTransform", "(Lcom/badlogic/gdx/math/Matrix4;)V", NULL 
    },
    {
      "setWorldTransform", "(Lcom/badlogic/gdx/math/Matrix4;)V", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/badlogic/gdx/physics/bullet/linearmath/btMotionState");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 2; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}



#ifdef __cplusplus
extern "C" {
#endif

SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btGetVersion(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)btGetVersion();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSqrt(JNIEnv *jenv, jclass jcls, jfloat jarg1) {
  jfloat jresult = 0 ;
  btScalar arg1 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  result = (btScalar)btSqrt(arg1);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btFabs(JNIEnv *jenv, jclass jcls, jfloat jarg1) {
  jfloat jresult = 0 ;
  btScalar arg1 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  result = (btScalar)btFabs(arg1);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btCos(JNIEnv *jenv, jclass jcls, jfloat jarg1) {
  jfloat jresult = 0 ;
  btScalar arg1 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  result = (btScalar)btCos(arg1);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSin(JNIEnv *jenv, jclass jcls, jfloat jarg1) {
  jfloat jresult = 0 ;
  btScalar arg1 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  result = (btScalar)btSin(arg1);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btTan(JNIEnv *jenv, jclass jcls, jfloat jarg1) {
  jfloat jresult = 0 ;
  btScalar arg1 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  result = (btScalar)btTan(arg1);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btAcos(JNIEnv *jenv, jclass jcls, jfloat jarg1) {
  jfloat jresult = 0 ;
  btScalar arg1 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  result = (btScalar)btAcos(arg1);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btAsin(JNIEnv *jenv, jclass jcls, jfloat jarg1) {
  jfloat jresult = 0 ;
  btScalar arg1 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  result = (btScalar)btAsin(arg1);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btAtan(JNIEnv *jenv, jclass jcls, jfloat jarg1) {
  jfloat jresult = 0 ;
  btScalar arg1 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  result = (btScalar)btAtan(arg1);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btAtan2(JNIEnv *jenv, jclass jcls, jfloat jarg1, jfloat jarg2) {
  jfloat jresult = 0 ;
  btScalar arg1 ;
  btScalar arg2 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  arg2 = (btScalar)jarg2; 
  result = (btScalar)btAtan2(arg1,arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btExp(JNIEnv *jenv, jclass jcls, jfloat jarg1) {
  jfloat jresult = 0 ;
  btScalar arg1 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  result = (btScalar)btExp(arg1);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btLog(JNIEnv *jenv, jclass jcls, jfloat jarg1) {
  jfloat jresult = 0 ;
  btScalar arg1 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  result = (btScalar)btLog(arg1);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btPow(JNIEnv *jenv, jclass jcls, jfloat jarg1, jfloat jarg2) {
  jfloat jresult = 0 ;
  btScalar arg1 ;
  btScalar arg2 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  arg2 = (btScalar)jarg2; 
  result = (btScalar)btPow(arg1,arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btFmod(JNIEnv *jenv, jclass jcls, jfloat jarg1, jfloat jarg2) {
  jfloat jresult = 0 ;
  btScalar arg1 ;
  btScalar arg2 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  arg2 = (btScalar)jarg2; 
  result = (btScalar)btFmod(arg1,arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btAtan2Fast(JNIEnv *jenv, jclass jcls, jfloat jarg1, jfloat jarg2) {
  jfloat jresult = 0 ;
  btScalar arg1 ;
  btScalar arg2 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  arg2 = (btScalar)jarg2; 
  result = (btScalar)btAtan2Fast(arg1,arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btFuzzyZero(JNIEnv *jenv, jclass jcls, jfloat jarg1) {
  jboolean jresult = 0 ;
  btScalar arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  result = (bool)btFuzzyZero(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btEqual(JNIEnv *jenv, jclass jcls, jfloat jarg1, jfloat jarg2) {
  jboolean jresult = 0 ;
  btScalar arg1 ;
  btScalar arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  arg2 = (btScalar)jarg2; 
  result = (bool)btEqual(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btGreaterEqual(JNIEnv *jenv, jclass jcls, jfloat jarg1, jfloat jarg2) {
  jboolean jresult = 0 ;
  btScalar arg1 ;
  btScalar arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  arg2 = (btScalar)jarg2; 
  result = (bool)btGreaterEqual(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIsNegative(JNIEnv *jenv, jclass jcls, jfloat jarg1) {
  jint jresult = 0 ;
  btScalar arg1 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  result = (int)btIsNegative(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btRadians(JNIEnv *jenv, jclass jcls, jfloat jarg1) {
  jfloat jresult = 0 ;
  btScalar arg1 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  result = (btScalar)btRadians(arg1);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btDegrees(JNIEnv *jenv, jclass jcls, jfloat jarg1) {
  jfloat jresult = 0 ;
  btScalar arg1 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  result = (btScalar)btDegrees(arg1);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btFsel(JNIEnv *jenv, jclass jcls, jfloat jarg1, jfloat jarg2, jfloat jarg3) {
  jfloat jresult = 0 ;
  btScalar arg1 ;
  btScalar arg2 ;
  btScalar arg3 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  arg2 = (btScalar)jarg2; 
  arg3 = (btScalar)jarg3; 
  result = (btScalar)btFsel(arg1,arg2,arg3);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btMachineIsLittleEndian(JNIEnv *jenv, jclass jcls) {
  jboolean jresult = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  result = (bool)btMachineIsLittleEndian();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSelect_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  unsigned int arg1 ;
  unsigned int arg2 ;
  unsigned int arg3 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (unsigned int)jarg1; 
  arg2 = (unsigned int)jarg2; 
  arg3 = (unsigned int)jarg3; 
  result = (unsigned int)btSelect(arg1,arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSelect_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3) {
  jint jresult = 0 ;
  unsigned int arg1 ;
  int arg2 ;
  int arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (unsigned int)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  result = (int)btSelect(arg1,arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSelect_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2, jfloat jarg3) {
  jfloat jresult = 0 ;
  unsigned int arg1 ;
  float arg2 ;
  float arg3 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (unsigned int)jarg1; 
  arg2 = (float)jarg2; 
  arg3 = (float)jarg3; 
  result = (float)btSelect(arg1,arg2,arg3);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSwapEndian_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  unsigned int arg1 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (unsigned int)jarg1; 
  result = (unsigned int)btSwapEndian(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSwapEndian_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jint jresult = 0 ;
  unsigned short arg1 ;
  unsigned short result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (unsigned short)jarg1; 
  result = (unsigned short)btSwapEndian(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSwapEndianInt(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  int arg1 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (unsigned int)btSwapEndian(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSwapEndian_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jshort jarg1) {
  jint jresult = 0 ;
  short arg1 ;
  unsigned short result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (short)jarg1; 
  result = (unsigned short)btSwapEndian(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSwapEndianFloat(JNIEnv *jenv, jclass jcls, jfloat jarg1) {
  jlong jresult = 0 ;
  float arg1 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (float)jarg1; 
  result = (unsigned int)btSwapEndianFloat(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btUnswapEndianFloat(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jfloat jresult = 0 ;
  unsigned int arg1 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (unsigned int)jarg1; 
  result = (float)btUnswapEndianFloat(arg1);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSwapEndianDouble(JNIEnv *jenv, jclass jcls, jdouble jarg1, jobject jarg2) {
  double arg1 ;
  unsigned char *arg2 = (unsigned char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (double)jarg1; 
  {
    arg2 = (unsigned char*)jenv->GetDirectBufferAddress(jarg2);
    if (arg2 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  btSwapEndianDouble(arg1,arg2);
  
}


SWIGEXPORT jdouble JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btUnswapEndianDouble(JNIEnv *jenv, jclass jcls, jobject jarg1) {
  jdouble jresult = 0 ;
  unsigned char *arg1 = (unsigned char *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  {
    arg1 = (unsigned char*)jenv->GetDirectBufferAddress(jarg1);
    if (arg1 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  result = (double)btUnswapEndianDouble((unsigned char const *)arg1);
  jresult = (jdouble)result; 
  
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btLargeDot(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jint jarg3) {
  jfloat jresult = 0 ;
  btScalar *arg1 = (btScalar *) 0 ;
  btScalar *arg2 = (btScalar *) 0 ;
  int arg3 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  {
    arg1 = (btScalar*)jenv->GetDirectBufferAddress(jarg1);
    if (arg1 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  {
    arg2 = (btScalar*)jenv->GetDirectBufferAddress(jarg2);
    if (arg2 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  arg3 = (int)jarg3; 
  result = (btScalar)btLargeDot((float const *)arg1,(float const *)arg2,arg3);
  jresult = (jfloat)result; 
  
  
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btNormalizeAngle(JNIEnv *jenv, jclass jcls, jfloat jarg1) {
  jfloat jresult = 0 ;
  btScalar arg1 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  result = (btScalar)btNormalizeAngle(arg1);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btTypedObject(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  int arg1 ;
  btTypedObject *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (btTypedObject *)new btTypedObject(arg1);
  *(btTypedObject **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btTypedObject_1objectType_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btTypedObject *arg1 = (btTypedObject *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedObject **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_objectType = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btTypedObject_1objectType_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btTypedObject *arg1 = (btTypedObject *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedObject **)&jarg1; 
  result = (int) ((arg1)->m_objectType);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_delete_1btTypedObject(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btTypedObject *arg1 = (btTypedObject *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btTypedObject **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btTransform_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btTransform *)new btTransform();
  *(btTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btTransform_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2) {
  jlong jresult = 0 ;
  btQuaternion *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btQuaternion local_arg1;
  gdx_setbtQuaternionFromQuaternion(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitQuaternion auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (btTransform *)new btTransform((btQuaternion const &)*arg1,(btVector3 const &)*arg2);
  *(btTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btTransform_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jobject jarg1) {
  jlong jresult = 0 ;
  btQuaternion *arg1 = 0 ;
  btTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btQuaternion local_arg1;
  gdx_setbtQuaternionFromQuaternion(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitQuaternion auto_commit_arg1(jenv, jarg1, &local_arg1);
  result = (btTransform *)new btTransform((btQuaternion const &)*arg1);
  *(btTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btTransform_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2) {
  jlong jresult = 0 ;
  btMatrix3x3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btMatrix3x3 local_arg1;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitMatrix3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (btTransform *)new btTransform((btMatrix3x3 const &)*arg1,(btVector3 const &)*arg2);
  *(btTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btTransform_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jobject jarg1) {
  jlong jresult = 0 ;
  btMatrix3x3 *arg1 = 0 ;
  btTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btMatrix3x3 local_arg1;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitMatrix3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  result = (btTransform *)new btTransform((btMatrix3x3 const &)*arg1);
  *(btTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btTransform_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jobject jarg1) {
  jlong jresult = 0 ;
  btTransform *arg1 = 0 ;
  btTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btTransform local_arg1;
  gdx_setbtTransformFromMatrix4(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitMatrix4 auto_commit_arg1(jenv, jarg1, &local_arg1);
  result = (btTransform *)new btTransform((btTransform const &)*arg1);
  *(btTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btTransform_1operatorAssignment(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jobject jresult = 0 ;
  btTransform *arg1 = (btTransform *) 0 ;
  btTransform *arg2 = 0 ;
  btTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTransform **)&jarg1; 
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (btTransform *) &(arg1)->operator =((btTransform const &)*arg2);
  jresult = gdx_getReturnMatrix4(jenv);
  gdx_setMatrix4FrombtTransform(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btTransform_1mult(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3) {
  btTransform *arg1 = (btTransform *) 0 ;
  btTransform *arg2 = 0 ;
  btTransform *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTransform **)&jarg1; 
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btTransform local_arg3;
  gdx_setbtTransformFromMatrix4(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitMatrix4 auto_commit_arg3(jenv, jarg3, &local_arg3);
  (arg1)->mult((btTransform const &)*arg2,(btTransform const &)*arg3);
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btTransform_1operatorFunctionCall(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jobject jresult = 0 ;
  btTransform *arg1 = (btTransform *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTransform **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = ((btTransform const *)arg1)->operator ()((btVector3 const &)*arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btTransform_1operatorMultiplication_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jobject jresult = 0 ;
  btTransform *arg1 = (btTransform *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTransform **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = ((btTransform const *)arg1)->operator *((btVector3 const &)*arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btTransform_1operatorMultiplication_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jobject jresult = 0 ;
  btTransform *arg1 = (btTransform *) 0 ;
  btQuaternion *arg2 = 0 ;
  btQuaternion result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTransform **)&jarg1; 
  btQuaternion local_arg2;
  gdx_setbtQuaternionFromQuaternion(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitQuaternion auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = ((btTransform const *)arg1)->operator *((btQuaternion const &)*arg2);
  jresult = gdx_getReturnQuaternion(jenv);
  gdx_setQuaternionFrombtQuaternion(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btTransform_1getBasis(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btTransform *arg1 = (btTransform *) 0 ;
  btMatrix3x3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTransform **)&jarg1; 
  result = (btMatrix3x3 *) &(arg1)->getBasis();
  jresult = gdx_getReturnMatrix3(jenv);
  gdx_setMatrix3FrombtMatrix3x3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btTransform_1getBasisConst(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btTransform *arg1 = (btTransform *) 0 ;
  btMatrix3x3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTransform **)&jarg1; 
  result = (btMatrix3x3 *) &((btTransform const *)arg1)->getBasis();
  jresult = gdx_getReturnMatrix3(jenv);
  gdx_setMatrix3FrombtMatrix3x3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btTransform_1getOrigin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btTransform *arg1 = (btTransform *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTransform **)&jarg1; 
  result = (btVector3 *) &(arg1)->getOrigin();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btTransform_1getOriginConst(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btTransform *arg1 = (btTransform *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTransform **)&jarg1; 
  result = (btVector3 *) &((btTransform const *)arg1)->getOrigin();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btTransform_1getRotation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btTransform *arg1 = (btTransform *) 0 ;
  btQuaternion result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTransform **)&jarg1; 
  result = ((btTransform const *)arg1)->getRotation();
  jresult = gdx_getReturnQuaternion(jenv);
  gdx_setQuaternionFrombtQuaternion(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btTransform_1setFromOpenGLMatrix(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloatArray jarg2) {
  btTransform *arg1 = (btTransform *) 0 ;
  btScalar *arg2 = (btScalar *) 0 ;
  jfloat *jarr2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTransform **)&jarg1; 
  if (!SWIG_JavaArrayInFloat(jenv, &jarr2, (float **)&arg2, jarg2)) return ; 
  (arg1)->setFromOpenGLMatrix((btScalar const *)arg2);
  SWIG_JavaArrayArgoutFloat(jenv, jarr2, (float *)arg2, jarg2); 
  delete [] arg2; 
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btTransform_1getOpenGLMatrix(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloatArray jarg2) {
  btTransform *arg1 = (btTransform *) 0 ;
  btScalar *arg2 = (btScalar *) 0 ;
  jfloat *jarr2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTransform **)&jarg1; 
  if (!SWIG_JavaArrayInFloat(jenv, &jarr2, (float **)&arg2, jarg2)) return ; 
  ((btTransform const *)arg1)->getOpenGLMatrix(arg2);
  SWIG_JavaArrayArgoutFloat(jenv, jarr2, (float *)arg2, jarg2); 
  delete [] arg2; 
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btTransform_1setOrigin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btTransform *arg1 = (btTransform *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTransform **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->setOrigin((btVector3 const &)*arg2);
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btTransform_1invXform(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jobject jresult = 0 ;
  btTransform *arg1 = (btTransform *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTransform **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = ((btTransform const *)arg1)->invXform((btVector3 const &)*arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btTransform_1setBasis(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btTransform *arg1 = (btTransform *) 0 ;
  btMatrix3x3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTransform **)&jarg1; 
  btMatrix3x3 local_arg2;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->setBasis((btMatrix3x3 const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btTransform_1setRotation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btTransform *arg1 = (btTransform *) 0 ;
  btQuaternion *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTransform **)&jarg1; 
  btQuaternion local_arg2;
  gdx_setbtQuaternionFromQuaternion(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitQuaternion auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->setRotation((btQuaternion const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btTransform_1setIdentity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btTransform *arg1 = (btTransform *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTransform **)&jarg1; 
  (arg1)->setIdentity();
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btTransform_1operatorMultiplicationAssignment(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jobject jresult = 0 ;
  btTransform *arg1 = (btTransform *) 0 ;
  btTransform *arg2 = 0 ;
  btTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTransform **)&jarg1; 
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (btTransform *) &(arg1)->operator *=((btTransform const &)*arg2);
  jresult = gdx_getReturnMatrix4(jenv);
  gdx_setMatrix4FrombtTransform(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btTransform_1inverse(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btTransform *arg1 = (btTransform *) 0 ;
  btTransform result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTransform **)&jarg1; 
  result = ((btTransform const *)arg1)->inverse();
  jresult = gdx_getReturnMatrix4(jenv);
  gdx_setMatrix4FrombtTransform(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btTransform_1inverseTimes(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jobject jresult = 0 ;
  btTransform *arg1 = (btTransform *) 0 ;
  btTransform *arg2 = 0 ;
  btTransform result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTransform **)&jarg1; 
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = ((btTransform const *)arg1)->inverseTimes((btTransform const &)*arg2);
  jresult = gdx_getReturnMatrix4(jenv);
  gdx_setMatrix4FrombtTransform(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btTransform_1operatorMultiplication_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jobject jresult = 0 ;
  btTransform *arg1 = (btTransform *) 0 ;
  btTransform *arg2 = 0 ;
  btTransform result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTransform **)&jarg1; 
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = ((btTransform const *)arg1)->operator *((btTransform const &)*arg2);
  jresult = gdx_getReturnMatrix4(jenv);
  gdx_setMatrix4FrombtTransform(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btTransform_1getIdentity(JNIEnv *jenv, jclass jcls) {
  jobject jresult = 0 ;
  btTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btTransform *) &btTransform::getIdentity();
  jresult = gdx_getReturnMatrix4(jenv);
  gdx_setMatrix4FrombtTransform(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btTransform_1serialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTransform *arg1 = (btTransform *) 0 ;
  btTransformFloatData *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTransform **)&jarg1; 
  arg2 = *(btTransformFloatData **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btTransformFloatData & reference is null");
    return ;
  } 
  ((btTransform const *)arg1)->serialize(*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btTransform_1serializeFloat(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTransform *arg1 = (btTransform *) 0 ;
  btTransformFloatData *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTransform **)&jarg1; 
  arg2 = *(btTransformFloatData **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btTransformFloatData & reference is null");
    return ;
  } 
  ((btTransform const *)arg1)->serializeFloat(*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btTransform_1deSerialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTransform *arg1 = (btTransform *) 0 ;
  btTransformFloatData *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTransform **)&jarg1; 
  arg2 = *(btTransformFloatData **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btTransformFloatData const & reference is null");
    return ;
  } 
  (arg1)->deSerialize((btTransformFloatData const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btTransform_1deSerializeDouble(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTransform *arg1 = (btTransform *) 0 ;
  btTransformDoubleData *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTransform **)&jarg1; 
  arg2 = *(btTransformDoubleData **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btTransformDoubleData const & reference is null");
    return ;
  } 
  (arg1)->deSerializeDouble((btTransformDoubleData const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btTransform_1deSerializeFloat(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTransform *arg1 = (btTransform *) 0 ;
  btTransformFloatData *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTransform **)&jarg1; 
  arg2 = *(btTransformFloatData **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btTransformFloatData const & reference is null");
    return ;
  } 
  (arg1)->deSerializeFloat((btTransformFloatData const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_delete_1btTransform(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btTransform *arg1 = (btTransform *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btTransform **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_operatorEqualTo_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2) {
  jboolean jresult = 0 ;
  btTransform *arg1 = 0 ;
  btTransform *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  btTransform local_arg1;
  gdx_setbtTransformFromMatrix4(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitMatrix4 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (bool)operator ==((btTransform const &)*arg1,(btTransform const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btTransformFloatData_1basis_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTransformFloatData *arg1 = (btTransformFloatData *) 0 ;
  btMatrix3x3FloatData *arg2 = (btMatrix3x3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTransformFloatData **)&jarg1; 
  arg2 = *(btMatrix3x3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_basis = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btTransformFloatData_1basis_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTransformFloatData *arg1 = (btTransformFloatData *) 0 ;
  btMatrix3x3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTransformFloatData **)&jarg1; 
  result = (btMatrix3x3FloatData *)& ((arg1)->m_basis);
  *(btMatrix3x3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btTransformFloatData_1origin_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTransformFloatData *arg1 = (btTransformFloatData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTransformFloatData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_origin = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btTransformFloatData_1origin_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTransformFloatData *arg1 = (btTransformFloatData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTransformFloatData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_origin);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btTransformFloatData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btTransformFloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btTransformFloatData *)new btTransformFloatData();
  *(btTransformFloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_delete_1btTransformFloatData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btTransformFloatData *arg1 = (btTransformFloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btTransformFloatData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btTransformDoubleData_1basis_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTransformDoubleData *arg1 = (btTransformDoubleData *) 0 ;
  btMatrix3x3DoubleData *arg2 = (btMatrix3x3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTransformDoubleData **)&jarg1; 
  arg2 = *(btMatrix3x3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_basis = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btTransformDoubleData_1basis_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTransformDoubleData *arg1 = (btTransformDoubleData *) 0 ;
  btMatrix3x3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTransformDoubleData **)&jarg1; 
  result = (btMatrix3x3DoubleData *)& ((arg1)->m_basis);
  *(btMatrix3x3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btTransformDoubleData_1origin_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTransformDoubleData *arg1 = (btTransformDoubleData *) 0 ;
  btVector3DoubleData *arg2 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTransformDoubleData **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_origin = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btTransformDoubleData_1origin_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTransformDoubleData *arg1 = (btTransformDoubleData *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTransformDoubleData **)&jarg1; 
  result = (btVector3DoubleData *)& ((arg1)->m_origin);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btTransformDoubleData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btTransformDoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btTransformDoubleData *)new btTransformDoubleData();
  *(btTransformDoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_delete_1btTransformDoubleData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btTransformDoubleData *arg1 = (btTransformDoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btTransformDoubleData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1operatorNew_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  size_t arg2 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  arg2 = (size_t)jarg2; 
  result = (void *)(arg1)->operator new(arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1operatorDelete_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btVector3 *arg1 = (btVector3 *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  arg2 = (void *)jarg2; 
  (arg1)->operator delete(arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1operatorNew_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  size_t arg2 ;
  void *arg3 = (void *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  arg2 = (size_t)jarg2; 
  arg3 = (void *)jarg3; 
  result = (void *)(arg1)->operator new(arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1operatorDelete_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  btVector3 *arg1 = (btVector3 *) 0 ;
  void *arg2 = (void *) 0 ;
  void *arg3 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  arg2 = (void *)jarg2; 
  arg3 = (void *)jarg3; 
  (arg1)->operator delete(arg2,arg3);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1operatorNewArray_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  size_t arg2 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  arg2 = (size_t)jarg2; 
  result = (void *)(arg1)->operator new[](arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1operatorDeleteArray_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btVector3 *arg1 = (btVector3 *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  arg2 = (void *)jarg2; 
  (arg1)->operator delete[](arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1operatorNewArray_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  size_t arg2 ;
  void *arg3 = (void *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  arg2 = (size_t)jarg2; 
  arg3 = (void *)jarg3; 
  result = (void *)(arg1)->operator new[](arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1operatorDeleteArray_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  btVector3 *arg1 = (btVector3 *) 0 ;
  void *arg2 = (void *) 0 ;
  void *arg3 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  arg2 = (void *)jarg2; 
  arg3 = (void *)jarg3; 
  (arg1)->operator delete[](arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1floats_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloatArray jarg2) {
  btVector3 *arg1 = (btVector3 *) 0 ;
  btScalar *arg2 ;
  jfloat *jarr2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  if (!SWIG_JavaArrayInFloat(jenv, &jarr2, (float **)&arg2, jarg2)) return ; 
  {
    size_t ii;
    btScalar *b = (btScalar *) arg1->m_floats;
    for (ii = 0; ii < (size_t)4; ii++) b[ii] = *((btScalar *) arg2 + ii);
  }
  SWIG_JavaArrayArgoutFloat(jenv, jarr2, (float *)arg2, jarg2); 
  delete [] arg2; 
}


SWIGEXPORT jfloatArray JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1floats_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloatArray jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btScalar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  result = (btScalar *)(btScalar *) ((arg1)->m_floats);
  jresult = SWIG_JavaArrayOutFloat(jenv, (float *)result, 4); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btVector3_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btVector3 *)new btVector3();
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btVector3_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jfloat jarg1, jfloat jarg2, jfloat jarg3) {
  jlong jresult = 0 ;
  btScalar *arg1 = 0 ;
  btScalar *arg2 = 0 ;
  btScalar *arg3 = 0 ;
  btScalar temp1 ;
  btScalar temp2 ;
  btScalar temp3 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  temp1 = (btScalar)jarg1; 
  arg1 = &temp1; 
  temp2 = (btScalar)jarg2; 
  arg2 = &temp2; 
  temp3 = (btScalar)jarg3; 
  arg3 = &temp3; 
  result = (btVector3 *)new btVector3((btScalar const &)*arg1,(btScalar const &)*arg2,(btScalar const &)*arg3);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1operatorAdditionAssignment(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jobject jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (btVector3 *) &(arg1)->operator +=((btVector3 const &)*arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1operatorSubtractionAssignment(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jobject jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (btVector3 *) &(arg1)->operator -=((btVector3 const &)*arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1operatorMultiplicationAssignment_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  jobject jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btScalar *arg2 = 0 ;
  btScalar temp2 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  temp2 = (btScalar)jarg2; 
  arg2 = &temp2; 
  result = (btVector3 *) &(arg1)->operator *=((btScalar const &)*arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1operatorDivisionAssignment(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  jobject jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btScalar *arg2 = 0 ;
  btScalar temp2 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  temp2 = (btScalar)jarg2; 
  arg2 = &temp2; 
  result = (btVector3 *) &(arg1)->operator /=((btScalar const &)*arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1dot(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jfloat jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btVector3 *arg2 = 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (btScalar)((btVector3 const *)arg1)->dot((btVector3 const &)*arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1length2(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  result = (btScalar)((btVector3 const *)arg1)->length2();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1length(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  result = (btScalar)((btVector3 const *)arg1)->length();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1norm(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  result = (btScalar)((btVector3 const *)arg1)->norm();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1safeNorm(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  result = (btScalar)((btVector3 const *)arg1)->safeNorm();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1distance2(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jfloat jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btVector3 *arg2 = 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (btScalar)((btVector3 const *)arg1)->distance2((btVector3 const &)*arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1distance(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jfloat jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btVector3 *arg2 = 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (btScalar)((btVector3 const *)arg1)->distance((btVector3 const &)*arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1safeNormalize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  result = (btVector3 *) &(arg1)->safeNormalize();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1normalize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  result = (btVector3 *) &(arg1)->normalize();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1normalized(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  result = ((btVector3 const *)arg1)->normalized();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1rotate(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jfloat jarg3) {
  jobject jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btVector3 *arg2 = 0 ;
  btScalar arg3 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (btScalar)jarg3; 
  result = ((btVector3 const *)arg1)->rotate((btVector3 const &)*arg2,arg3);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1angle(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jfloat jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btVector3 *arg2 = 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (btScalar)((btVector3 const *)arg1)->angle((btVector3 const &)*arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1absolute(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  result = ((btVector3 const *)arg1)->absolute();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1cross(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jobject jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = ((btVector3 const *)arg1)->cross((btVector3 const &)*arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1triple(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3) {
  jfloat jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  result = (btScalar)((btVector3 const *)arg1)->triple((btVector3 const &)*arg2,(btVector3 const &)*arg3);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1minAxis(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  result = (int)((btVector3 const *)arg1)->minAxis();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1maxAxis(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  result = (int)((btVector3 const *)arg1)->maxAxis();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1furthestAxis(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  result = (int)((btVector3 const *)arg1)->furthestAxis();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1closestAxis(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  result = (int)((btVector3 const *)arg1)->closestAxis();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1setInterpolate3(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jfloat jarg4) {
  btVector3 *arg1 = (btVector3 *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btScalar arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = (btScalar)jarg4; 
  (arg1)->setInterpolate3((btVector3 const &)*arg2,(btVector3 const &)*arg3,arg4);
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1lerp(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jfloat jarg3) {
  jobject jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btVector3 *arg2 = 0 ;
  btScalar *arg3 = 0 ;
  btScalar temp3 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  temp3 = (btScalar)jarg3; 
  arg3 = &temp3; 
  result = ((btVector3 const *)arg1)->lerp((btVector3 const &)*arg2,(btScalar const &)*arg3);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1operatorMultiplicationAssignment_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jobject jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (btVector3 *) &(arg1)->operator *=((btVector3 const &)*arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1getX(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btScalar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  result = (btScalar *) &((btVector3 const *)arg1)->getX();
  jresult = (jfloat)*result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1getY(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btScalar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  result = (btScalar *) &((btVector3 const *)arg1)->getY();
  jresult = (jfloat)*result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1getZ(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btScalar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  result = (btScalar *) &((btVector3 const *)arg1)->getZ();
  jresult = (jfloat)*result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1setX(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btVector3 *arg1 = (btVector3 *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setX(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1setY(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btVector3 *arg1 = (btVector3 *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setY(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1setZ(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btVector3 *arg1 = (btVector3 *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setZ(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1setW(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btVector3 *arg1 = (btVector3 *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setW(arg2);
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1x(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btScalar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  result = (btScalar *) &((btVector3 const *)arg1)->x();
  jresult = (jfloat)*result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1y(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btScalar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  result = (btScalar *) &((btVector3 const *)arg1)->y();
  jresult = (jfloat)*result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1z(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btScalar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  result = (btScalar *) &((btVector3 const *)arg1)->z();
  jresult = (jfloat)*result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1w(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btScalar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  result = (btScalar *) &((btVector3 const *)arg1)->w();
  jresult = (jfloat)*result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1operatorbtScalarPtr(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btScalar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  result = (btScalar *)(arg1)->operator btScalar*();
  *(btScalar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1operatorbtConstScalarPtr(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btScalar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  result = (btScalar *)((btVector3 const *)arg1)->operator const btScalar*();
  *(btScalar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1operatorEqualTo(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jboolean jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btVector3 *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (bool)((btVector3 const *)arg1)->operator ==((btVector3 const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1operatorNotEqualTo(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jboolean jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btVector3 *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (bool)((btVector3 const *)arg1)->operator !=((btVector3 const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1setMax(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btVector3 *arg1 = (btVector3 *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->setMax((btVector3 const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1setMin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btVector3 *arg1 = (btVector3 *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->setMin((btVector3 const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1setValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jfloat jarg3, jfloat jarg4) {
  btVector3 *arg1 = (btVector3 *) 0 ;
  btScalar *arg2 = 0 ;
  btScalar *arg3 = 0 ;
  btScalar *arg4 = 0 ;
  btScalar temp2 ;
  btScalar temp3 ;
  btScalar temp4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  temp2 = (btScalar)jarg2; 
  arg2 = &temp2; 
  temp3 = (btScalar)jarg3; 
  arg3 = &temp3; 
  temp4 = (btScalar)jarg4; 
  arg4 = &temp4; 
  (arg1)->setValue((btScalar const &)*arg2,(btScalar const &)*arg3,(btScalar const &)*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1getSkewSymmetricMatrix(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  btVector3 *arg1 = (btVector3 *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  btVector3 *arg3 = (btVector3 *) 0 ;
  btVector3 *arg4 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(btVector3 **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  arg3 = *(btVector3 **)&jarg3; 
  arg4 = *(btVector3 **)&jarg4; 
  ((btVector3 const *)arg1)->getSkewSymmetricMatrix(arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1setZero(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btVector3 *arg1 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  (arg1)->setZero();
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1isZero(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  result = (bool)((btVector3 const *)arg1)->isZero();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1fuzzyZero(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  result = (bool)((btVector3 const *)arg1)->fuzzyZero();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1serialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btVector3 *arg1 = (btVector3 *) 0 ;
  btVector3FloatData *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btVector3 **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3FloatData & reference is null");
    return ;
  } 
  ((btVector3 const *)arg1)->serialize(*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1deSerialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btVector3 *arg1 = (btVector3 *) 0 ;
  btVector3FloatData *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btVector3 **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3FloatData const & reference is null");
    return ;
  } 
  (arg1)->deSerialize((btVector3FloatData const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1serializeFloat(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btVector3 *arg1 = (btVector3 *) 0 ;
  btVector3FloatData *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btVector3 **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3FloatData & reference is null");
    return ;
  } 
  ((btVector3 const *)arg1)->serializeFloat(*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1deSerializeFloat(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btVector3 *arg1 = (btVector3 *) 0 ;
  btVector3FloatData *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btVector3 **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3FloatData const & reference is null");
    return ;
  } 
  (arg1)->deSerializeFloat((btVector3FloatData const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1serializeDouble(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btVector3 *arg1 = (btVector3 *) 0 ;
  btVector3DoubleData *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btVector3 **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3DoubleData & reference is null");
    return ;
  } 
  ((btVector3 const *)arg1)->serializeDouble(*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1deSerializeDouble(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btVector3 *arg1 = (btVector3 *) 0 ;
  btVector3DoubleData *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btVector3 **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector3DoubleData const & reference is null");
    return ;
  } 
  (arg1)->deSerializeDouble((btVector3DoubleData const &)*arg2);
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1maxDot(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3, jlong jarg4) {
  jint jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  long arg3 ;
  btScalar *arg4 = 0 ;
  long result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btVector3 **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  arg3 = (long)jarg3; 
  arg4 = *(btScalar **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btScalar & reference is null");
    return 0;
  } 
  result = (long)((btVector3 const *)arg1)->maxDot((btVector3 const *)arg2,arg3,*arg4);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1minDot(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3, jlong jarg4) {
  jint jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  long arg3 ;
  btScalar *arg4 = 0 ;
  long result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btVector3 **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  arg3 = (long)jarg3; 
  arg4 = *(btScalar **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btScalar & reference is null");
    return 0;
  } 
  result = (long)((btVector3 const *)arg1)->minDot((btVector3 const *)arg2,arg3,*arg4);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3_1dot3(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jobject jarg4) {
  jobject jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  result = ((btVector3 const *)arg1)->dot3((btVector3 const &)*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_delete_1btVector3(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btVector3 *arg1 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btVector3 **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_operatorAddition_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2) {
  jobject jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = operator +((btVector3 const &)*arg1,(btVector3 const &)*arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_operatorMultiplication_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2) {
  jobject jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = operator *((btVector3 const &)*arg1,(btVector3 const &)*arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_operatorSubtraction_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2) {
  jobject jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = operator -((btVector3 const &)*arg1,(btVector3 const &)*arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_operatorSubtraction_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jobject jarg1) {
  jobject jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  result = operator -((btVector3 const &)*arg1);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_operatorMultiplication_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jobject jarg1, jfloat jarg2) {
  jobject jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btScalar *arg2 = 0 ;
  btScalar temp2 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  temp2 = (btScalar)jarg2; 
  arg2 = &temp2; 
  result = operator *((btVector3 const &)*arg1,(float const &)*arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_operatorMultiplication_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jfloat jarg1, jobject jarg2) {
  jobject jresult = 0 ;
  btScalar *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btScalar temp1 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  temp1 = (btScalar)jarg1; 
  arg1 = &temp1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = operator *((float const &)*arg1,(btVector3 const &)*arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_operatorDivision_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jobject jarg1, jfloat jarg2) {
  jobject jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btScalar *arg2 = 0 ;
  btScalar temp2 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  temp2 = (btScalar)jarg2; 
  arg2 = &temp2; 
  result = operator /((btVector3 const &)*arg1,(float const &)*arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_operatorDivision_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2) {
  jobject jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = operator /((btVector3 const &)*arg1,(btVector3 const &)*arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btDot(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2) {
  jfloat jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (btScalar)btDot((btVector3 const &)*arg1,(btVector3 const &)*arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btDistance2(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2) {
  jfloat jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (btScalar)btDistance2((btVector3 const &)*arg1,(btVector3 const &)*arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btDistance(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2) {
  jfloat jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (btScalar)btDistance((btVector3 const &)*arg1,(btVector3 const &)*arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btAngle_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2) {
  jfloat jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (btScalar)btAngle((btVector3 const &)*arg1,(btVector3 const &)*arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btCross(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2) {
  jobject jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = btCross((btVector3 const &)*arg1,(btVector3 const &)*arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btTriple(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jobject jarg3) {
  jfloat jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  result = (btScalar)btTriple((btVector3 const &)*arg1,(btVector3 const &)*arg2,(btVector3 const &)*arg3);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_lerp(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jfloat jarg3) {
  jobject jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btScalar *arg3 = 0 ;
  btScalar temp3 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  temp3 = (btScalar)jarg3; 
  arg3 = &temp3; 
  result = lerp((btVector3 const &)*arg1,(btVector3 const &)*arg2,(float const &)*arg3);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btVector4_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btVector4 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btVector4 *)new btVector4();
  *(btVector4 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btVector4_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jfloat jarg1, jfloat jarg2, jfloat jarg3, jfloat jarg4) {
  jlong jresult = 0 ;
  btScalar *arg1 = 0 ;
  btScalar *arg2 = 0 ;
  btScalar *arg3 = 0 ;
  btScalar *arg4 = 0 ;
  btScalar temp1 ;
  btScalar temp2 ;
  btScalar temp3 ;
  btScalar temp4 ;
  btVector4 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  temp1 = (btScalar)jarg1; 
  arg1 = &temp1; 
  temp2 = (btScalar)jarg2; 
  arg2 = &temp2; 
  temp3 = (btScalar)jarg3; 
  arg3 = &temp3; 
  temp4 = (btScalar)jarg4; 
  arg4 = &temp4; 
  result = (btVector4 *)new btVector4((btScalar const &)*arg1,(btScalar const &)*arg2,(btScalar const &)*arg3,(btScalar const &)*arg4);
  *(btVector4 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector4_1absolute4(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btVector4 *arg1 = (btVector4 *) 0 ;
  btVector4 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector4 **)&jarg1; 
  result = ((btVector4 const *)arg1)->absolute4();
  *(btVector4 **)&jresult = new btVector4((const btVector4 &)result); 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector4_1getW(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btVector4 *arg1 = (btVector4 *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector4 **)&jarg1; 
  result = (btScalar)((btVector4 const *)arg1)->getW();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector4_1maxAxis4(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btVector4 *arg1 = (btVector4 *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector4 **)&jarg1; 
  result = (int)((btVector4 const *)arg1)->maxAxis4();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector4_1minAxis4(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btVector4 *arg1 = (btVector4 *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector4 **)&jarg1; 
  result = (int)((btVector4 const *)arg1)->minAxis4();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector4_1closestAxis4(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btVector4 *arg1 = (btVector4 *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector4 **)&jarg1; 
  result = (int)((btVector4 const *)arg1)->closestAxis4();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector4_1setValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jfloat jarg3, jfloat jarg4, jfloat jarg5) {
  btVector4 *arg1 = (btVector4 *) 0 ;
  btScalar *arg2 = 0 ;
  btScalar *arg3 = 0 ;
  btScalar *arg4 = 0 ;
  btScalar *arg5 = 0 ;
  btScalar temp2 ;
  btScalar temp3 ;
  btScalar temp4 ;
  btScalar temp5 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector4 **)&jarg1; 
  temp2 = (btScalar)jarg2; 
  arg2 = &temp2; 
  temp3 = (btScalar)jarg3; 
  arg3 = &temp3; 
  temp4 = (btScalar)jarg4; 
  arg4 = &temp4; 
  temp5 = (btScalar)jarg5; 
  arg5 = &temp5; 
  (arg1)->setValue((btScalar const &)*arg2,(btScalar const &)*arg3,(btScalar const &)*arg4,(btScalar const &)*arg5);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_delete_1btVector4(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btVector4 *arg1 = (btVector4 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btVector4 **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSwapScalarEndian(JNIEnv *jenv, jclass jcls, jfloat jarg1, jlong jarg2) {
  btScalar *arg1 = 0 ;
  btScalar *arg2 = 0 ;
  btScalar temp1 ;
  
  (void)jenv;
  (void)jcls;
  temp1 = (btScalar)jarg1; 
  arg1 = &temp1; 
  arg2 = *(btScalar **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btScalar & reference is null");
    return ;
  } 
  btSwapScalarEndian((float const &)*arg1,*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSwapVector3Endian(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2) {
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btSwapVector3Endian((btVector3 const &)*arg1,*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btUnSwapVector3Endian(JNIEnv *jenv, jclass jcls, jobject jarg1) {
  btVector3 *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btUnSwapVector3Endian(*arg1);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3FloatData_1floats_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloatArray jarg2) {
  btVector3FloatData *arg1 = (btVector3FloatData *) 0 ;
  float *arg2 ;
  jfloat *jarr2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3FloatData **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  if (!SWIG_JavaArrayInFloat(jenv, &jarr2, (float **)&arg2, jarg2)) return ; 
  {
    size_t ii;
    float *b = (float *) arg1->m_floats;
    for (ii = 0; ii < (size_t)4; ii++) b[ii] = *((float *) arg2 + ii);
  }
  SWIG_JavaArrayArgoutFloat(jenv, jarr2, (float *)arg2, jarg2); 
  delete [] arg2; 
}


SWIGEXPORT jfloatArray JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3FloatData_1floats_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloatArray jresult = 0 ;
  btVector3FloatData *arg1 = (btVector3FloatData *) 0 ;
  float *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3FloatData **)&jarg1; 
  result = (float *)(float *) ((arg1)->m_floats);
  jresult = SWIG_JavaArrayOutFloat(jenv, (float *)result, 4); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btVector3FloatData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btVector3FloatData *)new btVector3FloatData();
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_delete_1btVector3FloatData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btVector3FloatData *arg1 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btVector3FloatData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3DoubleData_1floats_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdoubleArray jarg2) {
  btVector3DoubleData *arg1 = (btVector3DoubleData *) 0 ;
  double *arg2 ;
  jdouble *jarr2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3DoubleData **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  if (!SWIG_JavaArrayInDouble(jenv, &jarr2, (double **)&arg2, jarg2)) return ; 
  {
    size_t ii;
    double *b = (double *) arg1->m_floats;
    for (ii = 0; ii < (size_t)4; ii++) b[ii] = *((double *) arg2 + ii);
  }
  SWIG_JavaArrayArgoutDouble(jenv, jarr2, (double *)arg2, jarg2); 
  delete [] arg2; 
}


SWIGEXPORT jdoubleArray JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3DoubleData_1floats_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdoubleArray jresult = 0 ;
  btVector3DoubleData *arg1 = (btVector3DoubleData *) 0 ;
  double *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3DoubleData **)&jarg1; 
  result = (double *)(double *) ((arg1)->m_floats);
  jresult = SWIG_JavaArrayOutDouble(jenv, (double *)result, 4); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btVector3DoubleData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btVector3DoubleData *)new btVector3DoubleData();
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_delete_1btVector3DoubleData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btVector3DoubleData *arg1 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btVector3DoubleData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btQuadWord_1getX(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btQuadWord *arg1 = (btQuadWord *) 0 ;
  btScalar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuadWord **)&jarg1; 
  result = (btScalar *) &((btQuadWord const *)arg1)->getX();
  jresult = (jfloat)*result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btQuadWord_1getY(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btQuadWord *arg1 = (btQuadWord *) 0 ;
  btScalar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuadWord **)&jarg1; 
  result = (btScalar *) &((btQuadWord const *)arg1)->getY();
  jresult = (jfloat)*result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btQuadWord_1getZ(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btQuadWord *arg1 = (btQuadWord *) 0 ;
  btScalar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuadWord **)&jarg1; 
  result = (btScalar *) &((btQuadWord const *)arg1)->getZ();
  jresult = (jfloat)*result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btQuadWord_1setX(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btQuadWord *arg1 = (btQuadWord *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuadWord **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setX(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btQuadWord_1setY(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btQuadWord *arg1 = (btQuadWord *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuadWord **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setY(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btQuadWord_1setZ(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btQuadWord *arg1 = (btQuadWord *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuadWord **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setZ(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btQuadWord_1setW(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btQuadWord *arg1 = (btQuadWord *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuadWord **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setW(arg2);
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btQuadWord_1x(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btQuadWord *arg1 = (btQuadWord *) 0 ;
  btScalar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuadWord **)&jarg1; 
  result = (btScalar *) &((btQuadWord const *)arg1)->x();
  jresult = (jfloat)*result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btQuadWord_1y(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btQuadWord *arg1 = (btQuadWord *) 0 ;
  btScalar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuadWord **)&jarg1; 
  result = (btScalar *) &((btQuadWord const *)arg1)->y();
  jresult = (jfloat)*result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btQuadWord_1z(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btQuadWord *arg1 = (btQuadWord *) 0 ;
  btScalar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuadWord **)&jarg1; 
  result = (btScalar *) &((btQuadWord const *)arg1)->z();
  jresult = (jfloat)*result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btQuadWord_1w(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btQuadWord *arg1 = (btQuadWord *) 0 ;
  btScalar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuadWord **)&jarg1; 
  result = (btScalar *) &((btQuadWord const *)arg1)->w();
  jresult = (jfloat)*result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btQuadWord_1operatorbtScalarPtr(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btQuadWord *arg1 = (btQuadWord *) 0 ;
  btScalar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuadWord **)&jarg1; 
  result = (btScalar *)(arg1)->operator btScalar*();
  *(btScalar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btQuadWord_1operatorbtConstScalarPtr(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btQuadWord *arg1 = (btQuadWord *) 0 ;
  btScalar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuadWord **)&jarg1; 
  result = (btScalar *)((btQuadWord const *)arg1)->operator const btScalar*();
  *(btScalar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btQuadWord_1operatorEqualTo(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  btQuadWord *arg1 = (btQuadWord *) 0 ;
  btQuadWord *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btQuadWord **)&jarg1; 
  arg2 = *(btQuadWord **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btQuadWord const & reference is null");
    return 0;
  } 
  result = (bool)((btQuadWord const *)arg1)->operator ==((btQuadWord const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btQuadWord_1operatorNotEqualTo(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  btQuadWord *arg1 = (btQuadWord *) 0 ;
  btQuadWord *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btQuadWord **)&jarg1; 
  arg2 = *(btQuadWord **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btQuadWord const & reference is null");
    return 0;
  } 
  result = (bool)((btQuadWord const *)arg1)->operator !=((btQuadWord const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btQuadWord_1setValue_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jfloat jarg3, jfloat jarg4) {
  btQuadWord *arg1 = (btQuadWord *) 0 ;
  btScalar *arg2 = 0 ;
  btScalar *arg3 = 0 ;
  btScalar *arg4 = 0 ;
  btScalar temp2 ;
  btScalar temp3 ;
  btScalar temp4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuadWord **)&jarg1; 
  temp2 = (btScalar)jarg2; 
  arg2 = &temp2; 
  temp3 = (btScalar)jarg3; 
  arg3 = &temp3; 
  temp4 = (btScalar)jarg4; 
  arg4 = &temp4; 
  (arg1)->setValue((btScalar const &)*arg2,(btScalar const &)*arg3,(btScalar const &)*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btQuadWord_1setValue_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jfloat jarg3, jfloat jarg4, jfloat jarg5) {
  btQuadWord *arg1 = (btQuadWord *) 0 ;
  btScalar *arg2 = 0 ;
  btScalar *arg3 = 0 ;
  btScalar *arg4 = 0 ;
  btScalar *arg5 = 0 ;
  btScalar temp2 ;
  btScalar temp3 ;
  btScalar temp4 ;
  btScalar temp5 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuadWord **)&jarg1; 
  temp2 = (btScalar)jarg2; 
  arg2 = &temp2; 
  temp3 = (btScalar)jarg3; 
  arg3 = &temp3; 
  temp4 = (btScalar)jarg4; 
  arg4 = &temp4; 
  temp5 = (btScalar)jarg5; 
  arg5 = &temp5; 
  (arg1)->setValue((btScalar const &)*arg2,(btScalar const &)*arg3,(btScalar const &)*arg4,(btScalar const &)*arg5);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btQuadWord_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btQuadWord *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btQuadWord *)new btQuadWord();
  *(btQuadWord **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btQuadWord_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jfloat jarg1, jfloat jarg2, jfloat jarg3) {
  jlong jresult = 0 ;
  btScalar *arg1 = 0 ;
  btScalar *arg2 = 0 ;
  btScalar *arg3 = 0 ;
  btScalar temp1 ;
  btScalar temp2 ;
  btScalar temp3 ;
  btQuadWord *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  temp1 = (btScalar)jarg1; 
  arg1 = &temp1; 
  temp2 = (btScalar)jarg2; 
  arg2 = &temp2; 
  temp3 = (btScalar)jarg3; 
  arg3 = &temp3; 
  result = (btQuadWord *)new btQuadWord((btScalar const &)*arg1,(btScalar const &)*arg2,(btScalar const &)*arg3);
  *(btQuadWord **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btQuadWord_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jfloat jarg1, jfloat jarg2, jfloat jarg3, jfloat jarg4) {
  jlong jresult = 0 ;
  btScalar *arg1 = 0 ;
  btScalar *arg2 = 0 ;
  btScalar *arg3 = 0 ;
  btScalar *arg4 = 0 ;
  btScalar temp1 ;
  btScalar temp2 ;
  btScalar temp3 ;
  btScalar temp4 ;
  btQuadWord *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  temp1 = (btScalar)jarg1; 
  arg1 = &temp1; 
  temp2 = (btScalar)jarg2; 
  arg2 = &temp2; 
  temp3 = (btScalar)jarg3; 
  arg3 = &temp3; 
  temp4 = (btScalar)jarg4; 
  arg4 = &temp4; 
  result = (btQuadWord *)new btQuadWord((btScalar const &)*arg1,(btScalar const &)*arg2,(btScalar const &)*arg3,(btScalar const &)*arg4);
  *(btQuadWord **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btQuadWord_1setMax(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btQuadWord *arg1 = (btQuadWord *) 0 ;
  btQuadWord *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btQuadWord **)&jarg1; 
  arg2 = *(btQuadWord **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btQuadWord const & reference is null");
    return ;
  } 
  (arg1)->setMax((btQuadWord const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btQuadWord_1setMin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btQuadWord *arg1 = (btQuadWord *) 0 ;
  btQuadWord *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btQuadWord **)&jarg1; 
  arg2 = *(btQuadWord **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btQuadWord const & reference is null");
    return ;
  } 
  (arg1)->setMin((btQuadWord const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_delete_1btQuadWord(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btQuadWord *arg1 = (btQuadWord *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btQuadWord **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btQuaternion_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btQuaternion *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btQuaternion *)new btQuaternion();
  *(btQuaternion **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btQuaternion_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jfloat jarg1, jfloat jarg2, jfloat jarg3, jfloat jarg4) {
  jlong jresult = 0 ;
  btScalar *arg1 = 0 ;
  btScalar *arg2 = 0 ;
  btScalar *arg3 = 0 ;
  btScalar *arg4 = 0 ;
  btScalar temp1 ;
  btScalar temp2 ;
  btScalar temp3 ;
  btScalar temp4 ;
  btQuaternion *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  temp1 = (btScalar)jarg1; 
  arg1 = &temp1; 
  temp2 = (btScalar)jarg2; 
  arg2 = &temp2; 
  temp3 = (btScalar)jarg3; 
  arg3 = &temp3; 
  temp4 = (btScalar)jarg4; 
  arg4 = &temp4; 
  result = (btQuaternion *)new btQuaternion((btScalar const &)*arg1,(btScalar const &)*arg2,(btScalar const &)*arg3,(btScalar const &)*arg4);
  *(btQuaternion **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btQuaternion_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jobject jarg1, jfloat jarg2) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btScalar *arg2 = 0 ;
  btScalar temp2 ;
  btQuaternion *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  temp2 = (btScalar)jarg2; 
  arg2 = &temp2; 
  result = (btQuaternion *)new btQuaternion((btVector3 const &)*arg1,(btScalar const &)*arg2);
  *(btQuaternion **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btQuaternion_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jfloat jarg1, jfloat jarg2, jfloat jarg3) {
  jlong jresult = 0 ;
  btScalar *arg1 = 0 ;
  btScalar *arg2 = 0 ;
  btScalar *arg3 = 0 ;
  btScalar temp1 ;
  btScalar temp2 ;
  btScalar temp3 ;
  btQuaternion *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  temp1 = (btScalar)jarg1; 
  arg1 = &temp1; 
  temp2 = (btScalar)jarg2; 
  arg2 = &temp2; 
  temp3 = (btScalar)jarg3; 
  arg3 = &temp3; 
  result = (btQuaternion *)new btQuaternion((btScalar const &)*arg1,(btScalar const &)*arg2,(btScalar const &)*arg3);
  *(btQuaternion **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btQuaternion_1setRotation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jfloat jarg3) {
  btQuaternion *arg1 = (btQuaternion *) 0 ;
  btVector3 *arg2 = 0 ;
  btScalar *arg3 = 0 ;
  btScalar temp3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuaternion **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  temp3 = (btScalar)jarg3; 
  arg3 = &temp3; 
  (arg1)->setRotation((btVector3 const &)*arg2,(btScalar const &)*arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btQuaternion_1setEuler(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jfloat jarg3, jfloat jarg4) {
  btQuaternion *arg1 = (btQuaternion *) 0 ;
  btScalar *arg2 = 0 ;
  btScalar *arg3 = 0 ;
  btScalar *arg4 = 0 ;
  btScalar temp2 ;
  btScalar temp3 ;
  btScalar temp4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuaternion **)&jarg1; 
  temp2 = (btScalar)jarg2; 
  arg2 = &temp2; 
  temp3 = (btScalar)jarg3; 
  arg3 = &temp3; 
  temp4 = (btScalar)jarg4; 
  arg4 = &temp4; 
  (arg1)->setEuler((btScalar const &)*arg2,(btScalar const &)*arg3,(btScalar const &)*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btQuaternion_1setEulerZYX(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jfloat jarg3, jfloat jarg4) {
  btQuaternion *arg1 = (btQuaternion *) 0 ;
  btScalar *arg2 = 0 ;
  btScalar *arg3 = 0 ;
  btScalar *arg4 = 0 ;
  btScalar temp2 ;
  btScalar temp3 ;
  btScalar temp4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuaternion **)&jarg1; 
  temp2 = (btScalar)jarg2; 
  arg2 = &temp2; 
  temp3 = (btScalar)jarg3; 
  arg3 = &temp3; 
  temp4 = (btScalar)jarg4; 
  arg4 = &temp4; 
  (arg1)->setEulerZYX((btScalar const &)*arg2,(btScalar const &)*arg3,(btScalar const &)*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btQuaternion_1getEulerZYX(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4) {
  btQuaternion *arg1 = (btQuaternion *) 0 ;
  btScalar *arg2 = 0 ;
  btScalar *arg3 = 0 ;
  btScalar *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuaternion **)&jarg1; 
  arg2 = *(btScalar **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btScalar & reference is null");
    return ;
  } 
  arg3 = *(btScalar **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btScalar & reference is null");
    return ;
  } 
  arg4 = *(btScalar **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btScalar & reference is null");
    return ;
  } 
  ((btQuaternion const *)arg1)->getEulerZYX(*arg2,*arg3,*arg4);
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btQuaternion_1operatorAdditionAssignment(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jobject jresult = 0 ;
  btQuaternion *arg1 = (btQuaternion *) 0 ;
  btQuaternion *arg2 = 0 ;
  btQuaternion *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuaternion **)&jarg1; 
  btQuaternion local_arg2;
  gdx_setbtQuaternionFromQuaternion(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitQuaternion auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (btQuaternion *) &(arg1)->operator +=((btQuaternion const &)*arg2);
  jresult = gdx_getReturnQuaternion(jenv);
  gdx_setQuaternionFrombtQuaternion(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btQuaternion_1operatorSubtractionAssignment(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jobject jresult = 0 ;
  btQuaternion *arg1 = (btQuaternion *) 0 ;
  btQuaternion *arg2 = 0 ;
  btQuaternion *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuaternion **)&jarg1; 
  btQuaternion local_arg2;
  gdx_setbtQuaternionFromQuaternion(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitQuaternion auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (btQuaternion *) &(arg1)->operator -=((btQuaternion const &)*arg2);
  jresult = gdx_getReturnQuaternion(jenv);
  gdx_setQuaternionFrombtQuaternion(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btQuaternion_1operatorMultiplicationAssignment_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  jobject jresult = 0 ;
  btQuaternion *arg1 = (btQuaternion *) 0 ;
  btScalar *arg2 = 0 ;
  btScalar temp2 ;
  btQuaternion *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuaternion **)&jarg1; 
  temp2 = (btScalar)jarg2; 
  arg2 = &temp2; 
  result = (btQuaternion *) &(arg1)->operator *=((btScalar const &)*arg2);
  jresult = gdx_getReturnQuaternion(jenv);
  gdx_setQuaternionFrombtQuaternion(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btQuaternion_1operatorMultiplicationAssignment_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jobject jresult = 0 ;
  btQuaternion *arg1 = (btQuaternion *) 0 ;
  btQuaternion *arg2 = 0 ;
  btQuaternion *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuaternion **)&jarg1; 
  btQuaternion local_arg2;
  gdx_setbtQuaternionFromQuaternion(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitQuaternion auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (btQuaternion *) &(arg1)->operator *=((btQuaternion const &)*arg2);
  jresult = gdx_getReturnQuaternion(jenv);
  gdx_setQuaternionFrombtQuaternion(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btQuaternion_1dot(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jfloat jresult = 0 ;
  btQuaternion *arg1 = (btQuaternion *) 0 ;
  btQuaternion *arg2 = 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuaternion **)&jarg1; 
  btQuaternion local_arg2;
  gdx_setbtQuaternionFromQuaternion(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitQuaternion auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (btScalar)((btQuaternion const *)arg1)->dot((btQuaternion const &)*arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btQuaternion_1length2(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btQuaternion *arg1 = (btQuaternion *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuaternion **)&jarg1; 
  result = (btScalar)((btQuaternion const *)arg1)->length2();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btQuaternion_1length(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btQuaternion *arg1 = (btQuaternion *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuaternion **)&jarg1; 
  result = (btScalar)((btQuaternion const *)arg1)->length();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btQuaternion_1safeNormalize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btQuaternion *arg1 = (btQuaternion *) 0 ;
  btQuaternion *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuaternion **)&jarg1; 
  result = (btQuaternion *) &(arg1)->safeNormalize();
  jresult = gdx_getReturnQuaternion(jenv);
  gdx_setQuaternionFrombtQuaternion(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btQuaternion_1normalize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btQuaternion *arg1 = (btQuaternion *) 0 ;
  btQuaternion *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuaternion **)&jarg1; 
  result = (btQuaternion *) &(arg1)->normalize();
  jresult = gdx_getReturnQuaternion(jenv);
  gdx_setQuaternionFrombtQuaternion(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btQuaternion_1operatorMultiplication(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  jobject jresult = 0 ;
  btQuaternion *arg1 = (btQuaternion *) 0 ;
  btScalar *arg2 = 0 ;
  btScalar temp2 ;
  btQuaternion result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuaternion **)&jarg1; 
  temp2 = (btScalar)jarg2; 
  arg2 = &temp2; 
  result = ((btQuaternion const *)arg1)->operator *((btScalar const &)*arg2);
  jresult = gdx_getReturnQuaternion(jenv);
  gdx_setQuaternionFrombtQuaternion(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btQuaternion_1operatorDivision(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  jobject jresult = 0 ;
  btQuaternion *arg1 = (btQuaternion *) 0 ;
  btScalar *arg2 = 0 ;
  btScalar temp2 ;
  btQuaternion result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuaternion **)&jarg1; 
  temp2 = (btScalar)jarg2; 
  arg2 = &temp2; 
  result = ((btQuaternion const *)arg1)->operator /((btScalar const &)*arg2);
  jresult = gdx_getReturnQuaternion(jenv);
  gdx_setQuaternionFrombtQuaternion(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btQuaternion_1operatorDivisionAssignment(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  jobject jresult = 0 ;
  btQuaternion *arg1 = (btQuaternion *) 0 ;
  btScalar *arg2 = 0 ;
  btScalar temp2 ;
  btQuaternion *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuaternion **)&jarg1; 
  temp2 = (btScalar)jarg2; 
  arg2 = &temp2; 
  result = (btQuaternion *) &(arg1)->operator /=((btScalar const &)*arg2);
  jresult = gdx_getReturnQuaternion(jenv);
  gdx_setQuaternionFrombtQuaternion(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btQuaternion_1normalized(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btQuaternion *arg1 = (btQuaternion *) 0 ;
  btQuaternion result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuaternion **)&jarg1; 
  result = ((btQuaternion const *)arg1)->normalized();
  jresult = gdx_getReturnQuaternion(jenv);
  gdx_setQuaternionFrombtQuaternion(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btQuaternion_1angle(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jfloat jresult = 0 ;
  btQuaternion *arg1 = (btQuaternion *) 0 ;
  btQuaternion *arg2 = 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuaternion **)&jarg1; 
  btQuaternion local_arg2;
  gdx_setbtQuaternionFromQuaternion(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitQuaternion auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (btScalar)((btQuaternion const *)arg1)->angle((btQuaternion const &)*arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btQuaternion_1angleShortestPath(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jfloat jresult = 0 ;
  btQuaternion *arg1 = (btQuaternion *) 0 ;
  btQuaternion *arg2 = 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuaternion **)&jarg1; 
  btQuaternion local_arg2;
  gdx_setbtQuaternionFromQuaternion(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitQuaternion auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (btScalar)((btQuaternion const *)arg1)->angleShortestPath((btQuaternion const &)*arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btQuaternion_1getAngle(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btQuaternion *arg1 = (btQuaternion *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuaternion **)&jarg1; 
  result = (btScalar)((btQuaternion const *)arg1)->getAngle();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btQuaternion_1getAngleShortestPath(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btQuaternion *arg1 = (btQuaternion *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuaternion **)&jarg1; 
  result = (btScalar)((btQuaternion const *)arg1)->getAngleShortestPath();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btQuaternion_1getAxis(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btQuaternion *arg1 = (btQuaternion *) 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuaternion **)&jarg1; 
  result = ((btQuaternion const *)arg1)->getAxis();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btQuaternion_1inverse(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btQuaternion *arg1 = (btQuaternion *) 0 ;
  btQuaternion result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuaternion **)&jarg1; 
  result = ((btQuaternion const *)arg1)->inverse();
  jresult = gdx_getReturnQuaternion(jenv);
  gdx_setQuaternionFrombtQuaternion(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btQuaternion_1operatorAddition(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jobject jresult = 0 ;
  btQuaternion *arg1 = (btQuaternion *) 0 ;
  btQuaternion *arg2 = 0 ;
  btQuaternion result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuaternion **)&jarg1; 
  btQuaternion local_arg2;
  gdx_setbtQuaternionFromQuaternion(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitQuaternion auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = ((btQuaternion const *)arg1)->operator +((btQuaternion const &)*arg2);
  jresult = gdx_getReturnQuaternion(jenv);
  gdx_setQuaternionFrombtQuaternion(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btQuaternion_1operatorSubtraction_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jobject jresult = 0 ;
  btQuaternion *arg1 = (btQuaternion *) 0 ;
  btQuaternion *arg2 = 0 ;
  btQuaternion result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuaternion **)&jarg1; 
  btQuaternion local_arg2;
  gdx_setbtQuaternionFromQuaternion(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitQuaternion auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = ((btQuaternion const *)arg1)->operator -((btQuaternion const &)*arg2);
  jresult = gdx_getReturnQuaternion(jenv);
  gdx_setQuaternionFrombtQuaternion(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btQuaternion_1operatorSubtraction_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btQuaternion *arg1 = (btQuaternion *) 0 ;
  btQuaternion result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuaternion **)&jarg1; 
  result = ((btQuaternion const *)arg1)->operator -();
  jresult = gdx_getReturnQuaternion(jenv);
  gdx_setQuaternionFrombtQuaternion(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btQuaternion_1farthest(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jobject jresult = 0 ;
  btQuaternion *arg1 = (btQuaternion *) 0 ;
  btQuaternion *arg2 = 0 ;
  btQuaternion result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuaternion **)&jarg1; 
  btQuaternion local_arg2;
  gdx_setbtQuaternionFromQuaternion(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitQuaternion auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = ((btQuaternion const *)arg1)->farthest((btQuaternion const &)*arg2);
  jresult = gdx_getReturnQuaternion(jenv);
  gdx_setQuaternionFrombtQuaternion(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btQuaternion_1nearest(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jobject jresult = 0 ;
  btQuaternion *arg1 = (btQuaternion *) 0 ;
  btQuaternion *arg2 = 0 ;
  btQuaternion result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuaternion **)&jarg1; 
  btQuaternion local_arg2;
  gdx_setbtQuaternionFromQuaternion(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitQuaternion auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = ((btQuaternion const *)arg1)->nearest((btQuaternion const &)*arg2);
  jresult = gdx_getReturnQuaternion(jenv);
  gdx_setQuaternionFrombtQuaternion(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btQuaternion_1slerp(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jfloat jarg3) {
  jobject jresult = 0 ;
  btQuaternion *arg1 = (btQuaternion *) 0 ;
  btQuaternion *arg2 = 0 ;
  btScalar *arg3 = 0 ;
  btScalar temp3 ;
  btQuaternion result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuaternion **)&jarg1; 
  btQuaternion local_arg2;
  gdx_setbtQuaternionFromQuaternion(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitQuaternion auto_commit_arg2(jenv, jarg2, &local_arg2);
  temp3 = (btScalar)jarg3; 
  arg3 = &temp3; 
  result = ((btQuaternion const *)arg1)->slerp((btQuaternion const &)*arg2,(btScalar const &)*arg3);
  jresult = gdx_getReturnQuaternion(jenv);
  gdx_setQuaternionFrombtQuaternion(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btQuaternion_1getIdentity(JNIEnv *jenv, jclass jcls) {
  jobject jresult = 0 ;
  btQuaternion *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btQuaternion *) &btQuaternion::getIdentity();
  jresult = gdx_getReturnQuaternion(jenv);
  gdx_setQuaternionFrombtQuaternion(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btQuaternion_1getW(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btQuaternion *arg1 = (btQuaternion *) 0 ;
  btScalar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuaternion **)&jarg1; 
  result = (btScalar *) &((btQuaternion const *)arg1)->getW();
  jresult = (jfloat)*result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btQuaternion_1serialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btQuaternion *arg1 = (btQuaternion *) 0 ;
  btQuaternionFloatData *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btQuaternion **)&jarg1; 
  arg2 = *(btQuaternionFloatData **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btQuaternionFloatData & reference is null");
    return ;
  } 
  ((btQuaternion const *)arg1)->serialize(*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btQuaternion_1deSerialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btQuaternion *arg1 = (btQuaternion *) 0 ;
  btQuaternionFloatData *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btQuaternion **)&jarg1; 
  arg2 = *(btQuaternionFloatData **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btQuaternionFloatData const & reference is null");
    return ;
  } 
  (arg1)->deSerialize((btQuaternionFloatData const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btQuaternion_1serializeFloat(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btQuaternion *arg1 = (btQuaternion *) 0 ;
  btQuaternionFloatData *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btQuaternion **)&jarg1; 
  arg2 = *(btQuaternionFloatData **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btQuaternionFloatData & reference is null");
    return ;
  } 
  ((btQuaternion const *)arg1)->serializeFloat(*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btQuaternion_1deSerializeFloat(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btQuaternion *arg1 = (btQuaternion *) 0 ;
  btQuaternionFloatData *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btQuaternion **)&jarg1; 
  arg2 = *(btQuaternionFloatData **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btQuaternionFloatData const & reference is null");
    return ;
  } 
  (arg1)->deSerializeFloat((btQuaternionFloatData const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btQuaternion_1serializeDouble(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btQuaternion *arg1 = (btQuaternion *) 0 ;
  btQuaternionDoubleData *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btQuaternion **)&jarg1; 
  arg2 = *(btQuaternionDoubleData **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btQuaternionDoubleData & reference is null");
    return ;
  } 
  ((btQuaternion const *)arg1)->serializeDouble(*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btQuaternion_1deSerializeDouble(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btQuaternion *arg1 = (btQuaternion *) 0 ;
  btQuaternionDoubleData *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btQuaternion **)&jarg1; 
  arg2 = *(btQuaternionDoubleData **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btQuaternionDoubleData const & reference is null");
    return ;
  } 
  (arg1)->deSerializeDouble((btQuaternionDoubleData const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_delete_1btQuaternion(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btQuaternion *arg1 = (btQuaternion *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btQuaternion **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_operatorMultiplication_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2) {
  jobject jresult = 0 ;
  btQuaternion *arg1 = 0 ;
  btQuaternion *arg2 = 0 ;
  btQuaternion result;
  
  (void)jenv;
  (void)jcls;
  btQuaternion local_arg1;
  gdx_setbtQuaternionFromQuaternion(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitQuaternion auto_commit_arg1(jenv, jarg1, &local_arg1);
  btQuaternion local_arg2;
  gdx_setbtQuaternionFromQuaternion(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitQuaternion auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = operator *((btQuaternion const &)*arg1,(btQuaternion const &)*arg2);
  jresult = gdx_getReturnQuaternion(jenv);
  gdx_setQuaternionFrombtQuaternion(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_operatorMultiplication_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2) {
  jobject jresult = 0 ;
  btQuaternion *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btQuaternion result;
  
  (void)jenv;
  (void)jcls;
  btQuaternion local_arg1;
  gdx_setbtQuaternionFromQuaternion(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitQuaternion auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = operator *((btQuaternion const &)*arg1,(btVector3 const &)*arg2);
  jresult = gdx_getReturnQuaternion(jenv);
  gdx_setQuaternionFrombtQuaternion(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_operatorMultiplication_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2) {
  jobject jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btQuaternion *arg2 = 0 ;
  btQuaternion result;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btQuaternion local_arg2;
  gdx_setbtQuaternionFromQuaternion(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitQuaternion auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = operator *((btVector3 const &)*arg1,(btQuaternion const &)*arg2);
  jresult = gdx_getReturnQuaternion(jenv);
  gdx_setQuaternionFrombtQuaternion(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_dot(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2) {
  jfloat jresult = 0 ;
  btQuaternion *arg1 = 0 ;
  btQuaternion *arg2 = 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  btQuaternion local_arg1;
  gdx_setbtQuaternionFromQuaternion(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitQuaternion auto_commit_arg1(jenv, jarg1, &local_arg1);
  btQuaternion local_arg2;
  gdx_setbtQuaternionFromQuaternion(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitQuaternion auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (btScalar)dot((btQuaternion const &)*arg1,(btQuaternion const &)*arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_length(JNIEnv *jenv, jclass jcls, jobject jarg1) {
  jfloat jresult = 0 ;
  btQuaternion *arg1 = 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  btQuaternion local_arg1;
  gdx_setbtQuaternionFromQuaternion(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitQuaternion auto_commit_arg1(jenv, jarg1, &local_arg1);
  result = (btScalar)length((btQuaternion const &)*arg1);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btAngle_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2) {
  jfloat jresult = 0 ;
  btQuaternion *arg1 = 0 ;
  btQuaternion *arg2 = 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  btQuaternion local_arg1;
  gdx_setbtQuaternionFromQuaternion(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitQuaternion auto_commit_arg1(jenv, jarg1, &local_arg1);
  btQuaternion local_arg2;
  gdx_setbtQuaternionFromQuaternion(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitQuaternion auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (btScalar)btAngle((btQuaternion const &)*arg1,(btQuaternion const &)*arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_inverse(JNIEnv *jenv, jclass jcls, jobject jarg1) {
  jobject jresult = 0 ;
  btQuaternion *arg1 = 0 ;
  btQuaternion result;
  
  (void)jenv;
  (void)jcls;
  btQuaternion local_arg1;
  gdx_setbtQuaternionFromQuaternion(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitQuaternion auto_commit_arg1(jenv, jarg1, &local_arg1);
  result = inverse((btQuaternion const &)*arg1);
  jresult = gdx_getReturnQuaternion(jenv);
  gdx_setQuaternionFrombtQuaternion(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_slerp(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jfloat jarg3) {
  jobject jresult = 0 ;
  btQuaternion *arg1 = 0 ;
  btQuaternion *arg2 = 0 ;
  btScalar *arg3 = 0 ;
  btScalar temp3 ;
  btQuaternion result;
  
  (void)jenv;
  (void)jcls;
  btQuaternion local_arg1;
  gdx_setbtQuaternionFromQuaternion(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitQuaternion auto_commit_arg1(jenv, jarg1, &local_arg1);
  btQuaternion local_arg2;
  gdx_setbtQuaternionFromQuaternion(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitQuaternion auto_commit_arg2(jenv, jarg2, &local_arg2);
  temp3 = (btScalar)jarg3; 
  arg3 = &temp3; 
  result = slerp((btQuaternion const &)*arg1,(btQuaternion const &)*arg2,(float const &)*arg3);
  jresult = gdx_getReturnQuaternion(jenv);
  gdx_setQuaternionFrombtQuaternion(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_quatRotate(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2) {
  jobject jresult = 0 ;
  btQuaternion *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  btQuaternion local_arg1;
  gdx_setbtQuaternionFromQuaternion(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitQuaternion auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = quatRotate((btQuaternion const &)*arg1,(btVector3 const &)*arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_shortestArcQuat(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2) {
  jobject jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btQuaternion result;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = shortestArcQuat((btVector3 const &)*arg1,(btVector3 const &)*arg2);
  jresult = gdx_getReturnQuaternion(jenv);
  gdx_setQuaternionFrombtQuaternion(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_shortestArcQuatNormalize2(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2) {
  jobject jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btQuaternion result;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = shortestArcQuatNormalize2(*arg1,*arg2);
  jresult = gdx_getReturnQuaternion(jenv);
  gdx_setQuaternionFrombtQuaternion(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btQuaternionFloatData_1floats_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloatArray jarg2) {
  btQuaternionFloatData *arg1 = (btQuaternionFloatData *) 0 ;
  float *arg2 ;
  jfloat *jarr2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuaternionFloatData **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  if (!SWIG_JavaArrayInFloat(jenv, &jarr2, (float **)&arg2, jarg2)) return ; 
  {
    size_t ii;
    float *b = (float *) arg1->m_floats;
    for (ii = 0; ii < (size_t)4; ii++) b[ii] = *((float *) arg2 + ii);
  }
  SWIG_JavaArrayArgoutFloat(jenv, jarr2, (float *)arg2, jarg2); 
  delete [] arg2; 
}


SWIGEXPORT jfloatArray JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btQuaternionFloatData_1floats_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloatArray jresult = 0 ;
  btQuaternionFloatData *arg1 = (btQuaternionFloatData *) 0 ;
  float *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuaternionFloatData **)&jarg1; 
  result = (float *)(float *) ((arg1)->m_floats);
  jresult = SWIG_JavaArrayOutFloat(jenv, (float *)result, 4); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btQuaternionFloatData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btQuaternionFloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btQuaternionFloatData *)new btQuaternionFloatData();
  *(btQuaternionFloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_delete_1btQuaternionFloatData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btQuaternionFloatData *arg1 = (btQuaternionFloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btQuaternionFloatData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btQuaternionDoubleData_1floats_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdoubleArray jarg2) {
  btQuaternionDoubleData *arg1 = (btQuaternionDoubleData *) 0 ;
  double *arg2 ;
  jdouble *jarr2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuaternionDoubleData **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  if (!SWIG_JavaArrayInDouble(jenv, &jarr2, (double **)&arg2, jarg2)) return ; 
  {
    size_t ii;
    double *b = (double *) arg1->m_floats;
    for (ii = 0; ii < (size_t)4; ii++) b[ii] = *((double *) arg2 + ii);
  }
  SWIG_JavaArrayArgoutDouble(jenv, jarr2, (double *)arg2, jarg2); 
  delete [] arg2; 
}


SWIGEXPORT jdoubleArray JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btQuaternionDoubleData_1floats_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdoubleArray jresult = 0 ;
  btQuaternionDoubleData *arg1 = (btQuaternionDoubleData *) 0 ;
  double *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btQuaternionDoubleData **)&jarg1; 
  result = (double *)(double *) ((arg1)->m_floats);
  jresult = SWIG_JavaArrayOutDouble(jenv, (double *)result, 4); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btQuaternionDoubleData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btQuaternionDoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btQuaternionDoubleData *)new btQuaternionDoubleData();
  *(btQuaternionDoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_delete_1btQuaternionDoubleData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btQuaternionDoubleData *arg1 = (btQuaternionDoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btQuaternionDoubleData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btMatrix3x3_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btMatrix3x3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btMatrix3x3 *)new btMatrix3x3();
  *(btMatrix3x3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btMatrix3x3_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jobject jarg1) {
  jlong jresult = 0 ;
  btQuaternion *arg1 = 0 ;
  btMatrix3x3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btQuaternion local_arg1;
  gdx_setbtQuaternionFromQuaternion(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitQuaternion auto_commit_arg1(jenv, jarg1, &local_arg1);
  result = (btMatrix3x3 *)new btMatrix3x3((btQuaternion const &)*arg1);
  *(btMatrix3x3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btMatrix3x3_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jfloat jarg1, jfloat jarg2, jfloat jarg3, jfloat jarg4, jfloat jarg5, jfloat jarg6, jfloat jarg7, jfloat jarg8, jfloat jarg9) {
  jlong jresult = 0 ;
  btScalar *arg1 = 0 ;
  btScalar *arg2 = 0 ;
  btScalar *arg3 = 0 ;
  btScalar *arg4 = 0 ;
  btScalar *arg5 = 0 ;
  btScalar *arg6 = 0 ;
  btScalar *arg7 = 0 ;
  btScalar *arg8 = 0 ;
  btScalar *arg9 = 0 ;
  btScalar temp1 ;
  btScalar temp2 ;
  btScalar temp3 ;
  btScalar temp4 ;
  btScalar temp5 ;
  btScalar temp6 ;
  btScalar temp7 ;
  btScalar temp8 ;
  btScalar temp9 ;
  btMatrix3x3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  temp1 = (btScalar)jarg1; 
  arg1 = &temp1; 
  temp2 = (btScalar)jarg2; 
  arg2 = &temp2; 
  temp3 = (btScalar)jarg3; 
  arg3 = &temp3; 
  temp4 = (btScalar)jarg4; 
  arg4 = &temp4; 
  temp5 = (btScalar)jarg5; 
  arg5 = &temp5; 
  temp6 = (btScalar)jarg6; 
  arg6 = &temp6; 
  temp7 = (btScalar)jarg7; 
  arg7 = &temp7; 
  temp8 = (btScalar)jarg8; 
  arg8 = &temp8; 
  temp9 = (btScalar)jarg9; 
  arg9 = &temp9; 
  result = (btMatrix3x3 *)new btMatrix3x3((btScalar const &)*arg1,(btScalar const &)*arg2,(btScalar const &)*arg3,(btScalar const &)*arg4,(btScalar const &)*arg5,(btScalar const &)*arg6,(btScalar const &)*arg7,(btScalar const &)*arg8,(btScalar const &)*arg9);
  *(btMatrix3x3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btMatrix3x3_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jobject jarg1) {
  jlong jresult = 0 ;
  btMatrix3x3 *arg1 = 0 ;
  btMatrix3x3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btMatrix3x3 local_arg1;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitMatrix3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  result = (btMatrix3x3 *)new btMatrix3x3((btMatrix3x3 const &)*arg1);
  *(btMatrix3x3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btMatrix3x3_1operatorAssignment(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jobject jresult = 0 ;
  btMatrix3x3 *arg1 = (btMatrix3x3 *) 0 ;
  btMatrix3x3 *arg2 = 0 ;
  btMatrix3x3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMatrix3x3 **)&jarg1; 
  btMatrix3x3 local_arg2;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (btMatrix3x3 *) &(arg1)->operator =((btMatrix3x3 const &)*arg2);
  jresult = gdx_getReturnMatrix3(jenv);
  gdx_setMatrix3FrombtMatrix3x3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btMatrix3x3_1getColumn(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jobject jresult = 0 ;
  btMatrix3x3 *arg1 = (btMatrix3x3 *) 0 ;
  int arg2 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMatrix3x3 **)&jarg1; 
  arg2 = (int)jarg2; 
  result = ((btMatrix3x3 const *)arg1)->getColumn(arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btMatrix3x3_1getRow(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jobject jresult = 0 ;
  btMatrix3x3 *arg1 = (btMatrix3x3 *) 0 ;
  int arg2 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMatrix3x3 **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (btVector3 *) &((btMatrix3x3 const *)arg1)->getRow(arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btMatrix3x3_1operatorSubscript(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jobject jresult = 0 ;
  btMatrix3x3 *arg1 = (btMatrix3x3 *) 0 ;
  int arg2 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMatrix3x3 **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (btVector3 *) &(arg1)->operator [](arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btMatrix3x3_1operatorSubscriptConst(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jobject jresult = 0 ;
  btMatrix3x3 *arg1 = (btMatrix3x3 *) 0 ;
  int arg2 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMatrix3x3 **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (btVector3 *) &((btMatrix3x3 const *)arg1)->operator [](arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btMatrix3x3_1operatorMultiplicationAssignment(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jobject jresult = 0 ;
  btMatrix3x3 *arg1 = (btMatrix3x3 *) 0 ;
  btMatrix3x3 *arg2 = 0 ;
  btMatrix3x3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMatrix3x3 **)&jarg1; 
  btMatrix3x3 local_arg2;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (btMatrix3x3 *) &(arg1)->operator *=((btMatrix3x3 const &)*arg2);
  jresult = gdx_getReturnMatrix3(jenv);
  gdx_setMatrix3FrombtMatrix3x3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btMatrix3x3_1operatorAdditionAssignment(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jobject jresult = 0 ;
  btMatrix3x3 *arg1 = (btMatrix3x3 *) 0 ;
  btMatrix3x3 *arg2 = 0 ;
  btMatrix3x3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMatrix3x3 **)&jarg1; 
  btMatrix3x3 local_arg2;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (btMatrix3x3 *) &(arg1)->operator +=((btMatrix3x3 const &)*arg2);
  jresult = gdx_getReturnMatrix3(jenv);
  gdx_setMatrix3FrombtMatrix3x3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btMatrix3x3_1operatorSubtractionAssignment(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jobject jresult = 0 ;
  btMatrix3x3 *arg1 = (btMatrix3x3 *) 0 ;
  btMatrix3x3 *arg2 = 0 ;
  btMatrix3x3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMatrix3x3 **)&jarg1; 
  btMatrix3x3 local_arg2;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (btMatrix3x3 *) &(arg1)->operator -=((btMatrix3x3 const &)*arg2);
  jresult = gdx_getReturnMatrix3(jenv);
  gdx_setMatrix3FrombtMatrix3x3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btMatrix3x3_1setFromOpenGLSubMatrix(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btMatrix3x3 *arg1 = (btMatrix3x3 *) 0 ;
  btScalar *arg2 = (btScalar *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMatrix3x3 **)&jarg1; 
  {
    arg2 = (btScalar*)jenv->GetDirectBufferAddress(jarg2);
    if (arg2 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  (arg1)->setFromOpenGLSubMatrix((btScalar const *)arg2);
  
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btMatrix3x3_1setValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jfloat jarg3, jfloat jarg4, jfloat jarg5, jfloat jarg6, jfloat jarg7, jfloat jarg8, jfloat jarg9, jfloat jarg10) {
  btMatrix3x3 *arg1 = (btMatrix3x3 *) 0 ;
  btScalar *arg2 = 0 ;
  btScalar *arg3 = 0 ;
  btScalar *arg4 = 0 ;
  btScalar *arg5 = 0 ;
  btScalar *arg6 = 0 ;
  btScalar *arg7 = 0 ;
  btScalar *arg8 = 0 ;
  btScalar *arg9 = 0 ;
  btScalar *arg10 = 0 ;
  btScalar temp2 ;
  btScalar temp3 ;
  btScalar temp4 ;
  btScalar temp5 ;
  btScalar temp6 ;
  btScalar temp7 ;
  btScalar temp8 ;
  btScalar temp9 ;
  btScalar temp10 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMatrix3x3 **)&jarg1; 
  temp2 = (btScalar)jarg2; 
  arg2 = &temp2; 
  temp3 = (btScalar)jarg3; 
  arg3 = &temp3; 
  temp4 = (btScalar)jarg4; 
  arg4 = &temp4; 
  temp5 = (btScalar)jarg5; 
  arg5 = &temp5; 
  temp6 = (btScalar)jarg6; 
  arg6 = &temp6; 
  temp7 = (btScalar)jarg7; 
  arg7 = &temp7; 
  temp8 = (btScalar)jarg8; 
  arg8 = &temp8; 
  temp9 = (btScalar)jarg9; 
  arg9 = &temp9; 
  temp10 = (btScalar)jarg10; 
  arg10 = &temp10; 
  (arg1)->setValue((btScalar const &)*arg2,(btScalar const &)*arg3,(btScalar const &)*arg4,(btScalar const &)*arg5,(btScalar const &)*arg6,(btScalar const &)*arg7,(btScalar const &)*arg8,(btScalar const &)*arg9,(btScalar const &)*arg10);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btMatrix3x3_1setRotation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btMatrix3x3 *arg1 = (btMatrix3x3 *) 0 ;
  btQuaternion *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMatrix3x3 **)&jarg1; 
  btQuaternion local_arg2;
  gdx_setbtQuaternionFromQuaternion(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitQuaternion auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->setRotation((btQuaternion const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btMatrix3x3_1setEulerYPR(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jfloat jarg3, jfloat jarg4) {
  btMatrix3x3 *arg1 = (btMatrix3x3 *) 0 ;
  btScalar *arg2 = 0 ;
  btScalar *arg3 = 0 ;
  btScalar *arg4 = 0 ;
  btScalar temp2 ;
  btScalar temp3 ;
  btScalar temp4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMatrix3x3 **)&jarg1; 
  temp2 = (btScalar)jarg2; 
  arg2 = &temp2; 
  temp3 = (btScalar)jarg3; 
  arg3 = &temp3; 
  temp4 = (btScalar)jarg4; 
  arg4 = &temp4; 
  (arg1)->setEulerYPR((btScalar const &)*arg2,(btScalar const &)*arg3,(btScalar const &)*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btMatrix3x3_1setEulerZYX(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jfloat jarg3, jfloat jarg4) {
  btMatrix3x3 *arg1 = (btMatrix3x3 *) 0 ;
  btScalar arg2 ;
  btScalar arg3 ;
  btScalar arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMatrix3x3 **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  arg3 = (btScalar)jarg3; 
  arg4 = (btScalar)jarg4; 
  (arg1)->setEulerZYX(arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btMatrix3x3_1setIdentity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btMatrix3x3 *arg1 = (btMatrix3x3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMatrix3x3 **)&jarg1; 
  (arg1)->setIdentity();
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btMatrix3x3_1getIdentity(JNIEnv *jenv, jclass jcls) {
  jobject jresult = 0 ;
  btMatrix3x3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btMatrix3x3 *) &btMatrix3x3::getIdentity();
  jresult = gdx_getReturnMatrix3(jenv);
  gdx_setMatrix3FrombtMatrix3x3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btMatrix3x3_1getOpenGLSubMatrix(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btMatrix3x3 *arg1 = (btMatrix3x3 *) 0 ;
  btScalar *arg2 = (btScalar *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMatrix3x3 **)&jarg1; 
  {
    arg2 = (btScalar*)jenv->GetDirectBufferAddress(jarg2);
    if (arg2 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  ((btMatrix3x3 const *)arg1)->getOpenGLSubMatrix(arg2);
  
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btMatrix3x3_1getRotation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btMatrix3x3 *arg1 = (btMatrix3x3 *) 0 ;
  btQuaternion *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMatrix3x3 **)&jarg1; 
  btQuaternion local_arg2;
  gdx_setbtQuaternionFromQuaternion(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitQuaternion auto_commit_arg2(jenv, jarg2, &local_arg2);
  ((btMatrix3x3 const *)arg1)->getRotation(*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btMatrix3x3_1getEulerYPR(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4) {
  btMatrix3x3 *arg1 = (btMatrix3x3 *) 0 ;
  btScalar *arg2 = 0 ;
  btScalar *arg3 = 0 ;
  btScalar *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMatrix3x3 **)&jarg1; 
  arg2 = *(btScalar **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btScalar & reference is null");
    return ;
  } 
  arg3 = *(btScalar **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btScalar & reference is null");
    return ;
  } 
  arg4 = *(btScalar **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btScalar & reference is null");
    return ;
  } 
  ((btMatrix3x3 const *)arg1)->getEulerYPR(*arg2,*arg3,*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btMatrix3x3_1getEulerZYX_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4, jlong jarg5) {
  btMatrix3x3 *arg1 = (btMatrix3x3 *) 0 ;
  btScalar *arg2 = 0 ;
  btScalar *arg3 = 0 ;
  btScalar *arg4 = 0 ;
  unsigned int arg5 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMatrix3x3 **)&jarg1; 
  arg2 = *(btScalar **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btScalar & reference is null");
    return ;
  } 
  arg3 = *(btScalar **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btScalar & reference is null");
    return ;
  } 
  arg4 = *(btScalar **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btScalar & reference is null");
    return ;
  } 
  arg5 = (unsigned int)jarg5; 
  ((btMatrix3x3 const *)arg1)->getEulerZYX(*arg2,*arg3,*arg4,arg5);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btMatrix3x3_1getEulerZYX_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4) {
  btMatrix3x3 *arg1 = (btMatrix3x3 *) 0 ;
  btScalar *arg2 = 0 ;
  btScalar *arg3 = 0 ;
  btScalar *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMatrix3x3 **)&jarg1; 
  arg2 = *(btScalar **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btScalar & reference is null");
    return ;
  } 
  arg3 = *(btScalar **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btScalar & reference is null");
    return ;
  } 
  arg4 = *(btScalar **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btScalar & reference is null");
    return ;
  } 
  ((btMatrix3x3 const *)arg1)->getEulerZYX(*arg2,*arg3,*arg4);
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btMatrix3x3_1scaled(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jobject jresult = 0 ;
  btMatrix3x3 *arg1 = (btMatrix3x3 *) 0 ;
  btVector3 *arg2 = 0 ;
  btMatrix3x3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMatrix3x3 **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = ((btMatrix3x3 const *)arg1)->scaled((btVector3 const &)*arg2);
  jresult = gdx_getReturnMatrix3(jenv);
  gdx_setMatrix3FrombtMatrix3x3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btMatrix3x3_1determinant(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btMatrix3x3 *arg1 = (btMatrix3x3 *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMatrix3x3 **)&jarg1; 
  result = (btScalar)((btMatrix3x3 const *)arg1)->determinant();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btMatrix3x3_1adjoint(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btMatrix3x3 *arg1 = (btMatrix3x3 *) 0 ;
  btMatrix3x3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMatrix3x3 **)&jarg1; 
  result = ((btMatrix3x3 const *)arg1)->adjoint();
  jresult = gdx_getReturnMatrix3(jenv);
  gdx_setMatrix3FrombtMatrix3x3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btMatrix3x3_1absolute(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btMatrix3x3 *arg1 = (btMatrix3x3 *) 0 ;
  btMatrix3x3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMatrix3x3 **)&jarg1; 
  result = ((btMatrix3x3 const *)arg1)->absolute();
  jresult = gdx_getReturnMatrix3(jenv);
  gdx_setMatrix3FrombtMatrix3x3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btMatrix3x3_1transpose(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btMatrix3x3 *arg1 = (btMatrix3x3 *) 0 ;
  btMatrix3x3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMatrix3x3 **)&jarg1; 
  result = ((btMatrix3x3 const *)arg1)->transpose();
  jresult = gdx_getReturnMatrix3(jenv);
  gdx_setMatrix3FrombtMatrix3x3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btMatrix3x3_1inverse(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btMatrix3x3 *arg1 = (btMatrix3x3 *) 0 ;
  btMatrix3x3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMatrix3x3 **)&jarg1; 
  result = ((btMatrix3x3 const *)arg1)->inverse();
  jresult = gdx_getReturnMatrix3(jenv);
  gdx_setMatrix3FrombtMatrix3x3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btMatrix3x3_1solve33(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jobject jresult = 0 ;
  btMatrix3x3 *arg1 = (btMatrix3x3 *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMatrix3x3 **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = ((btMatrix3x3 const *)arg1)->solve33((btVector3 const &)*arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btMatrix3x3_1transposeTimes(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jobject jresult = 0 ;
  btMatrix3x3 *arg1 = (btMatrix3x3 *) 0 ;
  btMatrix3x3 *arg2 = 0 ;
  btMatrix3x3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMatrix3x3 **)&jarg1; 
  btMatrix3x3 local_arg2;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = ((btMatrix3x3 const *)arg1)->transposeTimes((btMatrix3x3 const &)*arg2);
  jresult = gdx_getReturnMatrix3(jenv);
  gdx_setMatrix3FrombtMatrix3x3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btMatrix3x3_1timesTranspose(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jobject jresult = 0 ;
  btMatrix3x3 *arg1 = (btMatrix3x3 *) 0 ;
  btMatrix3x3 *arg2 = 0 ;
  btMatrix3x3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMatrix3x3 **)&jarg1; 
  btMatrix3x3 local_arg2;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = ((btMatrix3x3 const *)arg1)->timesTranspose((btMatrix3x3 const &)*arg2);
  jresult = gdx_getReturnMatrix3(jenv);
  gdx_setMatrix3FrombtMatrix3x3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btMatrix3x3_1tdotx(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jfloat jresult = 0 ;
  btMatrix3x3 *arg1 = (btMatrix3x3 *) 0 ;
  btVector3 *arg2 = 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMatrix3x3 **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (btScalar)((btMatrix3x3 const *)arg1)->tdotx((btVector3 const &)*arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btMatrix3x3_1tdoty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jfloat jresult = 0 ;
  btMatrix3x3 *arg1 = (btMatrix3x3 *) 0 ;
  btVector3 *arg2 = 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMatrix3x3 **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (btScalar)((btMatrix3x3 const *)arg1)->tdoty((btVector3 const &)*arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btMatrix3x3_1tdotz(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jfloat jresult = 0 ;
  btMatrix3x3 *arg1 = (btMatrix3x3 *) 0 ;
  btVector3 *arg2 = 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMatrix3x3 **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (btScalar)((btMatrix3x3 const *)arg1)->tdotz((btVector3 const &)*arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btMatrix3x3_1extractRotation_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jfloat jarg3, jint jarg4) {
  btMatrix3x3 *arg1 = (btMatrix3x3 *) 0 ;
  btQuaternion *arg2 = 0 ;
  btScalar arg3 ;
  int arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMatrix3x3 **)&jarg1; 
  btQuaternion local_arg2;
  gdx_setbtQuaternionFromQuaternion(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitQuaternion auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (btScalar)jarg3; 
  arg4 = (int)jarg4; 
  (arg1)->extractRotation(*arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btMatrix3x3_1extractRotation_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jfloat jarg3) {
  btMatrix3x3 *arg1 = (btMatrix3x3 *) 0 ;
  btQuaternion *arg2 = 0 ;
  btScalar arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMatrix3x3 **)&jarg1; 
  btQuaternion local_arg2;
  gdx_setbtQuaternionFromQuaternion(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitQuaternion auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (btScalar)jarg3; 
  (arg1)->extractRotation(*arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btMatrix3x3_1extractRotation_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btMatrix3x3 *arg1 = (btMatrix3x3 *) 0 ;
  btQuaternion *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMatrix3x3 **)&jarg1; 
  btQuaternion local_arg2;
  gdx_setbtQuaternionFromQuaternion(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitQuaternion auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->extractRotation(*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btMatrix3x3_1diagonalize_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jfloat jarg3, jint jarg4) {
  btMatrix3x3 *arg1 = (btMatrix3x3 *) 0 ;
  btMatrix3x3 *arg2 = 0 ;
  btScalar arg3 ;
  int arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMatrix3x3 **)&jarg1; 
  btMatrix3x3 local_arg2;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (btScalar)jarg3; 
  arg4 = (int)jarg4; 
  (arg1)->diagonalize(*arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btMatrix3x3_1diagonalize_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jfloat jarg3) {
  btMatrix3x3 *arg1 = (btMatrix3x3 *) 0 ;
  btMatrix3x3 *arg2 = 0 ;
  btScalar arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMatrix3x3 **)&jarg1; 
  btMatrix3x3 local_arg2;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (btScalar)jarg3; 
  (arg1)->diagonalize(*arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btMatrix3x3_1diagonalize_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btMatrix3x3 *arg1 = (btMatrix3x3 *) 0 ;
  btMatrix3x3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMatrix3x3 **)&jarg1; 
  btMatrix3x3 local_arg2;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->diagonalize(*arg2);
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btMatrix3x3_1cofac(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3, jint jarg4, jint jarg5) {
  jfloat jresult = 0 ;
  btMatrix3x3 *arg1 = (btMatrix3x3 *) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  int arg5 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMatrix3x3 **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (int)jarg5; 
  result = (btScalar)((btMatrix3x3 const *)arg1)->cofac(arg2,arg3,arg4,arg5);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btMatrix3x3_1serialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btMatrix3x3 *arg1 = (btMatrix3x3 *) 0 ;
  btMatrix3x3FloatData *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btMatrix3x3 **)&jarg1; 
  arg2 = *(btMatrix3x3FloatData **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btMatrix3x3FloatData & reference is null");
    return ;
  } 
  ((btMatrix3x3 const *)arg1)->serialize(*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btMatrix3x3_1serializeFloat(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btMatrix3x3 *arg1 = (btMatrix3x3 *) 0 ;
  btMatrix3x3FloatData *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btMatrix3x3 **)&jarg1; 
  arg2 = *(btMatrix3x3FloatData **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btMatrix3x3FloatData & reference is null");
    return ;
  } 
  ((btMatrix3x3 const *)arg1)->serializeFloat(*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btMatrix3x3_1deSerialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btMatrix3x3 *arg1 = (btMatrix3x3 *) 0 ;
  btMatrix3x3FloatData *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btMatrix3x3 **)&jarg1; 
  arg2 = *(btMatrix3x3FloatData **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btMatrix3x3FloatData const & reference is null");
    return ;
  } 
  (arg1)->deSerialize((btMatrix3x3FloatData const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btMatrix3x3_1deSerializeFloat(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btMatrix3x3 *arg1 = (btMatrix3x3 *) 0 ;
  btMatrix3x3FloatData *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btMatrix3x3 **)&jarg1; 
  arg2 = *(btMatrix3x3FloatData **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btMatrix3x3FloatData const & reference is null");
    return ;
  } 
  (arg1)->deSerializeFloat((btMatrix3x3FloatData const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btMatrix3x3_1deSerializeDouble(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btMatrix3x3 *arg1 = (btMatrix3x3 *) 0 ;
  btMatrix3x3DoubleData *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btMatrix3x3 **)&jarg1; 
  arg2 = *(btMatrix3x3DoubleData **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btMatrix3x3DoubleData const & reference is null");
    return ;
  } 
  (arg1)->deSerializeDouble((btMatrix3x3DoubleData const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_delete_1btMatrix3x3(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btMatrix3x3 *arg1 = (btMatrix3x3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btMatrix3x3 **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_operatorMultiplication_1_1SWIG_16(JNIEnv *jenv, jclass jcls, jobject jarg1, jfloat jarg2) {
  jobject jresult = 0 ;
  btMatrix3x3 *arg1 = 0 ;
  btScalar *arg2 = 0 ;
  btScalar temp2 ;
  btMatrix3x3 result;
  
  (void)jenv;
  (void)jcls;
  btMatrix3x3 local_arg1;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitMatrix3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  temp2 = (btScalar)jarg2; 
  arg2 = &temp2; 
  result = operator *((btMatrix3x3 const &)*arg1,(float const &)*arg2);
  jresult = gdx_getReturnMatrix3(jenv);
  gdx_setMatrix3FrombtMatrix3x3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_operatorAddition_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2) {
  jobject jresult = 0 ;
  btMatrix3x3 *arg1 = 0 ;
  btMatrix3x3 *arg2 = 0 ;
  btMatrix3x3 result;
  
  (void)jenv;
  (void)jcls;
  btMatrix3x3 local_arg1;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitMatrix3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btMatrix3x3 local_arg2;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = operator +((btMatrix3x3 const &)*arg1,(btMatrix3x3 const &)*arg2);
  jresult = gdx_getReturnMatrix3(jenv);
  gdx_setMatrix3FrombtMatrix3x3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_operatorSubtraction_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2) {
  jobject jresult = 0 ;
  btMatrix3x3 *arg1 = 0 ;
  btMatrix3x3 *arg2 = 0 ;
  btMatrix3x3 result;
  
  (void)jenv;
  (void)jcls;
  btMatrix3x3 local_arg1;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitMatrix3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btMatrix3x3 local_arg2;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = operator -((btMatrix3x3 const &)*arg1,(btMatrix3x3 const &)*arg2);
  jresult = gdx_getReturnMatrix3(jenv);
  gdx_setMatrix3FrombtMatrix3x3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_operatorMultiplication_1_1SWIG_17(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2) {
  jobject jresult = 0 ;
  btMatrix3x3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  btMatrix3x3 local_arg1;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitMatrix3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = operator *((btMatrix3x3 const &)*arg1,(btVector3 const &)*arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_operatorMultiplication_1_1SWIG_18(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2) {
  jobject jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btMatrix3x3 *arg2 = 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btMatrix3x3 local_arg2;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = operator *((btVector3 const &)*arg1,(btMatrix3x3 const &)*arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_operatorMultiplication_1_1SWIG_19(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2) {
  jobject jresult = 0 ;
  btMatrix3x3 *arg1 = 0 ;
  btMatrix3x3 *arg2 = 0 ;
  btMatrix3x3 result;
  
  (void)jenv;
  (void)jcls;
  btMatrix3x3 local_arg1;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitMatrix3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btMatrix3x3 local_arg2;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = operator *((btMatrix3x3 const &)*arg1,(btMatrix3x3 const &)*arg2);
  jresult = gdx_getReturnMatrix3(jenv);
  gdx_setMatrix3FrombtMatrix3x3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_operatorEqualTo_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2) {
  jboolean jresult = 0 ;
  btMatrix3x3 *arg1 = 0 ;
  btMatrix3x3 *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  btMatrix3x3 local_arg1;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitMatrix3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btMatrix3x3 local_arg2;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (bool)operator ==((btMatrix3x3 const &)*arg1,(btMatrix3x3 const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btMatrix3x3FloatData_1el_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btMatrix3x3FloatData *arg1 = (btMatrix3x3FloatData *) 0 ;
  btVector3FloatData *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btMatrix3x3FloatData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  {
    size_t ii;
    btVector3FloatData *b = (btVector3FloatData *) arg1->m_el;
    for (ii = 0; ii < (size_t)3; ii++) b[ii] = *((btVector3FloatData *) arg2 + ii);
  }
  
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btMatrix3x3FloatData_1el_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btMatrix3x3FloatData *arg1 = (btMatrix3x3FloatData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMatrix3x3FloatData **)&jarg1; 
  result = (btVector3FloatData *)(btVector3FloatData *) ((arg1)->m_el);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btMatrix3x3FloatData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btMatrix3x3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btMatrix3x3FloatData *)new btMatrix3x3FloatData();
  *(btMatrix3x3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_delete_1btMatrix3x3FloatData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btMatrix3x3FloatData *arg1 = (btMatrix3x3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btMatrix3x3FloatData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btMatrix3x3DoubleData_1el_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btMatrix3x3DoubleData *arg1 = (btMatrix3x3DoubleData *) 0 ;
  btVector3DoubleData *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btMatrix3x3DoubleData **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  {
    size_t ii;
    btVector3DoubleData *b = (btVector3DoubleData *) arg1->m_el;
    for (ii = 0; ii < (size_t)3; ii++) b[ii] = *((btVector3DoubleData *) arg2 + ii);
  }
  
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btMatrix3x3DoubleData_1el_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btMatrix3x3DoubleData *arg1 = (btMatrix3x3DoubleData *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMatrix3x3DoubleData **)&jarg1; 
  result = (btVector3DoubleData *)(btVector3DoubleData *) ((arg1)->m_el);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btMatrix3x3DoubleData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btMatrix3x3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btMatrix3x3DoubleData *)new btMatrix3x3DoubleData();
  *(btMatrix3x3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_delete_1btMatrix3x3DoubleData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btMatrix3x3DoubleData *arg1 = (btMatrix3x3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btMatrix3x3DoubleData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_AabbExpand(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jobject jarg3, jobject jarg4) {
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  AabbExpand(*arg1,*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4);
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_TestPointAgainstAabb2(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jobject jarg3) {
  jboolean jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  result = (bool)TestPointAgainstAabb2((btVector3 const &)*arg1,(btVector3 const &)*arg2,(btVector3 const &)*arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_TestAabbAgainstAabb2(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jobject jarg3, jobject jarg4) {
  jboolean jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  result = (bool)TestAabbAgainstAabb2((btVector3 const &)*arg1,(btVector3 const &)*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_TestTriangleAgainstAabb2(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3) {
  jboolean jresult = 0 ;
  btVector3 *arg1 = (btVector3 *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVector3 **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  result = (bool)TestTriangleAgainstAabb2((btVector3 const *)arg1,(btVector3 const &)*arg2,(btVector3 const &)*arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btOutcode(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2) {
  jint jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (int)btOutcode((btVector3 const &)*arg1,(btVector3 const &)*arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btRayAabb2(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jlongArray jarg3, jlong jarg4, jobject jarg4_, jlong jarg5, jfloat jarg6, jfloat jarg7) {
  jboolean jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  unsigned int *arg3 ;
  btVector3 *arg4 ;
  btScalar *arg5 = 0 ;
  btScalar arg6 ;
  btScalar arg7 ;
  jlong *jarr3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg4_;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  if (jarg3 && jenv->GetArrayLength(jarg3) != 3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return 0;
  }
  if (!SWIG_JavaArrayInUint(jenv, &jarr3, (unsigned int **)&arg3, jarg3)) return 0; 
  arg4 = *(btVector3 **)&jarg4; 
  arg5 = *(btScalar **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btScalar & reference is null");
    return 0;
  } 
  arg6 = (btScalar)jarg6; 
  arg7 = (btScalar)jarg7; 
  result = (bool)btRayAabb2((btVector3 const &)*arg1,(btVector3 const &)*arg2,(unsigned int const (*))arg3,(btVector3 const (*))arg4,*arg5,arg6,arg7);
  jresult = (jboolean)result; 
  SWIG_JavaArrayArgoutUint(jenv, jarr3, (unsigned int *)arg3, jarg3); 
  delete [] arg3; 
  
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btRayAabb(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jobject jarg3, jobject jarg4, jlong jarg5, jobject jarg6) {
  jboolean jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btScalar *arg5 = 0 ;
  btVector3 *arg6 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  arg5 = *(btScalar **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btScalar & reference is null");
    return 0;
  } 
  btVector3 local_arg6;
  gdx_setbtVector3FromVector3(jenv, local_arg6, jarg6);
  arg6 = &local_arg6;
  gdxAutoCommitVector3 auto_commit_arg6(jenv, jarg6, &local_arg6);
  result = (bool)btRayAabb((btVector3 const &)*arg1,(btVector3 const &)*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4,*arg5,*arg6);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btTransformAabb_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jobject jarg1, jfloat jarg2, jobject jarg3, jobject jarg4, jobject jarg5) {
  btVector3 *arg1 = 0 ;
  btScalar arg2 ;
  btTransform *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  arg2 = (btScalar)jarg2; 
  btTransform local_arg3;
  gdx_setbtTransformFromMatrix4(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitMatrix4 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  btTransformAabb((btVector3 const &)*arg1,arg2,(btTransform const &)*arg3,*arg4,*arg5);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btTransformAabb_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jfloat jarg3, jobject jarg4, jobject jarg5, jobject jarg6) {
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btScalar arg3 ;
  btTransform *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  btVector3 *arg6 = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (btScalar)jarg3; 
  btTransform local_arg4;
  gdx_setbtTransformFromMatrix4(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitMatrix4 auto_commit_arg4(jenv, jarg4, &local_arg4);
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  btVector3 local_arg6;
  gdx_setbtVector3FromVector3(jenv, local_arg6, jarg6);
  arg6 = &local_arg6;
  gdxAutoCommitVector3 auto_commit_arg6(jenv, jarg6, &local_arg6);
  btTransformAabb((btVector3 const &)*arg1,(btVector3 const &)*arg2,arg3,(btTransform const &)*arg4,*arg5,*arg6);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_testQuantizedAabbAgainstQuantizedAabb(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jobject jarg3, jobject jarg4) {
  jlong jresult = 0 ;
  unsigned short *arg1 = (unsigned short *) 0 ;
  unsigned short *arg2 = (unsigned short *) 0 ;
  unsigned short *arg3 = (unsigned short *) 0 ;
  unsigned short *arg4 = (unsigned short *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  {
    arg1 = (unsigned short*)jenv->GetDirectBufferAddress(jarg1);
    if (arg1 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  {
    arg2 = (unsigned short*)jenv->GetDirectBufferAddress(jarg2);
    if (arg2 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  {
    arg3 = (unsigned short*)jenv->GetDirectBufferAddress(jarg3);
    if (arg3 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  {
    arg4 = (unsigned short*)jenv->GetDirectBufferAddress(jarg4);
    if (arg4 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  result = (unsigned int)testQuantizedAabbAgainstQuantizedAabb((unsigned short const *)arg1,(unsigned short const *)arg2,(unsigned short const *)arg3,(unsigned short const *)arg4);
  jresult = (jlong)result; 
  
  
  
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1DefaultColors_1activeObject_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btIDebugDraw::DefaultColors *arg1 = (btIDebugDraw::DefaultColors *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btIDebugDraw::DefaultColors **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_activeObject = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1DefaultColors_1activeObject_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btIDebugDraw::DefaultColors *arg1 = (btIDebugDraw::DefaultColors *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIDebugDraw::DefaultColors **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_activeObject);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1DefaultColors_1deactivatedObject_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btIDebugDraw::DefaultColors *arg1 = (btIDebugDraw::DefaultColors *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btIDebugDraw::DefaultColors **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_deactivatedObject = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1DefaultColors_1deactivatedObject_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btIDebugDraw::DefaultColors *arg1 = (btIDebugDraw::DefaultColors *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIDebugDraw::DefaultColors **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_deactivatedObject);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1DefaultColors_1wantsDeactivationObject_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btIDebugDraw::DefaultColors *arg1 = (btIDebugDraw::DefaultColors *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btIDebugDraw::DefaultColors **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_wantsDeactivationObject = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1DefaultColors_1wantsDeactivationObject_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btIDebugDraw::DefaultColors *arg1 = (btIDebugDraw::DefaultColors *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIDebugDraw::DefaultColors **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_wantsDeactivationObject);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1DefaultColors_1disabledDeactivationObject_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btIDebugDraw::DefaultColors *arg1 = (btIDebugDraw::DefaultColors *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btIDebugDraw::DefaultColors **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_disabledDeactivationObject = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1DefaultColors_1disabledDeactivationObject_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btIDebugDraw::DefaultColors *arg1 = (btIDebugDraw::DefaultColors *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIDebugDraw::DefaultColors **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_disabledDeactivationObject);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1DefaultColors_1disabledSimulationObject_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btIDebugDraw::DefaultColors *arg1 = (btIDebugDraw::DefaultColors *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btIDebugDraw::DefaultColors **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_disabledSimulationObject = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1DefaultColors_1disabledSimulationObject_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btIDebugDraw::DefaultColors *arg1 = (btIDebugDraw::DefaultColors *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIDebugDraw::DefaultColors **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_disabledSimulationObject);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1DefaultColors_1aabb_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btIDebugDraw::DefaultColors *arg1 = (btIDebugDraw::DefaultColors *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btIDebugDraw::DefaultColors **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_aabb = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1DefaultColors_1aabb_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btIDebugDraw::DefaultColors *arg1 = (btIDebugDraw::DefaultColors *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIDebugDraw::DefaultColors **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_aabb);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1DefaultColors_1contactPoint_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btIDebugDraw::DefaultColors *arg1 = (btIDebugDraw::DefaultColors *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btIDebugDraw::DefaultColors **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_contactPoint = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1DefaultColors_1contactPoint_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btIDebugDraw::DefaultColors *arg1 = (btIDebugDraw::DefaultColors *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIDebugDraw::DefaultColors **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_contactPoint);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btIDebugDraw_1DefaultColors(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btIDebugDraw::DefaultColors *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btIDebugDraw::DefaultColors *)new btIDebugDraw::DefaultColors();
  *(btIDebugDraw::DefaultColors **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_delete_1btIDebugDraw_1DefaultColors(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btIDebugDraw::DefaultColors *arg1 = (btIDebugDraw::DefaultColors *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btIDebugDraw::DefaultColors **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_delete_1btIDebugDraw(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btIDebugDraw **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1getDefaultColors(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btIDebugDraw::DefaultColors result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  result = ((btIDebugDraw const *)arg1)->getDefaultColors();
  *(btIDebugDraw::DefaultColors **)&jresult = new btIDebugDraw::DefaultColors((const btIDebugDraw::DefaultColors &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1getDefaultColorsSwigExplicitbtIDebugDraw(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btIDebugDraw::DefaultColors result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  result = ((btIDebugDraw const *)arg1)->btIDebugDraw::getDefaultColors();
  *(btIDebugDraw::DefaultColors **)&jresult = new btIDebugDraw::DefaultColors((const btIDebugDraw::DefaultColors &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1setDefaultColors(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btIDebugDraw::DefaultColors *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  arg2 = *(btIDebugDraw::DefaultColors **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btIDebugDraw::DefaultColors const & reference is null");
    return ;
  } 
  (arg1)->setDefaultColors((btIDebugDraw::DefaultColors const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1setDefaultColorsSwigExplicitbtIDebugDraw(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btIDebugDraw::DefaultColors *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  arg2 = *(btIDebugDraw::DefaultColors **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btIDebugDraw::DefaultColors const & reference is null");
    return ;
  } 
  (arg1)->btIDebugDraw::setDefaultColors((btIDebugDraw::DefaultColors const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1drawLine_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jobject jarg4) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  (arg1)->drawLine((btVector3 const &)*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1drawLine_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jobject jarg4, jobject jarg5) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  (arg1)->drawLine((btVector3 const &)*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4,(btVector3 const &)*arg5);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1drawLineSwigExplicitbtIDebugDraw_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jobject jarg4, jobject jarg5) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  (arg1)->btIDebugDraw::drawLine((btVector3 const &)*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4,(btVector3 const &)*arg5);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1drawSphere_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jobject jarg3, jobject jarg4) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btScalar arg2 ;
  btTransform *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  btTransform local_arg3;
  gdx_setbtTransformFromMatrix4(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitMatrix4 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  (arg1)->drawSphere(arg2,(btTransform const &)*arg3,(btVector3 const &)*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1drawSphereSwigExplicitbtIDebugDraw_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jobject jarg3, jobject jarg4) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btScalar arg2 ;
  btTransform *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  btTransform local_arg3;
  gdx_setbtTransformFromMatrix4(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitMatrix4 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  (arg1)->btIDebugDraw::drawSphere(arg2,(btTransform const &)*arg3,(btVector3 const &)*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1drawSphere_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jfloat jarg3, jobject jarg4) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btVector3 *arg2 = 0 ;
  btScalar arg3 ;
  btVector3 *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (btScalar)jarg3; 
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  (arg1)->drawSphere((btVector3 const &)*arg2,arg3,(btVector3 const &)*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1drawSphereSwigExplicitbtIDebugDraw_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jfloat jarg3, jobject jarg4) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btVector3 *arg2 = 0 ;
  btScalar arg3 ;
  btVector3 *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (btScalar)jarg3; 
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  (arg1)->btIDebugDraw::drawSphere((btVector3 const &)*arg2,arg3,(btVector3 const &)*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1drawTriangle_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jobject jarg4, jobject jarg5, jobject jarg6, jobject jarg7, jobject jarg8, jfloat jarg9) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  btVector3 *arg6 = 0 ;
  btVector3 *arg7 = 0 ;
  btVector3 *arg8 = 0 ;
  btScalar arg9 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  btVector3 local_arg6;
  gdx_setbtVector3FromVector3(jenv, local_arg6, jarg6);
  arg6 = &local_arg6;
  gdxAutoCommitVector3 auto_commit_arg6(jenv, jarg6, &local_arg6);
  btVector3 local_arg7;
  gdx_setbtVector3FromVector3(jenv, local_arg7, jarg7);
  arg7 = &local_arg7;
  gdxAutoCommitVector3 auto_commit_arg7(jenv, jarg7, &local_arg7);
  btVector3 local_arg8;
  gdx_setbtVector3FromVector3(jenv, local_arg8, jarg8);
  arg8 = &local_arg8;
  gdxAutoCommitVector3 auto_commit_arg8(jenv, jarg8, &local_arg8);
  arg9 = (btScalar)jarg9; 
  (arg1)->drawTriangle((btVector3 const &)*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4,(btVector3 const &)*arg5,(btVector3 const &)*arg6,(btVector3 const &)*arg7,(btVector3 const &)*arg8,arg9);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1drawTriangleSwigExplicitbtIDebugDraw_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jobject jarg4, jobject jarg5, jobject jarg6, jobject jarg7, jobject jarg8, jfloat jarg9) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  btVector3 *arg6 = 0 ;
  btVector3 *arg7 = 0 ;
  btVector3 *arg8 = 0 ;
  btScalar arg9 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  btVector3 local_arg6;
  gdx_setbtVector3FromVector3(jenv, local_arg6, jarg6);
  arg6 = &local_arg6;
  gdxAutoCommitVector3 auto_commit_arg6(jenv, jarg6, &local_arg6);
  btVector3 local_arg7;
  gdx_setbtVector3FromVector3(jenv, local_arg7, jarg7);
  arg7 = &local_arg7;
  gdxAutoCommitVector3 auto_commit_arg7(jenv, jarg7, &local_arg7);
  btVector3 local_arg8;
  gdx_setbtVector3FromVector3(jenv, local_arg8, jarg8);
  arg8 = &local_arg8;
  gdxAutoCommitVector3 auto_commit_arg8(jenv, jarg8, &local_arg8);
  arg9 = (btScalar)jarg9; 
  (arg1)->btIDebugDraw::drawTriangle((btVector3 const &)*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4,(btVector3 const &)*arg5,(btVector3 const &)*arg6,(btVector3 const &)*arg7,(btVector3 const &)*arg8,arg9);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1drawTriangle_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jobject jarg4, jobject jarg5, jfloat jarg6) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  btScalar arg6 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  arg6 = (btScalar)jarg6; 
  (arg1)->drawTriangle((btVector3 const &)*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4,(btVector3 const &)*arg5,arg6);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1drawTriangleSwigExplicitbtIDebugDraw_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jobject jarg4, jobject jarg5, jfloat jarg6) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  btScalar arg6 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  arg6 = (btScalar)jarg6; 
  (arg1)->btIDebugDraw::drawTriangle((btVector3 const &)*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4,(btVector3 const &)*arg5,arg6);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1drawContactPoint(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jfloat jarg4, jint jarg5, jobject jarg6) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btScalar arg4 ;
  int arg5 ;
  btVector3 *arg6 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = (btScalar)jarg4; 
  arg5 = (int)jarg5; 
  btVector3 local_arg6;
  gdx_setbtVector3FromVector3(jenv, local_arg6, jarg6);
  arg6 = &local_arg6;
  gdxAutoCommitVector3 auto_commit_arg6(jenv, jarg6, &local_arg6);
  (arg1)->drawContactPoint((btVector3 const &)*arg2,(btVector3 const &)*arg3,arg4,arg5,(btVector3 const &)*arg6);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1reportErrorWarning(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->reportErrorWarning((char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1draw3dText(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jstring jarg3) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btVector3 *arg2 = 0 ;
  char *arg3 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return ;
  }
  (arg1)->draw3dText((btVector3 const &)*arg2,(char const *)arg3);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1setDebugMode(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->setDebugMode(arg2);
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1getDebugMode(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  result = (int)((btIDebugDraw const *)arg1)->getDebugMode();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1drawAabb(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jobject jarg4) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  (arg1)->drawAabb((btVector3 const &)*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1drawAabbSwigExplicitbtIDebugDraw(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jobject jarg4) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  (arg1)->btIDebugDraw::drawAabb((btVector3 const &)*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1drawTransform(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jfloat jarg3) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btTransform *arg2 = 0 ;
  btScalar arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (btScalar)jarg3; 
  (arg1)->drawTransform((btTransform const &)*arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1drawTransformSwigExplicitbtIDebugDraw(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jfloat jarg3) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btTransform *arg2 = 0 ;
  btScalar arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (btScalar)jarg3; 
  (arg1)->btIDebugDraw::drawTransform((btTransform const &)*arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1drawArc_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jobject jarg4, jfloat jarg5, jfloat jarg6, jfloat jarg7, jfloat jarg8, jobject jarg9, jboolean jarg10, jfloat jarg11) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btScalar arg5 ;
  btScalar arg6 ;
  btScalar arg7 ;
  btScalar arg8 ;
  btVector3 *arg9 = 0 ;
  bool arg10 ;
  btScalar arg11 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  arg5 = (btScalar)jarg5; 
  arg6 = (btScalar)jarg6; 
  arg7 = (btScalar)jarg7; 
  arg8 = (btScalar)jarg8; 
  btVector3 local_arg9;
  gdx_setbtVector3FromVector3(jenv, local_arg9, jarg9);
  arg9 = &local_arg9;
  gdxAutoCommitVector3 auto_commit_arg9(jenv, jarg9, &local_arg9);
  arg10 = jarg10 ? true : false; 
  arg11 = (btScalar)jarg11; 
  (arg1)->drawArc((btVector3 const &)*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4,arg5,arg6,arg7,arg8,(btVector3 const &)*arg9,arg10,arg11);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1drawArcSwigExplicitbtIDebugDraw_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jobject jarg4, jfloat jarg5, jfloat jarg6, jfloat jarg7, jfloat jarg8, jobject jarg9, jboolean jarg10, jfloat jarg11) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btScalar arg5 ;
  btScalar arg6 ;
  btScalar arg7 ;
  btScalar arg8 ;
  btVector3 *arg9 = 0 ;
  bool arg10 ;
  btScalar arg11 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  arg5 = (btScalar)jarg5; 
  arg6 = (btScalar)jarg6; 
  arg7 = (btScalar)jarg7; 
  arg8 = (btScalar)jarg8; 
  btVector3 local_arg9;
  gdx_setbtVector3FromVector3(jenv, local_arg9, jarg9);
  arg9 = &local_arg9;
  gdxAutoCommitVector3 auto_commit_arg9(jenv, jarg9, &local_arg9);
  arg10 = jarg10 ? true : false; 
  arg11 = (btScalar)jarg11; 
  (arg1)->btIDebugDraw::drawArc((btVector3 const &)*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4,arg5,arg6,arg7,arg8,(btVector3 const &)*arg9,arg10,arg11);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1drawArc_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jobject jarg4, jfloat jarg5, jfloat jarg6, jfloat jarg7, jfloat jarg8, jobject jarg9, jboolean jarg10) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btScalar arg5 ;
  btScalar arg6 ;
  btScalar arg7 ;
  btScalar arg8 ;
  btVector3 *arg9 = 0 ;
  bool arg10 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  arg5 = (btScalar)jarg5; 
  arg6 = (btScalar)jarg6; 
  arg7 = (btScalar)jarg7; 
  arg8 = (btScalar)jarg8; 
  btVector3 local_arg9;
  gdx_setbtVector3FromVector3(jenv, local_arg9, jarg9);
  arg9 = &local_arg9;
  gdxAutoCommitVector3 auto_commit_arg9(jenv, jarg9, &local_arg9);
  arg10 = jarg10 ? true : false; 
  (arg1)->drawArc((btVector3 const &)*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4,arg5,arg6,arg7,arg8,(btVector3 const &)*arg9,arg10);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1drawArcSwigExplicitbtIDebugDraw_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jobject jarg4, jfloat jarg5, jfloat jarg6, jfloat jarg7, jfloat jarg8, jobject jarg9, jboolean jarg10) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btScalar arg5 ;
  btScalar arg6 ;
  btScalar arg7 ;
  btScalar arg8 ;
  btVector3 *arg9 = 0 ;
  bool arg10 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  arg5 = (btScalar)jarg5; 
  arg6 = (btScalar)jarg6; 
  arg7 = (btScalar)jarg7; 
  arg8 = (btScalar)jarg8; 
  btVector3 local_arg9;
  gdx_setbtVector3FromVector3(jenv, local_arg9, jarg9);
  arg9 = &local_arg9;
  gdxAutoCommitVector3 auto_commit_arg9(jenv, jarg9, &local_arg9);
  arg10 = jarg10 ? true : false; 
  (arg1)->btIDebugDraw::drawArc((btVector3 const &)*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4,arg5,arg6,arg7,arg8,(btVector3 const &)*arg9,arg10);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1drawSpherePatch_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jobject jarg4, jfloat jarg5, jfloat jarg6, jfloat jarg7, jfloat jarg8, jfloat jarg9, jobject jarg10, jfloat jarg11, jboolean jarg12) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btScalar arg5 ;
  btScalar arg6 ;
  btScalar arg7 ;
  btScalar arg8 ;
  btScalar arg9 ;
  btVector3 *arg10 = 0 ;
  btScalar arg11 ;
  bool arg12 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  arg5 = (btScalar)jarg5; 
  arg6 = (btScalar)jarg6; 
  arg7 = (btScalar)jarg7; 
  arg8 = (btScalar)jarg8; 
  arg9 = (btScalar)jarg9; 
  btVector3 local_arg10;
  gdx_setbtVector3FromVector3(jenv, local_arg10, jarg10);
  arg10 = &local_arg10;
  gdxAutoCommitVector3 auto_commit_arg10(jenv, jarg10, &local_arg10);
  arg11 = (btScalar)jarg11; 
  arg12 = jarg12 ? true : false; 
  (arg1)->drawSpherePatch((btVector3 const &)*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4,arg5,arg6,arg7,arg8,arg9,(btVector3 const &)*arg10,arg11,arg12);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1drawSpherePatchSwigExplicitbtIDebugDraw_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jobject jarg4, jfloat jarg5, jfloat jarg6, jfloat jarg7, jfloat jarg8, jfloat jarg9, jobject jarg10, jfloat jarg11, jboolean jarg12) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btScalar arg5 ;
  btScalar arg6 ;
  btScalar arg7 ;
  btScalar arg8 ;
  btScalar arg9 ;
  btVector3 *arg10 = 0 ;
  btScalar arg11 ;
  bool arg12 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  arg5 = (btScalar)jarg5; 
  arg6 = (btScalar)jarg6; 
  arg7 = (btScalar)jarg7; 
  arg8 = (btScalar)jarg8; 
  arg9 = (btScalar)jarg9; 
  btVector3 local_arg10;
  gdx_setbtVector3FromVector3(jenv, local_arg10, jarg10);
  arg10 = &local_arg10;
  gdxAutoCommitVector3 auto_commit_arg10(jenv, jarg10, &local_arg10);
  arg11 = (btScalar)jarg11; 
  arg12 = jarg12 ? true : false; 
  (arg1)->btIDebugDraw::drawSpherePatch((btVector3 const &)*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4,arg5,arg6,arg7,arg8,arg9,(btVector3 const &)*arg10,arg11,arg12);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1drawSpherePatch_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jobject jarg4, jfloat jarg5, jfloat jarg6, jfloat jarg7, jfloat jarg8, jfloat jarg9, jobject jarg10, jfloat jarg11) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btScalar arg5 ;
  btScalar arg6 ;
  btScalar arg7 ;
  btScalar arg8 ;
  btScalar arg9 ;
  btVector3 *arg10 = 0 ;
  btScalar arg11 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  arg5 = (btScalar)jarg5; 
  arg6 = (btScalar)jarg6; 
  arg7 = (btScalar)jarg7; 
  arg8 = (btScalar)jarg8; 
  arg9 = (btScalar)jarg9; 
  btVector3 local_arg10;
  gdx_setbtVector3FromVector3(jenv, local_arg10, jarg10);
  arg10 = &local_arg10;
  gdxAutoCommitVector3 auto_commit_arg10(jenv, jarg10, &local_arg10);
  arg11 = (btScalar)jarg11; 
  (arg1)->drawSpherePatch((btVector3 const &)*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4,arg5,arg6,arg7,arg8,arg9,(btVector3 const &)*arg10,arg11);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1drawSpherePatchSwigExplicitbtIDebugDraw_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jobject jarg4, jfloat jarg5, jfloat jarg6, jfloat jarg7, jfloat jarg8, jfloat jarg9, jobject jarg10, jfloat jarg11) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btScalar arg5 ;
  btScalar arg6 ;
  btScalar arg7 ;
  btScalar arg8 ;
  btScalar arg9 ;
  btVector3 *arg10 = 0 ;
  btScalar arg11 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  arg5 = (btScalar)jarg5; 
  arg6 = (btScalar)jarg6; 
  arg7 = (btScalar)jarg7; 
  arg8 = (btScalar)jarg8; 
  arg9 = (btScalar)jarg9; 
  btVector3 local_arg10;
  gdx_setbtVector3FromVector3(jenv, local_arg10, jarg10);
  arg10 = &local_arg10;
  gdxAutoCommitVector3 auto_commit_arg10(jenv, jarg10, &local_arg10);
  arg11 = (btScalar)jarg11; 
  (arg1)->btIDebugDraw::drawSpherePatch((btVector3 const &)*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4,arg5,arg6,arg7,arg8,arg9,(btVector3 const &)*arg10,arg11);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1drawSpherePatch_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jobject jarg4, jfloat jarg5, jfloat jarg6, jfloat jarg7, jfloat jarg8, jfloat jarg9, jobject jarg10) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btScalar arg5 ;
  btScalar arg6 ;
  btScalar arg7 ;
  btScalar arg8 ;
  btScalar arg9 ;
  btVector3 *arg10 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  arg5 = (btScalar)jarg5; 
  arg6 = (btScalar)jarg6; 
  arg7 = (btScalar)jarg7; 
  arg8 = (btScalar)jarg8; 
  arg9 = (btScalar)jarg9; 
  btVector3 local_arg10;
  gdx_setbtVector3FromVector3(jenv, local_arg10, jarg10);
  arg10 = &local_arg10;
  gdxAutoCommitVector3 auto_commit_arg10(jenv, jarg10, &local_arg10);
  (arg1)->drawSpherePatch((btVector3 const &)*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4,arg5,arg6,arg7,arg8,arg9,(btVector3 const &)*arg10);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1drawSpherePatchSwigExplicitbtIDebugDraw_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jobject jarg4, jfloat jarg5, jfloat jarg6, jfloat jarg7, jfloat jarg8, jfloat jarg9, jobject jarg10) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btScalar arg5 ;
  btScalar arg6 ;
  btScalar arg7 ;
  btScalar arg8 ;
  btScalar arg9 ;
  btVector3 *arg10 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  arg5 = (btScalar)jarg5; 
  arg6 = (btScalar)jarg6; 
  arg7 = (btScalar)jarg7; 
  arg8 = (btScalar)jarg8; 
  arg9 = (btScalar)jarg9; 
  btVector3 local_arg10;
  gdx_setbtVector3FromVector3(jenv, local_arg10, jarg10);
  arg10 = &local_arg10;
  gdxAutoCommitVector3 auto_commit_arg10(jenv, jarg10, &local_arg10);
  (arg1)->btIDebugDraw::drawSpherePatch((btVector3 const &)*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4,arg5,arg6,arg7,arg8,arg9,(btVector3 const &)*arg10);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1drawBox_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jobject jarg4) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  (arg1)->drawBox((btVector3 const &)*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1drawBoxSwigExplicitbtIDebugDraw_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jobject jarg4) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  (arg1)->btIDebugDraw::drawBox((btVector3 const &)*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1drawBox_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jobject jarg4, jobject jarg5) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btTransform *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btTransform local_arg4;
  gdx_setbtTransformFromMatrix4(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitMatrix4 auto_commit_arg4(jenv, jarg4, &local_arg4);
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  (arg1)->drawBox((btVector3 const &)*arg2,(btVector3 const &)*arg3,(btTransform const &)*arg4,(btVector3 const &)*arg5);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1drawBoxSwigExplicitbtIDebugDraw_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jobject jarg4, jobject jarg5) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btTransform *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btTransform local_arg4;
  gdx_setbtTransformFromMatrix4(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitMatrix4 auto_commit_arg4(jenv, jarg4, &local_arg4);
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  (arg1)->btIDebugDraw::drawBox((btVector3 const &)*arg2,(btVector3 const &)*arg3,(btTransform const &)*arg4,(btVector3 const &)*arg5);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1drawCapsule(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jfloat jarg3, jint jarg4, jobject jarg5, jobject jarg6) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btScalar arg2 ;
  btScalar arg3 ;
  int arg4 ;
  btTransform *arg5 = 0 ;
  btVector3 *arg6 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  arg3 = (btScalar)jarg3; 
  arg4 = (int)jarg4; 
  btTransform local_arg5;
  gdx_setbtTransformFromMatrix4(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitMatrix4 auto_commit_arg5(jenv, jarg5, &local_arg5);
  btVector3 local_arg6;
  gdx_setbtVector3FromVector3(jenv, local_arg6, jarg6);
  arg6 = &local_arg6;
  gdxAutoCommitVector3 auto_commit_arg6(jenv, jarg6, &local_arg6);
  (arg1)->drawCapsule(arg2,arg3,arg4,(btTransform const &)*arg5,(btVector3 const &)*arg6);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1drawCapsuleSwigExplicitbtIDebugDraw(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jfloat jarg3, jint jarg4, jobject jarg5, jobject jarg6) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btScalar arg2 ;
  btScalar arg3 ;
  int arg4 ;
  btTransform *arg5 = 0 ;
  btVector3 *arg6 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  arg3 = (btScalar)jarg3; 
  arg4 = (int)jarg4; 
  btTransform local_arg5;
  gdx_setbtTransformFromMatrix4(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitMatrix4 auto_commit_arg5(jenv, jarg5, &local_arg5);
  btVector3 local_arg6;
  gdx_setbtVector3FromVector3(jenv, local_arg6, jarg6);
  arg6 = &local_arg6;
  gdxAutoCommitVector3 auto_commit_arg6(jenv, jarg6, &local_arg6);
  (arg1)->btIDebugDraw::drawCapsule(arg2,arg3,arg4,(btTransform const &)*arg5,(btVector3 const &)*arg6);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1drawCylinder(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jfloat jarg3, jint jarg4, jobject jarg5, jobject jarg6) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btScalar arg2 ;
  btScalar arg3 ;
  int arg4 ;
  btTransform *arg5 = 0 ;
  btVector3 *arg6 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  arg3 = (btScalar)jarg3; 
  arg4 = (int)jarg4; 
  btTransform local_arg5;
  gdx_setbtTransformFromMatrix4(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitMatrix4 auto_commit_arg5(jenv, jarg5, &local_arg5);
  btVector3 local_arg6;
  gdx_setbtVector3FromVector3(jenv, local_arg6, jarg6);
  arg6 = &local_arg6;
  gdxAutoCommitVector3 auto_commit_arg6(jenv, jarg6, &local_arg6);
  (arg1)->drawCylinder(arg2,arg3,arg4,(btTransform const &)*arg5,(btVector3 const &)*arg6);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1drawCylinderSwigExplicitbtIDebugDraw(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jfloat jarg3, jint jarg4, jobject jarg5, jobject jarg6) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btScalar arg2 ;
  btScalar arg3 ;
  int arg4 ;
  btTransform *arg5 = 0 ;
  btVector3 *arg6 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  arg3 = (btScalar)jarg3; 
  arg4 = (int)jarg4; 
  btTransform local_arg5;
  gdx_setbtTransformFromMatrix4(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitMatrix4 auto_commit_arg5(jenv, jarg5, &local_arg5);
  btVector3 local_arg6;
  gdx_setbtVector3FromVector3(jenv, local_arg6, jarg6);
  arg6 = &local_arg6;
  gdxAutoCommitVector3 auto_commit_arg6(jenv, jarg6, &local_arg6);
  (arg1)->btIDebugDraw::drawCylinder(arg2,arg3,arg4,(btTransform const &)*arg5,(btVector3 const &)*arg6);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1drawCone(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jfloat jarg3, jint jarg4, jobject jarg5, jobject jarg6) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btScalar arg2 ;
  btScalar arg3 ;
  int arg4 ;
  btTransform *arg5 = 0 ;
  btVector3 *arg6 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  arg3 = (btScalar)jarg3; 
  arg4 = (int)jarg4; 
  btTransform local_arg5;
  gdx_setbtTransformFromMatrix4(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitMatrix4 auto_commit_arg5(jenv, jarg5, &local_arg5);
  btVector3 local_arg6;
  gdx_setbtVector3FromVector3(jenv, local_arg6, jarg6);
  arg6 = &local_arg6;
  gdxAutoCommitVector3 auto_commit_arg6(jenv, jarg6, &local_arg6);
  (arg1)->drawCone(arg2,arg3,arg4,(btTransform const &)*arg5,(btVector3 const &)*arg6);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1drawConeSwigExplicitbtIDebugDraw(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jfloat jarg3, jint jarg4, jobject jarg5, jobject jarg6) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btScalar arg2 ;
  btScalar arg3 ;
  int arg4 ;
  btTransform *arg5 = 0 ;
  btVector3 *arg6 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  arg3 = (btScalar)jarg3; 
  arg4 = (int)jarg4; 
  btTransform local_arg5;
  gdx_setbtTransformFromMatrix4(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitMatrix4 auto_commit_arg5(jenv, jarg5, &local_arg5);
  btVector3 local_arg6;
  gdx_setbtVector3FromVector3(jenv, local_arg6, jarg6);
  arg6 = &local_arg6;
  gdxAutoCommitVector3 auto_commit_arg6(jenv, jarg6, &local_arg6);
  (arg1)->btIDebugDraw::drawCone(arg2,arg3,arg4,(btTransform const &)*arg5,(btVector3 const &)*arg6);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1drawPlane(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jfloat jarg3, jobject jarg4, jobject jarg5) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btVector3 *arg2 = 0 ;
  btScalar arg3 ;
  btTransform *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (btScalar)jarg3; 
  btTransform local_arg4;
  gdx_setbtTransformFromMatrix4(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitMatrix4 auto_commit_arg4(jenv, jarg4, &local_arg4);
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  (arg1)->drawPlane((btVector3 const &)*arg2,arg3,(btTransform const &)*arg4,(btVector3 const &)*arg5);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1drawPlaneSwigExplicitbtIDebugDraw(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jfloat jarg3, jobject jarg4, jobject jarg5) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  btVector3 *arg2 = 0 ;
  btScalar arg3 ;
  btTransform *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (btScalar)jarg3; 
  btTransform local_arg4;
  gdx_setbtTransformFromMatrix4(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitMatrix4 auto_commit_arg4(jenv, jarg4, &local_arg4);
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  (arg1)->btIDebugDraw::drawPlane((btVector3 const &)*arg2,arg3,(btTransform const &)*arg4,(btVector3 const &)*arg5);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1clearLines(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  (arg1)->clearLines();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1clearLinesSwigExplicitbtIDebugDraw(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  (arg1)->btIDebugDraw::clearLines();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1flushLines(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  (arg1)->flushLines();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1flushLinesSwigExplicitbtIDebugDraw(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btIDebugDraw *arg1 = (btIDebugDraw *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIDebugDraw **)&jarg1; 
  (arg1)->btIDebugDraw::flushLines();
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btIDebugDraw(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btIDebugDraw *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btIDebugDraw *)new SwigDirector_btIDebugDraw(jenv);
  *(btIDebugDraw **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  btIDebugDraw *obj = *((btIDebugDraw **)&objarg);
  (void)jcls;
  SwigDirector_btIDebugDraw *director = (SwigDirector_btIDebugDraw *)(obj);
  if (director) {
    director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
  }
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIDebugDraw_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  btIDebugDraw *obj = *((btIDebugDraw **)&objarg);
  SwigDirector_btIDebugDraw *director = (SwigDirector_btIDebugDraw *)(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btGeometryUtil_1getPlaneEquationsFromVertices(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btAlignedObjectArray< btVector3 > *arg1 = 0 ;
  btAlignedObjectArray< btVector3 > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btAlignedObjectArray< btVector3 > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btAlignedObjectArray< btVector3 > & reference is null");
    return ;
  } 
  arg2 = *(btAlignedObjectArray< btVector3 > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btAlignedObjectArray< btVector3 > & reference is null");
    return ;
  } 
  btGeometryUtil::getPlaneEquationsFromVertices(*arg1,*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btGeometryUtil_1getVerticesFromPlaneEquations(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btAlignedObjectArray< btVector3 > *arg1 = 0 ;
  btAlignedObjectArray< btVector3 > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btAlignedObjectArray< btVector3 > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btAlignedObjectArray< btVector3 > const & reference is null");
    return ;
  } 
  arg2 = *(btAlignedObjectArray< btVector3 > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btAlignedObjectArray< btVector3 > & reference is null");
    return ;
  } 
  btGeometryUtil::getVerticesFromPlaneEquations((btAlignedObjectArray< btVector3 > const &)*arg1,*arg2);
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btGeometryUtil_1isInside(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jfloat jarg3) {
  jboolean jresult = 0 ;
  btAlignedObjectArray< btVector3 > *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btScalar arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< btVector3 > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btAlignedObjectArray< btVector3 > const & reference is null");
    return 0;
  } 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (btScalar)jarg3; 
  result = (bool)btGeometryUtil::isInside((btAlignedObjectArray< btVector3 > const &)*arg1,(btVector3 const &)*arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btGeometryUtil_1isPointInsidePlanes(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jfloat jarg3) {
  jboolean jresult = 0 ;
  btAlignedObjectArray< btVector3 > *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btScalar arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< btVector3 > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btAlignedObjectArray< btVector3 > const & reference is null");
    return 0;
  } 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (btScalar)jarg3; 
  result = (bool)btGeometryUtil::isPointInsidePlanes((btAlignedObjectArray< btVector3 > const &)*arg1,(btVector3 const &)*arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btGeometryUtil_1areVerticesBehindPlane(JNIEnv *jenv, jclass jcls, jobject jarg1, jlong jarg2, jobject jarg2_, jfloat jarg3) {
  jboolean jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btAlignedObjectArray< btVector3 > *arg2 = 0 ;
  btScalar arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  arg2 = *(btAlignedObjectArray< btVector3 > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btAlignedObjectArray< btVector3 > const & reference is null");
    return 0;
  } 
  arg3 = (btScalar)jarg3; 
  result = (bool)btGeometryUtil::areVerticesBehindPlane((btVector3 const &)*arg1,(btAlignedObjectArray< btVector3 > const &)*arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btGeometryUtil(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btGeometryUtil *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btGeometryUtil *)new btGeometryUtil();
  *(btGeometryUtil **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_delete_1btGeometryUtil(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btGeometryUtil *arg1 = (btGeometryUtil *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btGeometryUtil **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_GEN_1srand(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  unsigned int arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (unsigned int)jarg1; 
  GEN_srand(arg1);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_GEN_1rand(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  result = (unsigned int)GEN_rand();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btAabbSupport(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2) {
  jobject jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = btAabbSupport((btVector3 const &)*arg1,(btVector3 const &)*arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btTransformUtil_1integrateTransform(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jobject jarg3, jfloat jarg4, jobject jarg5) {
  btTransform *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btScalar arg4 ;
  btTransform *arg5 = 0 ;
  
  (void)jenv;
  (void)jcls;
  btTransform local_arg1;
  gdx_setbtTransformFromMatrix4(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitMatrix4 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = (btScalar)jarg4; 
  btTransform local_arg5;
  gdx_setbtTransformFromMatrix4(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitMatrix4 auto_commit_arg5(jenv, jarg5, &local_arg5);
  btTransformUtil::integrateTransform((btTransform const &)*arg1,(btVector3 const &)*arg2,(btVector3 const &)*arg3,arg4,*arg5);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btTransformUtil_1calculateVelocityQuaternion(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jobject jarg3, jobject jarg4, jfloat jarg5, jobject jarg6, jobject jarg7) {
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btQuaternion *arg3 = 0 ;
  btQuaternion *arg4 = 0 ;
  btScalar arg5 ;
  btVector3 *arg6 = 0 ;
  btVector3 *arg7 = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btQuaternion local_arg3;
  gdx_setbtQuaternionFromQuaternion(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitQuaternion auto_commit_arg3(jenv, jarg3, &local_arg3);
  btQuaternion local_arg4;
  gdx_setbtQuaternionFromQuaternion(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitQuaternion auto_commit_arg4(jenv, jarg4, &local_arg4);
  arg5 = (btScalar)jarg5; 
  btVector3 local_arg6;
  gdx_setbtVector3FromVector3(jenv, local_arg6, jarg6);
  arg6 = &local_arg6;
  gdxAutoCommitVector3 auto_commit_arg6(jenv, jarg6, &local_arg6);
  btVector3 local_arg7;
  gdx_setbtVector3FromVector3(jenv, local_arg7, jarg7);
  arg7 = &local_arg7;
  gdxAutoCommitVector3 auto_commit_arg7(jenv, jarg7, &local_arg7);
  btTransformUtil::calculateVelocityQuaternion((btVector3 const &)*arg1,(btVector3 const &)*arg2,(btQuaternion const &)*arg3,(btQuaternion const &)*arg4,arg5,*arg6,*arg7);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btTransformUtil_1calculateDiffAxisAngleQuaternion(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jobject jarg3, jlong jarg4) {
  btQuaternion *arg1 = 0 ;
  btQuaternion *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btScalar *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  btQuaternion local_arg1;
  gdx_setbtQuaternionFromQuaternion(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitQuaternion auto_commit_arg1(jenv, jarg1, &local_arg1);
  btQuaternion local_arg2;
  gdx_setbtQuaternionFromQuaternion(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitQuaternion auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = *(btScalar **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btScalar & reference is null");
    return ;
  } 
  btTransformUtil::calculateDiffAxisAngleQuaternion((btQuaternion const &)*arg1,(btQuaternion const &)*arg2,*arg3,*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btTransformUtil_1calculateVelocity(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jfloat jarg3, jobject jarg4, jobject jarg5) {
  btTransform *arg1 = 0 ;
  btTransform *arg2 = 0 ;
  btScalar arg3 ;
  btVector3 *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  
  (void)jenv;
  (void)jcls;
  btTransform local_arg1;
  gdx_setbtTransformFromMatrix4(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitMatrix4 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (btScalar)jarg3; 
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  btTransformUtil::calculateVelocity((btTransform const &)*arg1,(btTransform const &)*arg2,arg3,*arg4,*arg5);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btTransformUtil_1calculateDiffAxisAngle(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jobject jarg3, jlong jarg4) {
  btTransform *arg1 = 0 ;
  btTransform *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btScalar *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  btTransform local_arg1;
  gdx_setbtTransformFromMatrix4(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitMatrix4 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = *(btScalar **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btScalar & reference is null");
    return ;
  } 
  btTransformUtil::calculateDiffAxisAngle((btTransform const &)*arg1,(btTransform const &)*arg2,*arg3,*arg4);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btTransformUtil(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btTransformUtil *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btTransformUtil *)new btTransformUtil();
  *(btTransformUtil **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_delete_1btTransformUtil(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btTransformUtil *arg1 = (btTransformUtil *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btTransformUtil **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btConvexSeparatingDistanceUtil(JNIEnv *jenv, jclass jcls, jfloat jarg1, jfloat jarg2) {
  jlong jresult = 0 ;
  btScalar arg1 ;
  btScalar arg2 ;
  btConvexSeparatingDistanceUtil *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  arg2 = (btScalar)jarg2; 
  result = (btConvexSeparatingDistanceUtil *)new btConvexSeparatingDistanceUtil(arg1,arg2);
  *(btConvexSeparatingDistanceUtil **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btConvexSeparatingDistanceUtil_1getConservativeSeparatingDistance(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btConvexSeparatingDistanceUtil *arg1 = (btConvexSeparatingDistanceUtil *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexSeparatingDistanceUtil **)&jarg1; 
  result = (btScalar)(arg1)->getConservativeSeparatingDistance();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btConvexSeparatingDistanceUtil_1updateSeparatingDistance(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3) {
  btConvexSeparatingDistanceUtil *arg1 = (btConvexSeparatingDistanceUtil *) 0 ;
  btTransform *arg2 = 0 ;
  btTransform *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexSeparatingDistanceUtil **)&jarg1; 
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btTransform local_arg3;
  gdx_setbtTransformFromMatrix4(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitMatrix4 auto_commit_arg3(jenv, jarg3, &local_arg3);
  (arg1)->updateSeparatingDistance((btTransform const &)*arg2,(btTransform const &)*arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btConvexSeparatingDistanceUtil_1initSeparatingDistance(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jfloat jarg3, jobject jarg4, jobject jarg5) {
  btConvexSeparatingDistanceUtil *arg1 = (btConvexSeparatingDistanceUtil *) 0 ;
  btVector3 *arg2 = 0 ;
  btScalar arg3 ;
  btTransform *arg4 = 0 ;
  btTransform *arg5 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexSeparatingDistanceUtil **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (btScalar)jarg3; 
  btTransform local_arg4;
  gdx_setbtTransformFromMatrix4(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitMatrix4 auto_commit_arg4(jenv, jarg4, &local_arg4);
  btTransform local_arg5;
  gdx_setbtTransformFromMatrix4(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitMatrix4 auto_commit_arg5(jenv, jarg5, &local_arg5);
  (arg1)->initSeparatingDistance((btVector3 const &)*arg2,arg3,(btTransform const &)*arg4,(btTransform const &)*arg5);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_delete_1btConvexSeparatingDistanceUtil(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btConvexSeparatingDistanceUtil *arg1 = (btConvexSeparatingDistanceUtil *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btConvexSeparatingDistanceUtil **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1HullResult(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  HullResult *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (HullResult *)new HullResult();
  *(HullResult **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_HullResult_1mPolygons_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  HullResult *arg1 = (HullResult *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(HullResult **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->mPolygons = arg2;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_HullResult_1mPolygons_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  HullResult *arg1 = (HullResult *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(HullResult **)&jarg1; 
  result = (bool) ((arg1)->mPolygons);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_HullResult_1mNumOutputVertices_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  HullResult *arg1 = (HullResult *) 0 ;
  unsigned int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(HullResult **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  if (arg1) (arg1)->mNumOutputVertices = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_HullResult_1mNumOutputVertices_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  HullResult *arg1 = (HullResult *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(HullResult **)&jarg1; 
  result = (unsigned int) ((arg1)->mNumOutputVertices);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_HullResult_1OutputVertices_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  HullResult *arg1 = (HullResult *) 0 ;
  btAlignedObjectArray< btVector3 > *arg2 = (btAlignedObjectArray< btVector3 > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(HullResult **)&jarg1; 
  arg2 = *(btAlignedObjectArray< btVector3 > **)&jarg2; 
  if (arg1) (arg1)->m_OutputVertices = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_HullResult_1OutputVertices_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  HullResult *arg1 = (HullResult *) 0 ;
  btAlignedObjectArray< btVector3 > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(HullResult **)&jarg1; 
  result = (btAlignedObjectArray< btVector3 > *)& ((arg1)->m_OutputVertices);
  *(btAlignedObjectArray< btVector3 > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_HullResult_1mNumFaces_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  HullResult *arg1 = (HullResult *) 0 ;
  unsigned int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(HullResult **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  if (arg1) (arg1)->mNumFaces = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_HullResult_1mNumFaces_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  HullResult *arg1 = (HullResult *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(HullResult **)&jarg1; 
  result = (unsigned int) ((arg1)->mNumFaces);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_HullResult_1mNumIndices_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  HullResult *arg1 = (HullResult *) 0 ;
  unsigned int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(HullResult **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  if (arg1) (arg1)->mNumIndices = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_HullResult_1mNumIndices_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  HullResult *arg1 = (HullResult *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(HullResult **)&jarg1; 
  result = (unsigned int) ((arg1)->mNumIndices);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_HullResult_1Indices_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  HullResult *arg1 = (HullResult *) 0 ;
  btAlignedObjectArray< unsigned int > *arg2 = (btAlignedObjectArray< unsigned int > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(HullResult **)&jarg1; 
  arg2 = *(btAlignedObjectArray< unsigned int > **)&jarg2; 
  if (arg1) (arg1)->m_Indices = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_HullResult_1Indices_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  HullResult *arg1 = (HullResult *) 0 ;
  btAlignedObjectArray< unsigned int > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(HullResult **)&jarg1; 
  result = (btAlignedObjectArray< unsigned int > *)& ((arg1)->m_Indices);
  *(btAlignedObjectArray< unsigned int > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_delete_1HullResult(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  HullResult *arg1 = (HullResult *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(HullResult **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1HullDesc_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  HullDesc *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (HullDesc *)new HullDesc();
  *(HullDesc **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1HullDesc_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jlong jarg3, jobject jarg3_, jlong jarg4) {
  jlong jresult = 0 ;
  HullFlag arg1 ;
  unsigned int arg2 ;
  btVector3 *arg3 = (btVector3 *) 0 ;
  unsigned int arg4 ;
  HullDesc *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg3_;
  arg1 = (HullFlag)jarg1; 
  arg2 = (unsigned int)jarg2; 
  arg3 = *(btVector3 **)&jarg3; 
  arg4 = (unsigned int)jarg4; 
  result = (HullDesc *)new HullDesc(arg1,arg2,(btVector3 const *)arg3,arg4);
  *(HullDesc **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1HullDesc_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  HullFlag arg1 ;
  unsigned int arg2 ;
  btVector3 *arg3 = (btVector3 *) 0 ;
  HullDesc *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg3_;
  arg1 = (HullFlag)jarg1; 
  arg2 = (unsigned int)jarg2; 
  arg3 = *(btVector3 **)&jarg3; 
  result = (HullDesc *)new HullDesc(arg1,arg2,(btVector3 const *)arg3);
  *(HullDesc **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_HullDesc_1HasHullFlag(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jboolean jresult = 0 ;
  HullDesc *arg1 = (HullDesc *) 0 ;
  HullFlag arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(HullDesc **)&jarg1; 
  arg2 = (HullFlag)jarg2; 
  result = (bool)((HullDesc const *)arg1)->HasHullFlag(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_HullDesc_1SetHullFlag(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  HullDesc *arg1 = (HullDesc *) 0 ;
  HullFlag arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(HullDesc **)&jarg1; 
  arg2 = (HullFlag)jarg2; 
  (arg1)->SetHullFlag(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_HullDesc_1ClearHullFlag(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  HullDesc *arg1 = (HullDesc *) 0 ;
  HullFlag arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(HullDesc **)&jarg1; 
  arg2 = (HullFlag)jarg2; 
  (arg1)->ClearHullFlag(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_HullDesc_1mFlags_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  HullDesc *arg1 = (HullDesc *) 0 ;
  unsigned int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(HullDesc **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  if (arg1) (arg1)->mFlags = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_HullDesc_1mFlags_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  HullDesc *arg1 = (HullDesc *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(HullDesc **)&jarg1; 
  result = (unsigned int) ((arg1)->mFlags);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_HullDesc_1mVcount_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  HullDesc *arg1 = (HullDesc *) 0 ;
  unsigned int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(HullDesc **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  if (arg1) (arg1)->mVcount = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_HullDesc_1mVcount_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  HullDesc *arg1 = (HullDesc *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(HullDesc **)&jarg1; 
  result = (unsigned int) ((arg1)->mVcount);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_HullDesc_1mVertices_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  HullDesc *arg1 = (HullDesc *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(HullDesc **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->mVertices = (btVector3 const *)arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_HullDesc_1mVertices_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  HullDesc *arg1 = (HullDesc *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(HullDesc **)&jarg1; 
  result = (btVector3 *) ((arg1)->mVertices);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_HullDesc_1mVertexStride_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  HullDesc *arg1 = (HullDesc *) 0 ;
  unsigned int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(HullDesc **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  if (arg1) (arg1)->mVertexStride = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_HullDesc_1mVertexStride_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  HullDesc *arg1 = (HullDesc *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(HullDesc **)&jarg1; 
  result = (unsigned int) ((arg1)->mVertexStride);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_HullDesc_1mNormalEpsilon_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  HullDesc *arg1 = (HullDesc *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(HullDesc **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->mNormalEpsilon = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_HullDesc_1mNormalEpsilon_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  HullDesc *arg1 = (HullDesc *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(HullDesc **)&jarg1; 
  result = (btScalar) ((arg1)->mNormalEpsilon);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_HullDesc_1mMaxVertices_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  HullDesc *arg1 = (HullDesc *) 0 ;
  unsigned int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(HullDesc **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  if (arg1) (arg1)->mMaxVertices = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_HullDesc_1mMaxVertices_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  HullDesc *arg1 = (HullDesc *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(HullDesc **)&jarg1; 
  result = (unsigned int) ((arg1)->mMaxVertices);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_HullDesc_1mMaxFaces_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  HullDesc *arg1 = (HullDesc *) 0 ;
  unsigned int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(HullDesc **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  if (arg1) (arg1)->mMaxFaces = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_HullDesc_1mMaxFaces_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  HullDesc *arg1 = (HullDesc *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(HullDesc **)&jarg1; 
  result = (unsigned int) ((arg1)->mMaxFaces);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_delete_1HullDesc(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  HullDesc *arg1 = (HullDesc *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(HullDesc **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btPlane_1normal_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btPlane *arg1 = (btPlane *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btPlane **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->normal = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btPlane_1normal_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btPlane *arg1 = (btPlane *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPlane **)&jarg1; 
  result = (btVector3 *)& ((arg1)->normal);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btPlane_1dist_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btPlane *arg1 = (btPlane *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPlane **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->dist = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btPlane_1dist_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btPlane *arg1 = (btPlane *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPlane **)&jarg1; 
  result = (btScalar) ((arg1)->dist);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btPlane_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jobject jarg1, jfloat jarg2) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btScalar arg2 ;
  btPlane *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  arg2 = (btScalar)jarg2; 
  result = (btPlane *)new btPlane((btVector3 const &)*arg1,arg2);
  *(btPlane **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btPlane_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btPlane *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btPlane *)new btPlane();
  *(btPlane **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_delete_1btPlane(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btPlane *arg1 = (btPlane *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btPlane **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_ConvexH_1HalfEdge_1ea_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  ConvexH::HalfEdge *arg1 = (ConvexH::HalfEdge *) 0 ;
  short arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ConvexH::HalfEdge **)&jarg1; 
  arg2 = (short)jarg2; 
  if (arg1) (arg1)->ea = arg2;
}


SWIGEXPORT jshort JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_ConvexH_1HalfEdge_1ea_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  ConvexH::HalfEdge *arg1 = (ConvexH::HalfEdge *) 0 ;
  short result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ConvexH::HalfEdge **)&jarg1; 
  result = (short) ((arg1)->ea);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_ConvexH_1HalfEdge_1v_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  ConvexH::HalfEdge *arg1 = (ConvexH::HalfEdge *) 0 ;
  unsigned char arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ConvexH::HalfEdge **)&jarg1; 
  arg2 = (unsigned char)jarg2; 
  if (arg1) (arg1)->v = arg2;
}


SWIGEXPORT jshort JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_ConvexH_1HalfEdge_1v_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  ConvexH::HalfEdge *arg1 = (ConvexH::HalfEdge *) 0 ;
  unsigned char result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ConvexH::HalfEdge **)&jarg1; 
  result = (unsigned char) ((arg1)->v);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_ConvexH_1HalfEdge_1p_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  ConvexH::HalfEdge *arg1 = (ConvexH::HalfEdge *) 0 ;
  unsigned char arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ConvexH::HalfEdge **)&jarg1; 
  arg2 = (unsigned char)jarg2; 
  if (arg1) (arg1)->p = arg2;
}


SWIGEXPORT jshort JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_ConvexH_1HalfEdge_1p_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  ConvexH::HalfEdge *arg1 = (ConvexH::HalfEdge *) 0 ;
  unsigned char result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ConvexH::HalfEdge **)&jarg1; 
  result = (unsigned char) ((arg1)->p);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1ConvexH_1HalfEdge_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  ConvexH::HalfEdge *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (ConvexH::HalfEdge *)new ConvexH::HalfEdge();
  *(ConvexH::HalfEdge **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1ConvexH_1HalfEdge_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jshort jarg1, jshort jarg2, jshort jarg3) {
  jlong jresult = 0 ;
  short arg1 ;
  unsigned char arg2 ;
  unsigned char arg3 ;
  ConvexH::HalfEdge *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (short)jarg1; 
  arg2 = (unsigned char)jarg2; 
  arg3 = (unsigned char)jarg3; 
  result = (ConvexH::HalfEdge *)new ConvexH::HalfEdge(arg1,arg2,arg3);
  *(ConvexH::HalfEdge **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_delete_1ConvexH_1HalfEdge(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  ConvexH::HalfEdge *arg1 = (ConvexH::HalfEdge *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(ConvexH::HalfEdge **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1ConvexH_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  ConvexH *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (ConvexH *)new ConvexH();
  *(ConvexH **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_delete_1ConvexH(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  ConvexH *arg1 = (ConvexH *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(ConvexH **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_ConvexH_1vertices_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  ConvexH *arg1 = (ConvexH *) 0 ;
  btAlignedObjectArray< btVector3 > *arg2 = (btAlignedObjectArray< btVector3 > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(ConvexH **)&jarg1; 
  arg2 = *(btAlignedObjectArray< btVector3 > **)&jarg2; 
  if (arg1) (arg1)->vertices = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_ConvexH_1vertices_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  ConvexH *arg1 = (ConvexH *) 0 ;
  btAlignedObjectArray< btVector3 > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ConvexH **)&jarg1; 
  result = (btAlignedObjectArray< btVector3 > *)& ((arg1)->vertices);
  *(btAlignedObjectArray< btVector3 > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_ConvexH_1edges_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  ConvexH *arg1 = (ConvexH *) 0 ;
  btAlignedObjectArray< ConvexH::HalfEdge > *arg2 = (btAlignedObjectArray< ConvexH::HalfEdge > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ConvexH **)&jarg1; 
  arg2 = *(btAlignedObjectArray< ConvexH::HalfEdge > **)&jarg2; 
  if (arg1) (arg1)->edges = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_ConvexH_1edges_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  ConvexH *arg1 = (ConvexH *) 0 ;
  btAlignedObjectArray< ConvexH::HalfEdge > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ConvexH **)&jarg1; 
  result = (btAlignedObjectArray< ConvexH::HalfEdge > *)& ((arg1)->edges);
  *(btAlignedObjectArray< ConvexH::HalfEdge > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_ConvexH_1facets_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  ConvexH *arg1 = (ConvexH *) 0 ;
  btAlignedObjectArray< btPlane > *arg2 = (btAlignedObjectArray< btPlane > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ConvexH **)&jarg1; 
  arg2 = *(btAlignedObjectArray< btPlane > **)&jarg2; 
  if (arg1) (arg1)->facets = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_ConvexH_1facets_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  ConvexH *arg1 = (ConvexH *) 0 ;
  btAlignedObjectArray< btPlane > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ConvexH **)&jarg1; 
  result = (btAlignedObjectArray< btPlane > *)& ((arg1)->facets);
  *(btAlignedObjectArray< btPlane > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1ConvexH_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jint jarg3) {
  jlong jresult = 0 ;
  int arg1 ;
  int arg2 ;
  int arg3 ;
  ConvexH *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  result = (ConvexH *)new ConvexH(arg1,arg2,arg3);
  *(ConvexH **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_int4_1x_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  int4 *arg1 = (int4 *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(int4 **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->x = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_int4_1x_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  int4 *arg1 = (int4 *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(int4 **)&jarg1; 
  result = (int) ((arg1)->x);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_int4_1y_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  int4 *arg1 = (int4 *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(int4 **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->y = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_int4_1y_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  int4 *arg1 = (int4 *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(int4 **)&jarg1; 
  result = (int) ((arg1)->y);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_int4_1z_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  int4 *arg1 = (int4 *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(int4 **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->z = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_int4_1z_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  int4 *arg1 = (int4 *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(int4 **)&jarg1; 
  result = (int) ((arg1)->z);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_int4_1w_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  int4 *arg1 = (int4 *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(int4 **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->w = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_int4_1w_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  int4 *arg1 = (int4 *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(int4 **)&jarg1; 
  result = (int) ((arg1)->w);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1int4_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  int4 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (int4 *)new int4();
  *(int4 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1int4_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jint jarg3, jint jarg4) {
  jlong jresult = 0 ;
  int arg1 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  int4 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  result = (int4 *)new int4(arg1,arg2,arg3,arg4);
  *(int4 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_int4_1operatorSubscriptConst(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  int4 *arg1 = (int4 *) 0 ;
  int arg2 ;
  int *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(int4 **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (int *) &((int4 const *)arg1)->operator [](arg2);
  jresult = (jint)*result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_int4_1operatorSubscript(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  int4 *arg1 = (int4 *) 0 ;
  int arg2 ;
  int *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(int4 **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (int *) &(arg1)->operator [](arg2);
  *(int **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_delete_1int4(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  int4 *arg1 = (int4 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(int4 **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1PHullResult(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  PHullResult *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (PHullResult *)new PHullResult();
  *(PHullResult **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_PHullResult_1mVcount_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  PHullResult *arg1 = (PHullResult *) 0 ;
  unsigned int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(PHullResult **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  if (arg1) (arg1)->mVcount = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_PHullResult_1mVcount_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  PHullResult *arg1 = (PHullResult *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(PHullResult **)&jarg1; 
  result = (unsigned int) ((arg1)->mVcount);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_PHullResult_1mIndexCount_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  PHullResult *arg1 = (PHullResult *) 0 ;
  unsigned int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(PHullResult **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  if (arg1) (arg1)->mIndexCount = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_PHullResult_1mIndexCount_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  PHullResult *arg1 = (PHullResult *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(PHullResult **)&jarg1; 
  result = (unsigned int) ((arg1)->mIndexCount);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_PHullResult_1mFaceCount_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  PHullResult *arg1 = (PHullResult *) 0 ;
  unsigned int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(PHullResult **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  if (arg1) (arg1)->mFaceCount = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_PHullResult_1mFaceCount_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  PHullResult *arg1 = (PHullResult *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(PHullResult **)&jarg1; 
  result = (unsigned int) ((arg1)->mFaceCount);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_PHullResult_1mVertices_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  PHullResult *arg1 = (PHullResult *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(PHullResult **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->mVertices = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_PHullResult_1mVertices_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  PHullResult *arg1 = (PHullResult *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(PHullResult **)&jarg1; 
  result = (btVector3 *) ((arg1)->mVertices);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_PHullResult_1Indices_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  PHullResult *arg1 = (PHullResult *) 0 ;
  TUIntArray *arg2 = (TUIntArray *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(PHullResult **)&jarg1; 
  arg2 = *(TUIntArray **)&jarg2; 
  if (arg1) (arg1)->m_Indices = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_PHullResult_1Indices_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  PHullResult *arg1 = (PHullResult *) 0 ;
  TUIntArray *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(PHullResult **)&jarg1; 
  result = (TUIntArray *)& ((arg1)->m_Indices);
  *(TUIntArray **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_delete_1PHullResult(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  PHullResult *arg1 = (PHullResult *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(PHullResult **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_HullLibrary_1vertexIndexMapping_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  HullLibrary *arg1 = (HullLibrary *) 0 ;
  btAlignedObjectArray< int > *arg2 = (btAlignedObjectArray< int > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(HullLibrary **)&jarg1; 
  arg2 = *(btAlignedObjectArray< int > **)&jarg2; 
  if (arg1) (arg1)->m_vertexIndexMapping = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_HullLibrary_1vertexIndexMapping_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  HullLibrary *arg1 = (HullLibrary *) 0 ;
  btAlignedObjectArray< int > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(HullLibrary **)&jarg1; 
  result = (btAlignedObjectArray< int > *)& ((arg1)->m_vertexIndexMapping);
  *(btAlignedObjectArray< int > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_HullLibrary_1CreateConvexHull(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jint jresult = 0 ;
  HullLibrary *arg1 = (HullLibrary *) 0 ;
  HullDesc *arg2 = 0 ;
  HullResult *arg3 = 0 ;
  HullError result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(HullLibrary **)&jarg1; 
  arg2 = *(HullDesc **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "HullDesc const & reference is null");
    return 0;
  } 
  arg3 = *(HullResult **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "HullResult & reference is null");
    return 0;
  } 
  result = (HullError)(arg1)->CreateConvexHull((HullDesc const &)*arg2,*arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_HullLibrary_1ReleaseResult(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  HullLibrary *arg1 = (HullLibrary *) 0 ;
  HullResult *arg2 = 0 ;
  HullError result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(HullLibrary **)&jarg1; 
  arg2 = *(HullResult **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "HullResult & reference is null");
    return 0;
  } 
  result = (HullError)(arg1)->ReleaseResult(*arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1HullLibrary(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  HullLibrary *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (HullLibrary *)new HullLibrary();
  *(HullLibrary **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_delete_1HullLibrary(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  HullLibrary *arg1 = (HullLibrary *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(HullLibrary **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1GrahamVector3(JNIEnv *jenv, jclass jcls, jobject jarg1, jint jarg2) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  int arg2 ;
  GrahamVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  arg2 = (int)jarg2; 
  result = (GrahamVector3 *)new GrahamVector3((btVector3 const &)*arg1,arg2);
  *(GrahamVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_GrahamVector3_1angle_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  GrahamVector3 *arg1 = (GrahamVector3 *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GrahamVector3 **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_angle = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_GrahamVector3_1angle_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  GrahamVector3 *arg1 = (GrahamVector3 *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GrahamVector3 **)&jarg1; 
  result = (btScalar) ((arg1)->m_angle);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_GrahamVector3_1orgIndex_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  GrahamVector3 *arg1 = (GrahamVector3 *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GrahamVector3 **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_orgIndex = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_GrahamVector3_1orgIndex_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  GrahamVector3 *arg1 = (GrahamVector3 *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(GrahamVector3 **)&jarg1; 
  result = (int) ((arg1)->m_orgIndex);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_delete_1GrahamVector3(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  GrahamVector3 *arg1 = (GrahamVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GrahamVector3 **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btAngleCompareFunc_1anchor_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btAngleCompareFunc *arg1 = (btAngleCompareFunc *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btAngleCompareFunc **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_anchor = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btAngleCompareFunc_1anchor_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btAngleCompareFunc *arg1 = (btAngleCompareFunc *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAngleCompareFunc **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_anchor);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btAngleCompareFunc(JNIEnv *jenv, jclass jcls, jobject jarg1) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btAngleCompareFunc *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  result = (btAngleCompareFunc *)new btAngleCompareFunc((btVector3 const &)*arg1);
  *(btAngleCompareFunc **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btAngleCompareFunc_1operatorFunctionCall(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jboolean jresult = 0 ;
  btAngleCompareFunc *arg1 = (btAngleCompareFunc *) 0 ;
  GrahamVector3 *arg2 = 0 ;
  GrahamVector3 *arg3 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btAngleCompareFunc **)&jarg1; 
  arg2 = *(GrahamVector3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "GrahamVector3 const & reference is null");
    return 0;
  } 
  arg3 = *(GrahamVector3 **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "GrahamVector3 const & reference is null");
    return 0;
  } 
  result = (bool)((btAngleCompareFunc const *)arg1)->operator ()((GrahamVector3 const &)*arg2,(GrahamVector3 const &)*arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_delete_1btAngleCompareFunc(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btAngleCompareFunc *arg1 = (btAngleCompareFunc *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btAngleCompareFunc **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_GrahamScanConvexHull2D(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jobject jarg3) {
  btAlignedObjectArray< GrahamVector3 > *arg1 = 0 ;
  btAlignedObjectArray< GrahamVector3 > *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btAlignedObjectArray< GrahamVector3 > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btAlignedObjectArray< GrahamVector3 > & reference is null");
    return ;
  } 
  arg2 = *(btAlignedObjectArray< GrahamVector3 > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btAlignedObjectArray< GrahamVector3 > & reference is null");
    return ;
  } 
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  GrahamScanConvexHull2D(*arg1,*arg2,(btVector3 const &)*arg3);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btPoolAllocator(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2) {
  jlong jresult = 0 ;
  int arg1 ;
  int arg2 ;
  btPoolAllocator *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = (int)jarg2; 
  result = (btPoolAllocator *)new btPoolAllocator(arg1,arg2);
  *(btPoolAllocator **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_delete_1btPoolAllocator(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btPoolAllocator *arg1 = (btPoolAllocator *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btPoolAllocator **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btPoolAllocator_1getFreeCount(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btPoolAllocator *arg1 = (btPoolAllocator *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPoolAllocator **)&jarg1; 
  result = (int)((btPoolAllocator const *)arg1)->getFreeCount();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btPoolAllocator_1getUsedCount(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btPoolAllocator *arg1 = (btPoolAllocator *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPoolAllocator **)&jarg1; 
  result = (int)((btPoolAllocator const *)arg1)->getUsedCount();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btPoolAllocator_1getMaxCount(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btPoolAllocator *arg1 = (btPoolAllocator *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPoolAllocator **)&jarg1; 
  result = (int)((btPoolAllocator const *)arg1)->getMaxCount();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btPoolAllocator_1allocate(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  btPoolAllocator *arg1 = (btPoolAllocator *) 0 ;
  int arg2 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPoolAllocator **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (void *)(arg1)->allocate(arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btPoolAllocator_1validPtr(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jboolean jresult = 0 ;
  btPoolAllocator *arg1 = (btPoolAllocator *) 0 ;
  void *arg2 = (void *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPoolAllocator **)&jarg1; 
  arg2 = (void *)jarg2; 
  result = (bool)(arg1)->validPtr(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btPoolAllocator_1freeMemory(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btPoolAllocator *arg1 = (btPoolAllocator *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPoolAllocator **)&jarg1; 
  arg2 = (void *)jarg2; 
  (arg1)->freeMemory(arg2);
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btPoolAllocator_1getElementSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btPoolAllocator *arg1 = (btPoolAllocator *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPoolAllocator **)&jarg1; 
  result = (int)((btPoolAllocator const *)arg1)->getElementSize();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btPoolAllocator_1getPoolAddress(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btPoolAllocator *arg1 = (btPoolAllocator *) 0 ;
  unsigned char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPoolAllocator **)&jarg1; 
  result = (unsigned char *)(arg1)->getPoolAddress();
  *(unsigned char **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btPoolAllocator_1getPoolAddressConst(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btPoolAllocator *arg1 = (btPoolAllocator *) 0 ;
  unsigned char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPoolAllocator **)&jarg1; 
  result = (unsigned char *)((btPoolAllocator const *)arg1)->getPoolAddress();
  *(unsigned char **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btClock_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btClock *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btClock *)new btClock();
  *(btClock **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btClock_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btClock *arg1 = 0 ;
  btClock *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btClock **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btClock const & reference is null");
    return 0;
  } 
  result = (btClock *)new btClock((btClock const &)*arg1);
  *(btClock **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btClock_1operatorAssignment(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  btClock *arg1 = (btClock *) 0 ;
  btClock *arg2 = 0 ;
  btClock *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btClock **)&jarg1; 
  arg2 = *(btClock **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btClock const & reference is null");
    return 0;
  } 
  result = (btClock *) &(arg1)->operator =((btClock const &)*arg2);
  *(btClock **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_delete_1btClock(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btClock *arg1 = (btClock *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btClock **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btClock_1reset(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btClock *arg1 = (btClock *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btClock **)&jarg1; 
  (arg1)->reset();
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btClock_1getTimeMilliseconds(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btClock *arg1 = (btClock *) 0 ;
  unsigned long long result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btClock **)&jarg1; 
  result = (unsigned long long)(arg1)->getTimeMilliseconds();
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btClock_1getTimeMicroseconds(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btClock *arg1 = (btClock *) 0 ;
  unsigned long long result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btClock **)&jarg1; 
  result = (unsigned long long)(arg1)->getTimeMicroseconds();
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btClock_1getTimeNanoseconds(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btClock *arg1 = (btClock *) 0 ;
  unsigned long long result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btClock **)&jarg1; 
  result = (unsigned long long)(arg1)->getTimeNanoseconds();
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btClock_1getTimeSeconds(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btClock *arg1 = (btClock *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btClock **)&jarg1; 
  result = (btScalar)(arg1)->getTimeSeconds();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btGetCurrentEnterProfileZoneFunc(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btEnterProfileZoneFunc *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btEnterProfileZoneFunc *)btGetCurrentEnterProfileZoneFunc();
  *(btEnterProfileZoneFunc **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btGetCurrentLeaveProfileZoneFunc(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btLeaveProfileZoneFunc *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btLeaveProfileZoneFunc *)btGetCurrentLeaveProfileZoneFunc();
  *(btLeaveProfileZoneFunc **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSetCustomEnterProfileZoneFunc(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btEnterProfileZoneFunc *arg1 = (btEnterProfileZoneFunc *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btEnterProfileZoneFunc **)&jarg1; 
  btSetCustomEnterProfileZoneFunc(arg1);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSetCustomLeaveProfileZoneFunc(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btLeaveProfileZoneFunc *arg1 = (btLeaveProfileZoneFunc *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btLeaveProfileZoneFunc **)&jarg1; 
  btSetCustomLeaveProfileZoneFunc(arg1);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1CProfileSample(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  CProfileSample *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (CProfileSample *)new CProfileSample((char const *)arg1);
  *(CProfileSample **)&jresult = result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_delete_1CProfileSample(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  CProfileSample *arg1 = (CProfileSample *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CProfileSample **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btConvexHullComputer_1Edge_1getSourceVertex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btConvexHullComputer::Edge *arg1 = (btConvexHullComputer::Edge *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexHullComputer::Edge **)&jarg1; 
  result = (int)((btConvexHullComputer::Edge const *)arg1)->getSourceVertex();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btConvexHullComputer_1Edge_1getTargetVertex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btConvexHullComputer::Edge *arg1 = (btConvexHullComputer::Edge *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexHullComputer::Edge **)&jarg1; 
  result = (int)((btConvexHullComputer::Edge const *)arg1)->getTargetVertex();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btConvexHullComputer_1Edge_1getNextEdgeOfVertex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btConvexHullComputer::Edge *arg1 = (btConvexHullComputer::Edge *) 0 ;
  btConvexHullComputer::Edge *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexHullComputer::Edge **)&jarg1; 
  result = (btConvexHullComputer::Edge *)((btConvexHullComputer::Edge const *)arg1)->getNextEdgeOfVertex();
  *(btConvexHullComputer::Edge **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btConvexHullComputer_1Edge_1getNextEdgeOfFace(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btConvexHullComputer::Edge *arg1 = (btConvexHullComputer::Edge *) 0 ;
  btConvexHullComputer::Edge *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexHullComputer::Edge **)&jarg1; 
  result = (btConvexHullComputer::Edge *)((btConvexHullComputer::Edge const *)arg1)->getNextEdgeOfFace();
  *(btConvexHullComputer::Edge **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btConvexHullComputer_1Edge_1getReverseEdge(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btConvexHullComputer::Edge *arg1 = (btConvexHullComputer::Edge *) 0 ;
  btConvexHullComputer::Edge *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexHullComputer::Edge **)&jarg1; 
  result = (btConvexHullComputer::Edge *)((btConvexHullComputer::Edge const *)arg1)->getReverseEdge();
  *(btConvexHullComputer::Edge **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btConvexHullComputer_1Edge(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btConvexHullComputer::Edge *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btConvexHullComputer::Edge *)new btConvexHullComputer::Edge();
  *(btConvexHullComputer::Edge **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_delete_1btConvexHullComputer_1Edge(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btConvexHullComputer::Edge *arg1 = (btConvexHullComputer::Edge *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btConvexHullComputer::Edge **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btConvexHullComputer_1vertices_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btConvexHullComputer *arg1 = (btConvexHullComputer *) 0 ;
  btAlignedObjectArray< btVector3 > *arg2 = (btAlignedObjectArray< btVector3 > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btConvexHullComputer **)&jarg1; 
  arg2 = *(btAlignedObjectArray< btVector3 > **)&jarg2; 
  if (arg1) (arg1)->vertices = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btConvexHullComputer_1vertices_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btConvexHullComputer *arg1 = (btConvexHullComputer *) 0 ;
  btAlignedObjectArray< btVector3 > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexHullComputer **)&jarg1; 
  result = (btAlignedObjectArray< btVector3 > *)& ((arg1)->vertices);
  *(btAlignedObjectArray< btVector3 > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btConvexHullComputer_1edges_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btConvexHullComputer *arg1 = (btConvexHullComputer *) 0 ;
  btAlignedObjectArray< btConvexHullComputer::Edge > *arg2 = (btAlignedObjectArray< btConvexHullComputer::Edge > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexHullComputer **)&jarg1; 
  arg2 = *(btAlignedObjectArray< btConvexHullComputer::Edge > **)&jarg2; 
  if (arg1) (arg1)->edges = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btConvexHullComputer_1edges_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btConvexHullComputer *arg1 = (btConvexHullComputer *) 0 ;
  btAlignedObjectArray< btConvexHullComputer::Edge > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexHullComputer **)&jarg1; 
  result = (btAlignedObjectArray< btConvexHullComputer::Edge > *)& ((arg1)->edges);
  *(btAlignedObjectArray< btConvexHullComputer::Edge > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btConvexHullComputer_1faces_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btConvexHullComputer *arg1 = (btConvexHullComputer *) 0 ;
  btAlignedObjectArray< int > *arg2 = (btAlignedObjectArray< int > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexHullComputer **)&jarg1; 
  arg2 = *(btAlignedObjectArray< int > **)&jarg2; 
  if (arg1) (arg1)->faces = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btConvexHullComputer_1faces_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btConvexHullComputer *arg1 = (btConvexHullComputer *) 0 ;
  btAlignedObjectArray< int > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexHullComputer **)&jarg1; 
  result = (btAlignedObjectArray< int > *)& ((arg1)->faces);
  *(btAlignedObjectArray< int > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btConvexHullComputer_1compute_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jint jarg3, jint jarg4, jfloat jarg5, jfloat jarg6) {
  jfloat jresult = 0 ;
  btConvexHullComputer *arg1 = (btConvexHullComputer *) 0 ;
  float *arg2 = (float *) 0 ;
  int arg3 ;
  int arg4 ;
  btScalar arg5 ;
  btScalar arg6 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexHullComputer **)&jarg1; 
  {
    arg2 = (float*)jenv->GetDirectBufferAddress(jarg2);
    if (arg2 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (btScalar)jarg5; 
  arg6 = (btScalar)jarg6; 
  result = (btScalar)(arg1)->compute((float const *)arg2,arg3,arg4,arg5,arg6);
  jresult = (jfloat)result; 
  
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btConvexHullComputer_1compute_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jint jarg3, jint jarg4, jfloat jarg5, jfloat jarg6) {
  jfloat jresult = 0 ;
  btConvexHullComputer *arg1 = (btConvexHullComputer *) 0 ;
  double *arg2 = (double *) 0 ;
  int arg3 ;
  int arg4 ;
  btScalar arg5 ;
  btScalar arg6 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConvexHullComputer **)&jarg1; 
  {
    arg2 = (double*)jenv->GetDirectBufferAddress(jarg2);
    if (arg2 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (btScalar)jarg5; 
  arg6 = (btScalar)jarg6; 
  result = (btScalar)(arg1)->compute((double const *)arg2,arg3,arg4,arg5,arg6);
  jresult = (jfloat)result; 
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btConvexHullComputer(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btConvexHullComputer *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btConvexHullComputer *)new btConvexHullComputer();
  *(btConvexHullComputer **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_delete_1btConvexHullComputer(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btConvexHullComputer *arg1 = (btConvexHullComputer *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btConvexHullComputer **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btGEN_1Link_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btGEN_Link *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btGEN_Link *)new btGEN_Link();
  *(btGEN_Link **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btGEN_1Link_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  btGEN_Link *arg1 = (btGEN_Link *) 0 ;
  btGEN_Link *arg2 = (btGEN_Link *) 0 ;
  btGEN_Link *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGEN_Link **)&jarg1; 
  arg2 = *(btGEN_Link **)&jarg2; 
  result = (btGEN_Link *)new btGEN_Link(arg1,arg2);
  *(btGEN_Link **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btGEN_1Link_1getNext(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGEN_Link *arg1 = (btGEN_Link *) 0 ;
  btGEN_Link *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGEN_Link **)&jarg1; 
  result = (btGEN_Link *)((btGEN_Link const *)arg1)->getNext();
  *(btGEN_Link **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btGEN_1Link_1getPrev(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGEN_Link *arg1 = (btGEN_Link *) 0 ;
  btGEN_Link *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGEN_Link **)&jarg1; 
  result = (btGEN_Link *)((btGEN_Link const *)arg1)->getPrev();
  *(btGEN_Link **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btGEN_1Link_1isHead(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btGEN_Link *arg1 = (btGEN_Link *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGEN_Link **)&jarg1; 
  result = (bool)((btGEN_Link const *)arg1)->isHead();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btGEN_1Link_1isTail(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btGEN_Link *arg1 = (btGEN_Link *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGEN_Link **)&jarg1; 
  result = (bool)((btGEN_Link const *)arg1)->isTail();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btGEN_1Link_1insertBefore(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGEN_Link *arg1 = (btGEN_Link *) 0 ;
  btGEN_Link *arg2 = (btGEN_Link *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGEN_Link **)&jarg1; 
  arg2 = *(btGEN_Link **)&jarg2; 
  (arg1)->insertBefore(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btGEN_1Link_1insertAfter(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGEN_Link *arg1 = (btGEN_Link *) 0 ;
  btGEN_Link *arg2 = (btGEN_Link *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGEN_Link **)&jarg1; 
  arg2 = *(btGEN_Link **)&jarg2; 
  (arg1)->insertAfter(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btGEN_1Link_1remove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btGEN_Link *arg1 = (btGEN_Link *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGEN_Link **)&jarg1; 
  (arg1)->remove();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_delete_1btGEN_1Link(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btGEN_Link *arg1 = (btGEN_Link *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btGEN_Link **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btGEN_1List(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btGEN_List *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btGEN_List *)new btGEN_List();
  *(btGEN_List **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btGEN_1List_1getHead(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGEN_List *arg1 = (btGEN_List *) 0 ;
  btGEN_Link *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGEN_List **)&jarg1; 
  result = (btGEN_Link *)((btGEN_List const *)arg1)->getHead();
  *(btGEN_Link **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btGEN_1List_1getTail(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGEN_List *arg1 = (btGEN_List *) 0 ;
  btGEN_Link *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGEN_List **)&jarg1; 
  result = (btGEN_Link *)((btGEN_List const *)arg1)->getTail();
  *(btGEN_Link **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btGEN_1List_1addHead(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGEN_List *arg1 = (btGEN_List *) 0 ;
  btGEN_Link *arg2 = (btGEN_Link *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGEN_List **)&jarg1; 
  arg2 = *(btGEN_Link **)&jarg2; 
  (arg1)->addHead(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btGEN_1List_1addTail(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGEN_List *arg1 = (btGEN_List *) 0 ;
  btGEN_Link *arg2 = (btGEN_Link *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGEN_List **)&jarg1; 
  arg2 = *(btGEN_Link **)&jarg2; 
  (arg1)->addTail(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_delete_1btGEN_1List(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btGEN_List *arg1 = (btGEN_List *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btGEN_List **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btAlignedAllocInternal(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jlong jresult = 0 ;
  size_t arg1 ;
  int arg2 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (size_t)jarg1; 
  arg2 = (int)jarg2; 
  result = (void *)btAlignedAllocInternal(arg1,arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btAlignedFreeInternal(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  void *arg1 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (void *)jarg1; 
  btAlignedFreeInternal(arg1);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btAlignedAllocSetCustom(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  btAllocFunc *arg1 = (btAllocFunc *) 0 ;
  btFreeFunc *arg2 = (btFreeFunc *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btAllocFunc **)&jarg1; 
  arg2 = *(btFreeFunc **)&jarg2; 
  btAlignedAllocSetCustom(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btAlignedAllocSetCustomAligned(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  btAlignedAllocFunc *arg1 = (btAlignedAllocFunc *) 0 ;
  btAlignedFreeFunc *arg2 = (btAlignedFreeFunc *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btAlignedAllocFunc **)&jarg1; 
  arg2 = *(btAlignedFreeFunc **)&jarg2; 
  btAlignedAllocSetCustomAligned(arg1,arg2);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btHashString_1string_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btHashString *arg1 = (btHashString *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btHashString **)&jarg1; 
  result = (char *) ((arg1)->m_string);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btHashString_1hash_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btHashString *arg1 = (btHashString *) 0 ;
  unsigned int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btHashString **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  if (arg1) (arg1)->m_hash = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btHashString_1hash_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btHashString *arg1 = (btHashString *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btHashString **)&jarg1; 
  result = (unsigned int) ((arg1)->m_hash);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btHashString(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  btHashString *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (btHashString *)new btHashString((char const *)arg1);
  *(btHashString **)&jresult = result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btHashString_1portableStringCompare(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  jint jresult = 0 ;
  btHashString *arg1 = (btHashString *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btHashString **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  result = (int)((btHashString const *)arg1)->portableStringCompare((char const *)arg2,(char const *)arg3);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btHashString_1equals(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  btHashString *arg1 = (btHashString *) 0 ;
  btHashString *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btHashString **)&jarg1; 
  arg2 = *(btHashString **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btHashString const & reference is null");
    return 0;
  } 
  result = (bool)((btHashString const *)arg1)->equals((btHashString const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_delete_1btHashString(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btHashString *arg1 = (btHashString *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btHashString **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_BT_1HASH_1NULL_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(int)BT_HASH_NULL;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btHashInt_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btHashInt *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btHashInt *)new btHashInt();
  *(btHashInt **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btHashInt_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  int arg1 ;
  btHashInt *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (btHashInt *)new btHashInt(arg1);
  *(btHashInt **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btHashInt_1getUid1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btHashInt *arg1 = (btHashInt *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btHashInt **)&jarg1; 
  result = (int)((btHashInt const *)arg1)->getUid1();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btHashInt_1setUid1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btHashInt *arg1 = (btHashInt *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btHashInt **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->setUid1(arg2);
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btHashInt_1equals(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  btHashInt *arg1 = (btHashInt *) 0 ;
  btHashInt *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btHashInt **)&jarg1; 
  arg2 = *(btHashInt **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btHashInt const & reference is null");
    return 0;
  } 
  result = (bool)((btHashInt const *)arg1)->equals((btHashInt const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btHashInt_1getHash(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btHashInt *arg1 = (btHashInt *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btHashInt **)&jarg1; 
  result = (unsigned int)((btHashInt const *)arg1)->getHash();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_delete_1btHashInt(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btHashInt *arg1 = (btHashInt *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btHashInt **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btHashPtr(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  void *arg1 = (void *) 0 ;
  btHashPtr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (void *)jarg1; 
  result = (btHashPtr *)new btHashPtr((void const *)arg1);
  *(btHashPtr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btHashPtr_1getPointer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btHashPtr *arg1 = (btHashPtr *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btHashPtr **)&jarg1; 
  result = (void *)((btHashPtr const *)arg1)->getPointer();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btHashPtr_1equals(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  btHashPtr *arg1 = (btHashPtr *) 0 ;
  btHashPtr *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btHashPtr **)&jarg1; 
  arg2 = *(btHashPtr **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btHashPtr const & reference is null");
    return 0;
  } 
  result = (bool)((btHashPtr const *)arg1)->equals((btHashPtr const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btHashPtr_1getHash(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btHashPtr *arg1 = (btHashPtr *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btHashPtr **)&jarg1; 
  result = (unsigned int)((btHashPtr const *)arg1)->getHash();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_delete_1btHashPtr(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btHashPtr *arg1 = (btHashPtr *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btHashPtr **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btBlock_1previous_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btBlock *arg1 = (btBlock *) 0 ;
  btBlock *arg2 = (btBlock *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btBlock **)&jarg1; 
  arg2 = *(btBlock **)&jarg2; 
  if (arg1) (arg1)->previous = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btBlock_1previous_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btBlock *arg1 = (btBlock *) 0 ;
  btBlock *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBlock **)&jarg1; 
  result = (btBlock *) ((arg1)->previous);
  *(btBlock **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btBlock_1address_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btBlock *arg1 = (btBlock *) 0 ;
  unsigned char *arg2 = (unsigned char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBlock **)&jarg1; 
  {
    arg2 = (unsigned char*)jenv->GetDirectBufferAddress(jarg2);
    if (arg2 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  {
    if (arg2) {
      arg1->address = arg2;
    } else {
      arg1->address = 0;
    }
  }
  
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btBlock_1address_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btBlock *arg1 = (btBlock *) 0 ;
  unsigned char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBlock **)&jarg1; 
  result = (unsigned char *) ((arg1)->address);
  *(unsigned char **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btBlock(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btBlock *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btBlock *)new btBlock();
  *(btBlock **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_delete_1btBlock(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btBlock *arg1 = (btBlock *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btBlock **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btStackAlloc(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  unsigned int arg1 ;
  btStackAlloc *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (unsigned int)jarg1; 
  result = (btStackAlloc *)new btStackAlloc(arg1);
  *(btStackAlloc **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_delete_1btStackAlloc(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btStackAlloc *arg1 = (btStackAlloc *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btStackAlloc **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btStackAlloc_1create(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btStackAlloc *arg1 = (btStackAlloc *) 0 ;
  unsigned int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStackAlloc **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  (arg1)->create(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btStackAlloc_1destroy(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btStackAlloc *arg1 = (btStackAlloc *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStackAlloc **)&jarg1; 
  (arg1)->destroy();
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btStackAlloc_1getAvailableMemory(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btStackAlloc *arg1 = (btStackAlloc *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStackAlloc **)&jarg1; 
  result = (int)((btStackAlloc const *)arg1)->getAvailableMemory();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btStackAlloc_1allocate(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jobject jresult = 0 ;
  btStackAlloc *arg1 = (btStackAlloc *) 0 ;
  unsigned int arg2 ;
  unsigned char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStackAlloc **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  result = (unsigned char *)(arg1)->allocate(arg2);
  *(unsigned char **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btStackAlloc_1beginBlock(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btStackAlloc *arg1 = (btStackAlloc *) 0 ;
  btBlock *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btStackAlloc **)&jarg1; 
  result = (btBlock *)(arg1)->beginBlock();
  *(btBlock **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btStackAlloc_1endBlock(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btStackAlloc *arg1 = (btStackAlloc *) 0 ;
  btBlock *arg2 = (btBlock *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btStackAlloc **)&jarg1; 
  arg2 = *(btBlock **)&jarg2; 
  (arg1)->endBlock(arg2);
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIntSortPredicate_1operatorFunctionCall(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  jboolean jresult = 0 ;
  btIntSortPredicate *arg1 = (btIntSortPredicate *) 0 ;
  int *arg2 = 0 ;
  int *arg3 = 0 ;
  int temp2 ;
  int temp3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIntSortPredicate **)&jarg1; 
  temp2 = (int)jarg2; 
  arg2 = &temp2; 
  temp3 = (int)jarg3; 
  arg3 = &temp3; 
  result = (bool)((btIntSortPredicate const *)arg1)->operator ()((int const &)*arg2,(int const &)*arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btIntSortPredicate(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btIntSortPredicate *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btIntSortPredicate *)new btIntSortPredicate();
  *(btIntSortPredicate **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_delete_1btIntSortPredicate(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btIntSortPredicate *arg1 = (btIntSortPredicate *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btIntSortPredicate **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_setElem_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3, jdouble jarg4) {
  btMatrixXd *arg1 = 0 ;
  int arg2 ;
  int arg3 ;
  double arg4 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btMatrixXd **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btMatrixXd & reference is null");
    return ;
  } 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (double)jarg4; 
  setElem(*arg1,arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_setElem_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3, jfloat jarg4) {
  btMatrixXf *arg1 = 0 ;
  int arg2 ;
  int arg3 ;
  float arg4 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btMatrixXf **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btMatrixXf & reference is null");
    return ;
  } 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (float)jarg4; 
  setElem(*arg1,arg2,arg3,arg4);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btPolarDecomposition_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jfloat jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  btScalar arg1 ;
  unsigned int arg2 ;
  btPolarDecomposition *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  arg2 = (unsigned int)jarg2; 
  result = (btPolarDecomposition *)new btPolarDecomposition(arg1,arg2);
  *(btPolarDecomposition **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btPolarDecomposition_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jfloat jarg1) {
  jlong jresult = 0 ;
  btScalar arg1 ;
  btPolarDecomposition *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  result = (btPolarDecomposition *)new btPolarDecomposition(arg1);
  *(btPolarDecomposition **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btPolarDecomposition_1_1SWIG_12(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btPolarDecomposition *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btPolarDecomposition *)new btPolarDecomposition();
  *(btPolarDecomposition **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btPolarDecomposition_1decompose(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jobject jarg4) {
  jlong jresult = 0 ;
  btPolarDecomposition *arg1 = (btPolarDecomposition *) 0 ;
  btMatrix3x3 *arg2 = 0 ;
  btMatrix3x3 *arg3 = 0 ;
  btMatrix3x3 *arg4 = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPolarDecomposition **)&jarg1; 
  btMatrix3x3 local_arg2;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btMatrix3x3 local_arg3;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitMatrix3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btMatrix3x3 local_arg4;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitMatrix3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  result = (unsigned int)((btPolarDecomposition const *)arg1)->decompose((btMatrix3x3 const &)*arg2,*arg3,*arg4);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btPolarDecomposition_1maxIterations(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btPolarDecomposition *arg1 = (btPolarDecomposition *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPolarDecomposition **)&jarg1; 
  result = (unsigned int)((btPolarDecomposition const *)arg1)->maxIterations();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_delete_1btPolarDecomposition(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btPolarDecomposition *arg1 = (btPolarDecomposition *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btPolarDecomposition **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_polarDecompose(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jobject jarg3) {
  jlong jresult = 0 ;
  btMatrix3x3 *arg1 = 0 ;
  btMatrix3x3 *arg2 = 0 ;
  btMatrix3x3 *arg3 = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  btMatrix3x3 local_arg1;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitMatrix3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btMatrix3x3 local_arg2;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btMatrix3x3 local_arg3;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitMatrix3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  result = (unsigned int)polarDecompose((btMatrix3x3 const &)*arg1,*arg2,*arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_sBulletDNAstr_1set(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  char *arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return ;
  }
  {
    if (arg1) strcpy((char *)sBulletDNAstr, (const char *)arg1);
    else sBulletDNAstr[0] = 0;
  }
  
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_sBulletDNAstr_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)sBulletDNAstr;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_sBulletDNAlen_1set(JNIEnv *jenv, jclass jcls, jint jarg1) {
  int arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  sBulletDNAlen = arg1;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_sBulletDNAlen_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)sBulletDNAlen;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_sBulletDNAstr64_1set(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  char *arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return ;
  }
  {
    if (arg1) strcpy((char *)sBulletDNAstr64, (const char *)arg1);
    else sBulletDNAstr64[0] = 0;
  }
  
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_sBulletDNAstr64_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)sBulletDNAstr64;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_sBulletDNAlen64_1set(JNIEnv *jenv, jclass jcls, jint jarg1) {
  int arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  sBulletDNAlen64 = arg1;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_sBulletDNAlen64_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)sBulletDNAlen64;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btStrLen(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jint jresult = 0 ;
  char *arg1 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (int)btStrLen((char const *)arg1);
  jresult = (jint)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btChunk_1chunkCode_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btChunk *arg1 = (btChunk *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btChunk **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_chunkCode = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btChunk_1chunkCode_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btChunk *arg1 = (btChunk *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btChunk **)&jarg1; 
  result = (int) ((arg1)->m_chunkCode);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btChunk_1length_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btChunk *arg1 = (btChunk *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btChunk **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_length = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btChunk_1length_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btChunk *arg1 = (btChunk *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btChunk **)&jarg1; 
  result = (int) ((arg1)->m_length);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btChunk_1oldPtr_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btChunk *arg1 = (btChunk *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btChunk **)&jarg1; 
  arg2 = (void *)jarg2; 
  if (arg1) (arg1)->m_oldPtr = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btChunk_1oldPtr_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btChunk *arg1 = (btChunk *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btChunk **)&jarg1; 
  result = (void *) ((arg1)->m_oldPtr);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btChunk_1dna_1nr_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btChunk *arg1 = (btChunk *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btChunk **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_dna_nr = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btChunk_1dna_1nr_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btChunk *arg1 = (btChunk *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btChunk **)&jarg1; 
  result = (int) ((arg1)->m_dna_nr);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btChunk_1number_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btChunk *arg1 = (btChunk *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btChunk **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_number = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btChunk_1number_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btChunk *arg1 = (btChunk *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btChunk **)&jarg1; 
  result = (int) ((arg1)->m_number);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btChunk(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btChunk *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btChunk *)new btChunk();
  *(btChunk **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_delete_1btChunk(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btChunk *arg1 = (btChunk *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btChunk **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_delete_1btSerializer(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSerializer *arg1 = (btSerializer *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSerializer **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSerializer_1getBufferPointer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btSerializer *arg1 = (btSerializer *) 0 ;
  unsigned char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSerializer **)&jarg1; 
  result = (unsigned char *)((btSerializer const *)arg1)->getBufferPointer();
  *(unsigned char **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSerializer_1getCurrentBufferSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSerializer *arg1 = (btSerializer *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSerializer **)&jarg1; 
  result = (int)((btSerializer const *)arg1)->getCurrentBufferSize();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSerializer_1allocate(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3) {
  jlong jresult = 0 ;
  btSerializer *arg1 = (btSerializer *) 0 ;
  size_t arg2 ;
  int arg3 ;
  btChunk *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSerializer **)&jarg1; 
  arg2 = (size_t)jarg2; 
  arg3 = (int)jarg3; 
  result = (btChunk *)(arg1)->allocate(arg2,arg3);
  *(btChunk **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSerializer_1finalizeChunk(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3, jint jarg4, jlong jarg5) {
  btSerializer *arg1 = (btSerializer *) 0 ;
  btChunk *arg2 = (btChunk *) 0 ;
  char *arg3 = (char *) 0 ;
  int arg4 ;
  void *arg5 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSerializer **)&jarg1; 
  arg2 = *(btChunk **)&jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return ;
  }
  arg4 = (int)jarg4; 
  arg5 = (void *)jarg5; 
  (arg1)->finalizeChunk(arg2,(char const *)arg3,arg4,arg5);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSerializer_1findPointer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  btSerializer *arg1 = (btSerializer *) 0 ;
  void *arg2 = (void *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSerializer **)&jarg1; 
  arg2 = (void *)jarg2; 
  result = (void *)(arg1)->findPointer(arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSerializer_1getUniquePointer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  btSerializer *arg1 = (btSerializer *) 0 ;
  void *arg2 = (void *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSerializer **)&jarg1; 
  arg2 = (void *)jarg2; 
  result = (void *)(arg1)->getUniquePointer(arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSerializer_1startSerialization(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btSerializer *arg1 = (btSerializer *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSerializer **)&jarg1; 
  (arg1)->startSerialization();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSerializer_1finishSerialization(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btSerializer *arg1 = (btSerializer *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSerializer **)&jarg1; 
  (arg1)->finishSerialization();
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSerializer_1findNameForPointer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jstring jresult = 0 ;
  btSerializer *arg1 = (btSerializer *) 0 ;
  void *arg2 = (void *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSerializer **)&jarg1; 
  arg2 = (void *)jarg2; 
  result = (char *)((btSerializer const *)arg1)->findNameForPointer((void const *)arg2);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSerializer_1registerNameForPointer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jstring jarg3) {
  btSerializer *arg1 = (btSerializer *) 0 ;
  void *arg2 = (void *) 0 ;
  char *arg3 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSerializer **)&jarg1; 
  arg2 = (void *)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return ;
  }
  (arg1)->registerNameForPointer((void const *)arg2,(char const *)arg3);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSerializer_1serializeName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btSerializer *arg1 = (btSerializer *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSerializer **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->serializeName((char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSerializer_1getSerializationFlags(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSerializer *arg1 = (btSerializer *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSerializer **)&jarg1; 
  result = (int)((btSerializer const *)arg1)->getSerializationFlags();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSerializer_1setSerializationFlags(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSerializer *arg1 = (btSerializer *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSerializer **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->setSerializationFlags(arg2);
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSerializer_1getNumChunks(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSerializer *arg1 = (btSerializer *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSerializer **)&jarg1; 
  result = (int)((btSerializer const *)arg1)->getNumChunks();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSerializer_1getChunk(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  btSerializer *arg1 = (btSerializer *) 0 ;
  int arg2 ;
  btChunk *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSerializer **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (btChunk *)((btSerializer const *)arg1)->getChunk(arg2);
  *(btChunk **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btPointerUid_1ptr_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btPointerUid *arg1 = (btPointerUid *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPointerUid **)&jarg1; 
  arg2 = (void *)jarg2; 
  if (arg1) (arg1)->m_ptr = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btPointerUid_1ptr_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btPointerUid *arg1 = (btPointerUid *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPointerUid **)&jarg1; 
  result = (void *) ((arg1)->m_ptr);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btPointerUid_1uniqueIds_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jintArray jarg2) {
  btPointerUid *arg1 = (btPointerUid *) 0 ;
  int *arg2 ;
  jint *jarr2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPointerUid **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  if (!SWIG_JavaArrayInInt(jenv, &jarr2, (int **)&arg2, jarg2)) return ; 
  {
    size_t ii;
    int *b = (int *) arg1->m_uniqueIds;
    for (ii = 0; ii < (size_t)2; ii++) b[ii] = *((int *) arg2 + ii);
  }
  SWIG_JavaArrayArgoutInt(jenv, jarr2, (int *)arg2, jarg2); 
  delete [] arg2; 
}


SWIGEXPORT jintArray JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btPointerUid_1uniqueIds_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jintArray jresult = 0 ;
  btPointerUid *arg1 = (btPointerUid *) 0 ;
  int *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPointerUid **)&jarg1; 
  result = (int *)(int *) ((arg1)->m_uniqueIds);
  jresult = SWIG_JavaArrayOutInt(jenv, (int *)result, 2); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btPointerUid(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btPointerUid *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btPointerUid *)new btPointerUid();
  *(btPointerUid **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_delete_1btPointerUid(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btPointerUid *arg1 = (btPointerUid *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btPointerUid **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btBulletSerializedArrays(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btBulletSerializedArrays *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btBulletSerializedArrays *)new btBulletSerializedArrays();
  *(btBulletSerializedArrays **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btBulletSerializedArrays_1bvhsDouble_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btBulletSerializedArrays *arg1 = (btBulletSerializedArrays *) 0 ;
  btAlignedObjectArray< btQuantizedBvhDoubleData * > *arg2 = (btAlignedObjectArray< btQuantizedBvhDoubleData * > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBulletSerializedArrays **)&jarg1; 
  arg2 = *(btAlignedObjectArray< btQuantizedBvhDoubleData * > **)&jarg2; 
  if (arg1) (arg1)->m_bvhsDouble = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btBulletSerializedArrays_1bvhsDouble_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btBulletSerializedArrays *arg1 = (btBulletSerializedArrays *) 0 ;
  btAlignedObjectArray< btQuantizedBvhDoubleData * > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBulletSerializedArrays **)&jarg1; 
  result = (btAlignedObjectArray< btQuantizedBvhDoubleData * > *)& ((arg1)->m_bvhsDouble);
  *(btAlignedObjectArray< btQuantizedBvhDoubleData * > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btBulletSerializedArrays_1bvhsFloat_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btBulletSerializedArrays *arg1 = (btBulletSerializedArrays *) 0 ;
  btAlignedObjectArray< btQuantizedBvhFloatData * > *arg2 = (btAlignedObjectArray< btQuantizedBvhFloatData * > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBulletSerializedArrays **)&jarg1; 
  arg2 = *(btAlignedObjectArray< btQuantizedBvhFloatData * > **)&jarg2; 
  if (arg1) (arg1)->m_bvhsFloat = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btBulletSerializedArrays_1bvhsFloat_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btBulletSerializedArrays *arg1 = (btBulletSerializedArrays *) 0 ;
  btAlignedObjectArray< btQuantizedBvhFloatData * > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBulletSerializedArrays **)&jarg1; 
  result = (btAlignedObjectArray< btQuantizedBvhFloatData * > *)& ((arg1)->m_bvhsFloat);
  *(btAlignedObjectArray< btQuantizedBvhFloatData * > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btBulletSerializedArrays_1colShapeData_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btBulletSerializedArrays *arg1 = (btBulletSerializedArrays *) 0 ;
  btAlignedObjectArray< btCollisionShapeData * > *arg2 = (btAlignedObjectArray< btCollisionShapeData * > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBulletSerializedArrays **)&jarg1; 
  arg2 = *(btAlignedObjectArray< btCollisionShapeData * > **)&jarg2; 
  if (arg1) (arg1)->m_colShapeData = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btBulletSerializedArrays_1colShapeData_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btBulletSerializedArrays *arg1 = (btBulletSerializedArrays *) 0 ;
  btAlignedObjectArray< btCollisionShapeData * > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBulletSerializedArrays **)&jarg1; 
  result = (btAlignedObjectArray< btCollisionShapeData * > *)& ((arg1)->m_colShapeData);
  *(btAlignedObjectArray< btCollisionShapeData * > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btBulletSerializedArrays_1dynamicWorldInfoDataDouble_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btBulletSerializedArrays *arg1 = (btBulletSerializedArrays *) 0 ;
  btAlignedObjectArray< btDynamicsWorldDoubleData * > *arg2 = (btAlignedObjectArray< btDynamicsWorldDoubleData * > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBulletSerializedArrays **)&jarg1; 
  arg2 = *(btAlignedObjectArray< btDynamicsWorldDoubleData * > **)&jarg2; 
  if (arg1) (arg1)->m_dynamicWorldInfoDataDouble = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btBulletSerializedArrays_1dynamicWorldInfoDataDouble_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btBulletSerializedArrays *arg1 = (btBulletSerializedArrays *) 0 ;
  btAlignedObjectArray< btDynamicsWorldDoubleData * > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBulletSerializedArrays **)&jarg1; 
  result = (btAlignedObjectArray< btDynamicsWorldDoubleData * > *)& ((arg1)->m_dynamicWorldInfoDataDouble);
  *(btAlignedObjectArray< btDynamicsWorldDoubleData * > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btBulletSerializedArrays_1dynamicWorldInfoDataFloat_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btBulletSerializedArrays *arg1 = (btBulletSerializedArrays *) 0 ;
  btAlignedObjectArray< btDynamicsWorldFloatData * > *arg2 = (btAlignedObjectArray< btDynamicsWorldFloatData * > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBulletSerializedArrays **)&jarg1; 
  arg2 = *(btAlignedObjectArray< btDynamicsWorldFloatData * > **)&jarg2; 
  if (arg1) (arg1)->m_dynamicWorldInfoDataFloat = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btBulletSerializedArrays_1dynamicWorldInfoDataFloat_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btBulletSerializedArrays *arg1 = (btBulletSerializedArrays *) 0 ;
  btAlignedObjectArray< btDynamicsWorldFloatData * > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBulletSerializedArrays **)&jarg1; 
  result = (btAlignedObjectArray< btDynamicsWorldFloatData * > *)& ((arg1)->m_dynamicWorldInfoDataFloat);
  *(btAlignedObjectArray< btDynamicsWorldFloatData * > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btBulletSerializedArrays_1rigidBodyDataDouble_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btBulletSerializedArrays *arg1 = (btBulletSerializedArrays *) 0 ;
  btAlignedObjectArray< btRigidBodyDoubleData * > *arg2 = (btAlignedObjectArray< btRigidBodyDoubleData * > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBulletSerializedArrays **)&jarg1; 
  arg2 = *(btAlignedObjectArray< btRigidBodyDoubleData * > **)&jarg2; 
  if (arg1) (arg1)->m_rigidBodyDataDouble = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btBulletSerializedArrays_1rigidBodyDataDouble_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btBulletSerializedArrays *arg1 = (btBulletSerializedArrays *) 0 ;
  btAlignedObjectArray< btRigidBodyDoubleData * > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBulletSerializedArrays **)&jarg1; 
  result = (btAlignedObjectArray< btRigidBodyDoubleData * > *)& ((arg1)->m_rigidBodyDataDouble);
  *(btAlignedObjectArray< btRigidBodyDoubleData * > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btBulletSerializedArrays_1rigidBodyDataFloat_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btBulletSerializedArrays *arg1 = (btBulletSerializedArrays *) 0 ;
  btAlignedObjectArray< btRigidBodyFloatData * > *arg2 = (btAlignedObjectArray< btRigidBodyFloatData * > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBulletSerializedArrays **)&jarg1; 
  arg2 = *(btAlignedObjectArray< btRigidBodyFloatData * > **)&jarg2; 
  if (arg1) (arg1)->m_rigidBodyDataFloat = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btBulletSerializedArrays_1rigidBodyDataFloat_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btBulletSerializedArrays *arg1 = (btBulletSerializedArrays *) 0 ;
  btAlignedObjectArray< btRigidBodyFloatData * > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBulletSerializedArrays **)&jarg1; 
  result = (btAlignedObjectArray< btRigidBodyFloatData * > *)& ((arg1)->m_rigidBodyDataFloat);
  *(btAlignedObjectArray< btRigidBodyFloatData * > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btBulletSerializedArrays_1collisionObjectDataDouble_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btBulletSerializedArrays *arg1 = (btBulletSerializedArrays *) 0 ;
  btAlignedObjectArray< btCollisionObjectDoubleData * > *arg2 = (btAlignedObjectArray< btCollisionObjectDoubleData * > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBulletSerializedArrays **)&jarg1; 
  arg2 = *(btAlignedObjectArray< btCollisionObjectDoubleData * > **)&jarg2; 
  if (arg1) (arg1)->m_collisionObjectDataDouble = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btBulletSerializedArrays_1collisionObjectDataDouble_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btBulletSerializedArrays *arg1 = (btBulletSerializedArrays *) 0 ;
  btAlignedObjectArray< btCollisionObjectDoubleData * > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBulletSerializedArrays **)&jarg1; 
  result = (btAlignedObjectArray< btCollisionObjectDoubleData * > *)& ((arg1)->m_collisionObjectDataDouble);
  *(btAlignedObjectArray< btCollisionObjectDoubleData * > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btBulletSerializedArrays_1collisionObjectDataFloat_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btBulletSerializedArrays *arg1 = (btBulletSerializedArrays *) 0 ;
  btAlignedObjectArray< btCollisionObjectFloatData * > *arg2 = (btAlignedObjectArray< btCollisionObjectFloatData * > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBulletSerializedArrays **)&jarg1; 
  arg2 = *(btAlignedObjectArray< btCollisionObjectFloatData * > **)&jarg2; 
  if (arg1) (arg1)->m_collisionObjectDataFloat = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btBulletSerializedArrays_1collisionObjectDataFloat_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btBulletSerializedArrays *arg1 = (btBulletSerializedArrays *) 0 ;
  btAlignedObjectArray< btCollisionObjectFloatData * > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBulletSerializedArrays **)&jarg1; 
  result = (btAlignedObjectArray< btCollisionObjectFloatData * > *)& ((arg1)->m_collisionObjectDataFloat);
  *(btAlignedObjectArray< btCollisionObjectFloatData * > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btBulletSerializedArrays_1constraintDataFloat_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btBulletSerializedArrays *arg1 = (btBulletSerializedArrays *) 0 ;
  btAlignedObjectArray< btTypedConstraintFloatData * > *arg2 = (btAlignedObjectArray< btTypedConstraintFloatData * > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBulletSerializedArrays **)&jarg1; 
  arg2 = *(btAlignedObjectArray< btTypedConstraintFloatData * > **)&jarg2; 
  if (arg1) (arg1)->m_constraintDataFloat = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btBulletSerializedArrays_1constraintDataFloat_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btBulletSerializedArrays *arg1 = (btBulletSerializedArrays *) 0 ;
  btAlignedObjectArray< btTypedConstraintFloatData * > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBulletSerializedArrays **)&jarg1; 
  result = (btAlignedObjectArray< btTypedConstraintFloatData * > *)& ((arg1)->m_constraintDataFloat);
  *(btAlignedObjectArray< btTypedConstraintFloatData * > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btBulletSerializedArrays_1constraintDataDouble_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btBulletSerializedArrays *arg1 = (btBulletSerializedArrays *) 0 ;
  btAlignedObjectArray< btTypedConstraintDoubleData * > *arg2 = (btAlignedObjectArray< btTypedConstraintDoubleData * > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBulletSerializedArrays **)&jarg1; 
  arg2 = *(btAlignedObjectArray< btTypedConstraintDoubleData * > **)&jarg2; 
  if (arg1) (arg1)->m_constraintDataDouble = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btBulletSerializedArrays_1constraintDataDouble_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btBulletSerializedArrays *arg1 = (btBulletSerializedArrays *) 0 ;
  btAlignedObjectArray< btTypedConstraintDoubleData * > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBulletSerializedArrays **)&jarg1; 
  result = (btAlignedObjectArray< btTypedConstraintDoubleData * > *)& ((arg1)->m_constraintDataDouble);
  *(btAlignedObjectArray< btTypedConstraintDoubleData * > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btBulletSerializedArrays_1constraintData_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btBulletSerializedArrays *arg1 = (btBulletSerializedArrays *) 0 ;
  btAlignedObjectArray< btTypedConstraintData * > *arg2 = (btAlignedObjectArray< btTypedConstraintData * > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBulletSerializedArrays **)&jarg1; 
  arg2 = *(btAlignedObjectArray< btTypedConstraintData * > **)&jarg2; 
  if (arg1) (arg1)->m_constraintData = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btBulletSerializedArrays_1constraintData_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btBulletSerializedArrays *arg1 = (btBulletSerializedArrays *) 0 ;
  btAlignedObjectArray< btTypedConstraintData * > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBulletSerializedArrays **)&jarg1; 
  result = (btAlignedObjectArray< btTypedConstraintData * > *)& ((arg1)->m_constraintData);
  *(btAlignedObjectArray< btTypedConstraintData * > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btBulletSerializedArrays_1softBodyFloatData_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btBulletSerializedArrays *arg1 = (btBulletSerializedArrays *) 0 ;
  btAlignedObjectArray< btSoftBodyFloatData * > *arg2 = (btAlignedObjectArray< btSoftBodyFloatData * > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBulletSerializedArrays **)&jarg1; 
  arg2 = *(btAlignedObjectArray< btSoftBodyFloatData * > **)&jarg2; 
  if (arg1) (arg1)->m_softBodyFloatData = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btBulletSerializedArrays_1softBodyFloatData_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btBulletSerializedArrays *arg1 = (btBulletSerializedArrays *) 0 ;
  btAlignedObjectArray< btSoftBodyFloatData * > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBulletSerializedArrays **)&jarg1; 
  result = (btAlignedObjectArray< btSoftBodyFloatData * > *)& ((arg1)->m_softBodyFloatData);
  *(btAlignedObjectArray< btSoftBodyFloatData * > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btBulletSerializedArrays_1softBodyDoubleData_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btBulletSerializedArrays *arg1 = (btBulletSerializedArrays *) 0 ;
  btAlignedObjectArray< btSoftBodyDoubleData * > *arg2 = (btAlignedObjectArray< btSoftBodyDoubleData * > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBulletSerializedArrays **)&jarg1; 
  arg2 = *(btAlignedObjectArray< btSoftBodyDoubleData * > **)&jarg2; 
  if (arg1) (arg1)->m_softBodyDoubleData = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btBulletSerializedArrays_1softBodyDoubleData_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btBulletSerializedArrays *arg1 = (btBulletSerializedArrays *) 0 ;
  btAlignedObjectArray< btSoftBodyDoubleData * > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btBulletSerializedArrays **)&jarg1; 
  result = (btAlignedObjectArray< btSoftBodyDoubleData * > *)& ((arg1)->m_softBodyDoubleData);
  *(btAlignedObjectArray< btSoftBodyDoubleData * > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_delete_1btBulletSerializedArrays(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btBulletSerializedArrays *arg1 = (btBulletSerializedArrays *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btBulletSerializedArrays **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btDefaultSerializer_1skipPointers_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDefaultSerializer *arg1 = (btDefaultSerializer *) 0 ;
  btHashMap< btHashPtr,void * > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDefaultSerializer **)&jarg1; 
  result = (btHashMap< btHashPtr,void * > *)& ((arg1)->m_skipPointers);
  *(btHashMap< btHashPtr,void * > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btDefaultSerializer_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1, jobject jarg2) {
  jlong jresult = 0 ;
  int arg1 ;
  unsigned char *arg2 = (unsigned char *) 0 ;
  btDefaultSerializer *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  {
    arg2 = (unsigned char*)jenv->GetDirectBufferAddress(jarg2);
    if (arg2 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  result = (btDefaultSerializer *)new btDefaultSerializer(arg1,arg2);
  *(btDefaultSerializer **)&jresult = result; 
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btDefaultSerializer_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  int arg1 ;
  btDefaultSerializer *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (btDefaultSerializer *)new btDefaultSerializer(arg1);
  *(btDefaultSerializer **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btDefaultSerializer_1_1SWIG_12(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btDefaultSerializer *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btDefaultSerializer *)new btDefaultSerializer();
  *(btDefaultSerializer **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_delete_1btDefaultSerializer(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btDefaultSerializer *arg1 = (btDefaultSerializer *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btDefaultSerializer **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btDefaultSerializer_1getMemoryDnaSizeInBytes(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)btDefaultSerializer::getMemoryDnaSizeInBytes();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btDefaultSerializer_1getMemoryDna(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)btDefaultSerializer::getMemoryDna();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btDefaultSerializer_1insertHeader(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btDefaultSerializer *arg1 = (btDefaultSerializer *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDefaultSerializer **)&jarg1; 
  (arg1)->insertHeader();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btDefaultSerializer_1writeHeader(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btDefaultSerializer *arg1 = (btDefaultSerializer *) 0 ;
  unsigned char *arg2 = (unsigned char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDefaultSerializer **)&jarg1; 
  {
    arg2 = (unsigned char*)jenv->GetDirectBufferAddress(jarg2);
    if (arg2 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  ((btDefaultSerializer const *)arg1)->writeHeader(arg2);
  
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btDefaultSerializer_1internalAlloc(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jobject jresult = 0 ;
  btDefaultSerializer *arg1 = (btDefaultSerializer *) 0 ;
  size_t arg2 ;
  unsigned char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDefaultSerializer **)&jarg1; 
  arg2 = (size_t)jarg2; 
  result = (unsigned char *)(arg1)->internalAlloc(arg2);
  *(unsigned char **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSpatialForceVector_1topVec_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSpatialForceVector *arg1 = (btSpatialForceVector *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSpatialForceVector **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_topVec = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSpatialForceVector_1topVec_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSpatialForceVector *arg1 = (btSpatialForceVector *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSpatialForceVector **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_topVec);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSpatialForceVector_1bottomVec_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSpatialForceVector *arg1 = (btSpatialForceVector *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSpatialForceVector **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_bottomVec = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSpatialForceVector_1bottomVec_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSpatialForceVector *arg1 = (btSpatialForceVector *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSpatialForceVector **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_bottomVec);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btSpatialForceVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSpatialForceVector *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSpatialForceVector *)new btSpatialForceVector();
  *(btSpatialForceVector **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btSpatialForceVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btSpatialForceVector *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (btSpatialForceVector *)new btSpatialForceVector((btVector3 const &)*arg1,(btVector3 const &)*arg2);
  *(btSpatialForceVector **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btSpatialForceVector_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jfloat jarg1, jfloat jarg2, jfloat jarg3, jfloat jarg4, jfloat jarg5, jfloat jarg6) {
  jlong jresult = 0 ;
  btScalar *arg1 = 0 ;
  btScalar *arg2 = 0 ;
  btScalar *arg3 = 0 ;
  btScalar *arg4 = 0 ;
  btScalar *arg5 = 0 ;
  btScalar *arg6 = 0 ;
  btScalar temp1 ;
  btScalar temp2 ;
  btScalar temp3 ;
  btScalar temp4 ;
  btScalar temp5 ;
  btScalar temp6 ;
  btSpatialForceVector *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  temp1 = (btScalar)jarg1; 
  arg1 = &temp1; 
  temp2 = (btScalar)jarg2; 
  arg2 = &temp2; 
  temp3 = (btScalar)jarg3; 
  arg3 = &temp3; 
  temp4 = (btScalar)jarg4; 
  arg4 = &temp4; 
  temp5 = (btScalar)jarg5; 
  arg5 = &temp5; 
  temp6 = (btScalar)jarg6; 
  arg6 = &temp6; 
  result = (btSpatialForceVector *)new btSpatialForceVector((btScalar const &)*arg1,(btScalar const &)*arg2,(btScalar const &)*arg3,(btScalar const &)*arg4,(btScalar const &)*arg5,(btScalar const &)*arg6);
  *(btSpatialForceVector **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSpatialForceVector_1setVector(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3) {
  btSpatialForceVector *arg1 = (btSpatialForceVector *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSpatialForceVector **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  (arg1)->setVector((btVector3 const &)*arg2,(btVector3 const &)*arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSpatialForceVector_1setValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jfloat jarg3, jfloat jarg4, jfloat jarg5, jfloat jarg6, jfloat jarg7) {
  btSpatialForceVector *arg1 = (btSpatialForceVector *) 0 ;
  btScalar *arg2 = 0 ;
  btScalar *arg3 = 0 ;
  btScalar *arg4 = 0 ;
  btScalar *arg5 = 0 ;
  btScalar *arg6 = 0 ;
  btScalar *arg7 = 0 ;
  btScalar temp2 ;
  btScalar temp3 ;
  btScalar temp4 ;
  btScalar temp5 ;
  btScalar temp6 ;
  btScalar temp7 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSpatialForceVector **)&jarg1; 
  temp2 = (btScalar)jarg2; 
  arg2 = &temp2; 
  temp3 = (btScalar)jarg3; 
  arg3 = &temp3; 
  temp4 = (btScalar)jarg4; 
  arg4 = &temp4; 
  temp5 = (btScalar)jarg5; 
  arg5 = &temp5; 
  temp6 = (btScalar)jarg6; 
  arg6 = &temp6; 
  temp7 = (btScalar)jarg7; 
  arg7 = &temp7; 
  (arg1)->setValue((btScalar const &)*arg2,(btScalar const &)*arg3,(btScalar const &)*arg4,(btScalar const &)*arg5,(btScalar const &)*arg6,(btScalar const &)*arg7);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSpatialForceVector_1addVector(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3) {
  btSpatialForceVector *arg1 = (btSpatialForceVector *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSpatialForceVector **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  (arg1)->addVector((btVector3 const &)*arg2,(btVector3 const &)*arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSpatialForceVector_1addValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jfloat jarg3, jfloat jarg4, jfloat jarg5, jfloat jarg6, jfloat jarg7) {
  btSpatialForceVector *arg1 = (btSpatialForceVector *) 0 ;
  btScalar *arg2 = 0 ;
  btScalar *arg3 = 0 ;
  btScalar *arg4 = 0 ;
  btScalar *arg5 = 0 ;
  btScalar *arg6 = 0 ;
  btScalar *arg7 = 0 ;
  btScalar temp2 ;
  btScalar temp3 ;
  btScalar temp4 ;
  btScalar temp5 ;
  btScalar temp6 ;
  btScalar temp7 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSpatialForceVector **)&jarg1; 
  temp2 = (btScalar)jarg2; 
  arg2 = &temp2; 
  temp3 = (btScalar)jarg3; 
  arg3 = &temp3; 
  temp4 = (btScalar)jarg4; 
  arg4 = &temp4; 
  temp5 = (btScalar)jarg5; 
  arg5 = &temp5; 
  temp6 = (btScalar)jarg6; 
  arg6 = &temp6; 
  temp7 = (btScalar)jarg7; 
  arg7 = &temp7; 
  (arg1)->addValue((btScalar const &)*arg2,(btScalar const &)*arg3,(btScalar const &)*arg4,(btScalar const &)*arg5,(btScalar const &)*arg6,(btScalar const &)*arg7);
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSpatialForceVector_1getLinear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btSpatialForceVector *arg1 = (btSpatialForceVector *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSpatialForceVector **)&jarg1; 
  result = (btVector3 *) &((btSpatialForceVector const *)arg1)->getLinear();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSpatialForceVector_1getAngular(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btSpatialForceVector *arg1 = (btSpatialForceVector *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSpatialForceVector **)&jarg1; 
  result = (btVector3 *) &((btSpatialForceVector const *)arg1)->getAngular();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSpatialForceVector_1setLinear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btSpatialForceVector *arg1 = (btSpatialForceVector *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSpatialForceVector **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->setLinear((btVector3 const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSpatialForceVector_1setAngular(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btSpatialForceVector *arg1 = (btSpatialForceVector *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSpatialForceVector **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->setAngular((btVector3 const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSpatialForceVector_1addAngular(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btSpatialForceVector *arg1 = (btSpatialForceVector *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSpatialForceVector **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->addAngular((btVector3 const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSpatialForceVector_1addLinear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btSpatialForceVector *arg1 = (btSpatialForceVector *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSpatialForceVector **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->addLinear((btVector3 const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSpatialForceVector_1setZero(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btSpatialForceVector *arg1 = (btSpatialForceVector *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSpatialForceVector **)&jarg1; 
  (arg1)->setZero();
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSpatialForceVector_1operatorAdditionAssignment(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  btSpatialForceVector *arg1 = (btSpatialForceVector *) 0 ;
  btSpatialForceVector *arg2 = 0 ;
  btSpatialForceVector *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSpatialForceVector **)&jarg1; 
  arg2 = *(btSpatialForceVector **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btSpatialForceVector const & reference is null");
    return 0;
  } 
  result = (btSpatialForceVector *) &(arg1)->operator +=((btSpatialForceVector const &)*arg2);
  *(btSpatialForceVector **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSpatialForceVector_1operatorSubtractionAssignment(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  btSpatialForceVector *arg1 = (btSpatialForceVector *) 0 ;
  btSpatialForceVector *arg2 = 0 ;
  btSpatialForceVector *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSpatialForceVector **)&jarg1; 
  arg2 = *(btSpatialForceVector **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btSpatialForceVector const & reference is null");
    return 0;
  } 
  result = (btSpatialForceVector *) &(arg1)->operator -=((btSpatialForceVector const &)*arg2);
  *(btSpatialForceVector **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSpatialForceVector_1operatorSubtraction_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  btSpatialForceVector *arg1 = (btSpatialForceVector *) 0 ;
  btSpatialForceVector *arg2 = 0 ;
  btSpatialForceVector result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSpatialForceVector **)&jarg1; 
  arg2 = *(btSpatialForceVector **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btSpatialForceVector const & reference is null");
    return 0;
  } 
  result = ((btSpatialForceVector const *)arg1)->operator -((btSpatialForceVector const &)*arg2);
  *(btSpatialForceVector **)&jresult = new btSpatialForceVector((const btSpatialForceVector &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSpatialForceVector_1operatorAddition(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  btSpatialForceVector *arg1 = (btSpatialForceVector *) 0 ;
  btSpatialForceVector *arg2 = 0 ;
  btSpatialForceVector result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSpatialForceVector **)&jarg1; 
  arg2 = *(btSpatialForceVector **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btSpatialForceVector const & reference is null");
    return 0;
  } 
  result = ((btSpatialForceVector const *)arg1)->operator +((btSpatialForceVector const &)*arg2);
  *(btSpatialForceVector **)&jresult = new btSpatialForceVector((const btSpatialForceVector &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSpatialForceVector_1operatorSubtraction_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSpatialForceVector *arg1 = (btSpatialForceVector *) 0 ;
  btSpatialForceVector result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSpatialForceVector **)&jarg1; 
  result = ((btSpatialForceVector const *)arg1)->operator -();
  *(btSpatialForceVector **)&jresult = new btSpatialForceVector((const btSpatialForceVector &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSpatialForceVector_1operatorMultiplication(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  jlong jresult = 0 ;
  btSpatialForceVector *arg1 = (btSpatialForceVector *) 0 ;
  btScalar *arg2 = 0 ;
  btScalar temp2 ;
  btSpatialForceVector result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSpatialForceVector **)&jarg1; 
  temp2 = (btScalar)jarg2; 
  arg2 = &temp2; 
  result = ((btSpatialForceVector const *)arg1)->operator *((btScalar const &)*arg2);
  *(btSpatialForceVector **)&jresult = new btSpatialForceVector((const btSpatialForceVector &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_delete_1btSpatialForceVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSpatialForceVector *arg1 = (btSpatialForceVector *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSpatialForceVector **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSpatialMotionVector_1topVec_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSpatialMotionVector *arg1 = (btSpatialMotionVector *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSpatialMotionVector **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_topVec = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSpatialMotionVector_1topVec_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSpatialMotionVector *arg1 = (btSpatialMotionVector *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSpatialMotionVector **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_topVec);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSpatialMotionVector_1bottomVec_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSpatialMotionVector *arg1 = (btSpatialMotionVector *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSpatialMotionVector **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_bottomVec = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSpatialMotionVector_1bottomVec_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSpatialMotionVector *arg1 = (btSpatialMotionVector *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSpatialMotionVector **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_bottomVec);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btSpatialMotionVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSpatialMotionVector *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSpatialMotionVector *)new btSpatialMotionVector();
  *(btSpatialMotionVector **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btSpatialMotionVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btSpatialMotionVector *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (btSpatialMotionVector *)new btSpatialMotionVector((btVector3 const &)*arg1,(btVector3 const &)*arg2);
  *(btSpatialMotionVector **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSpatialMotionVector_1setVector(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3) {
  btSpatialMotionVector *arg1 = (btSpatialMotionVector *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSpatialMotionVector **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  (arg1)->setVector((btVector3 const &)*arg2,(btVector3 const &)*arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSpatialMotionVector_1setValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jfloat jarg3, jfloat jarg4, jfloat jarg5, jfloat jarg6, jfloat jarg7) {
  btSpatialMotionVector *arg1 = (btSpatialMotionVector *) 0 ;
  btScalar *arg2 = 0 ;
  btScalar *arg3 = 0 ;
  btScalar *arg4 = 0 ;
  btScalar *arg5 = 0 ;
  btScalar *arg6 = 0 ;
  btScalar *arg7 = 0 ;
  btScalar temp2 ;
  btScalar temp3 ;
  btScalar temp4 ;
  btScalar temp5 ;
  btScalar temp6 ;
  btScalar temp7 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSpatialMotionVector **)&jarg1; 
  temp2 = (btScalar)jarg2; 
  arg2 = &temp2; 
  temp3 = (btScalar)jarg3; 
  arg3 = &temp3; 
  temp4 = (btScalar)jarg4; 
  arg4 = &temp4; 
  temp5 = (btScalar)jarg5; 
  arg5 = &temp5; 
  temp6 = (btScalar)jarg6; 
  arg6 = &temp6; 
  temp7 = (btScalar)jarg7; 
  arg7 = &temp7; 
  (arg1)->setValue((btScalar const &)*arg2,(btScalar const &)*arg3,(btScalar const &)*arg4,(btScalar const &)*arg5,(btScalar const &)*arg6,(btScalar const &)*arg7);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSpatialMotionVector_1addVector(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3) {
  btSpatialMotionVector *arg1 = (btSpatialMotionVector *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSpatialMotionVector **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  (arg1)->addVector((btVector3 const &)*arg2,(btVector3 const &)*arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSpatialMotionVector_1addValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jfloat jarg3, jfloat jarg4, jfloat jarg5, jfloat jarg6, jfloat jarg7) {
  btSpatialMotionVector *arg1 = (btSpatialMotionVector *) 0 ;
  btScalar *arg2 = 0 ;
  btScalar *arg3 = 0 ;
  btScalar *arg4 = 0 ;
  btScalar *arg5 = 0 ;
  btScalar *arg6 = 0 ;
  btScalar *arg7 = 0 ;
  btScalar temp2 ;
  btScalar temp3 ;
  btScalar temp4 ;
  btScalar temp5 ;
  btScalar temp6 ;
  btScalar temp7 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSpatialMotionVector **)&jarg1; 
  temp2 = (btScalar)jarg2; 
  arg2 = &temp2; 
  temp3 = (btScalar)jarg3; 
  arg3 = &temp3; 
  temp4 = (btScalar)jarg4; 
  arg4 = &temp4; 
  temp5 = (btScalar)jarg5; 
  arg5 = &temp5; 
  temp6 = (btScalar)jarg6; 
  arg6 = &temp6; 
  temp7 = (btScalar)jarg7; 
  arg7 = &temp7; 
  (arg1)->addValue((btScalar const &)*arg2,(btScalar const &)*arg3,(btScalar const &)*arg4,(btScalar const &)*arg5,(btScalar const &)*arg6,(btScalar const &)*arg7);
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSpatialMotionVector_1getAngular(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btSpatialMotionVector *arg1 = (btSpatialMotionVector *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSpatialMotionVector **)&jarg1; 
  result = (btVector3 *) &((btSpatialMotionVector const *)arg1)->getAngular();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSpatialMotionVector_1getLinear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btSpatialMotionVector *arg1 = (btSpatialMotionVector *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSpatialMotionVector **)&jarg1; 
  result = (btVector3 *) &((btSpatialMotionVector const *)arg1)->getLinear();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSpatialMotionVector_1setAngular(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btSpatialMotionVector *arg1 = (btSpatialMotionVector *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSpatialMotionVector **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->setAngular((btVector3 const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSpatialMotionVector_1setLinear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btSpatialMotionVector *arg1 = (btSpatialMotionVector *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSpatialMotionVector **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->setLinear((btVector3 const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSpatialMotionVector_1addAngular(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btSpatialMotionVector *arg1 = (btSpatialMotionVector *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSpatialMotionVector **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->addAngular((btVector3 const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSpatialMotionVector_1addLinear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btSpatialMotionVector *arg1 = (btSpatialMotionVector *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSpatialMotionVector **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->addLinear((btVector3 const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSpatialMotionVector_1setZero(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btSpatialMotionVector *arg1 = (btSpatialMotionVector *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSpatialMotionVector **)&jarg1; 
  (arg1)->setZero();
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSpatialMotionVector_1dot(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jfloat jresult = 0 ;
  btSpatialMotionVector *arg1 = (btSpatialMotionVector *) 0 ;
  btSpatialForceVector *arg2 = 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSpatialMotionVector **)&jarg1; 
  arg2 = *(btSpatialForceVector **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btSpatialForceVector const & reference is null");
    return 0;
  } 
  result = (btScalar)((btSpatialMotionVector const *)arg1)->dot((btSpatialForceVector const &)*arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSpatialMotionVector_1operatorAdditionAssignment(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  btSpatialMotionVector *arg1 = (btSpatialMotionVector *) 0 ;
  btSpatialMotionVector *arg2 = 0 ;
  btSpatialMotionVector *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSpatialMotionVector **)&jarg1; 
  arg2 = *(btSpatialMotionVector **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btSpatialMotionVector const & reference is null");
    return 0;
  } 
  result = (btSpatialMotionVector *) &(arg1)->operator +=((btSpatialMotionVector const &)*arg2);
  *(btSpatialMotionVector **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSpatialMotionVector_1operatorSubtractionAssignment(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  btSpatialMotionVector *arg1 = (btSpatialMotionVector *) 0 ;
  btSpatialMotionVector *arg2 = 0 ;
  btSpatialMotionVector *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSpatialMotionVector **)&jarg1; 
  arg2 = *(btSpatialMotionVector **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btSpatialMotionVector const & reference is null");
    return 0;
  } 
  result = (btSpatialMotionVector *) &(arg1)->operator -=((btSpatialMotionVector const &)*arg2);
  *(btSpatialMotionVector **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSpatialMotionVector_1operatorMultiplicationAssignment(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  jlong jresult = 0 ;
  btSpatialMotionVector *arg1 = (btSpatialMotionVector *) 0 ;
  btScalar *arg2 = 0 ;
  btScalar temp2 ;
  btSpatialMotionVector *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSpatialMotionVector **)&jarg1; 
  temp2 = (btScalar)jarg2; 
  arg2 = &temp2; 
  result = (btSpatialMotionVector *) &(arg1)->operator *=((btScalar const &)*arg2);
  *(btSpatialMotionVector **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSpatialMotionVector_1operatorSubtraction_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  btSpatialMotionVector *arg1 = (btSpatialMotionVector *) 0 ;
  btSpatialMotionVector *arg2 = 0 ;
  btSpatialMotionVector result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSpatialMotionVector **)&jarg1; 
  arg2 = *(btSpatialMotionVector **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btSpatialMotionVector const & reference is null");
    return 0;
  } 
  result = ((btSpatialMotionVector const *)arg1)->operator -((btSpatialMotionVector const &)*arg2);
  *(btSpatialMotionVector **)&jresult = new btSpatialMotionVector((const btSpatialMotionVector &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSpatialMotionVector_1operatorAddition(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  btSpatialMotionVector *arg1 = (btSpatialMotionVector *) 0 ;
  btSpatialMotionVector *arg2 = 0 ;
  btSpatialMotionVector result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSpatialMotionVector **)&jarg1; 
  arg2 = *(btSpatialMotionVector **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btSpatialMotionVector const & reference is null");
    return 0;
  } 
  result = ((btSpatialMotionVector const *)arg1)->operator +((btSpatialMotionVector const &)*arg2);
  *(btSpatialMotionVector **)&jresult = new btSpatialMotionVector((const btSpatialMotionVector &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSpatialMotionVector_1operatorSubtraction_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSpatialMotionVector *arg1 = (btSpatialMotionVector *) 0 ;
  btSpatialMotionVector result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSpatialMotionVector **)&jarg1; 
  result = ((btSpatialMotionVector const *)arg1)->operator -();
  *(btSpatialMotionVector **)&jresult = new btSpatialMotionVector((const btSpatialMotionVector &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSpatialMotionVector_1operatorMultiplication(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  jlong jresult = 0 ;
  btSpatialMotionVector *arg1 = (btSpatialMotionVector *) 0 ;
  btScalar *arg2 = 0 ;
  btScalar temp2 ;
  btSpatialMotionVector result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSpatialMotionVector **)&jarg1; 
  temp2 = (btScalar)jarg2; 
  arg2 = &temp2; 
  result = ((btSpatialMotionVector const *)arg1)->operator *((btScalar const &)*arg2);
  *(btSpatialMotionVector **)&jresult = new btSpatialMotionVector((const btSpatialMotionVector &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_delete_1btSpatialMotionVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSpatialMotionVector *arg1 = (btSpatialMotionVector *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSpatialMotionVector **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSymmetricSpatialDyad_1topLeftMat_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSymmetricSpatialDyad *arg1 = (btSymmetricSpatialDyad *) 0 ;
  btMatrix3x3 *arg2 = (btMatrix3x3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSymmetricSpatialDyad **)&jarg1; 
  arg2 = *(btMatrix3x3 **)&jarg2; 
  if (arg1) (arg1)->m_topLeftMat = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSymmetricSpatialDyad_1topLeftMat_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSymmetricSpatialDyad *arg1 = (btSymmetricSpatialDyad *) 0 ;
  btMatrix3x3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSymmetricSpatialDyad **)&jarg1; 
  result = (btMatrix3x3 *)& ((arg1)->m_topLeftMat);
  *(btMatrix3x3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSymmetricSpatialDyad_1topRightMat_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSymmetricSpatialDyad *arg1 = (btSymmetricSpatialDyad *) 0 ;
  btMatrix3x3 *arg2 = (btMatrix3x3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSymmetricSpatialDyad **)&jarg1; 
  arg2 = *(btMatrix3x3 **)&jarg2; 
  if (arg1) (arg1)->m_topRightMat = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSymmetricSpatialDyad_1topRightMat_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSymmetricSpatialDyad *arg1 = (btSymmetricSpatialDyad *) 0 ;
  btMatrix3x3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSymmetricSpatialDyad **)&jarg1; 
  result = (btMatrix3x3 *)& ((arg1)->m_topRightMat);
  *(btMatrix3x3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSymmetricSpatialDyad_1bottomLeftMat_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSymmetricSpatialDyad *arg1 = (btSymmetricSpatialDyad *) 0 ;
  btMatrix3x3 *arg2 = (btMatrix3x3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSymmetricSpatialDyad **)&jarg1; 
  arg2 = *(btMatrix3x3 **)&jarg2; 
  if (arg1) (arg1)->m_bottomLeftMat = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSymmetricSpatialDyad_1bottomLeftMat_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSymmetricSpatialDyad *arg1 = (btSymmetricSpatialDyad *) 0 ;
  btMatrix3x3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSymmetricSpatialDyad **)&jarg1; 
  result = (btMatrix3x3 *)& ((arg1)->m_bottomLeftMat);
  *(btMatrix3x3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btSymmetricSpatialDyad_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSymmetricSpatialDyad *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSymmetricSpatialDyad *)new btSymmetricSpatialDyad();
  *(btSymmetricSpatialDyad **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btSymmetricSpatialDyad_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jobject jarg3) {
  jlong jresult = 0 ;
  btMatrix3x3 *arg1 = 0 ;
  btMatrix3x3 *arg2 = 0 ;
  btMatrix3x3 *arg3 = 0 ;
  btSymmetricSpatialDyad *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btMatrix3x3 local_arg1;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitMatrix3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btMatrix3x3 local_arg2;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btMatrix3x3 local_arg3;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitMatrix3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  result = (btSymmetricSpatialDyad *)new btSymmetricSpatialDyad((btMatrix3x3 const &)*arg1,(btMatrix3x3 const &)*arg2,(btMatrix3x3 const &)*arg3);
  *(btSymmetricSpatialDyad **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSymmetricSpatialDyad_1setMatrix(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jobject jarg4) {
  btSymmetricSpatialDyad *arg1 = (btSymmetricSpatialDyad *) 0 ;
  btMatrix3x3 *arg2 = 0 ;
  btMatrix3x3 *arg3 = 0 ;
  btMatrix3x3 *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSymmetricSpatialDyad **)&jarg1; 
  btMatrix3x3 local_arg2;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btMatrix3x3 local_arg3;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitMatrix3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btMatrix3x3 local_arg4;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitMatrix3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  (arg1)->setMatrix((btMatrix3x3 const &)*arg2,(btMatrix3x3 const &)*arg3,(btMatrix3x3 const &)*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSymmetricSpatialDyad_1addMatrix(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jobject jarg4) {
  btSymmetricSpatialDyad *arg1 = (btSymmetricSpatialDyad *) 0 ;
  btMatrix3x3 *arg2 = 0 ;
  btMatrix3x3 *arg3 = 0 ;
  btMatrix3x3 *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSymmetricSpatialDyad **)&jarg1; 
  btMatrix3x3 local_arg2;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btMatrix3x3 local_arg3;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitMatrix3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btMatrix3x3 local_arg4;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitMatrix3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  (arg1)->addMatrix((btMatrix3x3 const &)*arg2,(btMatrix3x3 const &)*arg3,(btMatrix3x3 const &)*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSymmetricSpatialDyad_1setIdentity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btSymmetricSpatialDyad *arg1 = (btSymmetricSpatialDyad *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSymmetricSpatialDyad **)&jarg1; 
  (arg1)->setIdentity();
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSymmetricSpatialDyad_1operatorSubtractionAssignment(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  btSymmetricSpatialDyad *arg1 = (btSymmetricSpatialDyad *) 0 ;
  btSymmetricSpatialDyad *arg2 = 0 ;
  btSymmetricSpatialDyad *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSymmetricSpatialDyad **)&jarg1; 
  arg2 = *(btSymmetricSpatialDyad **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btSymmetricSpatialDyad const & reference is null");
    return 0;
  } 
  result = (btSymmetricSpatialDyad *) &(arg1)->operator -=((btSymmetricSpatialDyad const &)*arg2);
  *(btSymmetricSpatialDyad **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSymmetricSpatialDyad_1operatorMultiplication(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  btSymmetricSpatialDyad *arg1 = (btSymmetricSpatialDyad *) 0 ;
  btSpatialMotionVector *arg2 = 0 ;
  btSpatialForceVector result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSymmetricSpatialDyad **)&jarg1; 
  arg2 = *(btSpatialMotionVector **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btSpatialMotionVector const & reference is null");
    return 0;
  } 
  result = (arg1)->operator *((btSpatialMotionVector const &)*arg2);
  *(btSpatialForceVector **)&jresult = new btSpatialForceVector((const btSpatialForceVector &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_delete_1btSymmetricSpatialDyad(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSymmetricSpatialDyad *arg1 = (btSymmetricSpatialDyad *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSymmetricSpatialDyad **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSpatialTransformationMatrix_1rotMat_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSpatialTransformationMatrix *arg1 = (btSpatialTransformationMatrix *) 0 ;
  btMatrix3x3 *arg2 = (btMatrix3x3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSpatialTransformationMatrix **)&jarg1; 
  arg2 = *(btMatrix3x3 **)&jarg2; 
  if (arg1) (arg1)->m_rotMat = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSpatialTransformationMatrix_1rotMat_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSpatialTransformationMatrix *arg1 = (btSpatialTransformationMatrix *) 0 ;
  btMatrix3x3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSpatialTransformationMatrix **)&jarg1; 
  result = (btMatrix3x3 *)& ((arg1)->m_rotMat);
  *(btMatrix3x3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSpatialTransformationMatrix_1trnVec_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSpatialTransformationMatrix *arg1 = (btSpatialTransformationMatrix *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSpatialTransformationMatrix **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_trnVec = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSpatialTransformationMatrix_1trnVec_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSpatialTransformationMatrix *arg1 = (btSpatialTransformationMatrix *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSpatialTransformationMatrix **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_trnVec);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSpatialTransformationMatrix_1transformInverse_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jint jarg4) {
  btSpatialTransformationMatrix *arg1 = (btSpatialTransformationMatrix *) 0 ;
  btSymmetricSpatialDyad *arg2 = 0 ;
  btSymmetricSpatialDyad *arg3 = 0 ;
  btSpatialTransformationMatrix::eOutputOperation arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btSpatialTransformationMatrix **)&jarg1; 
  arg2 = *(btSymmetricSpatialDyad **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btSymmetricSpatialDyad const & reference is null");
    return ;
  } 
  arg3 = *(btSymmetricSpatialDyad **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btSymmetricSpatialDyad & reference is null");
    return ;
  } 
  arg4 = (btSpatialTransformationMatrix::eOutputOperation)jarg4; 
  (arg1)->transformInverse((btSymmetricSpatialDyad const &)*arg2,*arg3,arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSpatialTransformationMatrix_1transformInverse_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  btSpatialTransformationMatrix *arg1 = (btSpatialTransformationMatrix *) 0 ;
  btSymmetricSpatialDyad *arg2 = 0 ;
  btSymmetricSpatialDyad *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btSpatialTransformationMatrix **)&jarg1; 
  arg2 = *(btSymmetricSpatialDyad **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btSymmetricSpatialDyad const & reference is null");
    return ;
  } 
  arg3 = *(btSymmetricSpatialDyad **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btSymmetricSpatialDyad & reference is null");
    return ;
  } 
  (arg1)->transformInverse((btSymmetricSpatialDyad const &)*arg2,*arg3);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btSpatialTransformationMatrix(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSpatialTransformationMatrix *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSpatialTransformationMatrix *)new btSpatialTransformationMatrix();
  *(btSpatialTransformationMatrix **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_delete_1btSpatialTransformationMatrix(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSpatialTransformationMatrix *arg1 = (btSpatialTransformationMatrix *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSpatialTransformationMatrix **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_BT_1MAX_1THREAD_1COUNT_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  result = (unsigned int)(unsigned int)BT_MAX_THREAD_COUNT;
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIsMainThread(JNIEnv *jenv, jclass jcls) {
  jboolean jresult = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  result = (bool)btIsMainThread();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btThreadsAreRunning(JNIEnv *jenv, jclass jcls) {
  jboolean jresult = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  result = (bool)btThreadsAreRunning();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btGetCurrentThreadIndex(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  result = (unsigned int)btGetCurrentThreadIndex();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btResetThreadIndexCounter(JNIEnv *jenv, jclass jcls) {
  (void)jenv;
  (void)jcls;
  btResetThreadIndexCounter();
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btSpinMutex(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSpinMutex *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSpinMutex *)new btSpinMutex();
  *(btSpinMutex **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSpinMutex_1lock(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btSpinMutex *arg1 = (btSpinMutex *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSpinMutex **)&jarg1; 
  (arg1)->lock();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSpinMutex_1unlock(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btSpinMutex *arg1 = (btSpinMutex *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSpinMutex **)&jarg1; 
  (arg1)->unlock();
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSpinMutex_1tryLock(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btSpinMutex *arg1 = (btSpinMutex *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSpinMutex **)&jarg1; 
  result = (bool)(arg1)->tryLock();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_delete_1btSpinMutex(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSpinMutex *arg1 = (btSpinMutex *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSpinMutex **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btMutexLock(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btSpinMutex *arg1 = (btSpinMutex *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSpinMutex **)&jarg1; 
  btMutexLock(arg1);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btMutexUnlock(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btSpinMutex *arg1 = (btSpinMutex *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSpinMutex **)&jarg1; 
  btMutexUnlock(arg1);
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btMutexTryLock(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btSpinMutex *arg1 = (btSpinMutex *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSpinMutex **)&jarg1; 
  result = (bool)btMutexTryLock(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_delete_1btIParallelForBody(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btIParallelForBody *arg1 = (btIParallelForBody *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btIParallelForBody **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btIParallelForBody_1forLoop(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  btIParallelForBody *arg1 = (btIParallelForBody *) 0 ;
  int arg2 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btIParallelForBody **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  ((btIParallelForBody const *)arg1)->forLoop(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_delete_1btITaskScheduler(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btITaskScheduler *arg1 = (btITaskScheduler *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btITaskScheduler **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btITaskScheduler_1getName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btITaskScheduler *arg1 = (btITaskScheduler *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btITaskScheduler **)&jarg1; 
  result = (char *)((btITaskScheduler const *)arg1)->getName();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btITaskScheduler_1getMaxNumThreads(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btITaskScheduler *arg1 = (btITaskScheduler *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btITaskScheduler **)&jarg1; 
  result = (int)((btITaskScheduler const *)arg1)->getMaxNumThreads();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btITaskScheduler_1getNumThreads(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btITaskScheduler *arg1 = (btITaskScheduler *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btITaskScheduler **)&jarg1; 
  result = (int)((btITaskScheduler const *)arg1)->getNumThreads();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btITaskScheduler_1setNumThreads(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btITaskScheduler *arg1 = (btITaskScheduler *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btITaskScheduler **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->setNumThreads(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btITaskScheduler_1parallelFor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3, jint jarg4, jlong jarg5, jobject jarg5_) {
  btITaskScheduler *arg1 = (btITaskScheduler *) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  btIParallelForBody *arg5 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg5_;
  arg1 = *(btITaskScheduler **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = *(btIParallelForBody **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btIParallelForBody const & reference is null");
    return ;
  } 
  (arg1)->parallelFor(arg2,arg3,arg4,(btIParallelForBody const &)*arg5);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btITaskScheduler_1activate(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btITaskScheduler *arg1 = (btITaskScheduler *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btITaskScheduler **)&jarg1; 
  (arg1)->activate();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btITaskScheduler_1deactivate(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btITaskScheduler *arg1 = (btITaskScheduler *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btITaskScheduler **)&jarg1; 
  (arg1)->deactivate();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btSetTaskScheduler(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btITaskScheduler *arg1 = (btITaskScheduler *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btITaskScheduler **)&jarg1; 
  btSetTaskScheduler(arg1);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btGetTaskScheduler(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btITaskScheduler *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btITaskScheduler *)btGetTaskScheduler();
  *(btITaskScheduler **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btGetSequentialTaskScheduler(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btITaskScheduler *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btITaskScheduler *)btGetSequentialTaskScheduler();
  *(btITaskScheduler **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btGetOpenMPTaskScheduler(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btITaskScheduler *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btITaskScheduler *)btGetOpenMPTaskScheduler();
  *(btITaskScheduler **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btGetTBBTaskScheduler(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btITaskScheduler *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btITaskScheduler *)btGetTBBTaskScheduler();
  *(btITaskScheduler **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btGetPPLTaskScheduler(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btITaskScheduler *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btITaskScheduler *)btGetPPLTaskScheduler();
  *(btITaskScheduler **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btParallelFor(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jint jarg3, jlong jarg4, jobject jarg4_) {
  int arg1 ;
  int arg2 ;
  int arg3 ;
  btIParallelForBody *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg4_;
  arg1 = (int)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = *(btIParallelForBody **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btIParallelForBody const & reference is null");
    return ;
  } 
  btParallelFor(arg1,arg2,arg3,(btIParallelForBody const &)*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_delete_1btMotionState(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btMotionState *arg1 = (btMotionState *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btMotionState **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btMotionState_1getWorldTransform(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btMotionState *arg1 = (btMotionState *) 0 ;
  btTransform *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMotionState **)&jarg1; 
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  ((btMotionState const *)arg1)->getWorldTransform(*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btMotionState_1setWorldTransform(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btMotionState *arg1 = (btMotionState *) 0 ;
  btTransform *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btMotionState **)&jarg1; 
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->setWorldTransform((btTransform const &)*arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btMotionState(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btMotionState *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btMotionState *)new SwigDirector_btMotionState(jenv);
  *(btMotionState **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btMotionState_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  btMotionState *obj = *((btMotionState **)&objarg);
  (void)jcls;
  SwigDirector_btMotionState *director = (SwigDirector_btMotionState *)(obj);
  if (director) {
    director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
  }
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btMotionState_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  btMotionState *obj = *((btMotionState **)&objarg);
  SwigDirector_btMotionState *director = (SwigDirector_btMotionState *)(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btDefaultMotionState_1graphicsWorldTrans_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btDefaultMotionState *arg1 = (btDefaultMotionState *) 0 ;
  btTransform *arg2 = (btTransform *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDefaultMotionState **)&jarg1; 
  arg2 = *(btTransform **)&jarg2; 
  if (arg1) (arg1)->m_graphicsWorldTrans = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btDefaultMotionState_1graphicsWorldTrans_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDefaultMotionState *arg1 = (btDefaultMotionState *) 0 ;
  btTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDefaultMotionState **)&jarg1; 
  result = (btTransform *)& ((arg1)->m_graphicsWorldTrans);
  *(btTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btDefaultMotionState_1centerOfMassOffset_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btDefaultMotionState *arg1 = (btDefaultMotionState *) 0 ;
  btTransform *arg2 = (btTransform *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDefaultMotionState **)&jarg1; 
  arg2 = *(btTransform **)&jarg2; 
  if (arg1) (arg1)->m_centerOfMassOffset = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btDefaultMotionState_1centerOfMassOffset_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDefaultMotionState *arg1 = (btDefaultMotionState *) 0 ;
  btTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDefaultMotionState **)&jarg1; 
  result = (btTransform *)& ((arg1)->m_centerOfMassOffset);
  *(btTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btDefaultMotionState_1startWorldTrans_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btDefaultMotionState *arg1 = (btDefaultMotionState *) 0 ;
  btTransform *arg2 = (btTransform *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDefaultMotionState **)&jarg1; 
  arg2 = *(btTransform **)&jarg2; 
  if (arg1) (arg1)->m_startWorldTrans = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btDefaultMotionState_1startWorldTrans_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDefaultMotionState *arg1 = (btDefaultMotionState *) 0 ;
  btTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDefaultMotionState **)&jarg1; 
  result = (btTransform *)& ((arg1)->m_startWorldTrans);
  *(btTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btDefaultMotionState_1userPointer_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btDefaultMotionState *arg1 = (btDefaultMotionState *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDefaultMotionState **)&jarg1; 
  arg2 = (void *)jarg2; 
  if (arg1) (arg1)->m_userPointer = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btDefaultMotionState_1userPointer_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDefaultMotionState *arg1 = (btDefaultMotionState *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDefaultMotionState **)&jarg1; 
  result = (void *) ((arg1)->m_userPointer);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btDefaultMotionState_1operatorNew_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  btDefaultMotionState *arg1 = (btDefaultMotionState *) 0 ;
  size_t arg2 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDefaultMotionState **)&jarg1; 
  arg2 = (size_t)jarg2; 
  result = (void *)(arg1)->operator new(arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btDefaultMotionState_1operatorDelete_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btDefaultMotionState *arg1 = (btDefaultMotionState *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDefaultMotionState **)&jarg1; 
  arg2 = (void *)jarg2; 
  (arg1)->operator delete(arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btDefaultMotionState_1operatorNew_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  btDefaultMotionState *arg1 = (btDefaultMotionState *) 0 ;
  size_t arg2 ;
  void *arg3 = (void *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDefaultMotionState **)&jarg1; 
  arg2 = (size_t)jarg2; 
  arg3 = (void *)jarg3; 
  result = (void *)(arg1)->operator new(arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btDefaultMotionState_1operatorDelete_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  btDefaultMotionState *arg1 = (btDefaultMotionState *) 0 ;
  void *arg2 = (void *) 0 ;
  void *arg3 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDefaultMotionState **)&jarg1; 
  arg2 = (void *)jarg2; 
  arg3 = (void *)jarg3; 
  (arg1)->operator delete(arg2,arg3);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btDefaultMotionState_1operatorNewArray_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  btDefaultMotionState *arg1 = (btDefaultMotionState *) 0 ;
  size_t arg2 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDefaultMotionState **)&jarg1; 
  arg2 = (size_t)jarg2; 
  result = (void *)(arg1)->operator new[](arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btDefaultMotionState_1operatorDeleteArray_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btDefaultMotionState *arg1 = (btDefaultMotionState *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDefaultMotionState **)&jarg1; 
  arg2 = (void *)jarg2; 
  (arg1)->operator delete[](arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btDefaultMotionState_1operatorNewArray_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  btDefaultMotionState *arg1 = (btDefaultMotionState *) 0 ;
  size_t arg2 ;
  void *arg3 = (void *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDefaultMotionState **)&jarg1; 
  arg2 = (size_t)jarg2; 
  arg3 = (void *)jarg3; 
  result = (void *)(arg1)->operator new[](arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btDefaultMotionState_1operatorDeleteArray_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  btDefaultMotionState *arg1 = (btDefaultMotionState *) 0 ;
  void *arg2 = (void *) 0 ;
  void *arg3 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDefaultMotionState **)&jarg1; 
  arg2 = (void *)jarg2; 
  arg3 = (void *)jarg3; 
  (arg1)->operator delete[](arg2,arg3);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btDefaultMotionState_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2) {
  jlong jresult = 0 ;
  btTransform *arg1 = 0 ;
  btTransform *arg2 = 0 ;
  btDefaultMotionState *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btTransform local_arg1;
  gdx_setbtTransformFromMatrix4(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitMatrix4 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (btDefaultMotionState *)new btDefaultMotionState((btTransform const &)*arg1,(btTransform const &)*arg2);
  *(btDefaultMotionState **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btDefaultMotionState_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jobject jarg1) {
  jlong jresult = 0 ;
  btTransform *arg1 = 0 ;
  btDefaultMotionState *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btTransform local_arg1;
  gdx_setbtTransformFromMatrix4(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitMatrix4 auto_commit_arg1(jenv, jarg1, &local_arg1);
  result = (btDefaultMotionState *)new btDefaultMotionState((btTransform const &)*arg1);
  *(btDefaultMotionState **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btDefaultMotionState_1_1SWIG_12(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btDefaultMotionState *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btDefaultMotionState *)new btDefaultMotionState();
  *(btDefaultMotionState **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btDefaultMotionState_1getGraphicsWorldTrans(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btDefaultMotionState *arg1 = (btDefaultMotionState *) 0 ;
  btTransform *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDefaultMotionState **)&jarg1; 
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btDefaultMotionState_getGraphicsWorldTrans(arg1,*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btDefaultMotionState_1getCenterOfMassOffset(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btDefaultMotionState *arg1 = (btDefaultMotionState *) 0 ;
  btTransform *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDefaultMotionState **)&jarg1; 
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btDefaultMotionState_getCenterOfMassOffset(arg1,*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btDefaultMotionState_1getStartWorldTrans(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btDefaultMotionState *arg1 = (btDefaultMotionState *) 0 ;
  btTransform *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDefaultMotionState **)&jarg1; 
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btDefaultMotionState_getStartWorldTrans(arg1,*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_delete_1btDefaultMotionState(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btDefaultMotionState *arg1 = (btDefaultMotionState *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btDefaultMotionState **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3Array_1operatorAssignment(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  btAlignedObjectArray< btVector3 > *arg1 = (btAlignedObjectArray< btVector3 > *) 0 ;
  btAlignedObjectArray< btVector3 > *arg2 = 0 ;
  btAlignedObjectArray< btVector3 > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btAlignedObjectArray< btVector3 > **)&jarg1; 
  arg2 = *(btAlignedObjectArray< btVector3 > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btAlignedObjectArray< btVector3 > const & reference is null");
    return 0;
  } 
  result = (btAlignedObjectArray< btVector3 > *) &(arg1)->operator =((btAlignedObjectArray< btVector3 > const &)*arg2);
  *(btAlignedObjectArray< btVector3 > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btVector3Array_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btAlignedObjectArray< btVector3 > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btAlignedObjectArray< btVector3 > *)new btAlignedObjectArray< btVector3 >();
  *(btAlignedObjectArray< btVector3 > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_delete_1btVector3Array(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btAlignedObjectArray< btVector3 > *arg1 = (btAlignedObjectArray< btVector3 > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btAlignedObjectArray< btVector3 > **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btVector3Array_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btAlignedObjectArray< btVector3 > *arg1 = 0 ;
  btAlignedObjectArray< btVector3 > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< btVector3 > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btAlignedObjectArray< btVector3 > const & reference is null");
    return 0;
  } 
  result = (btAlignedObjectArray< btVector3 > *)new btAlignedObjectArray< btVector3 >((btAlignedObjectArray< btVector3 > const &)*arg1);
  *(btAlignedObjectArray< btVector3 > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3Array_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btAlignedObjectArray< btVector3 > *arg1 = (btAlignedObjectArray< btVector3 > *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< btVector3 > **)&jarg1; 
  result = (int)((btAlignedObjectArray< btVector3 > const *)arg1)->size();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3Array_1atConst(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jobject jresult = 0 ;
  btAlignedObjectArray< btVector3 > *arg1 = (btAlignedObjectArray< btVector3 > *) 0 ;
  int arg2 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< btVector3 > **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (btVector3 *) &((btAlignedObjectArray< btVector3 > const *)arg1)->at(arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3Array_1at(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jobject jresult = 0 ;
  btAlignedObjectArray< btVector3 > *arg1 = (btAlignedObjectArray< btVector3 > *) 0 ;
  int arg2 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< btVector3 > **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (btVector3 *) &(arg1)->at(arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3Array_1operatorSubscriptConst(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jobject jresult = 0 ;
  btAlignedObjectArray< btVector3 > *arg1 = (btAlignedObjectArray< btVector3 > *) 0 ;
  int arg2 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< btVector3 > **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (btVector3 *) &((btAlignedObjectArray< btVector3 > const *)arg1)->operator [](arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3Array_1operatorSubscript(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jobject jresult = 0 ;
  btAlignedObjectArray< btVector3 > *arg1 = (btAlignedObjectArray< btVector3 > *) 0 ;
  int arg2 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< btVector3 > **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (btVector3 *) &(arg1)->operator [](arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3Array_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btAlignedObjectArray< btVector3 > *arg1 = (btAlignedObjectArray< btVector3 > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< btVector3 > **)&jarg1; 
  (arg1)->clear();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3Array_1pop_1back(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btAlignedObjectArray< btVector3 > *arg1 = (btAlignedObjectArray< btVector3 > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< btVector3 > **)&jarg1; 
  (arg1)->pop_back();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3Array_1resizeNoInitialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btAlignedObjectArray< btVector3 > *arg1 = (btAlignedObjectArray< btVector3 > *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< btVector3 > **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->resizeNoInitialize(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3Array_1resize_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jobject jarg3) {
  btAlignedObjectArray< btVector3 > *arg1 = (btAlignedObjectArray< btVector3 > *) 0 ;
  int arg2 ;
  btVector3 *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< btVector3 > **)&jarg1; 
  arg2 = (int)jarg2; 
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  (arg1)->resize(arg2,(btVector3 const &)*arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3Array_1resize_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btAlignedObjectArray< btVector3 > *arg1 = (btAlignedObjectArray< btVector3 > *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< btVector3 > **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->resize(arg2);
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3Array_1expandNonInitializing(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btAlignedObjectArray< btVector3 > *arg1 = (btAlignedObjectArray< btVector3 > *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< btVector3 > **)&jarg1; 
  result = (btVector3 *) &(arg1)->expandNonInitializing();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3Array_1expand_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jobject jresult = 0 ;
  btAlignedObjectArray< btVector3 > *arg1 = (btAlignedObjectArray< btVector3 > *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< btVector3 > **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (btVector3 *) &(arg1)->expand((btVector3 const &)*arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3Array_1expand_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btAlignedObjectArray< btVector3 > *arg1 = (btAlignedObjectArray< btVector3 > *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< btVector3 > **)&jarg1; 
  result = (btVector3 *) &(arg1)->expand();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3Array_1push_1back(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btAlignedObjectArray< btVector3 > *arg1 = (btAlignedObjectArray< btVector3 > *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< btVector3 > **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->push_back((btVector3 const &)*arg2);
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3Array_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btAlignedObjectArray< btVector3 > *arg1 = (btAlignedObjectArray< btVector3 > *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< btVector3 > **)&jarg1; 
  result = (int)((btAlignedObjectArray< btVector3 > const *)arg1)->capacity();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3Array_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btAlignedObjectArray< btVector3 > *arg1 = (btAlignedObjectArray< btVector3 > *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< btVector3 > **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->reserve(arg2);
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3Array_1less_1operatorFunctionCall(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3) {
  jboolean jresult = 0 ;
  btAlignedObjectArray< btVector3 >::less *arg1 = (btAlignedObjectArray< btVector3 >::less *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< btVector3 >::less **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  result = (bool)((btAlignedObjectArray< btVector3 >::less const *)arg1)->operator ()((btVector3 const &)*arg2,(btVector3 const &)*arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btVector3Array_1less(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btAlignedObjectArray< btVector3 >::less *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btAlignedObjectArray< btVector3 >::less *)new btAlignedObjectArray< btVector3 >::less();
  *(btAlignedObjectArray< btVector3 >::less **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_delete_1btVector3Array_1less(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btAlignedObjectArray< btVector3 >::less *arg1 = (btAlignedObjectArray< btVector3 >::less *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btAlignedObjectArray< btVector3 >::less **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3Array_1swap(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  btAlignedObjectArray< btVector3 > *arg1 = (btAlignedObjectArray< btVector3 > *) 0 ;
  int arg2 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< btVector3 > **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  (arg1)->swap(arg2,arg3);
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3Array_1findBinarySearch(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jint jresult = 0 ;
  btAlignedObjectArray< btVector3 > *arg1 = (btAlignedObjectArray< btVector3 > *) 0 ;
  btVector3 *arg2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< btVector3 > **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (int)((btAlignedObjectArray< btVector3 > const *)arg1)->findBinarySearch((btVector3 const &)*arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3Array_1findLinearSearch(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jint jresult = 0 ;
  btAlignedObjectArray< btVector3 > *arg1 = (btAlignedObjectArray< btVector3 > *) 0 ;
  btVector3 *arg2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< btVector3 > **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (int)((btAlignedObjectArray< btVector3 > const *)arg1)->findLinearSearch((btVector3 const &)*arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3Array_1findLinearSearch2(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jint jresult = 0 ;
  btAlignedObjectArray< btVector3 > *arg1 = (btAlignedObjectArray< btVector3 > *) 0 ;
  btVector3 *arg2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< btVector3 > **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (int)((btAlignedObjectArray< btVector3 > const *)arg1)->findLinearSearch2((btVector3 const &)*arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3Array_1removeAtIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btAlignedObjectArray< btVector3 > *arg1 = (btAlignedObjectArray< btVector3 > *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< btVector3 > **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->removeAtIndex(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3Array_1remove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btAlignedObjectArray< btVector3 > *arg1 = (btAlignedObjectArray< btVector3 > *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< btVector3 > **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->remove((btVector3 const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3Array_1initializeFromBuffer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3, jint jarg4) {
  btAlignedObjectArray< btVector3 > *arg1 = (btAlignedObjectArray< btVector3 > *) 0 ;
  void *arg2 = (void *) 0 ;
  int arg3 ;
  int arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< btVector3 > **)&jarg1; 
  arg2 = (void *)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  (arg1)->initializeFromBuffer(arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector3Array_1copyFromArray(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btAlignedObjectArray< btVector3 > *arg1 = (btAlignedObjectArray< btVector3 > *) 0 ;
  btAlignedObjectArray< btVector3 > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btAlignedObjectArray< btVector3 > **)&jarg1; 
  arg2 = *(btAlignedObjectArray< btVector3 > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btAlignedObjectArray< btVector3 > const & reference is null");
    return ;
  } 
  (arg1)->copyFromArray((btAlignedObjectArray< btVector3 > const &)*arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btScalarArray_1operatorAssignment(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  btAlignedObjectArray< btScalar > *arg1 = (btAlignedObjectArray< btScalar > *) 0 ;
  btAlignedObjectArray< float > *arg2 = 0 ;
  btAlignedObjectArray< float > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btAlignedObjectArray< btScalar > **)&jarg1; 
  arg2 = *(btAlignedObjectArray< float > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btAlignedObjectArray< float > const & reference is null");
    return 0;
  } 
  result = (btAlignedObjectArray< float > *) &(arg1)->operator =((btAlignedObjectArray< float > const &)*arg2);
  *(btAlignedObjectArray< float > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btScalarArray_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btAlignedObjectArray< btScalar > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btAlignedObjectArray< btScalar > *)new btAlignedObjectArray< btScalar >();
  *(btAlignedObjectArray< btScalar > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_delete_1btScalarArray(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btAlignedObjectArray< btScalar > *arg1 = (btAlignedObjectArray< btScalar > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btAlignedObjectArray< btScalar > **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btScalarArray_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btAlignedObjectArray< btScalar > *arg1 = 0 ;
  btAlignedObjectArray< btScalar > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< btScalar > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btAlignedObjectArray< btScalar > const & reference is null");
    return 0;
  } 
  result = (btAlignedObjectArray< btScalar > *)new btAlignedObjectArray< btScalar >((btAlignedObjectArray< btScalar > const &)*arg1);
  *(btAlignedObjectArray< btScalar > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btScalarArray_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btAlignedObjectArray< btScalar > *arg1 = (btAlignedObjectArray< btScalar > *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< btScalar > **)&jarg1; 
  result = (int)((btAlignedObjectArray< btScalar > const *)arg1)->size();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btScalarArray_1atConst(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jfloat jresult = 0 ;
  btAlignedObjectArray< btScalar > *arg1 = (btAlignedObjectArray< btScalar > *) 0 ;
  int arg2 ;
  float *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< btScalar > **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (float *) &((btAlignedObjectArray< btScalar > const *)arg1)->at(arg2);
  jresult = (jfloat)*result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btScalarArray_1at(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  btAlignedObjectArray< btScalar > *arg1 = (btAlignedObjectArray< btScalar > *) 0 ;
  int arg2 ;
  float *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< btScalar > **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (float *) &(arg1)->at(arg2);
  *(float **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btScalarArray_1operatorSubscriptConst(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jfloat jresult = 0 ;
  btAlignedObjectArray< btScalar > *arg1 = (btAlignedObjectArray< btScalar > *) 0 ;
  int arg2 ;
  float *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< btScalar > **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (float *) &((btAlignedObjectArray< btScalar > const *)arg1)->operator [](arg2);
  jresult = (jfloat)*result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btScalarArray_1operatorSubscript(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  btAlignedObjectArray< btScalar > *arg1 = (btAlignedObjectArray< btScalar > *) 0 ;
  int arg2 ;
  float *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< btScalar > **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (float *) &(arg1)->operator [](arg2);
  *(float **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btScalarArray_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btAlignedObjectArray< btScalar > *arg1 = (btAlignedObjectArray< btScalar > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< btScalar > **)&jarg1; 
  (arg1)->clear();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btScalarArray_1pop_1back(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btAlignedObjectArray< btScalar > *arg1 = (btAlignedObjectArray< btScalar > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< btScalar > **)&jarg1; 
  (arg1)->pop_back();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btScalarArray_1resizeNoInitialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btAlignedObjectArray< btScalar > *arg1 = (btAlignedObjectArray< btScalar > *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< btScalar > **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->resizeNoInitialize(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btScalarArray_1resize_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jfloat jarg3) {
  btAlignedObjectArray< btScalar > *arg1 = (btAlignedObjectArray< btScalar > *) 0 ;
  int arg2 ;
  float *arg3 = 0 ;
  float temp3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< btScalar > **)&jarg1; 
  arg2 = (int)jarg2; 
  temp3 = (float)jarg3; 
  arg3 = &temp3; 
  (arg1)->resize(arg2,(float const &)*arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btScalarArray_1resize_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btAlignedObjectArray< btScalar > *arg1 = (btAlignedObjectArray< btScalar > *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< btScalar > **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->resize(arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btScalarArray_1expandNonInitializing(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btAlignedObjectArray< btScalar > *arg1 = (btAlignedObjectArray< btScalar > *) 0 ;
  float *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< btScalar > **)&jarg1; 
  result = (float *) &(arg1)->expandNonInitializing();
  *(float **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btScalarArray_1expand_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  jlong jresult = 0 ;
  btAlignedObjectArray< btScalar > *arg1 = (btAlignedObjectArray< btScalar > *) 0 ;
  float *arg2 = 0 ;
  float temp2 ;
  float *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< btScalar > **)&jarg1; 
  temp2 = (float)jarg2; 
  arg2 = &temp2; 
  result = (float *) &(arg1)->expand((float const &)*arg2);
  *(float **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btScalarArray_1expand_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btAlignedObjectArray< btScalar > *arg1 = (btAlignedObjectArray< btScalar > *) 0 ;
  float *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< btScalar > **)&jarg1; 
  result = (float *) &(arg1)->expand();
  *(float **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btScalarArray_1push_1back(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btAlignedObjectArray< btScalar > *arg1 = (btAlignedObjectArray< btScalar > *) 0 ;
  float *arg2 = 0 ;
  float temp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< btScalar > **)&jarg1; 
  temp2 = (float)jarg2; 
  arg2 = &temp2; 
  (arg1)->push_back((float const &)*arg2);
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btScalarArray_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btAlignedObjectArray< btScalar > *arg1 = (btAlignedObjectArray< btScalar > *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< btScalar > **)&jarg1; 
  result = (int)((btAlignedObjectArray< btScalar > const *)arg1)->capacity();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btScalarArray_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btAlignedObjectArray< btScalar > *arg1 = (btAlignedObjectArray< btScalar > *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< btScalar > **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->reserve(arg2);
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btScalarArray_1less_1operatorFunctionCall(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2, jfloat jarg3) {
  jboolean jresult = 0 ;
  btAlignedObjectArray< btScalar >::less *arg1 = (btAlignedObjectArray< btScalar >::less *) 0 ;
  float *arg2 = 0 ;
  float *arg3 = 0 ;
  float temp2 ;
  float temp3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btAlignedObjectArray< btScalar >::less **)&jarg1; 
  temp2 = (float)jarg2; 
  arg2 = &temp2; 
  temp3 = (float)jarg3; 
  arg3 = &temp3; 
  result = (bool)((btAlignedObjectArray< btScalar >::less const *)arg1)->operator ()((float const &)*arg2,(float const &)*arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_new_1btScalarArray_1less(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btAlignedObjectArray< btScalar >::less *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btAlignedObjectArray< btScalar >::less *)new btAlignedObjectArray< btScalar >::less();
  *(btAlignedObjectArray< btScalar >::less **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_delete_1btScalarArray_1less(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btAlignedObjectArray< btScalar >::less *arg1 = (btAlignedObjectArray< btScalar >::less *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btAlignedObjectArray< btScalar >::less **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btScalarArray_1swap(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  btAlignedObjectArray< btScalar > *arg1 = (btAlignedObjectArray< btScalar > *) 0 ;
  int arg2 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< btScalar > **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  (arg1)->swap(arg2,arg3);
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btScalarArray_1findBinarySearch(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  jint jresult = 0 ;
  btAlignedObjectArray< btScalar > *arg1 = (btAlignedObjectArray< btScalar > *) 0 ;
  float *arg2 = 0 ;
  float temp2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< btScalar > **)&jarg1; 
  temp2 = (float)jarg2; 
  arg2 = &temp2; 
  result = (int)((btAlignedObjectArray< btScalar > const *)arg1)->findBinarySearch((float const &)*arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btScalarArray_1findLinearSearch(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  jint jresult = 0 ;
  btAlignedObjectArray< btScalar > *arg1 = (btAlignedObjectArray< btScalar > *) 0 ;
  float *arg2 = 0 ;
  float temp2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< btScalar > **)&jarg1; 
  temp2 = (float)jarg2; 
  arg2 = &temp2; 
  result = (int)((btAlignedObjectArray< btScalar > const *)arg1)->findLinearSearch((float const &)*arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btScalarArray_1findLinearSearch2(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  jint jresult = 0 ;
  btAlignedObjectArray< btScalar > *arg1 = (btAlignedObjectArray< btScalar > *) 0 ;
  float *arg2 = 0 ;
  float temp2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< btScalar > **)&jarg1; 
  temp2 = (float)jarg2; 
  arg2 = &temp2; 
  result = (int)((btAlignedObjectArray< btScalar > const *)arg1)->findLinearSearch2((float const &)*arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btScalarArray_1removeAtIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btAlignedObjectArray< btScalar > *arg1 = (btAlignedObjectArray< btScalar > *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< btScalar > **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->removeAtIndex(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btScalarArray_1remove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btAlignedObjectArray< btScalar > *arg1 = (btAlignedObjectArray< btScalar > *) 0 ;
  float *arg2 = 0 ;
  float temp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< btScalar > **)&jarg1; 
  temp2 = (float)jarg2; 
  arg2 = &temp2; 
  (arg1)->remove((float const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btScalarArray_1initializeFromBuffer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3, jint jarg4) {
  btAlignedObjectArray< btScalar > *arg1 = (btAlignedObjectArray< btScalar > *) 0 ;
  void *arg2 = (void *) 0 ;
  int arg3 ;
  int arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAlignedObjectArray< btScalar > **)&jarg1; 
  arg2 = (void *)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  (arg1)->initializeFromBuffer(arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btScalarArray_1copyFromArray(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btAlignedObjectArray< btScalar > *arg1 = (btAlignedObjectArray< btScalar > *) 0 ;
  btAlignedObjectArray< btScalar > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btAlignedObjectArray< btScalar > **)&jarg1; 
  arg2 = *(btAlignedObjectArray< btScalar > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btAlignedObjectArray< btScalar > const & reference is null");
    return ;
  } 
  (arg1)->copyFromArray((btAlignedObjectArray< btScalar > const &)*arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btVector4_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(btVector3 **)&baseptr = *(btVector4 **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btQuaternion_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(btQuadWord **)&baseptr = *(btQuaternion **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_GrahamVector3_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(btVector3 **)&baseptr = *(GrahamVector3 **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btDefaultSerializer_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(btSerializer **)&baseptr = *(btDefaultSerializer **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_btDefaultMotionState_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(btMotionState **)&baseptr = *(btDefaultMotionState **)&jarg1;
    return baseptr;
}

SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_linearmath_LinearMathJNI_swig_1module_1init(JNIEnv *jenv, jclass jcls) {
  int i;
  
  static struct {
    const char *method;
    const char *signature;
  } methods[30] = {
    {
      "SwigDirector_btIDebugDraw_getDefaultColors", "(Lcom/badlogic/gdx/physics/bullet/linearmath/btIDebugDraw;)J" 
    },
    {
      "SwigDirector_btIDebugDraw_setDefaultColors", "(Lcom/badlogic/gdx/physics/bullet/linearmath/btIDebugDraw;J)V" 
    },
    {
      "SwigDirector_btIDebugDraw_drawLine__SWIG_0", "(Lcom/badlogic/gdx/physics/bullet/linearmath/btIDebugDraw;Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;)V" 
    },
    {
      "SwigDirector_btIDebugDraw_drawLine__SWIG_1", "(Lcom/badlogic/gdx/physics/bullet/linearmath/btIDebugDraw;Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;)V" 
    },
    {
      "SwigDirector_btIDebugDraw_drawSphere__SWIG_0", "(Lcom/badlogic/gdx/physics/bullet/linearmath/btIDebugDraw;FLcom/badlogic/gdx/math/Matrix4;Lcom/badlogic/gdx/math/Vector3;)V" 
    },
    {
      "SwigDirector_btIDebugDraw_drawSphere__SWIG_1", "(Lcom/badlogic/gdx/physics/bullet/linearmath/btIDebugDraw;Lcom/badlogic/gdx/math/Vector3;FLcom/badlogic/gdx/math/Vector3;)V" 
    },
    {
      "SwigDirector_btIDebugDraw_drawTriangle__SWIG_0", "(Lcom/badlogic/gdx/physics/bullet/linearmath/btIDebugDraw;Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;F)V" 
    },
    {
      "SwigDirector_btIDebugDraw_drawTriangle__SWIG_1", "(Lcom/badlogic/gdx/physics/bullet/linearmath/btIDebugDraw;Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;F)V" 
    },
    {
      "SwigDirector_btIDebugDraw_drawContactPoint", "(Lcom/badlogic/gdx/physics/bullet/linearmath/btIDebugDraw;Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;FILcom/badlogic/gdx/math/Vector3;)V" 
    },
    {
      "SwigDirector_btIDebugDraw_reportErrorWarning", "(Lcom/badlogic/gdx/physics/bullet/linearmath/btIDebugDraw;Ljava/lang/String;)V" 
    },
    {
      "SwigDirector_btIDebugDraw_draw3dText", "(Lcom/badlogic/gdx/physics/bullet/linearmath/btIDebugDraw;Lcom/badlogic/gdx/math/Vector3;Ljava/lang/String;)V" 
    },
    {
      "SwigDirector_btIDebugDraw_setDebugMode", "(Lcom/badlogic/gdx/physics/bullet/linearmath/btIDebugDraw;I)V" 
    },
    {
      "SwigDirector_btIDebugDraw_getDebugMode", "(Lcom/badlogic/gdx/physics/bullet/linearmath/btIDebugDraw;)I" 
    },
    {
      "SwigDirector_btIDebugDraw_drawAabb", "(Lcom/badlogic/gdx/physics/bullet/linearmath/btIDebugDraw;Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;)V" 
    },
    {
      "SwigDirector_btIDebugDraw_drawTransform", "(Lcom/badlogic/gdx/physics/bullet/linearmath/btIDebugDraw;Lcom/badlogic/gdx/math/Matrix4;F)V" 
    },
    {
      "SwigDirector_btIDebugDraw_drawArc__SWIG_0", "(Lcom/badlogic/gdx/physics/bullet/linearmath/btIDebugDraw;Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;FFFFLcom/badlogic/gdx/math/Vector3;ZF)V" 
    },
    {
      "SwigDirector_btIDebugDraw_drawArc__SWIG_1", "(Lcom/badlogic/gdx/physics/bullet/linearmath/btIDebugDraw;Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;FFFFLcom/badlogic/gdx/math/Vector3;Z)V" 
    },
    {
      "SwigDirector_btIDebugDraw_drawSpherePatch__SWIG_0", "(Lcom/badlogic/gdx/physics/bullet/linearmath/btIDebugDraw;Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;FFFFFLcom/badlogic/gdx/math/Vector3;FZ)V" 
    },
    {
      "SwigDirector_btIDebugDraw_drawSpherePatch__SWIG_1", "(Lcom/badlogic/gdx/physics/bullet/linearmath/btIDebugDraw;Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;FFFFFLcom/badlogic/gdx/math/Vector3;F)V" 
    },
    {
      "SwigDirector_btIDebugDraw_drawSpherePatch__SWIG_2", "(Lcom/badlogic/gdx/physics/bullet/linearmath/btIDebugDraw;Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;FFFFFLcom/badlogic/gdx/math/Vector3;)V" 
    },
    {
      "SwigDirector_btIDebugDraw_drawBox__SWIG_0", "(Lcom/badlogic/gdx/physics/bullet/linearmath/btIDebugDraw;Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;)V" 
    },
    {
      "SwigDirector_btIDebugDraw_drawBox__SWIG_1", "(Lcom/badlogic/gdx/physics/bullet/linearmath/btIDebugDraw;Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Vector3;Lcom/badlogic/gdx/math/Matrix4;Lcom/badlogic/gdx/math/Vector3;)V" 
    },
    {
      "SwigDirector_btIDebugDraw_drawCapsule", "(Lcom/badlogic/gdx/physics/bullet/linearmath/btIDebugDraw;FFILcom/badlogic/gdx/math/Matrix4;Lcom/badlogic/gdx/math/Vector3;)V" 
    },
    {
      "SwigDirector_btIDebugDraw_drawCylinder", "(Lcom/badlogic/gdx/physics/bullet/linearmath/btIDebugDraw;FFILcom/badlogic/gdx/math/Matrix4;Lcom/badlogic/gdx/math/Vector3;)V" 
    },
    {
      "SwigDirector_btIDebugDraw_drawCone", "(Lcom/badlogic/gdx/physics/bullet/linearmath/btIDebugDraw;FFILcom/badlogic/gdx/math/Matrix4;Lcom/badlogic/gdx/math/Vector3;)V" 
    },
    {
      "SwigDirector_btIDebugDraw_drawPlane", "(Lcom/badlogic/gdx/physics/bullet/linearmath/btIDebugDraw;Lcom/badlogic/gdx/math/Vector3;FLcom/badlogic/gdx/math/Matrix4;Lcom/badlogic/gdx/math/Vector3;)V" 
    },
    {
      "SwigDirector_btIDebugDraw_clearLines", "(Lcom/badlogic/gdx/physics/bullet/linearmath/btIDebugDraw;)V" 
    },
    {
      "SwigDirector_btIDebugDraw_flushLines", "(Lcom/badlogic/gdx/physics/bullet/linearmath/btIDebugDraw;)V" 
    },
    {
      "SwigDirector_btMotionState_getWorldTransform", "(Lcom/badlogic/gdx/physics/bullet/linearmath/btMotionState;Lcom/badlogic/gdx/math/Matrix4;)V" 
    },
    {
      "SwigDirector_btMotionState_setWorldTransform", "(Lcom/badlogic/gdx/physics/bullet/linearmath/btMotionState;Lcom/badlogic/gdx/math/Matrix4;)V" 
    }
  };
  Swig::jclass_LinearMathJNI = (jclass) jenv->NewGlobalRef(jcls);
  if (!Swig::jclass_LinearMathJNI) return;
  for (i = 0; i < (int) (sizeof(methods)/sizeof(methods[0])); ++i) {
    Swig::director_method_ids[i] = jenv->GetStaticMethodID(jcls, methods[i].method, methods[i].signature);
    if (!Swig::director_method_ids[i]) return;
  }
}


#ifdef __cplusplus
}
#endif

