/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.bullet.collision;

import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.physics.bullet.BulletBase;
import com.badlogic.gdx.physics.bullet.collision.BT_QUANTIZED_BVH_NODE;
import com.badlogic.gdx.physics.bullet.collision.CollisionJNI;
import com.badlogic.gdx.physics.bullet.collision.GIM_BVH_DATA_ARRAY;
import com.badlogic.gdx.physics.bullet.collision.btAABB;
import java.nio.IntBuffer;

public class btQuantizedBvhTree
extends BulletBase {
    private long swigCPtr;

    protected btQuantizedBvhTree(String className, long cPtr, boolean cMemoryOwn) {
        super(className, cPtr, cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    public btQuantizedBvhTree(long cPtr, boolean cMemoryOwn) {
        this("btQuantizedBvhTree", cPtr, cMemoryOwn);
        this.construct();
    }

    @Override
    protected void reset(long cPtr, boolean cMemoryOwn) {
        if (!this.destroyed) {
            this.destroy();
        }
        this.swigCPtr = cPtr;
        super.reset(this.swigCPtr, cMemoryOwn);
    }

    public static long getCPtr(btQuantizedBvhTree obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    protected void finalize() throws Throwable {
        if (!this.destroyed) {
            this.destroy();
        }
        super.finalize();
    }

    @Override
    protected synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                CollisionJNI.delete_btQuantizedBvhTree(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public btQuantizedBvhTree() {
        this(CollisionJNI.new_btQuantizedBvhTree(), true);
    }

    public void build_tree(GIM_BVH_DATA_ARRAY primitive_boxes) {
        CollisionJNI.btQuantizedBvhTree_build_tree(this.swigCPtr, this, GIM_BVH_DATA_ARRAY.getCPtr(primitive_boxes), primitive_boxes);
    }

    public void quantizePoint(IntBuffer quantizedpoint, Vector3 point) {
        assert (quantizedpoint.isDirect()) : "Buffer must be allocated direct.";
        CollisionJNI.btQuantizedBvhTree_quantizePoint(this.swigCPtr, this, quantizedpoint, point);
    }

    public boolean testQuantizedBoxOverlapp(int node_index, IntBuffer quantizedMin, IntBuffer quantizedMax) {
        assert (quantizedMin.isDirect()) : "Buffer must be allocated direct.";
        assert (quantizedMax.isDirect()) : "Buffer must be allocated direct.";
        return CollisionJNI.btQuantizedBvhTree_testQuantizedBoxOverlapp(this.swigCPtr, this, node_index, quantizedMin, quantizedMax);
    }

    public void clearNodes() {
        CollisionJNI.btQuantizedBvhTree_clearNodes(this.swigCPtr, this);
    }

    public int getNodeCount() {
        return CollisionJNI.btQuantizedBvhTree_getNodeCount(this.swigCPtr, this);
    }

    public boolean isLeafNode(int nodeindex) {
        return CollisionJNI.btQuantizedBvhTree_isLeafNode(this.swigCPtr, this, nodeindex);
    }

    public int getNodeData(int nodeindex) {
        return CollisionJNI.btQuantizedBvhTree_getNodeData(this.swigCPtr, this, nodeindex);
    }

    public void getNodeBound(int nodeindex, btAABB bound) {
        CollisionJNI.btQuantizedBvhTree_getNodeBound(this.swigCPtr, this, nodeindex, btAABB.getCPtr(bound), bound);
    }

    public void setNodeBound(int nodeindex, btAABB bound) {
        CollisionJNI.btQuantizedBvhTree_setNodeBound(this.swigCPtr, this, nodeindex, btAABB.getCPtr(bound), bound);
    }

    public int getLeftNode(int nodeindex) {
        return CollisionJNI.btQuantizedBvhTree_getLeftNode(this.swigCPtr, this, nodeindex);
    }

    public int getRightNode(int nodeindex) {
        return CollisionJNI.btQuantizedBvhTree_getRightNode(this.swigCPtr, this, nodeindex);
    }

    public int getEscapeNodeIndex(int nodeindex) {
        return CollisionJNI.btQuantizedBvhTree_getEscapeNodeIndex(this.swigCPtr, this, nodeindex);
    }

    public BT_QUANTIZED_BVH_NODE get_node_pointer(int index) {
        long cPtr = CollisionJNI.btQuantizedBvhTree_get_node_pointer__SWIG_0(this.swigCPtr, this, index);
        return cPtr == 0L ? null : new BT_QUANTIZED_BVH_NODE(cPtr, false);
    }

    public BT_QUANTIZED_BVH_NODE get_node_pointer() {
        long cPtr = CollisionJNI.btQuantizedBvhTree_get_node_pointer__SWIG_1(this.swigCPtr, this);
        return cPtr == 0L ? null : new BT_QUANTIZED_BVH_NODE(cPtr, false);
    }
}

